/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FileCreationRecord;
import net.sf.mpxj.Filter;
import net.sf.mpxj.GraphicalIndicator;
import net.sf.mpxj.Group;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.View;
import net.sf.mpxj.ViewState;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectFile {
    private String m_projectFilePath;
    private int m_taskUniqueID;
    private int m_calendarUniqueID;
    private int m_assignmentUniqueID;
    private int m_taskID;
    private int m_resourceUniqueID;
    private int m_resourceID;
    private List<Resource> m_allResources = new LinkedList<Resource>();
    private List<Task> m_allTasks = new LinkedList<Task>();
    private List<Task> m_childTasks = new LinkedList<Task>();
    private List<ResourceAssignment> m_allResourceAssignments = new LinkedList<ResourceAssignment>();
    private List<ProjectCalendar> m_baseCalendars = new LinkedList<ProjectCalendar>();
    private List<ProjectCalendar> m_resourceCalendars = new LinkedList<ProjectCalendar>();
    private FileCreationRecord m_fileCreationRecord = new FileCreationRecord(this);
    private ProjectHeader m_projectHeader = new ProjectHeader(this);
    private char m_delimiter = (char)44;
    private byte m_encryptionKey;
    private boolean m_encoded;
    private boolean m_autoWBS = true;
    private boolean m_autoOutlineLevel = true;
    private boolean m_autoOutlineNumber = true;
    private boolean m_autoTaskUniqueID = true;
    private boolean m_autoCalendarUniqueID = true;
    private boolean m_autoAssignmentUniqueID = true;
    private boolean m_autoTaskID = true;
    private boolean m_autoResourceUniqueID = true;
    private boolean m_autoResourceID = true;
    private Map<TaskField, String> m_taskFieldAlias = new HashMap<TaskField, String>();
    private Map<TaskField, List<Object>> m_taskFieldValueList = new HashMap<TaskField, List<Object>>();
    private Map<TaskField, List<String>> m_taskFieldDescriptionList = new HashMap<TaskField, List<String>>();
    private Map<String, TaskField> m_aliasTaskField = new HashMap<String, TaskField>();
    private Map<ResourceField, String> m_resourceFieldAlias = new HashMap<ResourceField, String>();
    private Map<String, ResourceField> m_aliasResourceField = new HashMap<String, ResourceField>();
    private Map<Integer, Task> m_taskUniqueIDMap = new HashMap<Integer, Task>();
    private Map<Integer, Task> m_taskIDMap = new HashMap<Integer, Task>();
    private Map<Integer, Resource> m_resourceUniqueIDMap = new HashMap<Integer, Resource>();
    private Map<Integer, Resource> m_resourceIDMap = new HashMap<Integer, Resource>();
    private Map<Integer, ProjectCalendar> m_calendarUniqueIDMap = new HashMap<Integer, ProjectCalendar>();
    private List<ProjectListener> m_projectListeners;
    private int m_mppFileType;
    private List<View> m_views = new ArrayList<View>();
    private List<Table> m_tables = new ArrayList<Table>();
    private Map<FieldType, GraphicalIndicator> m_graphicalIndicators = new HashMap<FieldType, GraphicalIndicator>();
    private Map<String, Table> m_taskTablesByName = new HashMap<String, Table>();
    private Map<String, Table> m_resourceTablesByName = new HashMap<String, Table>();
    private List<Filter> m_taskFilters = new ArrayList<Filter>();
    private List<Filter> m_resourceFilters = new ArrayList<Filter>();
    private Map<String, Filter> m_filtersByName = new HashMap<String, Filter>();
    private Map<Integer, Filter> m_filtersByID = new HashMap<Integer, Filter>();
    private List<Group> m_groups = new ArrayList<Group>();
    private Map<String, Group> m_groupsByName = new HashMap<String, Group>();
    private SubProject m_resourceSubProject;
    private List<SubProject> m_allSubProjects = new LinkedList<SubProject>();
    private boolean m_autoFilter;
    private ViewState m_viewState;
    private Map<Integer, CustomFieldValueItem> m_customFieldValueItems = new HashMap<Integer, CustomFieldValueItem>();
    private static final int MS_PROJECT_MAX_UNIQUE_ID = 0x1FFFFF;

    public char getDelimiter() {
        return this.m_delimiter;
    }

    public void setDelimiter(char c) {
        this.m_delimiter = c;
    }

    void addTask(Task task) {
        this.m_allTasks.add(task);
    }

    public Task addTask() {
        Task task = new Task(this, null);
        this.m_allTasks.add(task);
        this.m_childTasks.add(task);
        return task;
    }

    public void removeTask(Task task) {
        Object object;
        this.m_allTasks.remove(task);
        this.m_taskUniqueIDMap.remove(task.getUniqueID());
        this.m_taskIDMap.remove(task.getID());
        Task task2 = task.getParentTask();
        if (task2 != null) {
            task2.removeChildTask(task);
        } else {
            this.m_childTasks.remove(task);
        }
        Iterator<ResourceAssignment> iterator = this.m_allResourceAssignments.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((ResourceAssignment)object).getTask() != task) continue;
            Resource resource = ((ResourceAssignment)object).getResource();
            if (resource != null) {
                resource.removeResourceAssignment((ResourceAssignment)object);
            }
            iterator.remove();
        }
        while (!(object = task.getChildTasks()).isEmpty()) {
            this.removeTask((Task)object.get(0));
        }
    }

    public void renumberTaskIDs() {
        if (!this.m_allTasks.isEmpty()) {
            Collections.sort(this.m_allTasks);
            Task task = this.m_allTasks.get(0);
            int n = NumberUtility.getInt(task.getID());
            if (n != 0) {
                n = 1;
            }
            for (Task task2 : this.m_allTasks) {
                task2.setID(n++);
            }
        }
    }

    public void renumberResourceIDs() {
        if (!this.m_allResources.isEmpty()) {
            Collections.sort(this.m_allResources);
            int n = 1;
            for (Resource resource : this.m_allResources) {
                resource.setID(n++);
            }
        }
    }

    private void renumberTaskUniqueIDs() {
        Task task = this.getTaskByID(0);
        int n = task == null ? 1 : 0;
        for (Task task2 : this.m_allTasks) {
            task2.setUniqueID(n++);
        }
    }

    private void renumberResourceUniqueIDs() {
        int n = 1;
        for (Resource resource : this.m_allResources) {
            resource.setUniqueID(n++);
        }
    }

    private void renumberAssignmentUniqueIDs() {
        int n = 1;
        for (ResourceAssignment resourceAssignment : this.m_allResourceAssignments) {
            resourceAssignment.setUniqueID(n++);
        }
    }

    private void renumberCalendarUniqueIDs() {
        int n = 1;
        for (ProjectCalendar projectCalendar : this.m_baseCalendars) {
            projectCalendar.setUniqueID(n++);
        }
        for (ProjectCalendar projectCalendar : this.m_resourceCalendars) {
            projectCalendar.setUniqueID(n++);
        }
    }

    public void validateUniqueIDsForMicrosoftProject() {
        if (!this.m_allTasks.isEmpty()) {
            for (Task object : this.m_allTasks) {
                if (NumberUtility.getInt(object.getUniqueID()) <= 0x1FFFFF) continue;
                this.renumberTaskUniqueIDs();
                break;
            }
        }
        if (!this.m_allResources.isEmpty()) {
            for (Resource resource : this.m_allResources) {
                if (NumberUtility.getInt(resource.getUniqueID()) <= 0x1FFFFF) continue;
                this.renumberResourceUniqueIDs();
                break;
            }
        }
        if (!this.m_allResourceAssignments.isEmpty()) {
            for (ResourceAssignment resourceAssignment : this.m_allResourceAssignments) {
                if (NumberUtility.getInt(resourceAssignment.getUniqueID()) <= 0x1FFFFF) continue;
                this.renumberAssignmentUniqueIDs();
                break;
            }
        }
        if (!this.m_baseCalendars.isEmpty()) {
            for (ProjectCalendar projectCalendar : this.m_baseCalendars) {
                if (NumberUtility.getInt(projectCalendar.getUniqueID()) <= 0x1FFFFF) continue;
                this.renumberCalendarUniqueIDs();
                break;
            }
        }
        if (!this.m_resourceCalendars.isEmpty()) {
            for (ProjectCalendar projectCalendar : this.m_resourceCalendars) {
                if (NumberUtility.getInt(projectCalendar.getUniqueID()) <= 0x1FFFFF) continue;
                this.renumberCalendarUniqueIDs();
                break;
            }
        }
    }

    public void synchronizeTaskIDToHierarchy() {
        this.m_allTasks.clear();
        int n = this.getTaskByID(0) == null ? 1 : 0;
        for (Task task : this.m_childTasks) {
            task.setID(n++);
            this.m_allTasks.add(task);
            n = this.synchroizeTaskIDToHierarchy(task, n);
        }
    }

    private int synchroizeTaskIDToHierarchy(Task task, int n) {
        for (Task task2 : task.getChildTasks()) {
            task2.setID(n++);
            this.m_allTasks.add(task2);
            n = this.synchroizeTaskIDToHierarchy(task2, n);
        }
        return n;
    }

    public List<Task> getChildTasks() {
        return this.m_childTasks;
    }

    public List<Task> getAllTasks() {
        return this.m_allTasks;
    }

    public void setAutoWBS(boolean bl) {
        this.m_autoWBS = bl;
    }

    public void setAutoOutlineLevel(boolean bl) {
        this.m_autoOutlineLevel = bl;
    }

    public void setAutoOutlineNumber(boolean bl) {
        this.m_autoOutlineNumber = bl;
    }

    public void setAutoTaskUniqueID(boolean bl) {
        this.m_autoTaskUniqueID = bl;
    }

    public void setAutoCalendarUniqueID(boolean bl) {
        this.m_autoCalendarUniqueID = bl;
    }

    public void setAutoAssignmentUniqueID(boolean bl) {
        this.m_autoAssignmentUniqueID = bl;
    }

    public void setAutoTaskID(boolean bl) {
        this.m_autoTaskID = bl;
    }

    public boolean getAutoWBS() {
        return this.m_autoWBS;
    }

    public boolean getAutoOutlineLevel() {
        return this.m_autoOutlineLevel;
    }

    public boolean getAutoOutlineNumber() {
        return this.m_autoOutlineNumber;
    }

    public boolean getAutoTaskUniqueID() {
        return this.m_autoTaskUniqueID;
    }

    public boolean getAutoCalendarUniqueID() {
        return this.m_autoCalendarUniqueID;
    }

    public boolean getAutoAssignmentUniqueID() {
        return this.m_autoAssignmentUniqueID;
    }

    public boolean getAutoTaskID() {
        return this.m_autoTaskID;
    }

    public int getTaskUniqueID() {
        return ++this.m_taskUniqueID;
    }

    int getCalendarUniqueID() {
        return ++this.m_calendarUniqueID;
    }

    int getAssignmentUniqueID() {
        return ++this.m_assignmentUniqueID;
    }

    public int getTaskID() {
        return ++this.m_taskID;
    }

    public void setAutoResourceUniqueID(boolean bl) {
        this.m_autoResourceUniqueID = bl;
    }

    public void setAutoResourceID(boolean bl) {
        this.m_autoResourceID = bl;
    }

    public boolean getAutoResourceUniqueID() {
        return this.m_autoResourceUniqueID;
    }

    public boolean getAutoResourceID() {
        return this.m_autoResourceID;
    }

    public int getResourceUniqueID() {
        return ++this.m_resourceUniqueID;
    }

    public int getResourceID() {
        return ++this.m_resourceID;
    }

    public FileCreationRecord getFileCreationRecord() {
        return this.m_fileCreationRecord;
    }

    public ProjectCalendar addResourceCalendar() {
        ProjectCalendar projectCalendar = new ProjectCalendar(this);
        this.m_resourceCalendars.add(projectCalendar);
        return projectCalendar;
    }

    public ProjectCalendar addBaseCalendar() {
        ProjectCalendar projectCalendar = new ProjectCalendar(this);
        this.m_baseCalendars.add(projectCalendar);
        return projectCalendar;
    }

    public void removeCalendar(ProjectCalendar projectCalendar) {
        if (this.m_baseCalendars.contains(projectCalendar)) {
            this.m_baseCalendars.remove(projectCalendar);
        } else if (this.m_resourceCalendars.contains(projectCalendar)) {
            this.m_resourceCalendars.remove(projectCalendar);
            Resource resource = projectCalendar.getResource();
            if (resource != null) {
                resource.setResourceCalendar(null);
            }
        }
        projectCalendar.setParent(null);
    }

    public ProjectCalendar addDefaultBaseCalendar() {
        ProjectCalendar projectCalendar = this.addBaseCalendar();
        projectCalendar.setName("Standard");
        projectCalendar.setWorkingDay(Day.SUNDAY, false);
        projectCalendar.setWorkingDay(Day.MONDAY, true);
        projectCalendar.setWorkingDay(Day.TUESDAY, true);
        projectCalendar.setWorkingDay(Day.WEDNESDAY, true);
        projectCalendar.setWorkingDay(Day.THURSDAY, true);
        projectCalendar.setWorkingDay(Day.FRIDAY, true);
        projectCalendar.setWorkingDay(Day.SATURDAY, false);
        projectCalendar.addDefaultCalendarHours();
        return projectCalendar;
    }

    public ProjectCalendar getDefaultResourceCalendar() {
        ProjectCalendar projectCalendar = new ProjectCalendar(this);
        projectCalendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
        return projectCalendar;
    }

    public List<ProjectCalendar> getBaseCalendars() {
        return this.m_baseCalendars;
    }

    public List<ProjectCalendar> getResourceCalendars() {
        return this.m_resourceCalendars;
    }

    public ProjectHeader getProjectHeader() {
        return this.m_projectHeader;
    }

    public Resource addResource() {
        Resource resource = new Resource(this);
        this.m_allResources.add(resource);
        return resource;
    }

    public void removeResource(Resource resource) {
        Object object;
        this.m_allResources.remove(resource);
        this.m_resourceUniqueIDMap.remove(resource.getUniqueID());
        this.m_resourceIDMap.remove(resource.getID());
        Iterator<ResourceAssignment> iterator = this.m_allResourceAssignments.iterator();
        Integer n = resource.getUniqueID();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!NumberUtility.equals(((ResourceAssignment)object).getResourceUniqueID(), n)) continue;
            ((ResourceAssignment)object).getTask().removeResourceAssignment((ResourceAssignment)object);
            iterator.remove();
        }
        object = resource.getResourceCalendar();
        if (object != null) {
            ((ProjectCalendar)object).remove();
        }
    }

    public List<Resource> getAllResources() {
        return this.m_allResources;
    }

    public List<ResourceAssignment> getAllResourceAssignments() {
        return this.m_allResourceAssignments;
    }

    void addResourceAssignment(ResourceAssignment resourceAssignment) {
        this.m_allResourceAssignments.add(resourceAssignment);
    }

    void removeResourceAssignment(ResourceAssignment resourceAssignment) {
        this.m_allResourceAssignments.remove(resourceAssignment);
        resourceAssignment.getTask().removeResourceAssignment(resourceAssignment);
        Resource resource = resourceAssignment.getResource();
        if (resource != null) {
            resource.removeResourceAssignment(resourceAssignment);
        }
    }

    public ResourceAssignment newResourceAssignment(Task task) {
        return new ResourceAssignment(this, task);
    }

    public ProjectCalendar getBaseCalendar(String string) {
        ProjectCalendar projectCalendar = null;
        if (string != null && string.length() != 0) {
            String string2;
            Iterator<ProjectCalendar> iterator = this.m_baseCalendars.iterator();
            while (iterator.hasNext() && ((string2 = (projectCalendar = iterator.next()).getName()) == null || !string2.equalsIgnoreCase(string))) {
                projectCalendar = null;
            }
        }
        return projectCalendar;
    }

    public ProjectCalendar getBaseCalendarByUniqueID(Integer n) {
        return this.m_calendarUniqueIDMap.get(n);
    }

    int getChildTaskCount() {
        return this.m_childTasks.size();
    }

    public Duration getDuration(Date date, Date date2) throws MPXJException {
        return this.getDuration("Standard", date, date2);
    }

    public Duration getDuration(String string, Date date, Date date2) throws MPXJException {
        ProjectCalendar projectCalendar = this.getBaseCalendar(string);
        if (projectCalendar == null) {
            throw new MPXJException("Invalid calendar: " + string);
        }
        return projectCalendar.getDuration(date, date2);
    }

    public Task getTaskByID(Integer n) {
        return this.m_taskIDMap.get(n);
    }

    public Task getTaskByUniqueID(Integer n) {
        return this.m_taskUniqueIDMap.get(n);
    }

    public Resource getResourceByID(Integer n) {
        return this.m_resourceIDMap.get(n);
    }

    public Resource getResourceByUniqueID(Integer n) {
        return this.m_resourceUniqueIDMap.get(n);
    }

    public void updateStructure() {
        if (this.m_allTasks.size() > 1) {
            Collections.sort(this.m_allTasks);
            this.m_childTasks.clear();
            Task task = null;
            int n = -1;
            for (Task task2 : this.m_allTasks) {
                task2.clearChildTasks();
                Task task3 = null;
                if (!task2.getNull()) {
                    int n2 = NumberUtility.getInt(task2.getOutlineLevel());
                    if (task != null) {
                        if (n2 == n || task2.getNull()) {
                            task3 = task.getParentTask();
                            n2 = n;
                        } else if (n2 > n) {
                            task3 = task;
                        } else {
                            while (n2 <= n && (task3 = task.getParentTask()) != null) {
                                n = NumberUtility.getInt(task3.getOutlineLevel());
                                task = task3;
                            }
                        }
                    }
                    task = task2;
                    n = n2;
                    if (this.getAutoWBS() || task2.getWBS() == null) {
                        task2.generateWBS(task3);
                    }
                    if (this.getAutoOutlineNumber()) {
                        task2.generateOutlineNumber(task3);
                    }
                }
                if (task3 == null) {
                    this.m_childTasks.add(task2);
                    continue;
                }
                task3.addChildTask(task2);
            }
        }
    }

    public void updateUniqueCounters() {
        int n;
        for (Task object : this.m_allTasks) {
            n = NumberUtility.getInt(object.getUniqueID());
            if (n <= this.m_taskUniqueID) continue;
            this.m_taskUniqueID = n;
        }
        for (Resource resource : this.m_allResources) {
            n = NumberUtility.getInt(resource.getUniqueID());
            if (n <= this.m_resourceUniqueID) continue;
            this.m_resourceUniqueID = n;
        }
        for (ProjectCalendar projectCalendar : this.m_baseCalendars) {
            n = NumberUtility.getInt(projectCalendar.getUniqueID());
            if (n <= this.m_calendarUniqueID) continue;
            this.m_calendarUniqueID = n;
        }
        for (ProjectCalendar projectCalendar : this.m_resourceCalendars) {
            n = NumberUtility.getInt(projectCalendar.getUniqueID());
            if (n <= this.m_calendarUniqueID) continue;
            this.m_calendarUniqueID = n;
        }
        for (ResourceAssignment resourceAssignment : this.m_allResourceAssignments) {
            n = NumberUtility.getInt(resourceAssignment.getUniqueID());
            if (n <= this.m_assignmentUniqueID) continue;
            this.m_assignmentUniqueID = n;
        }
    }

    public Date getStartDate() {
        Date date = null;
        for (Task task : this.m_allTasks) {
            Date date2;
            if (NumberUtility.getInt(task.getUniqueID()) == 0) continue;
            if (task.getMilestone()) {
                date2 = task.getActualFinish();
                if (date2 == null) {
                    date2 = task.getFinish();
                }
            } else {
                date2 = task.getActualStart();
                if (date2 == null) {
                    date2 = task.getStart();
                }
            }
            if (date2 == null) continue;
            if (date == null) {
                date = date2;
                continue;
            }
            if (date2.getTime() >= date.getTime()) continue;
            date = date2;
        }
        return date;
    }

    public Date getFinishDate() {
        Date date = null;
        for (Task task : this.m_allTasks) {
            if (NumberUtility.getInt(task.getUniqueID()) == 0) continue;
            Date date2 = task.getActualFinish();
            if (date2 == null) {
                date2 = task.getFinish();
            }
            if (date2 == null) continue;
            if (date == null) {
                date = date2;
                continue;
            }
            if (date2.getTime() <= date.getTime()) continue;
            date = date2;
        }
        return date;
    }

    public void fireTaskReadEvent(Task task) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.taskRead(task);
            }
        }
    }

    public void fireTaskWrittenEvent(Task task) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.taskWritten(task);
            }
        }
    }

    public void fireResourceReadEvent(Resource resource) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.resourceRead(resource);
            }
        }
    }

    public void fireResourceWrittenEvent(Resource resource) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.resourceWritten(resource);
            }
        }
    }

    public void fireCalendarReadEvent(ProjectCalendar projectCalendar) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.calendarRead(projectCalendar);
            }
        }
    }

    public void fireAssignmentReadEvent(ResourceAssignment resourceAssignment) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.assignmentRead(resourceAssignment);
            }
        }
    }

    public void fireAssignmentWrittenEvent(ResourceAssignment resourceAssignment) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.assignmentWritten(resourceAssignment);
            }
        }
    }

    public void fireRelationReadEvent(Relation relation) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.relationRead(relation);
            }
        }
    }

    public void fireRelationWrittenEvent(Relation relation) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.relationWritten(relation);
            }
        }
    }

    public void fireCalendarWrittenEvent(ProjectCalendar projectCalendar) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.calendarWritten(projectCalendar);
            }
        }
    }

    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    public void addProjectListeners(List<ProjectListener> list) {
        if (list != null) {
            for (ProjectListener projectListener : list) {
                this.addProjectListener(projectListener);
            }
        }
    }

    public void removeProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners != null) {
            this.m_projectListeners.remove(projectListener);
        }
    }

    public void setTaskFieldAlias(TaskField taskField, String string) {
        if (string != null && string.length() != 0) {
            this.m_taskFieldAlias.put(taskField, string);
            this.m_aliasTaskField.put(string, taskField);
        }
    }

    public String getTaskFieldAlias(TaskField taskField) {
        return this.m_taskFieldAlias.get(taskField);
    }

    public TaskField getAliasTaskField(String string) {
        return this.m_aliasTaskField.get(string);
    }

    public void setTaskFieldValueList(TaskField taskField, List<Object> list) {
        if (list != null && list.size() != 0) {
            this.m_taskFieldValueList.put(taskField, list);
        }
    }

    public List<Object> getTaskFieldValueList(TaskField taskField) {
        return this.m_taskFieldValueList.get(taskField);
    }

    public void setTaskFieldDescriptionList(TaskField taskField, List<String> list) {
        if (list != null && list.size() != 0) {
            this.m_taskFieldDescriptionList.put(taskField, list);
        }
    }

    public List<String> getTaskFieldDescriptionList(TaskField taskField) {
        return this.m_taskFieldDescriptionList.get(taskField);
    }

    public void setResourceFieldAlias(ResourceField resourceField, String string) {
        if (string != null && string.length() != 0) {
            this.m_resourceFieldAlias.put(resourceField, string);
            this.m_aliasResourceField.put(string, resourceField);
        }
    }

    public String getResourceFieldAlias(ResourceField resourceField) {
        return this.m_resourceFieldAlias.get(resourceField);
    }

    public ResourceField getAliasResourceField(String string) {
        return this.m_aliasResourceField.get(string);
    }

    public Map<TaskField, String> getTaskFieldAliasMap() {
        return this.m_taskFieldAlias;
    }

    public Map<ResourceField, String> getResourceFieldAliasMap() {
        return this.m_resourceFieldAlias;
    }

    void unmapTaskUniqueID(Integer n) {
        this.m_taskUniqueIDMap.remove(n);
    }

    void mapTaskUniqueID(Integer n, Task task) {
        this.m_taskUniqueIDMap.put(n, task);
    }

    void unmapTaskID(Integer n) {
        this.m_taskIDMap.remove(n);
    }

    void mapTaskID(Integer n, Task task) {
        this.m_taskIDMap.put(n, task);
    }

    void unmapResourceUniqueID(Integer n) {
        this.m_resourceUniqueIDMap.remove(n);
    }

    void mapResourceUniqueID(Integer n, Resource resource) {
        this.m_resourceUniqueIDMap.put(n, resource);
    }

    void unmapResourceID(Integer n) {
        this.m_resourceIDMap.remove(n);
    }

    void mapResourceID(Integer n, Resource resource) {
        this.m_resourceIDMap.put(n, resource);
    }

    void unmapCalendarUniqueID(Integer n) {
        this.m_calendarUniqueIDMap.remove(n);
    }

    void mapCalendarUniqueID(Integer n, ProjectCalendar projectCalendar) {
        this.m_calendarUniqueIDMap.put(n, projectCalendar);
    }

    public int getMppFileType() {
        return this.m_mppFileType;
    }

    public void setMppFileType(int n) {
        this.m_mppFileType = n;
    }

    public void addView(View view) {
        this.m_views.add(view);
    }

    public List<View> getViews() {
        return this.m_views;
    }

    public void addTable(Table table) {
        this.m_tables.add(table);
        if (!table.getResourceFlag()) {
            this.m_taskTablesByName.put(table.getName(), table);
        } else {
            this.m_resourceTablesByName.put(table.getName(), table);
        }
    }

    public List<Table> getTables() {
        return this.m_tables;
    }

    public void addFilter(Filter filter) {
        if (filter.isTaskFilter()) {
            this.m_taskFilters.add(filter);
        }
        if (filter.isResourceFilter()) {
            this.m_resourceFilters.add(filter);
        }
        this.m_filtersByName.put(filter.getName(), filter);
        this.m_filtersByID.put(filter.getID(), filter);
    }

    public void removeFilter(String string) {
        Filter filter = this.getFilterByName(string);
        if (filter != null) {
            if (filter.isTaskFilter()) {
                this.m_taskFilters.remove(filter);
            }
            if (filter.isResourceFilter()) {
                this.m_resourceFilters.remove(filter);
            }
            this.m_filtersByName.remove(string);
            this.m_filtersByID.remove(filter.getID());
        }
    }

    public List<Filter> getAllResourceFilters() {
        return this.m_resourceFilters;
    }

    public List<Filter> getAllTaskFilters() {
        return this.m_taskFilters;
    }

    public Filter getFilterByName(String string) {
        return this.m_filtersByName.get(string);
    }

    public Filter getFilterByID(Integer n) {
        return this.m_filtersByID.get(n);
    }

    public List<Group> getAllGroups() {
        return this.m_groups;
    }

    public Group getGroupByName(String string) {
        return this.m_groupsByName.get(string);
    }

    public void addGroup(Group group) {
        this.m_groups.add(group);
        this.m_groupsByName.put(group.getName(), group);
    }

    public void addGraphicalIndicator(FieldType fieldType, GraphicalIndicator graphicalIndicator) {
        this.m_graphicalIndicators.put(fieldType, graphicalIndicator);
    }

    public GraphicalIndicator getGraphicalIndicator(FieldType fieldType) {
        return this.m_graphicalIndicators.get(fieldType);
    }

    public Table getTaskTableByName(String string) {
        return this.m_taskTablesByName.get(string);
    }

    public Table getResourceTableByName(String string) {
        return this.m_resourceTablesByName.get(string);
    }

    public void setResourceSubProject(SubProject subProject) {
        this.m_resourceSubProject = subProject;
    }

    public SubProject getResourceSubProject() {
        return this.m_resourceSubProject;
    }

    public void addSubProject(SubProject subProject) {
        this.m_allSubProjects.add(subProject);
    }

    public List<SubProject> getAllSubProjects() {
        return this.m_allSubProjects;
    }

    public boolean getAutoFilter() {
        return this.m_autoFilter;
    }

    public void setAutoFilter(boolean bl) {
        this.m_autoFilter = bl;
    }

    public void setViewState(ViewState viewState) {
        this.m_viewState = viewState;
    }

    public ViewState getViewState() {
        return this.m_viewState;
    }

    public void setEncoded(boolean bl) {
        this.m_encoded = bl;
    }

    public boolean getEncoded() {
        return this.m_encoded;
    }

    public void setEncryptionCode(byte by) {
        this.m_encryptionKey = by != 0 ? (byte)(255 - by) : (byte)0;
    }

    public byte getEncryptionCode() {
        return this.m_encryptionKey;
    }

    public void setProjectFilePath(String string) {
        this.m_projectFilePath = string;
    }

    public String getProjectFilePath() {
        return this.m_projectFilePath;
    }

    public void addCustomFieldValueItem(CustomFieldValueItem customFieldValueItem) {
        this.m_customFieldValueItems.put(customFieldValueItem.getUniqueID(), customFieldValueItem);
    }

    public CustomFieldValueItem getCustomFieldValueItem(Integer n) {
        return this.m_customFieldValueItems.get(n);
    }

    public ProjectCalendar getCalendar() {
        String string = this.m_projectHeader.getCalendarName();
        ProjectCalendar projectCalendar = this.getBaseCalendar(string);
        return projectCalendar;
    }

    public void setCalendar(ProjectCalendar projectCalendar) {
        this.m_projectHeader.setCalendarName(projectCalendar.getName());
    }

    public ProjectCalendar getBaselineCalendar() {
        ProjectCalendar projectCalendar = this.getBaseCalendar("Used for Microsoft Project 98 Baseline Calendar");
        if (projectCalendar == null) {
            projectCalendar = this.getCalendar();
        }
        return projectCalendar;
    }
}

