/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.Column;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpp.ExtendedData;
import net.sf.mpxj.mpp.FixDeferFix;
import net.sf.mpxj.mpp.FixFix;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.mpp.ProjectHeaderReader;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props8;
import net.sf.mpxj.mpp.RecurringTaskReader;
import net.sf.mpxj.mpp.View8;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.Pair;
import net.sf.mpxj.utility.RTFUtility;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MPP8Reader
implements MPPVariantReader {
    private MPPReader m_reader;
    private ProjectFile m_file;
    private HashMap<Integer, ProjectCalendar> m_calendarMap;
    private DirectoryEntry m_root;
    private DirectoryEntry m_projectDir;
    private DirectoryEntry m_viewDir;
    private static final Integer TASK_WBS = 104;
    private static final Integer TASK_CONTACT = 105;
    private static final Integer TASK_TEXT1 = 106;
    private static final Integer TASK_TEXT2 = 107;
    private static final Integer TASK_TEXT3 = 108;
    private static final Integer TASK_TEXT4 = 109;
    private static final Integer TASK_TEXT5 = 110;
    private static final Integer TASK_TEXT6 = 111;
    private static final Integer TASK_TEXT7 = 112;
    private static final Integer TASK_TEXT8 = 113;
    private static final Integer TASK_TEXT9 = 114;
    private static final Integer TASK_TEXT10 = 115;
    private static final Integer TASK_START1 = 116;
    private static final Integer TASK_FINISH1 = 117;
    private static final Integer TASK_START2 = 118;
    private static final Integer TASK_FINISH2 = 119;
    private static final Integer TASK_START3 = 120;
    private static final Integer TASK_FINISH3 = 121;
    private static final Integer TASK_START4 = 122;
    private static final Integer TASK_FINISH4 = 123;
    private static final Integer TASK_START5 = 124;
    private static final Integer TASK_FINISH5 = 125;
    private static final Integer TASK_START6 = 126;
    private static final Integer TASK_FINISH6 = 127;
    private static final Integer TASK_START7 = 128;
    private static final Integer TASK_FINISH7 = 129;
    private static final Integer TASK_START8 = 130;
    private static final Integer TASK_FINISH8 = 131;
    private static final Integer TASK_START9 = 132;
    private static final Integer TASK_FINISH9 = 133;
    private static final Integer TASK_START10 = 134;
    private static final Integer TASK_FINISH10 = 135;
    private static final Integer TASK_NUMBER1 = 137;
    private static final Integer TASK_NUMBER2 = 138;
    private static final Integer TASK_NUMBER3 = 139;
    private static final Integer TASK_NUMBER4 = 140;
    private static final Integer TASK_NUMBER5 = 141;
    private static final Integer TASK_NUMBER6 = 142;
    private static final Integer TASK_NUMBER7 = 143;
    private static final Integer TASK_NUMBER8 = 144;
    private static final Integer TASK_NUMBER9 = 145;
    private static final Integer TASK_NUMBER10 = 146;
    private static final Integer TASK_DURATION1 = 147;
    private static final Integer TASK_DURATION1_UNITS = 148;
    private static final Integer TASK_DURATION2 = 149;
    private static final Integer TASK_DURATION2_UNITS = 150;
    private static final Integer TASK_DURATION3 = 151;
    private static final Integer TASK_DURATION3_UNITS = 152;
    private static final Integer TASK_DURATION4 = 153;
    private static final Integer TASK_DURATION4_UNITS = 154;
    private static final Integer TASK_DURATION5 = 155;
    private static final Integer TASK_DURATION5_UNITS = 156;
    private static final Integer TASK_DURATION6 = 157;
    private static final Integer TASK_DURATION6_UNITS = 158;
    private static final Integer TASK_DURATION7 = 159;
    private static final Integer TASK_DURATION7_UNITS = 160;
    private static final Integer TASK_DURATION8 = 161;
    private static final Integer TASK_DURATION8_UNITS = 162;
    private static final Integer TASK_DURATION9 = 163;
    private static final Integer TASK_DURATION9_UNITS = 164;
    private static final Integer TASK_DURATION10 = 165;
    private static final Integer TASK_DURATION10_UNITS = 166;
    private static final Integer TASK_RECURRING_DATA = 168;
    private static final Integer TASK_DATE1 = 174;
    private static final Integer TASK_DATE2 = 175;
    private static final Integer TASK_DATE3 = 176;
    private static final Integer TASK_DATE4 = 177;
    private static final Integer TASK_DATE5 = 178;
    private static final Integer TASK_DATE6 = 179;
    private static final Integer TASK_DATE7 = 180;
    private static final Integer TASK_DATE8 = 181;
    private static final Integer TASK_DATE9 = 182;
    private static final Integer TASK_DATE10 = 183;
    private static final Integer TASK_TEXT11 = 184;
    private static final Integer TASK_TEXT12 = 185;
    private static final Integer TASK_TEXT13 = 186;
    private static final Integer TASK_TEXT14 = 187;
    private static final Integer TASK_TEXT15 = 188;
    private static final Integer TASK_TEXT16 = 189;
    private static final Integer TASK_TEXT17 = 190;
    private static final Integer TASK_TEXT18 = 191;
    private static final Integer TASK_TEXT19 = 192;
    private static final Integer TASK_TEXT20 = 193;
    private static final Integer TASK_TEXT21 = 194;
    private static final Integer TASK_TEXT22 = 195;
    private static final Integer TASK_TEXT23 = 196;
    private static final Integer TASK_TEXT24 = 197;
    private static final Integer TASK_TEXT25 = 198;
    private static final Integer TASK_TEXT26 = 199;
    private static final Integer TASK_TEXT27 = 200;
    private static final Integer TASK_TEXT28 = 201;
    private static final Integer TASK_TEXT29 = 202;
    private static final Integer TASK_TEXT30 = 203;
    private static final Integer TASK_NUMBER11 = 204;
    private static final Integer TASK_NUMBER12 = 205;
    private static final Integer TASK_NUMBER13 = 206;
    private static final Integer TASK_NUMBER14 = 207;
    private static final Integer TASK_NUMBER15 = 208;
    private static final Integer TASK_NUMBER16 = 209;
    private static final Integer TASK_NUMBER17 = 210;
    private static final Integer TASK_NUMBER18 = 211;
    private static final Integer TASK_NUMBER19 = 212;
    private static final Integer TASK_NUMBER20 = 213;
    private static final Integer TASK_HYPERLINK = 236;
    private static final Integer TASK_COST1 = 237;
    private static final Integer TASK_COST2 = 238;
    private static final Integer TASK_COST3 = 239;
    private static final Integer TASK_COST4 = 240;
    private static final Integer TASK_COST5 = 241;
    private static final Integer TASK_COST6 = 242;
    private static final Integer TASK_COST7 = 243;
    private static final Integer TASK_COST8 = 244;
    private static final Integer TASK_COST9 = 245;
    private static final Integer TASK_COST10 = 246;
    private static final Integer TASK_NOTES = 247;
    private static final Integer RESOURCE_GROUP = 61;
    private static final Integer RESOURCE_CODE = 62;
    private static final Integer RESOURCE_EMAIL = 63;
    private static final Integer RESOURCE_TEXT1 = 64;
    private static final Integer RESOURCE_TEXT2 = 65;
    private static final Integer RESOURCE_TEXT3 = 66;
    private static final Integer RESOURCE_TEXT4 = 67;
    private static final Integer RESOURCE_TEXT5 = 68;
    private static final Integer RESOURCE_TEXT6 = 69;
    private static final Integer RESOURCE_TEXT7 = 70;
    private static final Integer RESOURCE_TEXT8 = 71;
    private static final Integer RESOURCE_TEXT9 = 72;
    private static final Integer RESOURCE_TEXT10 = 73;
    private static final Integer RESOURCE_TEXT11 = 74;
    private static final Integer RESOURCE_TEXT12 = 75;
    private static final Integer RESOURCE_TEXT13 = 76;
    private static final Integer RESOURCE_TEXT14 = 77;
    private static final Integer RESOURCE_TEXT15 = 78;
    private static final Integer RESOURCE_TEXT16 = 79;
    private static final Integer RESOURCE_TEXT17 = 80;
    private static final Integer RESOURCE_TEXT18 = 81;
    private static final Integer RESOURCE_TEXT19 = 82;
    private static final Integer RESOURCE_TEXT20 = 83;
    private static final Integer RESOURCE_TEXT21 = 84;
    private static final Integer RESOURCE_TEXT22 = 85;
    private static final Integer RESOURCE_TEXT23 = 86;
    private static final Integer RESOURCE_TEXT24 = 87;
    private static final Integer RESOURCE_TEXT25 = 88;
    private static final Integer RESOURCE_TEXT26 = 89;
    private static final Integer RESOURCE_TEXT27 = 90;
    private static final Integer RESOURCE_TEXT28 = 91;
    private static final Integer RESOURCE_TEXT29 = 92;
    private static final Integer RESOURCE_TEXT30 = 93;
    private static final Integer RESOURCE_START1 = 94;
    private static final Integer RESOURCE_START2 = 95;
    private static final Integer RESOURCE_START3 = 96;
    private static final Integer RESOURCE_START4 = 97;
    private static final Integer RESOURCE_START5 = 98;
    private static final Integer RESOURCE_START6 = 99;
    private static final Integer RESOURCE_START7 = 100;
    private static final Integer RESOURCE_START8 = 101;
    private static final Integer RESOURCE_START9 = 102;
    private static final Integer RESOURCE_START10 = 103;
    private static final Integer RESOURCE_FINISH1 = 104;
    private static final Integer RESOURCE_FINISH2 = 105;
    private static final Integer RESOURCE_FINISH3 = 106;
    private static final Integer RESOURCE_FINISH4 = 107;
    private static final Integer RESOURCE_FINISH5 = 108;
    private static final Integer RESOURCE_FINISH6 = 109;
    private static final Integer RESOURCE_FINISH7 = 110;
    private static final Integer RESOURCE_FINISH8 = 111;
    private static final Integer RESOURCE_FINISH9 = 112;
    private static final Integer RESOURCE_FINISH10 = 113;
    private static final Integer RESOURCE_NUMBER1 = 114;
    private static final Integer RESOURCE_NUMBER2 = 115;
    private static final Integer RESOURCE_NUMBER3 = 116;
    private static final Integer RESOURCE_NUMBER4 = 117;
    private static final Integer RESOURCE_NUMBER5 = 118;
    private static final Integer RESOURCE_NUMBER6 = 119;
    private static final Integer RESOURCE_NUMBER7 = 120;
    private static final Integer RESOURCE_NUMBER8 = 121;
    private static final Integer RESOURCE_NUMBER9 = 122;
    private static final Integer RESOURCE_NUMBER10 = 123;
    private static final Integer RESOURCE_NUMBER11 = 124;
    private static final Integer RESOURCE_NUMBER12 = 125;
    private static final Integer RESOURCE_NUMBER13 = 126;
    private static final Integer RESOURCE_NUMBER14 = 127;
    private static final Integer RESOURCE_NUMBER15 = 128;
    private static final Integer RESOURCE_NUMBER16 = 129;
    private static final Integer RESOURCE_NUMBER17 = 130;
    private static final Integer RESOURCE_NUMBER18 = 131;
    private static final Integer RESOURCE_NUMBER19 = 132;
    private static final Integer RESOURCE_NUMBER20 = 133;
    private static final Integer RESOURCE_DURATION1 = 134;
    private static final Integer RESOURCE_DURATION2 = 135;
    private static final Integer RESOURCE_DURATION3 = 136;
    private static final Integer RESOURCE_DURATION4 = 137;
    private static final Integer RESOURCE_DURATION5 = 138;
    private static final Integer RESOURCE_DURATION6 = 139;
    private static final Integer RESOURCE_DURATION7 = 140;
    private static final Integer RESOURCE_DURATION8 = 141;
    private static final Integer RESOURCE_DURATION9 = 142;
    private static final Integer RESOURCE_DURATION10 = 143;
    private static final Integer RESOURCE_DURATION1_UNITS = 144;
    private static final Integer RESOURCE_DURATION2_UNITS = 145;
    private static final Integer RESOURCE_DURATION3_UNITS = 146;
    private static final Integer RESOURCE_DURATION4_UNITS = 147;
    private static final Integer RESOURCE_DURATION5_UNITS = 148;
    private static final Integer RESOURCE_DURATION6_UNITS = 149;
    private static final Integer RESOURCE_DURATION7_UNITS = 150;
    private static final Integer RESOURCE_DURATION8_UNITS = 151;
    private static final Integer RESOURCE_DURATION9_UNITS = 152;
    private static final Integer RESOURCE_DURATION10_UNITS = 153;
    private static final Integer RESOURCE_DATE1 = 157;
    private static final Integer RESOURCE_DATE2 = 158;
    private static final Integer RESOURCE_DATE3 = 159;
    private static final Integer RESOURCE_DATE4 = 160;
    private static final Integer RESOURCE_DATE5 = 161;
    private static final Integer RESOURCE_DATE6 = 162;
    private static final Integer RESOURCE_DATE7 = 163;
    private static final Integer RESOURCE_DATE8 = 164;
    private static final Integer RESOURCE_DATE9 = 165;
    private static final Integer RESOURCE_DATE10 = 166;
    private static final Integer RESOURCE_NOTES = 169;
    private static final Integer RESOURCE_COST1 = 170;
    private static final Integer RESOURCE_COST2 = 171;
    private static final Integer RESOURCE_COST3 = 172;
    private static final Integer RESOURCE_COST4 = 173;
    private static final Integer RESOURCE_COST5 = 174;
    private static final Integer RESOURCE_COST6 = 175;
    private static final Integer RESOURCE_COST7 = 176;
    private static final Integer RESOURCE_COST8 = 177;
    private static final Integer RESOURCE_COST9 = 178;
    private static final Integer RESOURCE_COST10 = 179;
    private static final boolean[] DEFAULT_WORKING_WEEK = new boolean[]{false, true, true, true, true, true, false};

    MPP8Reader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MPPReader mPPReader, ProjectFile projectFile, DirectoryEntry directoryEntry) throws MPXJException, IOException {
        try {
            this.m_reader = mPPReader;
            this.m_root = directoryEntry;
            this.m_file = projectFile;
            this.m_calendarMap = new HashMap();
            this.m_projectDir = (DirectoryEntry)directoryEntry.getEntry("   1");
            this.m_viewDir = (DirectoryEntry)directoryEntry.getEntry("   2");
            this.m_file.setMppFileType(8);
            this.processPropertyData();
            this.processCalendarData();
            this.processResourceData();
            this.processTaskData();
            this.processConstraintData();
            this.processAssignmentData();
            if (mPPReader.getReadPresentationData()) {
                this.processViewPropertyData();
                this.processViewData();
                this.processTableData();
            }
            Object var5_4 = null;
            this.m_reader = null;
            this.m_root = null;
            this.m_file = null;
            this.m_calendarMap = null;
            this.m_projectDir = null;
            this.m_viewDir = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_reader = null;
            this.m_root = null;
            this.m_file = null;
            this.m_calendarMap = null;
            this.m_projectDir = null;
            this.m_viewDir = null;
            throw throwable;
        }
    }

    private void processPropertyData() throws MPXJException, IOException {
        Props8 props8 = new Props8(new DocumentInputStream((DocumentEntry)this.m_projectDir.getEntry("Props")));
        ProjectHeaderReader projectHeaderReader = new ProjectHeaderReader();
        projectHeaderReader.process(this.m_file, props8, this.m_root);
    }

    private void processViewPropertyData() throws IOException {
        Props8 props8 = new Props8(new DocumentInputStream((DocumentEntry)this.m_viewDir.getEntry("Props")));
        ProjectHeader projectHeader = this.m_file.getProjectHeader();
        projectHeader.setShowProjectSummaryTask(props8.getBoolean(Props.SHOW_PROJECT_SUMMARY_TASK));
    }

    private void processCalendarData() throws MPXJException, IOException {
        Date date;
        Date date2;
        Date date3;
        Date date4;
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCal");
        FixFix fixFix = new FixFix(36, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        FixDeferFix fixDeferFix = new FixDeferFix(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixDeferFix   0")));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        try {
            date4 = simpleDateFormat.parse("08:00");
            date3 = simpleDateFormat.parse("12:00");
            date2 = simpleDateFormat.parse("13:00");
            date = simpleDateFormat.parse("17:00");
        }
        catch (ParseException parseException) {
            throw new MPXJException("Invalid format", parseException);
        }
        int n = fixFix.getItemCount();
        LinkedList<Pair<ProjectCalendar, Integer>> linkedList = new LinkedList<Pair<ProjectCalendar, Integer>>();
        for (int i = 0; i < n; ++i) {
            ProjectCalendar projectCalendar;
            byte[] byArray = fixFix.getByteArrayValue(i);
            int n2 = MPPUtility.getInt(byArray, 0);
            int n3 = MPPUtility.getInt(byArray, 4);
            String string = fixDeferFix.getUnicodeString(this.getOffset(byArray, 20));
            if (n2 < 0) continue;
            ExtendedData extendedData = new ExtendedData(fixDeferFix, this.getOffset(byArray, 32));
            int n4 = -1 - extendedData.getInt(8);
            if (n4 == -1) {
                if (n3 > 0) {
                    projectCalendar = this.m_file.getDefaultResourceCalendar();
                    linkedList.add(new Pair<ProjectCalendar, Integer>(projectCalendar, n3));
                } else {
                    projectCalendar = this.m_file.addDefaultBaseCalendar();
                    projectCalendar.setName(string);
                }
                projectCalendar.setUniqueID(n2);
            } else {
                long l;
                Date date5;
                int n5;
                int n6;
                if (n3 > 0) {
                    projectCalendar = this.m_file.addResourceCalendar();
                    linkedList.add(new Pair<ProjectCalendar, Integer>(projectCalendar, n3));
                } else {
                    projectCalendar = this.m_file.addBaseCalendar();
                    projectCalendar.setName(string);
                }
                projectCalendar.setUniqueID(n2);
                byte[] byArray2 = fixDeferFix.getByteArray(n4);
                for (n6 = 0; n6 < 7; ++n6) {
                    ProjectCalendarHours projectCalendarHours;
                    n4 = 4 + 40 * n6;
                    int n7 = MPPUtility.getShort(byArray2, n4);
                    Day day = Day.getInstance(n6 + 1);
                    if (n7 == 1) {
                        projectCalendar.setWorkingDay(day, DEFAULT_WORKING_WEEK[n6]);
                        if (!projectCalendar.isWorkingDay(day)) continue;
                        projectCalendarHours = projectCalendar.addCalendarHours(Day.getInstance(n6 + 1));
                        projectCalendarHours.addRange(new DateRange(date4, date3));
                        projectCalendarHours.addRange(new DateRange(date2, date));
                        continue;
                    }
                    n5 = MPPUtility.getShort(byArray2, n4 + 2);
                    if (n5 == 0) {
                        projectCalendar.setWorkingDay(day, false);
                        continue;
                    }
                    projectCalendar.setWorkingDay(day, true);
                    projectCalendarHours = projectCalendar.addCalendarHours(Day.getInstance(n6 + 1));
                    for (int j = 0; j < n5; ++j) {
                        date5 = MPPUtility.getTime(byArray2, n4 + 8 + j * 2);
                        l = MPPUtility.getDuration(byArray2, n4 + 16 + j * 4);
                        projectCalendarHours.addRange(new DateRange(date5, new Date(date5.getTime() + l)));
                    }
                }
                int n8 = MPPUtility.getShort(byArray2, 0);
                if (n8 != 0) {
                    for (n6 = 0; n6 < n8; ++n6) {
                        n4 = 284 + n6 * 44;
                        Date date6 = MPPUtility.getDate(byArray2, n4);
                        Date date7 = MPPUtility.getDate(byArray2, n4 + 2);
                        ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date6, date7);
                        n5 = MPPUtility.getShort(byArray2, n4 + 6);
                        if (n5 == 0) continue;
                        for (int j = 0; j < n5; ++j) {
                            date5 = MPPUtility.getTime(byArray2, n4 + 12 + j * 2);
                            l = MPPUtility.getDuration(byArray2, n4 + 20 + j * 4);
                            projectCalendarException.addRange(new DateRange(date5, new Date(date5.getTime() + l)));
                        }
                    }
                }
            }
            this.m_calendarMap.put(n2, projectCalendar);
            this.m_file.fireCalendarReadEvent(projectCalendar);
        }
        this.updateBaseCalendarNames(linkedList);
    }

    private void updateBaseCalendarNames(List<Pair<ProjectCalendar, Integer>> list) {
        for (Pair<ProjectCalendar, Integer> pair : list) {
            ProjectCalendar projectCalendar = pair.getFirst();
            Integer n = pair.getSecond();
            ProjectCalendar projectCalendar2 = this.m_calendarMap.get(n);
            if (projectCalendar2 == null) continue;
            projectCalendar.setParent(projectCalendar2);
        }
    }

    private void processTaskData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        FixFix fixFix = new FixFix(316, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        if (fixFix.getDiff() != 0) {
            fixFix = new FixFix(366, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        }
        FixDeferFix fixDeferFix = null;
        ExtendedData extendedData = null;
        int n = fixFix.getItemCount();
        boolean bl = true;
        RTFUtility rTFUtility = new RTFUtility();
        byte[] byArray = new byte[3];
        RecurringTaskReader recurringTaskReader = null;
        for (int i = 0; i < n; ++i) {
            String string;
            int n2;
            byte[] byArray2 = fixFix.getByteArrayValue(i);
            int n3 = MPPUtility.getInt(byArray2, 0);
            if (n3 < 1 || ((n2 = MPPUtility.getShort(byArray2, 272)) & 0xC0) == 0 && (n2 & 3) != 0 && n2 != 49 && n2 != 8253) continue;
            if (fixDeferFix == null) {
                fixDeferFix = new FixDeferFix(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixDeferFix   0")));
            }
            if ((byArray2[8] & 1) != 0) continue;
            extendedData = new ExtendedData(fixDeferFix, this.getOffset(byArray2, 312));
            byte[] byArray3 = extendedData.getByteArray(TASK_RECURRING_DATA);
            int n4 = MPPUtility.getInt(byArray2, 4);
            byArray[0] = (byte)(byArray2[268] & byArray2[303]);
            byArray[1] = (byte)(byArray2[269] & byArray2[304]);
            byArray[2] = (byte)(byArray2[270] & byArray2[305]);
            Task task = this.m_file.addTask();
            task.setActualCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray2, 234) / 100.0));
            task.setActualDuration(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(byArray2, 74), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 72))));
            task.setActualFinish(MPPUtility.getTimestamp(byArray2, 108));
            task.setActualOvertimeCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray2, 210) / 100.0));
            task.setActualOvertimeWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray2, 192) / 100.0, TimeUnit.HOURS));
            task.setActualStart(MPPUtility.getTimestamp(byArray2, 104));
            task.setActualWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray2, 180) / 100.0, TimeUnit.HOURS));
            task.setBaselineCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray2, 246) / 100.0));
            task.setBaselineDuration(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(byArray2, 82), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 72))));
            task.setBaselineFinish(MPPUtility.getTimestamp(byArray2, 116));
            task.setBaselineStart(MPPUtility.getTimestamp(byArray2, 112));
            task.setBaselineWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray2, 174) / 100.0, TimeUnit.HOURS));
            task.setConstraintDate(MPPUtility.getTimestamp(byArray2, 120));
            task.setConstraintType(ConstraintType.getInstance(MPPUtility.getShort(byArray2, 88)));
            task.setContact(extendedData.getUnicodeString(TASK_CONTACT));
            task.setCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray2, 222) / 100.0));
            task.setCost1(NumberUtility.getDouble((double)extendedData.getLong(TASK_COST1) / 100.0));
            task.setCost2(NumberUtility.getDouble((double)extendedData.getLong(TASK_COST2) / 100.0));
            task.setCost3(NumberUtility.getDouble((double)extendedData.getLong(TASK_COST3) / 100.0));
            task.setCost4(NumberUtility.getDouble((double)extendedData.getLong(TASK_COST4) / 100.0));
            task.setCost5(NumberUtility.getDouble((double)extendedData.getLong(TASK_COST5) / 100.0));
            task.setCost6(NumberUtility.getDouble((double)extendedData.getLong(TASK_COST6) / 100.0));
            task.setCost7(NumberUtility.getDouble((double)extendedData.getLong(TASK_COST7) / 100.0));
            task.setCost8(NumberUtility.getDouble((double)extendedData.getLong(TASK_COST8) / 100.0));
            task.setCost9(NumberUtility.getDouble((double)extendedData.getLong(TASK_COST9) / 100.0));
            task.setCost10(NumberUtility.getDouble((double)extendedData.getLong(TASK_COST10) / 100.0));
            task.setCreateDate(MPPUtility.getTimestamp(byArray2, 138));
            task.setDate1(extendedData.getTimestamp(TASK_DATE1));
            task.setDate2(extendedData.getTimestamp(TASK_DATE2));
            task.setDate3(extendedData.getTimestamp(TASK_DATE3));
            task.setDate4(extendedData.getTimestamp(TASK_DATE4));
            task.setDate5(extendedData.getTimestamp(TASK_DATE5));
            task.setDate6(extendedData.getTimestamp(TASK_DATE6));
            task.setDate7(extendedData.getTimestamp(TASK_DATE7));
            task.setDate8(extendedData.getTimestamp(TASK_DATE8));
            task.setDate9(extendedData.getTimestamp(TASK_DATE9));
            task.setDate10(extendedData.getTimestamp(TASK_DATE10));
            task.setDuration(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(byArray2, 68), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 72))));
            task.setDuration1(MPPUtility.getAdjustedDuration(this.m_file, extendedData.getInt(TASK_DURATION1), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION1_UNITS))));
            task.setDuration2(MPPUtility.getAdjustedDuration(this.m_file, extendedData.getInt(TASK_DURATION2), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION2_UNITS))));
            task.setDuration3(MPPUtility.getAdjustedDuration(this.m_file, extendedData.getInt(TASK_DURATION3), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION3_UNITS))));
            task.setDuration4(MPPUtility.getAdjustedDuration(this.m_file, extendedData.getInt(TASK_DURATION4), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION4_UNITS))));
            task.setDuration5(MPPUtility.getAdjustedDuration(this.m_file, extendedData.getInt(TASK_DURATION5), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION5_UNITS))));
            task.setDuration6(MPPUtility.getAdjustedDuration(this.m_file, extendedData.getInt(TASK_DURATION6), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION6_UNITS))));
            task.setDuration7(MPPUtility.getAdjustedDuration(this.m_file, extendedData.getInt(TASK_DURATION7), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION7_UNITS))));
            task.setDuration8(MPPUtility.getAdjustedDuration(this.m_file, extendedData.getInt(TASK_DURATION8), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION8_UNITS))));
            task.setDuration9(MPPUtility.getAdjustedDuration(this.m_file, extendedData.getInt(TASK_DURATION9), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION9_UNITS))));
            task.setDuration10(MPPUtility.getAdjustedDuration(this.m_file, extendedData.getInt(TASK_DURATION10), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION10_UNITS))));
            task.setEarlyFinish(MPPUtility.getTimestamp(byArray2, 20));
            task.setEarlyStart(MPPUtility.getTimestamp(byArray2, 96));
            task.setEffortDriven((byArray2[17] & 8) != 0);
            task.setFinish(MPPUtility.getTimestamp(byArray2, 20));
            task.setFinish1(extendedData.getTimestamp(TASK_FINISH1));
            task.setFinish2(extendedData.getTimestamp(TASK_FINISH2));
            task.setFinish3(extendedData.getTimestamp(TASK_FINISH3));
            task.setFinish4(extendedData.getTimestamp(TASK_FINISH4));
            task.setFinish5(extendedData.getTimestamp(TASK_FINISH5));
            task.setFinish6(extendedData.getTimestamp(TASK_FINISH6));
            task.setFinish7(extendedData.getTimestamp(TASK_FINISH7));
            task.setFinish8(extendedData.getTimestamp(TASK_FINISH8));
            task.setFinish9(extendedData.getTimestamp(TASK_FINISH9));
            task.setFinish10(extendedData.getTimestamp(TASK_FINISH10));
            task.setFixedCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray2, 228) / 100.0));
            task.setFixedCostAccrual(AccrueType.getInstance(MPPUtility.getShort(byArray2, 136)));
            task.setFlag1((byArray[0] & 2) != 0);
            task.setFlag2((byArray[0] & 4) != 0);
            task.setFlag3((byArray[0] & 8) != 0);
            task.setFlag4((byArray[0] & 0x10) != 0);
            task.setFlag5((byArray[0] & 0x20) != 0);
            task.setFlag6((byArray[0] & 0x40) != 0);
            task.setFlag7((byArray[0] & 0x80) != 0);
            task.setFlag8((byArray[1] & 1) != 0);
            task.setFlag9((byArray[1] & 2) != 0);
            task.setFlag10((byArray[1] & 4) != 0);
            task.setFlag11((byArray[1] & 8) != 0);
            task.setFlag12((byArray[1] & 0x10) != 0);
            task.setFlag13((byArray[1] & 0x20) != 0);
            task.setFlag14((byArray[1] & 0x40) != 0);
            task.setFlag15((byArray[1] & 0x80) != 0);
            task.setFlag16((byArray[2] & 1) != 0);
            task.setFlag17((byArray[2] & 2) != 0);
            task.setFlag18((byArray[2] & 4) != 0);
            task.setFlag19((byArray[2] & 8) != 0);
            task.setFlag20((byArray[2] & 0x10) != 0);
            task.setHideBar((byArray2[16] & 1) != 0);
            this.processHyperlinkData(task, fixDeferFix.getByteArray(-1 - extendedData.getInt(TASK_HYPERLINK)));
            task.setID(n4);
            task.setLateFinish(MPPUtility.getTimestamp(byArray2, 160));
            task.setLateStart(MPPUtility.getTimestamp(byArray2, 24));
            task.setLevelAssignments((byArray2[19] & 0x10) != 0);
            task.setLevelingCanSplit((byArray2[19] & 8) != 0);
            task.setLevelingDelay(MPPUtility.getDuration((double)MPPUtility.getInt(byArray2, 90) / 3.0, MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 94))));
            task.setMarked((byArray2[13] & 2) != 0);
            task.setMilestone((byArray2[12] & 1) != 0);
            task.setName(fixDeferFix.getUnicodeString(this.getOffset(byArray2, 264)));
            task.setNumber1(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER1)));
            task.setNumber2(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER2)));
            task.setNumber3(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER3)));
            task.setNumber4(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER4)));
            task.setNumber5(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER5)));
            task.setNumber6(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER6)));
            task.setNumber7(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER7)));
            task.setNumber8(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER8)));
            task.setNumber9(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER9)));
            task.setNumber10(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER10)));
            task.setNumber11(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER11)));
            task.setNumber12(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER12)));
            task.setNumber13(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER13)));
            task.setNumber14(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER14)));
            task.setNumber15(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER15)));
            task.setNumber16(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER16)));
            task.setNumber17(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER17)));
            task.setNumber18(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER18)));
            task.setNumber19(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER19)));
            task.setNumber20(NumberUtility.getDouble(extendedData.getDouble(TASK_NUMBER20)));
            task.setOutlineLevel(MPPUtility.getShort(byArray2, 48));
            task.setOvertimeCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray2, 204) / 100.0));
            task.setPercentageComplete(MPPUtility.getPercentage(byArray2, 130));
            task.setPercentageWorkComplete(MPPUtility.getPercentage(byArray2, 132));
            task.setPreleveledFinish(MPPUtility.getTimestamp(byArray2, 148));
            task.setPreleveledStart(MPPUtility.getTimestamp(byArray2, 144));
            task.setPriority(Priority.getInstance((MPPUtility.getShort(byArray2, 128) + 1) * 100));
            task.setRecurring(MPPUtility.getShort(byArray2, 142) != 0);
            task.setRemainingCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray2, 240) / 100.0));
            task.setRemainingDuration(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(byArray2, 78), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 72))));
            task.setRemainingOvertimeCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray2, 216) / 100.0));
            task.setRemainingOvertimeWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray2, 198) / 100.0, TimeUnit.HOURS));
            task.setRemainingWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray2, 186) / 100.0, TimeUnit.HOURS));
            task.setResume(MPPUtility.getTimestamp(byArray2, 32));
            task.setRollup((byArray2[15] & 4) != 0);
            task.setStart(MPPUtility.getTimestamp(byArray2, 96));
            task.setStart1(extendedData.getTimestamp(TASK_START1));
            task.setStart2(extendedData.getTimestamp(TASK_START2));
            task.setStart3(extendedData.getTimestamp(TASK_START3));
            task.setStart4(extendedData.getTimestamp(TASK_START4));
            task.setStart5(extendedData.getTimestamp(TASK_START5));
            task.setStart6(extendedData.getTimestamp(TASK_START6));
            task.setStart7(extendedData.getTimestamp(TASK_START7));
            task.setStart8(extendedData.getTimestamp(TASK_START8));
            task.setStart9(extendedData.getTimestamp(TASK_START9));
            task.setStart10(extendedData.getTimestamp(TASK_START10));
            task.setStop(MPPUtility.getTimestamp(byArray2, 124));
            task.setText1(extendedData.getUnicodeString(TASK_TEXT1));
            task.setText2(extendedData.getUnicodeString(TASK_TEXT2));
            task.setText3(extendedData.getUnicodeString(TASK_TEXT3));
            task.setText4(extendedData.getUnicodeString(TASK_TEXT4));
            task.setText5(extendedData.getUnicodeString(TASK_TEXT5));
            task.setText6(extendedData.getUnicodeString(TASK_TEXT6));
            task.setText7(extendedData.getUnicodeString(TASK_TEXT7));
            task.setText8(extendedData.getUnicodeString(TASK_TEXT8));
            task.setText9(extendedData.getUnicodeString(TASK_TEXT9));
            task.setText10(extendedData.getUnicodeString(TASK_TEXT10));
            task.setText11(extendedData.getUnicodeString(TASK_TEXT11));
            task.setText12(extendedData.getUnicodeString(TASK_TEXT12));
            task.setText13(extendedData.getUnicodeString(TASK_TEXT13));
            task.setText14(extendedData.getUnicodeString(TASK_TEXT14));
            task.setText15(extendedData.getUnicodeString(TASK_TEXT15));
            task.setText16(extendedData.getUnicodeString(TASK_TEXT16));
            task.setText17(extendedData.getUnicodeString(TASK_TEXT17));
            task.setText18(extendedData.getUnicodeString(TASK_TEXT18));
            task.setText19(extendedData.getUnicodeString(TASK_TEXT19));
            task.setText20(extendedData.getUnicodeString(TASK_TEXT20));
            task.setText21(extendedData.getUnicodeString(TASK_TEXT21));
            task.setText22(extendedData.getUnicodeString(TASK_TEXT22));
            task.setText23(extendedData.getUnicodeString(TASK_TEXT23));
            task.setText24(extendedData.getUnicodeString(TASK_TEXT24));
            task.setText25(extendedData.getUnicodeString(TASK_TEXT25));
            task.setText26(extendedData.getUnicodeString(TASK_TEXT26));
            task.setText27(extendedData.getUnicodeString(TASK_TEXT27));
            task.setText28(extendedData.getUnicodeString(TASK_TEXT28));
            task.setText29(extendedData.getUnicodeString(TASK_TEXT29));
            task.setText30(extendedData.getUnicodeString(TASK_TEXT30));
            task.setType(TaskType.getInstance(MPPUtility.getShort(byArray2, 134)));
            task.setUniqueID(n3);
            task.setWBS(extendedData.getUnicodeString(TASK_WBS));
            task.setWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray2, 168) / 100.0, TimeUnit.HOURS));
            if (byArray3 != null) {
                if (recurringTaskReader == null) {
                    recurringTaskReader = new RecurringTaskReader(this.m_file);
                }
                recurringTaskReader.processRecurringTask(task, byArray3);
            }
            if ((string = extendedData.getString(TASK_NOTES)) != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    string = rTFUtility.strip(string);
                }
                task.setNotes(string);
            }
            if (task.getWBS() != null) {
                bl = false;
            }
            this.m_file.fireTaskReadEvent(task);
        }
        this.m_file.setAutoWBS(bl);
    }

    private void processHyperlinkData(Task task, byte[] byArray) {
        if (byArray != null) {
            int n = 12;
            String string = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string.length() + 1) * 2;
            String string2 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string2.length() + 1) * 2;
            String string3 = MPPUtility.getUnicodeString(byArray, n += 12);
            task.setHyperlink(string);
            task.setHyperlinkAddress(string2);
            task.setHyperlinkSubAddress(string3);
        }
    }

    private void processConstraintData() throws IOException {
        DirectoryEntry directoryEntry;
        try {
            directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCons");
        }
        catch (FileNotFoundException fileNotFoundException) {
            directoryEntry = null;
        }
        if (directoryEntry != null) {
            FixFix fixFix = new FixFix(36, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
            int n = fixFix.getItemCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                byte[] byArray = fixFix.getByteArrayValue(i);
                if (MPPUtility.getInt(byArray, 28) != 0 || (n3 = MPPUtility.getInt(byArray, 12)) == (n2 = MPPUtility.getInt(byArray, 16))) continue;
                Task task = this.m_file.getTaskByUniqueID(n3);
                Task task2 = this.m_file.getTaskByUniqueID(n2);
                if (task == null || task2 == null) continue;
                RelationType relationType = RelationType.getInstance(MPPUtility.getShort(byArray, 20));
                TimeUnit timeUnit = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray, 22));
                Duration duration = MPPUtility.getDuration(MPPUtility.getInt(byArray, 24), timeUnit);
                Relation relation = task2.addPredecessor(task, relationType, duration);
                this.m_file.fireRelationReadEvent(relation);
            }
        }
    }

    private void processResourceData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc");
        FixFix fixFix = new FixFix(196, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        FixDeferFix fixDeferFix = null;
        ExtendedData extendedData = null;
        int n = fixFix.getItemCount();
        RTFUtility rTFUtility = new RTFUtility();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixFix.getByteArrayValue(i);
            int n2 = MPPUtility.getInt(byArray, 0);
            if (n2 < 1 || (byArray[8] & 1) != 0 || MPPUtility.getShort(byArray, 164) != 0) continue;
            if (fixDeferFix == null) {
                fixDeferFix = new FixDeferFix(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixDeferFix   0")));
            }
            extendedData = new ExtendedData(fixDeferFix, this.getOffset(byArray, 192));
            Resource resource = this.m_file.addResource();
            resource.setAccrueAt(AccrueType.getInstance(MPPUtility.getShort(byArray, 20)));
            resource.setActualCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray, 114) / 100.0));
            resource.setActualOvertimeCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray, 144) / 100.0));
            resource.setActualWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 62) / 100.0, TimeUnit.HOURS));
            resource.setAvailableFrom(MPPUtility.getTimestamp(byArray, 28));
            resource.setAvailableTo(MPPUtility.getTimestamp(byArray, 32));
            resource.setBaselineCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray, 126) / 100.0));
            resource.setBaselineWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 68) / 100.0, TimeUnit.HOURS));
            resource.setCode(extendedData.getUnicodeString(RESOURCE_CODE));
            resource.setCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray, 120) / 100.0));
            resource.setCost1(NumberUtility.getDouble((double)extendedData.getLong(RESOURCE_COST1) / 100.0));
            resource.setCost2(NumberUtility.getDouble((double)extendedData.getLong(RESOURCE_COST2) / 100.0));
            resource.setCost3(NumberUtility.getDouble((double)extendedData.getLong(RESOURCE_COST3) / 100.0));
            resource.setCost4(NumberUtility.getDouble((double)extendedData.getLong(RESOURCE_COST4) / 100.0));
            resource.setCost5(NumberUtility.getDouble((double)extendedData.getLong(RESOURCE_COST5) / 100.0));
            resource.setCost6(NumberUtility.getDouble((double)extendedData.getLong(RESOURCE_COST6) / 100.0));
            resource.setCost7(NumberUtility.getDouble((double)extendedData.getLong(RESOURCE_COST7) / 100.0));
            resource.setCost8(NumberUtility.getDouble((double)extendedData.getLong(RESOURCE_COST8) / 100.0));
            resource.setCost9(NumberUtility.getDouble((double)extendedData.getLong(RESOURCE_COST9) / 100.0));
            resource.setCost10(NumberUtility.getDouble((double)extendedData.getLong(RESOURCE_COST10) / 100.0));
            resource.setCostPerUse(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray, 80) / 100.0));
            resource.setDate1(extendedData.getTimestamp(RESOURCE_DATE1));
            resource.setDate2(extendedData.getTimestamp(RESOURCE_DATE2));
            resource.setDate3(extendedData.getTimestamp(RESOURCE_DATE3));
            resource.setDate4(extendedData.getTimestamp(RESOURCE_DATE4));
            resource.setDate5(extendedData.getTimestamp(RESOURCE_DATE5));
            resource.setDate6(extendedData.getTimestamp(RESOURCE_DATE6));
            resource.setDate7(extendedData.getTimestamp(RESOURCE_DATE7));
            resource.setDate8(extendedData.getTimestamp(RESOURCE_DATE8));
            resource.setDate9(extendedData.getTimestamp(RESOURCE_DATE9));
            resource.setDate10(extendedData.getTimestamp(RESOURCE_DATE10));
            resource.setDuration1(MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION1), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION1_UNITS))));
            resource.setDuration2(MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION2), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION2_UNITS))));
            resource.setDuration3(MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION3), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION3_UNITS))));
            resource.setDuration4(MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION4), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION4_UNITS))));
            resource.setDuration5(MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION5), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION5_UNITS))));
            resource.setDuration6(MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION6), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION6_UNITS))));
            resource.setDuration7(MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION7), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION7_UNITS))));
            resource.setDuration8(MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION8), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION8_UNITS))));
            resource.setDuration9(MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION9), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION9_UNITS))));
            resource.setDuration10(MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION10), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION10_UNITS))));
            resource.setEmailAddress(extendedData.getUnicodeString(RESOURCE_EMAIL));
            resource.setFinish1(extendedData.getTimestamp(RESOURCE_FINISH1));
            resource.setFinish2(extendedData.getTimestamp(RESOURCE_FINISH2));
            resource.setFinish3(extendedData.getTimestamp(RESOURCE_FINISH3));
            resource.setFinish4(extendedData.getTimestamp(RESOURCE_FINISH4));
            resource.setFinish5(extendedData.getTimestamp(RESOURCE_FINISH5));
            resource.setFinish6(extendedData.getTimestamp(RESOURCE_FINISH6));
            resource.setFinish7(extendedData.getTimestamp(RESOURCE_FINISH7));
            resource.setFinish8(extendedData.getTimestamp(RESOURCE_FINISH8));
            resource.setFinish9(extendedData.getTimestamp(RESOURCE_FINISH9));
            resource.setFinish10(extendedData.getTimestamp(RESOURCE_FINISH10));
            resource.setGroup(extendedData.getUnicodeString(RESOURCE_GROUP));
            resource.setID(MPPUtility.getInt(byArray, 4));
            resource.setInitials(fixDeferFix.getUnicodeString(this.getOffset(byArray, 160)));
            resource.setMaxUnits(NumberUtility.getDouble((double)MPPUtility.getInt(byArray, 52) / 100.0));
            resource.setName(fixDeferFix.getUnicodeString(this.getOffset(byArray, 156)));
            resource.setNumber1(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER1)));
            resource.setNumber2(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER2)));
            resource.setNumber3(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER3)));
            resource.setNumber4(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER4)));
            resource.setNumber5(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER5)));
            resource.setNumber6(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER6)));
            resource.setNumber7(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER7)));
            resource.setNumber8(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER8)));
            resource.setNumber9(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER9)));
            resource.setNumber10(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER10)));
            resource.setNumber11(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER11)));
            resource.setNumber12(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER12)));
            resource.setNumber13(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER13)));
            resource.setNumber14(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER14)));
            resource.setNumber15(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER15)));
            resource.setNumber16(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER16)));
            resource.setNumber17(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER17)));
            resource.setNumber18(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER18)));
            resource.setNumber19(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER19)));
            resource.setNumber20(NumberUtility.getDouble(extendedData.getDouble(RESOURCE_NUMBER20)));
            resource.setOvertimeCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray, 138) / 100.0));
            resource.setOvertimeRate(new Rate(MPPUtility.getDouble(byArray, 44), TimeUnit.HOURS));
            resource.setOvertimeWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 74) / 100.0, TimeUnit.HOURS));
            resource.setPeakUnits(NumberUtility.getDouble((double)MPPUtility.getInt(byArray, 110) / 100.0));
            resource.setRegularWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 92) / 100.0, TimeUnit.HOURS));
            resource.setRemainingCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray, 132) / 100.0));
            resource.setRemainingOvertimeCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray, 150) / 100.0));
            resource.setRemainingWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 86) / 100.0, TimeUnit.HOURS));
            resource.setStandardRate(new Rate(MPPUtility.getDouble(byArray, 36), TimeUnit.HOURS));
            resource.setStart1(extendedData.getTimestamp(RESOURCE_START1));
            resource.setStart2(extendedData.getTimestamp(RESOURCE_START2));
            resource.setStart3(extendedData.getTimestamp(RESOURCE_START3));
            resource.setStart4(extendedData.getTimestamp(RESOURCE_START4));
            resource.setStart5(extendedData.getTimestamp(RESOURCE_START5));
            resource.setStart6(extendedData.getTimestamp(RESOURCE_START6));
            resource.setStart7(extendedData.getTimestamp(RESOURCE_START7));
            resource.setStart8(extendedData.getTimestamp(RESOURCE_START8));
            resource.setStart9(extendedData.getTimestamp(RESOURCE_START9));
            resource.setStart10(extendedData.getTimestamp(RESOURCE_START10));
            resource.setText1(extendedData.getUnicodeString(RESOURCE_TEXT1));
            resource.setText2(extendedData.getUnicodeString(RESOURCE_TEXT2));
            resource.setText3(extendedData.getUnicodeString(RESOURCE_TEXT3));
            resource.setText4(extendedData.getUnicodeString(RESOURCE_TEXT4));
            resource.setText5(extendedData.getUnicodeString(RESOURCE_TEXT5));
            resource.setText6(extendedData.getUnicodeString(RESOURCE_TEXT6));
            resource.setText7(extendedData.getUnicodeString(RESOURCE_TEXT7));
            resource.setText8(extendedData.getUnicodeString(RESOURCE_TEXT8));
            resource.setText9(extendedData.getUnicodeString(RESOURCE_TEXT9));
            resource.setText10(extendedData.getUnicodeString(RESOURCE_TEXT10));
            resource.setText11(extendedData.getUnicodeString(RESOURCE_TEXT11));
            resource.setText12(extendedData.getUnicodeString(RESOURCE_TEXT12));
            resource.setText13(extendedData.getUnicodeString(RESOURCE_TEXT13));
            resource.setText14(extendedData.getUnicodeString(RESOURCE_TEXT14));
            resource.setText15(extendedData.getUnicodeString(RESOURCE_TEXT15));
            resource.setText16(extendedData.getUnicodeString(RESOURCE_TEXT16));
            resource.setText17(extendedData.getUnicodeString(RESOURCE_TEXT17));
            resource.setText18(extendedData.getUnicodeString(RESOURCE_TEXT18));
            resource.setText19(extendedData.getUnicodeString(RESOURCE_TEXT19));
            resource.setText20(extendedData.getUnicodeString(RESOURCE_TEXT20));
            resource.setText21(extendedData.getUnicodeString(RESOURCE_TEXT21));
            resource.setText22(extendedData.getUnicodeString(RESOURCE_TEXT22));
            resource.setText23(extendedData.getUnicodeString(RESOURCE_TEXT23));
            resource.setText24(extendedData.getUnicodeString(RESOURCE_TEXT24));
            resource.setText25(extendedData.getUnicodeString(RESOURCE_TEXT25));
            resource.setText26(extendedData.getUnicodeString(RESOURCE_TEXT26));
            resource.setText27(extendedData.getUnicodeString(RESOURCE_TEXT27));
            resource.setText28(extendedData.getUnicodeString(RESOURCE_TEXT28));
            resource.setText29(extendedData.getUnicodeString(RESOURCE_TEXT29));
            resource.setText30(extendedData.getUnicodeString(RESOURCE_TEXT30));
            resource.setUniqueID(n2);
            resource.setWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 56) / 100.0, TimeUnit.HOURS));
            ProjectCalendar projectCalendar = this.m_calendarMap.get(MPPUtility.getInt(byArray, 24));
            resource.setResourceCalendar(projectCalendar);
            String string = extendedData.getString(RESOURCE_NOTES);
            if (string != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    string = rTFUtility.strip(string);
                }
                resource.setNotes(string);
            }
            this.m_file.fireResourceReadEvent(resource);
        }
    }

    private void processAssignmentData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndAssn");
        FixFix fixFix = new FixFix(204, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        if (fixFix.getDiff() != 0 || fixFix.getSize() % 238 == 0 && !this.testAssignmentTasks(fixFix)) {
            fixFix = new FixFix(238, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        }
        int n = fixFix.getItemCount();
        FixDeferFix fixDeferFix = null;
        for (int i = 0; i < n; ++i) {
            if (fixDeferFix == null) {
                fixDeferFix = new FixDeferFix(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixDeferFix   0")));
            }
            byte[] byArray = fixFix.getByteArrayValue(i);
            Task task = this.m_file.getTaskByUniqueID(MPPUtility.getInt(byArray, 16));
            Resource resource = this.m_file.getResourceByUniqueID(MPPUtility.getInt(byArray, 20));
            if (task == null || resource == null) continue;
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            resourceAssignment.setActualCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray, 138) / 100.0));
            resourceAssignment.setActualWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 96) / 100.0, TimeUnit.HOURS));
            resourceAssignment.setCost(NumberUtility.getDouble((double)MPPUtility.getLong6(byArray, 132) / 100.0));
            resourceAssignment.setFinish(MPPUtility.getTimestamp(byArray, 28));
            resourceAssignment.setOvertimeWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 90) / 100.0, TimeUnit.HOURS));
            resourceAssignment.setRemainingWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 114) / 100.0, TimeUnit.HOURS));
            resourceAssignment.setStart(MPPUtility.getTimestamp(byArray, 24));
            resourceAssignment.setUniqueID(MPPUtility.getInt(byArray, 0));
            resourceAssignment.setUnits((double)MPPUtility.getShort(byArray, 80) / 100.0);
            resourceAssignment.setWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 84) / 100.0, TimeUnit.HOURS));
            this.m_file.fireAssignmentReadEvent(resourceAssignment);
        }
    }

    private boolean testAssignmentTasks(FixFix fixFix) {
        boolean bl = true;
        int n = fixFix.getItemCount();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixFix.getByteArrayValue(i);
            Task task = this.m_file.getTaskByUniqueID(MPPUtility.getInt(byArray, 16));
            Resource resource = this.m_file.getResourceByUniqueID(MPPUtility.getInt(byArray, 20));
            if (task != null || resource != null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void processViewData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CV_iew");
        FixFix fixFix = new FixFix(138, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        int n = fixFix.getItemCount();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixFix.getByteArrayValue(i);
            View8 view8 = new View8(this.m_file, byArray);
            this.m_file.addView(view8);
        }
    }

    private void processTableData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CTable");
        FixFix fixFix = new FixFix(126, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        FixDeferFix fixDeferFix = new FixDeferFix(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixDeferFix   0")));
        int n = fixFix.getItemCount();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixFix.getByteArrayValue(i);
            Table table = new Table();
            table.setID(MPPUtility.getInt(byArray, 0));
            String string = MPPUtility.getUnicodeString(byArray, 4);
            if (string != null && string.indexOf(38) != -1) {
                stringBuffer.setLength(0);
                for (int j = 0; j < string.length(); ++j) {
                    char c = string.charAt(j);
                    if (c == '&') continue;
                    stringBuffer.append(c);
                }
                string = stringBuffer.toString();
            }
            table.setName(MPPUtility.removeAmpersands(string));
            this.m_file.addTable(table);
            byte[] byArray2 = fixDeferFix.getByteArray(this.getOffset(byArray, 122));
            if (byArray2 == null) continue;
            byte[] byArray3 = fixDeferFix.getByteArray(this.getOffset(byArray2, 8));
            this.processColumnData(table, byArray3);
        }
    }

    private void processColumnData(Table table, byte[] byArray) {
        int n = MPPUtility.getShort(byArray, 4) + 1;
        int n2 = 8;
        for (int i = 0; i < n; ++i) {
            int n3;
            Column column = new Column(this.m_file);
            if (i == 0) {
                if (MPPUtility.getShort(byArray, n2) == 0) {
                    table.setResourceFlag(true);
                } else {
                    table.setResourceFlag(false);
                }
            }
            if (!table.getResourceFlag()) {
                column.setFieldType(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n2)));
            } else {
                column.setFieldType(MPPResourceField.getInstance(MPPUtility.getShort(byArray, n2)));
            }
            column.setWidth(MPPUtility.getByte(byArray, n2 + 4));
            int n4 = MPPUtility.getShort(byArray, n2 + 6);
            if (n4 != 0) {
                column.setTitle(MPPUtility.getUnicodeString(byArray, n4));
            }
            if ((n3 = MPPUtility.getByte(byArray, n2 + 8)) == 32) {
                column.setAlignTitle(1);
            } else if (n3 == 33) {
                column.setAlignTitle(2);
            } else {
                column.setAlignTitle(3);
            }
            n3 = MPPUtility.getByte(byArray, n2 + 10);
            if (n3 == 32) {
                column.setAlignData(1);
            } else if (n3 == 33) {
                column.setAlignData(2);
            } else {
                column.setAlignData(3);
            }
            table.addColumn(column);
            n2 += 12;
        }
    }

    private int getOffset(byte[] byArray, int n) {
        return -1 - MPPUtility.getInt(byArray, n);
    }
}

