/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.visitors;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISourceModule;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.TokenMgrError;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.refactoring.ast.PythonModuleManager;
import org.python.pydev.refactoring.ast.adapters.AbstractNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.printer.SourcePrinter;
import org.python.pydev.refactoring.ast.visitors.context.AbstractContextVisitor;
import org.python.pydev.refactoring.ast.visitors.selection.SelectionException;
import org.python.pydev.refactoring.ast.visitors.selection.SelectionExtenderVisitor;
import org.python.pydev.refactoring.ast.visitors.selection.SelectionValidationVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitorFactory {
    public static ITextSelection createSelectionExtension(AbstractScopeNode<?> scope, ITextSelection selection) {
        SelectionExtenderVisitor visitor = null;
        try {
            visitor = new SelectionExtenderVisitor(scope.getModule(), selection);
            scope.getASTNode().accept((VisitorIF)visitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return visitor.getSelection();
    }

    public static void validateSelection(ModuleAdapter scope) throws SelectionException {
        SelectionValidationVisitor visitor = null;
        try {
            visitor = new SelectionValidationVisitor();
            ((Module)scope.getASTNode()).accept((VisitorIF)visitor);
        }
        catch (SelectionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends VisitorIF> T createVisitor(Class<T> visitorClass, String source) throws Throwable {
        return VisitorFactory.createVisitor(visitorClass, VisitorFactory.getRootNodeFromString(source));
    }

    public static <T extends VisitorIF> T createVisitor(Class<T> visitorClass, SimpleNode root) {
        VisitorIF visitor = null;
        try {
            visitor = (VisitorIF)visitorClass.newInstance();
            root.accept(visitor);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return (T)visitor;
    }

    public static <T extends AbstractContextVisitor> T createContextVisitor(Class<T> visitorClass, SimpleNode root, ModuleAdapter module, AbstractNodeAdapter parent) {
        AbstractContextVisitor visitor = null;
        try {
            visitor = (AbstractContextVisitor)((Object)visitorClass.getConstructors()[0].newInstance(module, parent));
            root.accept((VisitorIF)visitor);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return (T)((Object)visitor);
    }

    public static ModuleAdapter createModuleAdapter(PythonModuleManager moduleManager, File file, IDocument doc, IPythonNature nature) throws ParseException {
        IModule module;
        String modName;
        IModulesManager m;
        if (file != null && file.exists() && moduleManager != null && (m = moduleManager.getIModuleManager()) != null && (modName = m.resolveModule(REF.getFileAbsolutePath((File)file))) != null && (module = m.getModule(modName, nature, true)) instanceof ISourceModule) {
            return VisitorFactory.createModuleAdapter(moduleManager, (ISourceModule)module, nature);
        }
        return new ModuleAdapter(moduleManager, file, doc, VisitorFactory.getRootNode(doc), nature);
    }

    public static ModuleAdapter createModuleAdapter(PythonModuleManager moduleManager, ISourceModule module, IPythonNature nature) {
        return new ModuleAdapter(moduleManager, module, nature);
    }

    public static SourcePrinter createPrinter(Writer out, String newLineDelim) {
        return new SourcePrinter(new PrintWriter(out), newLineDelim);
    }

    public static SimpleNode getRootNodeFromString(String source) throws ParseException {
        return VisitorFactory.getRootNode(VisitorFactory.getDocumentFromString(source));
    }

    private static IDocument getDocumentFromString(String source) {
        return new Document(source);
    }

    public static Module getRootNode(IDocument doc) throws ParseException {
        Tuple objects = PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo(doc, false, 12));
        Throwable exception = (Throwable)objects.o2;
        if (exception != null) {
            if (exception instanceof ParseException) {
                throw (ParseException)exception;
            }
            if (exception instanceof TokenMgrError) {
                throw new ParseException(exception.toString());
            }
            throw new RuntimeException(exception);
        }
        if (objects.o2 != null) {
            throw new RuntimeException((Throwable)objects.o2);
        }
        return (Module)objects.o1;
    }
}

