/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.constructorfield;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.refactoring.ast.adapters.ClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.INodeAdapter;
import org.python.pydev.refactoring.codegenerator.constructorfield.request.ConstructorFieldRequest;
import org.python.pydev.refactoring.core.request.IRequestProcessor;
import org.python.pydev.refactoring.ui.model.constructorfield.TreeNodeClassField;
import org.python.pydev.refactoring.ui.model.constructorfield.TreeNodeField;
import org.python.pydev.refactoring.ui.model.tree.ITreeNode;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorFieldRequestProcessor
implements IRequestProcessor<ConstructorFieldRequest> {
    private Object[] checked = new Object[0];
    private int offsetStrategy = 1;
    private String endLineDelim;

    public ConstructorFieldRequestProcessor(String endLineDelim) {
        this.endLineDelim = endLineDelim;
    }

    public void setCheckedElements(Object[] checked) {
        this.checked = checked;
    }

    @Override
    public List<ConstructorFieldRequest> getRefactoringRequests() {
        return this.generateRequests();
    }

    private List<ConstructorFieldRequest> generateRequests() {
        ArrayList<ConstructorFieldRequest> requests = new ArrayList<ConstructorFieldRequest>();
        ArrayList<ITreeNode> nodes = new ArrayList<ITreeNode>();
        Object[] objectArray = this.checked;
        int n = this.checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            nodes.add((ITreeNode)o);
            ++n2;
        }
        Iterator<ITreeNode> iter = nodes.iterator();
        while (iter.hasNext()) {
            ITreeNode node = (ITreeNode)iter.next();
            if (!(node instanceof TreeNodeClassField)) continue;
            this.addRequest(requests, iter, node);
        }
        return requests;
    }

    private void addRequest(List<ConstructorFieldRequest> requests, Iterator<ITreeNode> iter, ITreeNode node) {
        ArrayList<INodeAdapter> fields = new ArrayList<INodeAdapter>();
        ITreeNode field = iter.next();
        while (field instanceof TreeNodeField) {
            fields.add(field.getAdapter());
            if (!iter.hasNext()) break;
            field = iter.next();
        }
        if (fields.size() > 0) {
            ClassDefAdapter clazz = (ClassDefAdapter)node.getAdapter();
            ConstructorFieldRequest request = new ConstructorFieldRequest(clazz, fields, this.offsetStrategy, this.endLineDelim);
            requests.add(request);
        }
    }

    public void setMethodDestination(int strat) {
        this.offsetStrategy = strat;
    }
}

