/* --------------------------------------------------------------------------

   libmusicbrainz5 - Client library to access MusicBrainz

   Copyright (C) 2012 Andrew Hawkins

   This file is part of libmusicbrainz5.

   This library is free software; you can redistribute it and/or
   modify it under the terms of v2 of the GNU Lesser General Public
   License as published by the Free Software Foundation.

   libmusicbrainz5 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

   THIS FILE IS AUTOMATICALLY GENERATED - DO NOT EDIT IT!

----------------------------------------------------------------------------*/


/*
	Things you should delete using the appropriate mb5_xxx_delete() function:

	* The query object you create to do the actual work
	* Any object or list returned from one of the mb5_query_xxx() functions
	* The return from mb5_release_media_matching_discid() function
	* The return from any mb5_xxx_clone() function

	Everything else remains managed by the library, and should not be deleted

	If in doubt, valgrind is a useful way to spot leaks or things being deleted
	when they shouldn't be.

*/

#ifndef _MUSICBRAINZ5_MB_C_H
#define _MUSICBRAINZ5_MB_C_H

#include "musicbrainz5/defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  typedef void *Mb5Entity;
  typedef void *Mb5Alias;
  typedef void *Mb5Annotation;
  typedef void *Mb5Artist;
  typedef void *Mb5ArtistCredit;
  typedef void *Mb5Attribute;
  typedef void *Mb5CDStub;
  typedef void *Mb5Collection;
  typedef void *Mb5Disc;
  typedef void *Mb5FreeDBDisc;
  typedef void *Mb5IPI;
  typedef void *Mb5ISRC;
  typedef void *Mb5ISWC;
  typedef void *Mb5Label;
  typedef void *Mb5LabelInfo;
  typedef void *Mb5Lifespan;
  typedef void *Mb5Medium;
  typedef void *Mb5Message;
  typedef void *Mb5Metadata;
  typedef void *Mb5NameCredit;
  typedef void *Mb5NonMBTrack;
  typedef void *Mb5PUID;
  typedef void *Mb5Query;
  typedef void *Mb5Rating;
  typedef void *Mb5Recording;
  typedef void *Mb5Relation;
  typedef void *Mb5Release;
  typedef void *Mb5ReleaseGroup;
  typedef void *Mb5SecondaryType;
  typedef void *Mb5Tag;
  typedef void *Mb5TextRepresentation;
  typedef void *Mb5Track;
  typedef void *Mb5UserRating;
  typedef void *Mb5UserTag;
  typedef void *Mb5Work;
  typedef void *Mb5AliasList;
  typedef void *Mb5AnnotationList;
  typedef void *Mb5ArtistList;
  typedef void *Mb5AttributeList;
  typedef void *Mb5CDStubList;
  typedef void *Mb5CollectionList;
  typedef void *Mb5DiscList;
  typedef void *Mb5FreeDBDiscList;
  typedef void *Mb5IPIList;
  typedef void *Mb5ISRCList;
  typedef void *Mb5ISWCList;
  typedef void *Mb5LabelList;
  typedef void *Mb5LabelInfoList;
  typedef void *Mb5MediumList;
  typedef void *Mb5NameCreditList;
  typedef void *Mb5NonMBTrackList;
  typedef void *Mb5PUIDList;
  typedef void *Mb5RecordingList;
  typedef void *Mb5RelationList;
  typedef void *Mb5RelationListList;
  typedef void *Mb5ReleaseList;
  typedef void *Mb5ReleaseGroupList;
  typedef void *Mb5SecondaryTypeList;
  typedef void *Mb5TagList;
  typedef void *Mb5TrackList;
  typedef void *Mb5UserTagList;
  typedef void *Mb5WorkList;

/**
 * Returns the number of extension attributes for the entity
 *
 * @param Entity #Mb5Entity object
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_entity_ext_attributes_size(Mb5Entity Entity);

/**
 * Returns the name of the requested extension attribute
 *
 * @param Entity #Mb5Entity object
 * @param Item Item to return
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_entity_ext_attribute_name(Mb5Entity Entity, int Item, char *str, int len);

/**
 * Returns the value of the requested extension attribute
 *
 * @param Entity #Mb5Entity object
 * @param Item Item to return
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_entity_ext_attribute_value(Mb5Entity Entity, int Item, char *str, int len);

/**
 * Returns the number of extension elements for the entity
 *
 * @param Entity #Mb5Entity object
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_entity_ext_elements_size(Mb5Entity Entity);

/**
 * Returns the name of the requested extension element
 *
 * @param Entity #Mb5Entity object
 * @param Item Item to return
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_entity_ext_element_name(Mb5Entity Entity, int Item, char *str, int len);

/**
 * Returns the value of the requested extension element
 *
 * @param Entity #Mb5Entity object
 * @param Item Item to return
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_entity_ext_element_value(Mb5Entity Entity, int Item, char *str, int len);

/**
* Delete an #Mb5Alias object
*
* @param Alias Object to delete
*/
  void mb5_alias_delete(Mb5Alias Alias);

/**
* Clone an #Mb5Alias object
*
* @param Alias Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Alias mb5_alias_clone(Mb5Alias Alias);

/**
 * @see MusicBrainz5::CAlias::Locale
 *
 * @param Alias #Mb5Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_alias_get_locale(Mb5Alias Alias, char *str, int len);

/**
 * @see MusicBrainz5::CAlias::Text
 *
 * @param Alias #Mb5Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_alias_get_text(Mb5Alias Alias, char *str, int len);

/**
 * @see MusicBrainz5::CAlias::SortName
 *
 * @param Alias #Mb5Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_alias_get_sortname(Mb5Alias Alias, char *str, int len);

/**
 * @see MusicBrainz5::CAlias::Type
 *
 * @param Alias #Mb5Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_alias_get_type(Mb5Alias Alias, char *str, int len);

/**
 * @see MusicBrainz5::CAlias::Primary
 *
 * @param Alias #Mb5Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_alias_get_primary(Mb5Alias Alias, char *str, int len);

/**
 * @see MusicBrainz5::CAlias::BeginDate
 *
 * @param Alias #Mb5Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_alias_get_begindate(Mb5Alias Alias, char *str, int len);

/**
 * @see MusicBrainz5::CAlias::EndDate
 *
 * @param Alias #Mb5Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_alias_get_enddate(Mb5Alias Alias, char *str, int len);

/**
* Delete an #Mb5Annotation object
*
* @param Annotation Object to delete
*/
  void mb5_annotation_delete(Mb5Annotation Annotation);

/**
* Clone an #Mb5Annotation object
*
* @param Annotation Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Annotation mb5_annotation_clone(Mb5Annotation Annotation);

/**
 * @see MusicBrainz5::CAnnotation::Type
 *
 * @param Annotation #Mb5Annotation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_annotation_get_type(Mb5Annotation Annotation, char *str, int len);

/**
 * @see MusicBrainz5::CAnnotation::Entity
 *
 * @param Annotation #Mb5Annotation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_annotation_get_entity(Mb5Annotation Annotation, char *str, int len);

/**
 * @see MusicBrainz5::CAnnotation::Name
 *
 * @param Annotation #Mb5Annotation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_annotation_get_name(Mb5Annotation Annotation, char *str, int len);

/**
 * @see MusicBrainz5::CAnnotation::Text
 *
 * @param Annotation #Mb5Annotation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_annotation_get_text(Mb5Annotation Annotation, char *str, int len);

/**
* Delete an #Mb5Artist object
*
* @param Artist Object to delete
*/
  void mb5_artist_delete(Mb5Artist Artist);

/**
* Clone an #Mb5Artist object
*
* @param Artist Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Artist mb5_artist_clone(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::ID
 *
 * @param Artist #Mb5Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_artist_get_id(Mb5Artist Artist, char *str, int len);

/**
 * @see MusicBrainz5::CArtist::Type
 *
 * @param Artist #Mb5Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_artist_get_type(Mb5Artist Artist, char *str, int len);

/**
 * @see MusicBrainz5::CArtist::Name
 *
 * @param Artist #Mb5Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_artist_get_name(Mb5Artist Artist, char *str, int len);

/**
 * @see MusicBrainz5::CArtist::SortName
 *
 * @param Artist #Mb5Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_artist_get_sortname(Mb5Artist Artist, char *str, int len);

/**
 * @see MusicBrainz5::CArtist::Gender
 *
 * @param Artist #Mb5Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_artist_get_gender(Mb5Artist Artist, char *str, int len);

/**
 * @see MusicBrainz5::CArtist::Country
 *
 * @param Artist #Mb5Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_artist_get_country(Mb5Artist Artist, char *str, int len);

/**
 * @see MusicBrainz5::CArtist::Disambiguation
 *
 * @param Artist #Mb5Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_artist_get_disambiguation(Mb5Artist Artist, char *str, int len);

/**
 * @see MusicBrainz5::CArtist::IPIList
 *
 * @param Artist #Mb5ArtistList object
 *
 * @return #Mb5IPIList object
 */
  Mb5IPIList mb5_artist_get_ipilist(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::Lifespan
 *
 * @param Artist #Mb5Artist object
 *
 * @return #Mb5Lifespan object
 */
  Mb5Lifespan mb5_artist_get_lifespan(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::AliasList
 *
 * @param Artist #Mb5Artist object
 *
 * @return #Mb5AliasList object
 */
  Mb5AliasList mb5_artist_get_aliaslist(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::RecordingList
 *
 * @param Artist #Mb5Artist object
 *
 * @return #Mb5RecordingList object
 */
  Mb5RecordingList mb5_artist_get_recordinglist(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::ReleaseList
 *
 * @param Artist #Mb5Artist object
 *
 * @return #Mb5ReleaseList object
 */
  Mb5ReleaseList mb5_artist_get_releaselist(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::ReleaseGroupList
 *
 * @param Artist #Mb5Artist object
 *
 * @return #Mb5ReleaseGroupList object
 */
  Mb5ReleaseGroupList mb5_artist_get_releasegrouplist(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::LabelList
 *
 * @param Artist #Mb5Artist object
 *
 * @return #Mb5LabelList object
 */
  Mb5LabelList mb5_artist_get_labellist(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::WorkList
 *
 * @param Artist #Mb5Artist object
 *
 * @return #Mb5WorkList object
 */
  Mb5WorkList mb5_artist_get_worklist(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::RelationListList
 *
 * @param Artist #Mb5ArtistList object
 *
 * @return #Mb5RelationListList object
 */
  Mb5RelationListList mb5_artist_get_relationlistlist(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::TagList
 *
 * @param Artist #Mb5Artist object
 *
 * @return #Mb5TagList object
 */
  Mb5TagList mb5_artist_get_taglist(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::UserTagList
 *
 * @param Artist #Mb5Artist object
 *
 * @return #Mb5UserTagList object
 */
  Mb5UserTagList mb5_artist_get_usertaglist(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::Rating
 *
 * @param Artist #Mb5Artist object
 *
 * @return #Mb5Rating object
 */
  Mb5Rating mb5_artist_get_rating(Mb5Artist Artist);

/**
 * @see MusicBrainz5::CArtist::UserRating
 *
 * @param Artist #Mb5Artist object
 *
 * @return #Mb5UserRating object
 */
  Mb5UserRating mb5_artist_get_userrating(Mb5Artist Artist);

/**
* Delete an #Mb5ArtistCredit object
*
* @param ArtistCredit Object to delete
*/
  void mb5_artistcredit_delete(Mb5ArtistCredit ArtistCredit);

/**
* Clone an #Mb5ArtistCredit object
*
* @param ArtistCredit Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5ArtistCredit mb5_artistcredit_clone(Mb5ArtistCredit ArtistCredit);

/**
 * @see MusicBrainz5::CArtistCredit::NameCreditList
 *
 * @param ArtistCredit #Mb5ArtistCredit object
 *
 * @return #Mb5NameCreditList object
 */
  Mb5NameCreditList mb5_artistcredit_get_namecreditlist(Mb5ArtistCredit ArtistCredit);

/**
* Delete an #Mb5Attribute object
*
* @param Attribute Object to delete
*/
  void mb5_attribute_delete(Mb5Attribute Attribute);

/**
* Clone an #Mb5Attribute object
*
* @param Attribute Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Attribute mb5_attribute_clone(Mb5Attribute Attribute);

/**
 * @see MusicBrainz5::CAttribute::Text
 *
 * @param Attribute #Mb5Attribute object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_attribute_get_text(Mb5Attribute Attribute, char *str, int len);

/**
* Delete an #Mb5CDStub object
*
* @param CDStub Object to delete
*/
  void mb5_cdstub_delete(Mb5CDStub CDStub);

/**
* Clone an #Mb5CDStub object
*
* @param CDStub Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5CDStub mb5_cdstub_clone(Mb5CDStub CDStub);

/**
 * @see MusicBrainz5::CCDStub::ID
 *
 * @param CDStub #Mb5CDStub object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_cdstub_get_id(Mb5CDStub CDStub, char *str, int len);

/**
 * @see MusicBrainz5::CCDStub::Title
 *
 * @param CDStub #Mb5CDStub object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_cdstub_get_title(Mb5CDStub CDStub, char *str, int len);

/**
 * @see MusicBrainz5::CCDStub::Artist
 *
 * @param CDStub #Mb5CDStub object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_cdstub_get_artist(Mb5CDStub CDStub, char *str, int len);

/**
 * @see MusicBrainz5::CCDStub::Barcode
 *
 * @param CDStub #Mb5CDStub object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_cdstub_get_barcode(Mb5CDStub CDStub, char *str, int len);

/**
 * @see MusicBrainz5::CCDStub::Comment
 *
 * @param CDStub #Mb5CDStub object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_cdstub_get_comment(Mb5CDStub CDStub, char *str, int len);

/**
 * @see MusicBrainz5::CCDStub::NonMBTrackList
 *
 * @param CDStub #Mb5CDStub object
 *
 * @return #Mb5NonMBTrackList object
 */
  Mb5NonMBTrackList mb5_cdstub_get_nonmbtracklist(Mb5CDStub CDStub);

/**
* Delete an #Mb5Collection object
*
* @param Collection Object to delete
*/
  void mb5_collection_delete(Mb5Collection Collection);

/**
* Clone an #Mb5Collection object
*
* @param Collection Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Collection mb5_collection_clone(Mb5Collection Collection);

/**
 * @see MusicBrainz5::CCollection::ID
 *
 * @param Collection #Mb5Collection object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_collection_get_id(Mb5Collection Collection, char *str, int len);

/**
 * @see MusicBrainz5::CCollection::Name
 *
 * @param Collection #Mb5Collection object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_collection_get_name(Mb5Collection Collection, char *str, int len);

/**
 * @see MusicBrainz5::CCollection::Editor
 *
 * @param Collection #Mb5Collection object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_collection_get_editor(Mb5Collection Collection, char *str, int len);

/**
 * @see MusicBrainz5::CCollection::ReleaseList
 *
 * @param Collection #Mb5Collection object
 *
 * @return #Mb5ReleaseList object
 */
  Mb5ReleaseList mb5_collection_get_releaselist(Mb5Collection Collection);

/**
* Delete an #Mb5Disc object
*
* @param Disc Object to delete
*/
  void mb5_disc_delete(Mb5Disc Disc);

/**
* Clone an #Mb5Disc object
*
* @param Disc Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Disc mb5_disc_clone(Mb5Disc Disc);

/**
 * @see MusicBrainz5::CDisc::ID
 *
 * @param Disc #Mb5Disc object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_disc_get_id(Mb5Disc Disc, char *str, int len);

/**
 * @see MusicBrainz5::CDisc::Sectors
 *
 * @param Disc #Mb5Disc object
 *
 * @return Returned value
 */
  int mb5_disc_get_sectors(Mb5Disc Disc);

/**
 * @see MusicBrainz5::CDisc::ReleaseList
 *
 * @param Disc #Mb5Disc object
 *
 * @return #Mb5ReleaseList object
 */
  Mb5ReleaseList mb5_disc_get_releaselist(Mb5Disc Disc);

/**
* Delete an #Mb5FreeDBDisc object
*
* @param FreeDBDisc Object to delete
*/
  void mb5_freedbdisc_delete(Mb5FreeDBDisc FreeDBDisc);

/**
* Clone an #Mb5FreeDBDisc object
*
* @param FreeDBDisc Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5FreeDBDisc mb5_freedbdisc_clone(Mb5FreeDBDisc FreeDBDisc);

/**
 * @see MusicBrainz5::CFreeDBDisc::ID
 *
 * @param FreeDBDisc #Mb5FreeDBDisc object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_freedbdisc_get_id(Mb5FreeDBDisc FreeDBDisc, char *str, int len);

/**
 * @see MusicBrainz5::CFreeDBDisc::Title
 *
 * @param FreeDBDisc #Mb5FreeDBDisc object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_freedbdisc_get_title(Mb5FreeDBDisc FreeDBDisc, char *str, int len);

/**
 * @see MusicBrainz5::CFreeDBDisc::Artist
 *
 * @param FreeDBDisc #Mb5FreeDBDisc object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_freedbdisc_get_artist(Mb5FreeDBDisc FreeDBDisc, char *str, int len);

/**
 * @see MusicBrainz5::CFreeDBDisc::Category
 *
 * @param FreeDBDisc #Mb5FreeDBDisc object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_freedbdisc_get_category(Mb5FreeDBDisc FreeDBDisc, char *str, int len);

/**
 * @see MusicBrainz5::CFreeDBDisc::Year
 *
 * @param FreeDBDisc #Mb5FreeDBDisc object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_freedbdisc_get_year(Mb5FreeDBDisc FreeDBDisc, char *str, int len);

/**
 * @see MusicBrainz5::CFreeDBDisc::NonMBTrackList
 *
 * @param FreeDBDisc #Mb5FreeDBDisc object
 *
 * @return #Mb5NonMBTrackList object
 */
  Mb5NonMBTrackList mb5_freedbdisc_get_nonmbtracklist(Mb5FreeDBDisc FreeDBDisc);

/**
* Delete an #Mb5IPI object
*
* @param IPI Object to delete
*/
  void mb5_ipi_delete(Mb5IPI IPI);

/**
* Clone an #Mb5IPI object
*
* @param IPI Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5IPI mb5_ipi_clone(Mb5IPI IPI);

/**
 * @see MusicBrainz5::CIPI::IPI
 *
 * @param IPI #Mb5IPI object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_ipi_get_ipi(Mb5IPI IPI, char *str, int len);

/**
* Delete an #Mb5ISRC object
*
* @param ISRC Object to delete
*/
  void mb5_isrc_delete(Mb5ISRC ISRC);

/**
* Clone an #Mb5ISRC object
*
* @param ISRC Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5ISRC mb5_isrc_clone(Mb5ISRC ISRC);

/**
 * @see MusicBrainz5::CISRC::ID
 *
 * @param ISRC #Mb5ISRC object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_isrc_get_id(Mb5ISRC ISRC, char *str, int len);

/**
 * @see MusicBrainz5::CISRC::RecordingList
 *
 * @param ISRC #Mb5ISRC object
 *
 * @return #Mb5RecordingList object
 */
  Mb5RecordingList mb5_isrc_get_recordinglist(Mb5ISRC ISRC);

/**
* Delete an #Mb5ISWC object
*
* @param ISWC Object to delete
*/
  void mb5_iswc_delete(Mb5ISWC ISWC);

/**
* Clone an #Mb5ISWC object
*
* @param ISWC Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5ISWC mb5_iswc_clone(Mb5ISWC ISWC);

/**
 * @see MusicBrainz5::CISWC::ISWC
 *
 * @param ISWC #Mb5ISWC object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_iswc_get_iswc(Mb5ISWC ISWC, char *str, int len);

/**
* Delete an #Mb5Label object
*
* @param Label Object to delete
*/
  void mb5_label_delete(Mb5Label Label);

/**
* Clone an #Mb5Label object
*
* @param Label Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Label mb5_label_clone(Mb5Label Label);

/**
 * @see MusicBrainz5::CLabel::ID
 *
 * @param Label #Mb5Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_label_get_id(Mb5Label Label, char *str, int len);

/**
 * @see MusicBrainz5::CLabel::Type
 *
 * @param Label #Mb5Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_label_get_type(Mb5Label Label, char *str, int len);

/**
 * @see MusicBrainz5::CLabel::Name
 *
 * @param Label #Mb5Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_label_get_name(Mb5Label Label, char *str, int len);

/**
 * @see MusicBrainz5::CLabel::SortName
 *
 * @param Label #Mb5Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_label_get_sortname(Mb5Label Label, char *str, int len);

/**
 * @see MusicBrainz5::CLabel::LabelCode
 *
 * @param Label #Mb5Label object
 *
 * @return Returned value
 */
  int mb5_label_get_labelcode(Mb5Label Label);

/**
 * @see MusicBrainz5::CLabel::IPIList
 *
 * @param Label #Mb5LabelList object
 *
 * @return #Mb5IPIList object
 */
  Mb5IPIList mb5_label_get_ipilist(Mb5Label Label);

/**
 * @see MusicBrainz5::CLabel::Disambiguation
 *
 * @param Label #Mb5Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_label_get_disambiguation(Mb5Label Label, char *str, int len);

/**
 * @see MusicBrainz5::CLabel::Country
 *
 * @param Label #Mb5Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_label_get_country(Mb5Label Label, char *str, int len);

/**
 * @see MusicBrainz5::CLabel::Lifespan
 *
 * @param Label #Mb5Label object
 *
 * @return #Mb5Lifespan object
 */
  Mb5Lifespan mb5_label_get_lifespan(Mb5Label Label);

/**
 * @see MusicBrainz5::CLabel::AliasList
 *
 * @param Label #Mb5Label object
 *
 * @return #Mb5AliasList object
 */
  Mb5AliasList mb5_label_get_aliaslist(Mb5Label Label);

/**
 * @see MusicBrainz5::CLabel::ReleaseList
 *
 * @param Label #Mb5Label object
 *
 * @return #Mb5ReleaseList object
 */
  Mb5ReleaseList mb5_label_get_releaselist(Mb5Label Label);

/**
 * @see MusicBrainz5::CLabel::RelationListList
 *
 * @param Label #Mb5LabelList object
 *
 * @return #Mb5RelationListList object
 */
  Mb5RelationListList mb5_label_get_relationlistlist(Mb5Label Label);

/**
 * @see MusicBrainz5::CLabel::TagList
 *
 * @param Label #Mb5Label object
 *
 * @return #Mb5TagList object
 */
  Mb5TagList mb5_label_get_taglist(Mb5Label Label);

/**
 * @see MusicBrainz5::CLabel::UserTagList
 *
 * @param Label #Mb5Label object
 *
 * @return #Mb5UserTagList object
 */
  Mb5UserTagList mb5_label_get_usertaglist(Mb5Label Label);

/**
 * @see MusicBrainz5::CLabel::Rating
 *
 * @param Label #Mb5Label object
 *
 * @return #Mb5Rating object
 */
  Mb5Rating mb5_label_get_rating(Mb5Label Label);

/**
 * @see MusicBrainz5::CLabel::UserRating
 *
 * @param Label #Mb5Label object
 *
 * @return #Mb5UserRating object
 */
  Mb5UserRating mb5_label_get_userrating(Mb5Label Label);

/**
* Delete an #Mb5LabelInfo object
*
* @param LabelInfo Object to delete
*/
  void mb5_labelinfo_delete(Mb5LabelInfo LabelInfo);

/**
* Clone an #Mb5LabelInfo object
*
* @param LabelInfo Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5LabelInfo mb5_labelinfo_clone(Mb5LabelInfo LabelInfo);

/**
 * @see MusicBrainz5::CLabelInfo::CatalogNumber
 *
 * @param LabelInfo #Mb5LabelInfo object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_labelinfo_get_catalognumber(Mb5LabelInfo LabelInfo, char *str, int len);

/**
 * @see MusicBrainz5::CLabelInfo::Label
 *
 * @param LabelInfo #Mb5LabelInfo object
 *
 * @return #Mb5Label object
 */
  Mb5Label mb5_labelinfo_get_label(Mb5LabelInfo LabelInfo);

/**
* Delete an #Mb5Lifespan object
*
* @param Lifespan Object to delete
*/
  void mb5_lifespan_delete(Mb5Lifespan Lifespan);

/**
* Clone an #Mb5Lifespan object
*
* @param Lifespan Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Lifespan mb5_lifespan_clone(Mb5Lifespan Lifespan);

/**
 * @see MusicBrainz5::CLifespan::Begin
 *
 * @param Lifespan #Mb5Lifespan object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_lifespan_get_begin(Mb5Lifespan Lifespan, char *str, int len);

/**
 * @see MusicBrainz5::CLifespan::End
 *
 * @param Lifespan #Mb5Lifespan object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_lifespan_get_end(Mb5Lifespan Lifespan, char *str, int len);

/**
 * @see MusicBrainz5::CLifespan::Ended
 *
 * @param Lifespan #Mb5Lifespan object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_lifespan_get_ended(Mb5Lifespan Lifespan, char *str, int len);

/**
* Delete an #Mb5Medium object
*
* @param Medium Object to delete
*/
  void mb5_medium_delete(Mb5Medium Medium);

/**
* Clone an #Mb5Medium object
*
* @param Medium Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Medium mb5_medium_clone(Mb5Medium Medium);

/**
 * @see MusicBrainz5::CMedium::Title
 *
 * @param Medium #Mb5Medium object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_medium_get_title(Mb5Medium Medium, char *str, int len);

/**
 * @see MusicBrainz5::CMedium::Position
 *
 * @param Medium #Mb5Medium object
 *
 * @return Returned value
 */
  int mb5_medium_get_position(Mb5Medium Medium);

/**
 * @see MusicBrainz5::CMedium::Format
 *
 * @param Medium #Mb5Medium object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_medium_get_format(Mb5Medium Medium, char *str, int len);

/**
 * @see MusicBrainz5::CMedium::DiscList
 *
 * @param Medium #Mb5Medium object
 *
 * @return #Mb5DiscList object
 */
  Mb5DiscList mb5_medium_get_disclist(Mb5Medium Medium);

/**
 * @see MusicBrainz5::CMedium::TrackList
 *
 * @param Medium #Mb5Medium object
 *
 * @return #Mb5TrackList object
 */
  Mb5TrackList mb5_medium_get_tracklist(Mb5Medium Medium);

/* --------------------------------------------------------------------------

   libmusicbrainz5 - Client library to access MusicBrainz

   Copyright (C) 2012 Andrew Hawkins

   This file is part of libmusicbrainz5.

   This library is free software; you can redistribute it and/or
   modify it under the terms of v2 of the GNU Lesser General Public
   License as published by the Free Software Foundation.

   libmusicbrainz5 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

     $Id$

----------------------------------------------------------------------------*/

/**
 * @see MusicBrainz5::CMedium::ContainsDiscID
 *
 * @param Medium #Mb5Medium object
 * @param DiscID DiscID to check
 *
 * @return 1 if DiscID found, 0 otherwise
 */
	unsigned char mb5_medium_contains_discid(Mb5Medium Medium, const char *DiscID);


/**
* Delete an #Mb5Message object
*
* @param Message Object to delete
*/
  void mb5_message_delete(Mb5Message Message);

/**
* Clone an #Mb5Message object
*
* @param Message Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Message mb5_message_clone(Mb5Message Message);

/**
 * @see MusicBrainz5::CMessage::Text
 *
 * @param Message #Mb5Message object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_message_get_text(Mb5Message Message, char *str, int len);

/**
* Delete an #Mb5Metadata object
*
* @param Metadata Object to delete
*/
  void mb5_metadata_delete(Mb5Metadata Metadata);

/**
* Clone an #Mb5Metadata object
*
* @param Metadata Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Metadata mb5_metadata_clone(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::XMLNS
 *
 * @param Metadata #Mb5Metadata object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_metadata_get_xmlns(Mb5Metadata Metadata, char *str, int len);

/**
 * @see MusicBrainz5::CMetadata::XMLNSExt
 *
 * @param Metadata #Mb5Metadata object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_metadata_get_xmlnsext(Mb5Metadata Metadata, char *str, int len);

/**
 * @see MusicBrainz5::CMetadata::Generator
 *
 * @param Metadata #Mb5Metadata object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_metadata_get_generator(Mb5Metadata Metadata, char *str, int len);

/**
 * @see MusicBrainz5::CMetadata::Created
 *
 * @param Metadata #Mb5Metadata object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_metadata_get_created(Mb5Metadata Metadata, char *str, int len);

/**
 * @see MusicBrainz5::CMetadata::Artist
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5Artist object
 */
  Mb5Artist mb5_metadata_get_artist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::Release
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5Release object
 */
  Mb5Release mb5_metadata_get_release(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::ReleaseGroup
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5ReleaseGroup object
 */
  Mb5ReleaseGroup mb5_metadata_get_releasegroup(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::Recording
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5Recording object
 */
  Mb5Recording mb5_metadata_get_recording(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::Label
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5Label object
 */
  Mb5Label mb5_metadata_get_label(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::Work
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5Work object
 */
  Mb5Work mb5_metadata_get_work(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::PUID
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5PUID object
 */
  Mb5PUID mb5_metadata_get_puid(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::ISRC
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5ISRC object
 */
  Mb5ISRC mb5_metadata_get_isrc(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::Disc
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5Disc object
 */
  Mb5Disc mb5_metadata_get_disc(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::LabelInfoList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5LabelInfoList object
 */
  Mb5LabelInfoList mb5_metadata_get_labelinfolist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::Rating
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5Rating object
 */
  Mb5Rating mb5_metadata_get_rating(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::UserRating
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5UserRating object
 */
  Mb5UserRating mb5_metadata_get_userrating(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::Collection
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5Collection object
 */
  Mb5Collection mb5_metadata_get_collection(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::ArtistList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5ArtistList object
 */
  Mb5ArtistList mb5_metadata_get_artistlist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::ReleaseList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5ReleaseList object
 */
  Mb5ReleaseList mb5_metadata_get_releaselist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::ReleaseGroupList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5ReleaseGroupList object
 */
  Mb5ReleaseGroupList mb5_metadata_get_releasegrouplist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::RecordingList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5RecordingList object
 */
  Mb5RecordingList mb5_metadata_get_recordinglist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::LabelList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5LabelList object
 */
  Mb5LabelList mb5_metadata_get_labellist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::WorkList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5WorkList object
 */
  Mb5WorkList mb5_metadata_get_worklist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::ISRCList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5ISRCList object
 */
  Mb5ISRCList mb5_metadata_get_isrclist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::AnnotationList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5AnnotationList object
 */
  Mb5AnnotationList mb5_metadata_get_annotationlist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::CDStubList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5CDStubList object
 */
  Mb5CDStubList mb5_metadata_get_cdstublist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::FreeDBDiscList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5FreeDBDiscList object
 */
  Mb5FreeDBDiscList mb5_metadata_get_freedbdisclist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::TagList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5TagList object
 */
  Mb5TagList mb5_metadata_get_taglist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::UserTagList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5UserTagList object
 */
  Mb5UserTagList mb5_metadata_get_usertaglist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::CollectionList
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5CollectionList object
 */
  Mb5CollectionList mb5_metadata_get_collectionlist(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::CDStub
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5CDStub object
 */
  Mb5CDStub mb5_metadata_get_cdstub(Mb5Metadata Metadata);

/**
 * @see MusicBrainz5::CMetadata::Message
 *
 * @param Metadata #Mb5Metadata object
 *
 * @return #Mb5Message object
 */
  Mb5Message mb5_metadata_get_message(Mb5Metadata Metadata);

/**
* Delete an #Mb5NameCredit object
*
* @param NameCredit Object to delete
*/
  void mb5_namecredit_delete(Mb5NameCredit NameCredit);

/**
* Clone an #Mb5NameCredit object
*
* @param NameCredit Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5NameCredit mb5_namecredit_clone(Mb5NameCredit NameCredit);

/**
 * @see MusicBrainz5::CNameCredit::JoinPhrase
 *
 * @param NameCredit #Mb5NameCredit object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_namecredit_get_joinphrase(Mb5NameCredit NameCredit, char *str, int len);

/**
 * @see MusicBrainz5::CNameCredit::Name
 *
 * @param NameCredit #Mb5NameCredit object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_namecredit_get_name(Mb5NameCredit NameCredit, char *str, int len);

/**
 * @see MusicBrainz5::CNameCredit::Artist
 *
 * @param NameCredit #Mb5NameCredit object
 *
 * @return #Mb5Artist object
 */
  Mb5Artist mb5_namecredit_get_artist(Mb5NameCredit NameCredit);

/**
* Delete an #Mb5NonMBTrack object
*
* @param NonMBTrack Object to delete
*/
  void mb5_nonmbtrack_delete(Mb5NonMBTrack NonMBTrack);

/**
* Clone an #Mb5NonMBTrack object
*
* @param NonMBTrack Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5NonMBTrack mb5_nonmbtrack_clone(Mb5NonMBTrack NonMBTrack);

/**
 * @see MusicBrainz5::CNonMBTrack::Title
 *
 * @param NonMBTrack #Mb5NonMBTrack object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_nonmbtrack_get_title(Mb5NonMBTrack NonMBTrack, char *str, int len);

/**
 * @see MusicBrainz5::CNonMBTrack::Artist
 *
 * @param NonMBTrack #Mb5NonMBTrack object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_nonmbtrack_get_artist(Mb5NonMBTrack NonMBTrack, char *str, int len);

/**
 * @see MusicBrainz5::CNonMBTrack::Length
 *
 * @param NonMBTrack #Mb5NonMBTrack object
 *
 * @return Returned value
 */
  int mb5_nonmbtrack_get_length(Mb5NonMBTrack NonMBTrack);

/**
* Delete an #Mb5PUID object
*
* @param PUID Object to delete
*/
  void mb5_puid_delete(Mb5PUID PUID);

/**
* Clone an #Mb5PUID object
*
* @param PUID Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5PUID mb5_puid_clone(Mb5PUID PUID);

/**
 * @see MusicBrainz5::CPUID::ID
 *
 * @param PUID #Mb5PUID object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_puid_get_id(Mb5PUID PUID, char *str, int len);

/**
 * @see MusicBrainz5::CPUID::RecordingList
 *
 * @param PUID #Mb5PUID object
 *
 * @return #Mb5RecordingList object
 */
  Mb5RecordingList mb5_puid_get_recordinglist(Mb5PUID PUID);

/**
* Delete an #Mb5Query object
*
* @param Query Object to delete
*/
  void mb5_query_delete(Mb5Query Query);

/**
* Clone an #Mb5Query object
*
* @param Query Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Query mb5_query_clone(Mb5Query Query);

/**
 * @see MusicBrainz5::CQuery::LastHTTPCode
 *
 * @param Query #Mb5Query object
 *
 * @return Returned value
 */
  int mb5_query_get_lasthttpcode(Mb5Query Query);

/**
 * @see MusicBrainz5::CQuery::LastErrorMessage
 *
 * @param Query #Mb5Query object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_query_get_lasterrormessage(Mb5Query Query, char *str, int len);

/**
 * @see MusicBrainz5::CQuery::Version
 *
 * @param Query #Mb5Query object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_query_get_version(Mb5Query Query, char *str, int len);

/* --------------------------------------------------------------------------

   libmusicbrainz5 - Client library to access MusicBrainz

   Copyright (C) 2012 Andrew Hawkins

   This file is part of libmusicbrainz5.

   This library is free software; you can redistribute it and/or
   modify it under the terms of v2 of the GNU Lesser General Public
   License as published by the Free Software Foundation.

   libmusicbrainz5 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

     $Id$

----------------------------------------------------------------------------*/

/**
 * Create a new instance of #Mb5Query.
 *
 * @see MusicBrainz5::CQuery::CQuery
 *
 * @param UserAgent User agent to be passed to submissions
 * @param Server Server to use, pass null to use the default server
 * @param Port Port to use, pass 0 to use the default port
 *
 * @return The newly created #Mb5Query object. This object <b>must</b> be deleted once
 *				finished with.
 */

	Mb5Query mb5_query_new(const char *UserAgent, const char *Server, int Port);

/**
 * Set the username for authenticating to MusicBrainz
 *
 * @see MusicBrainz5::CQuery::SetUserName
 *
 * @param Query #Mb5Query object
 * @param UserName Username to use
 */
	void mb5_query_set_username(Mb5Query Query, const char *UserName);

/**
 * Set the password for authenticating to MusicBrainz
 *
 * @see MusicBrainz5::CQuery::SetPassword
 *
 * @param Query #Mb5Query object
 * @param Password Password to use
 */
	void mb5_query_set_password(Mb5Query Query, const char *Password);

/**
 * Set the proxy server
 *
 * @see MusicBrainz5::CQuery::SetProxyHost
 *
 * @param Query #Mb5Query object
 * @param ProxyHost Proxy server to use
 */
	void mb5_query_set_proxyhost(Mb5Query Query, const char *ProxyHost);

/**
 *	Set the port to use on the proxy server
 *
 * @see MusicBrainz5::CQuery::SetProxyPort
 *
 * @param Query #Mb5Query object
 * @param ProxyPort Port to use on proxy server
 */
	void mb5_query_set_proxyport(Mb5Query Query, int ProxyPort);

/**
 *	Set the username to use to authenticate to the proxy server
 *
 * @see MusicBrainz5::CQuery::SetProxyUserName
 *
 * @param Query #Mb5Query object
 * @param	ProxyUserName User name to use
 */
	void mb5_query_set_proxyusername(Mb5Query Query, const char *ProxyUserName);

/**
 * Set the password to use to authenticate to the proxy server
 *
 * @see MusicBrainz5::CQuery::SetProxyPassword
 *
 * @param Query #Mb5Query object
 * @param ProxyPassword Password to use
 */
	void mb5_query_set_proxypassword(Mb5Query Query, const char *ProxyPassword);

/**
 *	Return a list of releases that match the specified Disc ID
 *
 * @see MusicBrainz5::CQuery::LookupDiscID
 *
 * @param Query #Mb5Query object
 * @param	DiscID DiscID to lookup
 *
 * @return A #Mb5ReleaseList object. This object <b>must</b> be deleted once
 *				finished with.
 */
	Mb5ReleaseList mb5_query_lookup_discid(Mb5Query Query, const char *DiscID);

/**
 * Return full information about a specific release
 *
 * @see MusicBrainz5::CQuery::LookupRelease
 *
 * @param Query #Mb5Query object
 * @param	Release Release to return information for
 *
 * @return A #Mb5Release object. This object <b>must</b> be deleted once
 *				finished with.
 */
	Mb5Release mb5_query_lookup_release(Mb5Query Query, const char *Release);

/**
 *	Perform a generic query
 *
 * @see MusicBrainz5::CQuery::Query
 *
 * @param Query #Mb5Query object
 * @param	Entity The entity to query
 * @param ID The ID to query
 * @param Resource The resource to query
 * @param	NumParams The number of parameters in the following arrays
 * @param ParamNames Array of strings containing parameter names
 * @param	ParamValues Array of space seperated parameter values
 *
 * @return A #Mb5Metadata object. This object <b>must</b> be deleted once
 *				finished with.
 */
	Mb5Metadata mb5_query_query(Mb5Query Query, const char *Entity, const char *ID, const char *Resource, int NumParams, char **ParamNames, char **ParamValues);

/**
 *	Add a list of releases to a collection
 *
 * @see MusicBrainz5::CQuery::AddCollectionEntries
 *
 * @param Query #Mb5Query object
 * @param	Collection ID of collection to add releases to
 * @param	NumEntries The number of entries to add
 * @param Entries Array of strings of release IDs to add
 *
 * @return 0 on failure, 1 on success
 */
	unsigned char mb5_query_add_collection_entries(Mb5Query Query, const char *Collection, int NumEntries, const char **Entries);

/**
 *	Delete a list of releases from a collection
 *
 * @see MusicBrainz5::CQuery::AddCollectionEntries
 *
 * @param Query #Mb5Query object
 * @param	Collection ID of collection to delete releases from
 * @param	NumEntries The number of entries to delete
 * @param Entries Array of strings of release IDs to delete
 *
 * @return 0 on failure, 1 on success
 */
	unsigned char mb5_query_delete_collection_entries(Mb5Query Query, const char *Collection, int NumEntries, const char **Entries);

/**
 * @see MusicBrainz5::CQuery::tQueryResult
 */

	typedef enum
	{
			eQuery_Success=0,
			eQuery_ConnectionError,
			eQuery_Timeout,
			eQuery_AuthenticationError,
			eQuery_FetchError,
			eQuery_RequestError,
			eQuery_ResourceNotFound
	} tQueryResult;

/**
 * @see MusicBrainz5::CQuery::LastResult
 *
 * @param Query #Mb5Query object
 *
 * @return Last query result code
 */
	tQueryResult mb5_query_get_lastresult(Mb5Query Query);



/**
* Delete an #Mb5Rating object
*
* @param Rating Object to delete
*/
  void mb5_rating_delete(Mb5Rating Rating);

/**
* Clone an #Mb5Rating object
*
* @param Rating Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Rating mb5_rating_clone(Mb5Rating Rating);

/**
 * @see MusicBrainz5::CRating::VotesCount
 *
 * @param Rating #Mb5Rating object
 *
 * @return Returned value
 */
  int mb5_rating_get_votescount(Mb5Rating Rating);

/**
 * @see MusicBrainz5::CRating::Rating
 *
 * @param Rating #Mb5Rating object
 *
 * @return Returned value
 */
  double mb5_rating_get_rating(Mb5Rating Rating);

/**
* Delete an #Mb5Recording object
*
* @param Recording Object to delete
*/
  void mb5_recording_delete(Mb5Recording Recording);

/**
* Clone an #Mb5Recording object
*
* @param Recording Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Recording mb5_recording_clone(Mb5Recording Recording);

/**
 * @see MusicBrainz5::CRecording::ID
 *
 * @param Recording #Mb5Recording object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_recording_get_id(Mb5Recording Recording, char *str, int len);

/**
 * @see MusicBrainz5::CRecording::Title
 *
 * @param Recording #Mb5Recording object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_recording_get_title(Mb5Recording Recording, char *str, int len);

/**
 * @see MusicBrainz5::CRecording::Length
 *
 * @param Recording #Mb5Recording object
 *
 * @return Returned value
 */
  int mb5_recording_get_length(Mb5Recording Recording);

/**
 * @see MusicBrainz5::CRecording::Disambiguation
 *
 * @param Recording #Mb5Recording object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_recording_get_disambiguation(Mb5Recording Recording, char *str, int len);

/**
 * @see MusicBrainz5::CRecording::ArtistCredit
 *
 * @param Recording #Mb5Recording object
 *
 * @return #Mb5ArtistCredit object
 */
  Mb5ArtistCredit mb5_recording_get_artistcredit(Mb5Recording Recording);

/**
 * @see MusicBrainz5::CRecording::ReleaseList
 *
 * @param Recording #Mb5Recording object
 *
 * @return #Mb5ReleaseList object
 */
  Mb5ReleaseList mb5_recording_get_releaselist(Mb5Recording Recording);

/**
 * @see MusicBrainz5::CRecording::PUIDList
 *
 * @param Recording #Mb5Recording object
 *
 * @return #Mb5PUIDList object
 */
  Mb5PUIDList mb5_recording_get_puidlist(Mb5Recording Recording);

/**
 * @see MusicBrainz5::CRecording::ISRCList
 *
 * @param Recording #Mb5Recording object
 *
 * @return #Mb5ISRCList object
 */
  Mb5ISRCList mb5_recording_get_isrclist(Mb5Recording Recording);

/**
 * @see MusicBrainz5::CRecording::RelationListList
 *
 * @param Recording #Mb5RecordingList object
 *
 * @return #Mb5RelationListList object
 */
  Mb5RelationListList mb5_recording_get_relationlistlist(Mb5Recording Recording);

/**
 * @see MusicBrainz5::CRecording::TagList
 *
 * @param Recording #Mb5Recording object
 *
 * @return #Mb5TagList object
 */
  Mb5TagList mb5_recording_get_taglist(Mb5Recording Recording);

/**
 * @see MusicBrainz5::CRecording::UserTagList
 *
 * @param Recording #Mb5Recording object
 *
 * @return #Mb5UserTagList object
 */
  Mb5UserTagList mb5_recording_get_usertaglist(Mb5Recording Recording);

/**
 * @see MusicBrainz5::CRecording::Rating
 *
 * @param Recording #Mb5Recording object
 *
 * @return #Mb5Rating object
 */
  Mb5Rating mb5_recording_get_rating(Mb5Recording Recording);

/**
 * @see MusicBrainz5::CRecording::UserRating
 *
 * @param Recording #Mb5Recording object
 *
 * @return #Mb5UserRating object
 */
  Mb5UserRating mb5_recording_get_userrating(Mb5Recording Recording);

/**
* Delete an #Mb5Relation object
*
* @param Relation Object to delete
*/
  void mb5_relation_delete(Mb5Relation Relation);

/**
* Clone an #Mb5Relation object
*
* @param Relation Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Relation mb5_relation_clone(Mb5Relation Relation);

/**
 * @see MusicBrainz5::CRelation::Type
 *
 * @param Relation #Mb5Relation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_relation_get_type(Mb5Relation Relation, char *str, int len);

/**
 * @see MusicBrainz5::CRelation::Target
 *
 * @param Relation #Mb5Relation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_relation_get_target(Mb5Relation Relation, char *str, int len);

/**
 * @see MusicBrainz5::CRelation::Direction
 *
 * @param Relation #Mb5Relation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_relation_get_direction(Mb5Relation Relation, char *str, int len);

/**
 * @see MusicBrainz5::CRelation::AttributeList
 *
 * @param Relation #Mb5Relation object
 *
 * @return #Mb5AttributeList object
 */
  Mb5AttributeList mb5_relation_get_attributelist(Mb5Relation Relation);

/**
 * @see MusicBrainz5::CRelation::Begin
 *
 * @param Relation #Mb5Relation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_relation_get_begin(Mb5Relation Relation, char *str, int len);

/**
 * @see MusicBrainz5::CRelation::End
 *
 * @param Relation #Mb5Relation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_relation_get_end(Mb5Relation Relation, char *str, int len);

/**
 * @see MusicBrainz5::CRelation::Artist
 *
 * @param Relation #Mb5Relation object
 *
 * @return #Mb5Artist object
 */
  Mb5Artist mb5_relation_get_artist(Mb5Relation Relation);

/**
 * @see MusicBrainz5::CRelation::Release
 *
 * @param Relation #Mb5Relation object
 *
 * @return #Mb5Release object
 */
  Mb5Release mb5_relation_get_release(Mb5Relation Relation);

/**
 * @see MusicBrainz5::CRelation::ReleaseGroup
 *
 * @param Relation #Mb5Relation object
 *
 * @return #Mb5ReleaseGroup object
 */
  Mb5ReleaseGroup mb5_relation_get_releasegroup(Mb5Relation Relation);

/**
 * @see MusicBrainz5::CRelation::Recording
 *
 * @param Relation #Mb5Relation object
 *
 * @return #Mb5Recording object
 */
  Mb5Recording mb5_relation_get_recording(Mb5Relation Relation);

/**
 * @see MusicBrainz5::CRelation::Label
 *
 * @param Relation #Mb5Relation object
 *
 * @return #Mb5Label object
 */
  Mb5Label mb5_relation_get_label(Mb5Relation Relation);

/**
 * @see MusicBrainz5::CRelation::Work
 *
 * @param Relation #Mb5Relation object
 *
 * @return #Mb5Work object
 */
  Mb5Work mb5_relation_get_work(Mb5Relation Relation);

/**
* Delete an #Mb5Release object
*
* @param Release Object to delete
*/
  void mb5_release_delete(Mb5Release Release);

/**
* Clone an #Mb5Release object
*
* @param Release Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Release mb5_release_clone(Mb5Release Release);

/**
 * @see MusicBrainz5::CRelease::ID
 *
 * @param Release #Mb5Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_release_get_id(Mb5Release Release, char *str, int len);

/**
 * @see MusicBrainz5::CRelease::Title
 *
 * @param Release #Mb5Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_release_get_title(Mb5Release Release, char *str, int len);

/**
 * @see MusicBrainz5::CRelease::Status
 *
 * @param Release #Mb5Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_release_get_status(Mb5Release Release, char *str, int len);

/**
 * @see MusicBrainz5::CRelease::Quality
 *
 * @param Release #Mb5Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_release_get_quality(Mb5Release Release, char *str, int len);

/**
 * @see MusicBrainz5::CRelease::Disambiguation
 *
 * @param Release #Mb5Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_release_get_disambiguation(Mb5Release Release, char *str, int len);

/**
 * @see MusicBrainz5::CRelease::Packaging
 *
 * @param Release #Mb5Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_release_get_packaging(Mb5Release Release, char *str, int len);

/**
 * @see MusicBrainz5::CRelease::TextRepresentation
 *
 * @param Release #Mb5Release object
 *
 * @return #Mb5TextRepresentation object
 */
  Mb5TextRepresentation mb5_release_get_textrepresentation(Mb5Release Release);

/**
 * @see MusicBrainz5::CRelease::ArtistCredit
 *
 * @param Release #Mb5Release object
 *
 * @return #Mb5ArtistCredit object
 */
  Mb5ArtistCredit mb5_release_get_artistcredit(Mb5Release Release);

/**
 * @see MusicBrainz5::CRelease::ReleaseGroup
 *
 * @param Release #Mb5Release object
 *
 * @return #Mb5ReleaseGroup object
 */
  Mb5ReleaseGroup mb5_release_get_releasegroup(Mb5Release Release);

/**
 * @see MusicBrainz5::CRelease::Date
 *
 * @param Release #Mb5Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_release_get_date(Mb5Release Release, char *str, int len);

/**
 * @see MusicBrainz5::CRelease::Country
 *
 * @param Release #Mb5Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_release_get_country(Mb5Release Release, char *str, int len);

/**
 * @see MusicBrainz5::CRelease::Barcode
 *
 * @param Release #Mb5Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_release_get_barcode(Mb5Release Release, char *str, int len);

/**
 * @see MusicBrainz5::CRelease::ASIN
 *
 * @param Release #Mb5Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_release_get_asin(Mb5Release Release, char *str, int len);

/**
 * @see MusicBrainz5::CRelease::LabelInfoList
 *
 * @param Release #Mb5Release object
 *
 * @return #Mb5LabelInfoList object
 */
  Mb5LabelInfoList mb5_release_get_labelinfolist(Mb5Release Release);

/**
 * @see MusicBrainz5::CRelease::MediumList
 *
 * @param Release #Mb5Release object
 *
 * @return #Mb5MediumList object
 */
  Mb5MediumList mb5_release_get_mediumlist(Mb5Release Release);

/**
 * @see MusicBrainz5::CRelease::RelationListList
 *
 * @param Release #Mb5ReleaseList object
 *
 * @return #Mb5RelationListList object
 */
  Mb5RelationListList mb5_release_get_relationlistlist(Mb5Release Release);

/**
 * @see MusicBrainz5::CRelease::CollectionList
 *
 * @param Release #Mb5Release object
 *
 * @return #Mb5CollectionList object
 */
  Mb5CollectionList mb5_release_get_collectionlist(Mb5Release Release);

/* --------------------------------------------------------------------------

   libmusicbrainz5 - Client library to access MusicBrainz

   Copyright (C) 2012 Andrew Hawkins

   This file is part of libmusicbrainz5.

   This library is free software; you can redistribute it and/or
   modify it under the terms of v2 of the GNU Lesser General Public
   License as published by the Free Software Foundation.

   libmusicbrainz5 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

     $Id$

----------------------------------------------------------------------------*/

/**
 * @see MusicBrainz5::CRelease::MediaMatchingDiscID
 *
 * @param Release #Mb5Release object
 * @param DiscID DiscID to match
 *
 * @return #Mb5MediumList.  This object <b>must</b> be deleted once
 *				finished with.
 */
	Mb5MediumList mb5_release_media_matching_discid(Mb5Release Release, const char *DiscID);



/**
* Delete an #Mb5ReleaseGroup object
*
* @param ReleaseGroup Object to delete
*/
  void mb5_releasegroup_delete(Mb5ReleaseGroup ReleaseGroup);

/**
* Clone an #Mb5ReleaseGroup object
*
* @param ReleaseGroup Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5ReleaseGroup mb5_releasegroup_clone(Mb5ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz5::CReleaseGroup::ID
 *
 * @param ReleaseGroup #Mb5ReleaseGroup object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_releasegroup_get_id(Mb5ReleaseGroup ReleaseGroup, char *str, int len);

/**
 * @see MusicBrainz5::CReleaseGroup::PrimaryType
 *
 * @param ReleaseGroup #Mb5ReleaseGroup object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_releasegroup_get_primarytype(Mb5ReleaseGroup ReleaseGroup, char *str, int len);

/**
 * @see MusicBrainz5::CReleaseGroup::Title
 *
 * @param ReleaseGroup #Mb5ReleaseGroup object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_releasegroup_get_title(Mb5ReleaseGroup ReleaseGroup, char *str, int len);

/**
 * @see MusicBrainz5::CReleaseGroup::Disambiguation
 *
 * @param ReleaseGroup #Mb5ReleaseGroup object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_releasegroup_get_disambiguation(Mb5ReleaseGroup ReleaseGroup, char *str, int len);

/**
 * @see MusicBrainz5::CReleaseGroup::FirstReleaseDate
 *
 * @param ReleaseGroup #Mb5ReleaseGroup object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_releasegroup_get_firstreleasedate(Mb5ReleaseGroup ReleaseGroup, char *str, int len);

/**
 * @see MusicBrainz5::CReleaseGroup::ArtistCredit
 *
 * @param ReleaseGroup #Mb5ReleaseGroup object
 *
 * @return #Mb5ArtistCredit object
 */
  Mb5ArtistCredit mb5_releasegroup_get_artistcredit(Mb5ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz5::CReleaseGroup::ReleaseList
 *
 * @param ReleaseGroup #Mb5ReleaseGroup object
 *
 * @return #Mb5ReleaseList object
 */
  Mb5ReleaseList mb5_releasegroup_get_releaselist(Mb5ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz5::CReleaseGroup::RelationListList
 *
 * @param ReleaseGroup #Mb5ReleaseGroupList object
 *
 * @return #Mb5RelationListList object
 */
  Mb5RelationListList mb5_releasegroup_get_relationlistlist(Mb5ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz5::CReleaseGroup::TagList
 *
 * @param ReleaseGroup #Mb5ReleaseGroup object
 *
 * @return #Mb5TagList object
 */
  Mb5TagList mb5_releasegroup_get_taglist(Mb5ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz5::CReleaseGroup::UserTagList
 *
 * @param ReleaseGroup #Mb5ReleaseGroup object
 *
 * @return #Mb5UserTagList object
 */
  Mb5UserTagList mb5_releasegroup_get_usertaglist(Mb5ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz5::CReleaseGroup::Rating
 *
 * @param ReleaseGroup #Mb5ReleaseGroup object
 *
 * @return #Mb5Rating object
 */
  Mb5Rating mb5_releasegroup_get_rating(Mb5ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz5::CReleaseGroup::UserRating
 *
 * @param ReleaseGroup #Mb5ReleaseGroup object
 *
 * @return #Mb5UserRating object
 */
  Mb5UserRating mb5_releasegroup_get_userrating(Mb5ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz5::CReleaseGroup::SecondaryTypeList
 *
 * @param ReleaseGroup #Mb5ReleaseGroup object
 *
 * @return #Mb5SecondaryTypeList object
 */
  Mb5SecondaryTypeList mb5_releasegroup_get_secondarytypelist(Mb5ReleaseGroup ReleaseGroup);

/**
* Delete an #Mb5SecondaryType object
*
* @param SecondaryType Object to delete
*/
  void mb5_secondarytype_delete(Mb5SecondaryType SecondaryType);

/**
* Clone an #Mb5SecondaryType object
*
* @param SecondaryType Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5SecondaryType mb5_secondarytype_clone(Mb5SecondaryType SecondaryType);

/**
 * @see MusicBrainz5::CSecondaryType::SecondaryType
 *
 * @param SecondaryType #Mb5SecondaryType object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_secondarytype_get_secondarytype(Mb5SecondaryType SecondaryType, char *str, int len);

/**
* Delete an #Mb5Tag object
*
* @param Tag Object to delete
*/
  void mb5_tag_delete(Mb5Tag Tag);

/**
* Clone an #Mb5Tag object
*
* @param Tag Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Tag mb5_tag_clone(Mb5Tag Tag);

/**
 * @see MusicBrainz5::CTag::Count
 *
 * @param Tag #Mb5Tag object
 *
 * @return Returned value
 */
  int mb5_tag_get_count(Mb5Tag Tag);

/**
 * @see MusicBrainz5::CTag::Name
 *
 * @param Tag #Mb5Tag object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_tag_get_name(Mb5Tag Tag, char *str, int len);

/**
* Delete an #Mb5TextRepresentation object
*
* @param TextRepresentation Object to delete
*/
  void mb5_textrepresentation_delete(Mb5TextRepresentation TextRepresentation);

/**
* Clone an #Mb5TextRepresentation object
*
* @param TextRepresentation Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5TextRepresentation mb5_textrepresentation_clone(Mb5TextRepresentation TextRepresentation);

/**
 * @see MusicBrainz5::CTextRepresentation::Language
 *
 * @param TextRepresentation #Mb5TextRepresentation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_textrepresentation_get_language(Mb5TextRepresentation TextRepresentation, char *str, int len);

/**
 * @see MusicBrainz5::CTextRepresentation::Script
 *
 * @param TextRepresentation #Mb5TextRepresentation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_textrepresentation_get_script(Mb5TextRepresentation TextRepresentation, char *str, int len);

/**
* Delete an #Mb5Track object
*
* @param Track Object to delete
*/
  void mb5_track_delete(Mb5Track Track);

/**
* Clone an #Mb5Track object
*
* @param Track Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Track mb5_track_clone(Mb5Track Track);

/**
 * @see MusicBrainz5::CTrack::Position
 *
 * @param Track #Mb5Track object
 *
 * @return Returned value
 */
  int mb5_track_get_position(Mb5Track Track);

/**
 * @see MusicBrainz5::CTrack::Title
 *
 * @param Track #Mb5Track object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_track_get_title(Mb5Track Track, char *str, int len);

/**
 * @see MusicBrainz5::CTrack::Recording
 *
 * @param Track #Mb5Track object
 *
 * @return #Mb5Recording object
 */
  Mb5Recording mb5_track_get_recording(Mb5Track Track);

/**
 * @see MusicBrainz5::CTrack::Length
 *
 * @param Track #Mb5Track object
 *
 * @return Returned value
 */
  int mb5_track_get_length(Mb5Track Track);

/**
 * @see MusicBrainz5::CTrack::ArtistCredit
 *
 * @param Track #Mb5Track object
 *
 * @return #Mb5ArtistCredit object
 */
  Mb5ArtistCredit mb5_track_get_artistcredit(Mb5Track Track);

/**
 * @see MusicBrainz5::CTrack::Number
 *
 * @param Track #Mb5Track object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_track_get_number(Mb5Track Track, char *str, int len);

/**
* Delete an #Mb5UserRating object
*
* @param UserRating Object to delete
*/
  void mb5_userrating_delete(Mb5UserRating UserRating);

/**
* Clone an #Mb5UserRating object
*
* @param UserRating Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5UserRating mb5_userrating_clone(Mb5UserRating UserRating);

/**
 * @see MusicBrainz5::CUserRating::UserRating
 *
 * @param UserRating #Mb5UserRating object
 *
 * @return Returned value
 */
  int mb5_userrating_get_userrating(Mb5UserRating UserRating);

/**
* Delete an #Mb5UserTag object
*
* @param UserTag Object to delete
*/
  void mb5_usertag_delete(Mb5UserTag UserTag);

/**
* Clone an #Mb5UserTag object
*
* @param UserTag Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5UserTag mb5_usertag_clone(Mb5UserTag UserTag);

/**
 * @see MusicBrainz5::CUserTag::Name
 *
 * @param UserTag #Mb5UserTag object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_usertag_get_name(Mb5UserTag UserTag, char *str, int len);

/**
* Delete an #Mb5Work object
*
* @param Work Object to delete
*/
  void mb5_work_delete(Mb5Work Work);

/**
* Clone an #Mb5Work object
*
* @param Work Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb5Work mb5_work_clone(Mb5Work Work);

/**
 * @see MusicBrainz5::CWork::ID
 *
 * @param Work #Mb5Work object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_work_get_id(Mb5Work Work, char *str, int len);

/**
 * @see MusicBrainz5::CWork::Type
 *
 * @param Work #Mb5Work object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_work_get_type(Mb5Work Work, char *str, int len);

/**
 * @see MusicBrainz5::CWork::Title
 *
 * @param Work #Mb5Work object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_work_get_title(Mb5Work Work, char *str, int len);

/**
 * @see MusicBrainz5::CWork::ArtistCredit
 *
 * @param Work #Mb5Work object
 *
 * @return #Mb5ArtistCredit object
 */
  Mb5ArtistCredit mb5_work_get_artistcredit(Mb5Work Work);

/**
 * @see MusicBrainz5::CWork::ISWCList
 *
 * @param Work #Mb5WorkList object
 *
 * @return #Mb5ISWCList object
 */
  Mb5ISWCList mb5_work_get_iswclist(Mb5Work Work);

/**
 * @see MusicBrainz5::CWork::Disambiguation
 *
 * @param Work #Mb5Work object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_work_get_disambiguation(Mb5Work Work, char *str, int len);

/**
 * @see MusicBrainz5::CWork::AliasList
 *
 * @param Work #Mb5Work object
 *
 * @return #Mb5AliasList object
 */
  Mb5AliasList mb5_work_get_aliaslist(Mb5Work Work);

/**
 * @see MusicBrainz5::CWork::RelationListList
 *
 * @param Work #Mb5WorkList object
 *
 * @return #Mb5RelationListList object
 */
  Mb5RelationListList mb5_work_get_relationlistlist(Mb5Work Work);

/**
 * @see MusicBrainz5::CWork::TagList
 *
 * @param Work #Mb5Work object
 *
 * @return #Mb5TagList object
 */
  Mb5TagList mb5_work_get_taglist(Mb5Work Work);

/**
 * @see MusicBrainz5::CWork::UserTagList
 *
 * @param Work #Mb5Work object
 *
 * @return #Mb5UserTagList object
 */
  Mb5UserTagList mb5_work_get_usertaglist(Mb5Work Work);

/**
 * @see MusicBrainz5::CWork::Rating
 *
 * @param Work #Mb5Work object
 *
 * @return #Mb5Rating object
 */
  Mb5Rating mb5_work_get_rating(Mb5Work Work);

/**
 * @see MusicBrainz5::CWork::UserRating
 *
 * @param Work #Mb5Work object
 *
 * @return #Mb5UserRating object
 */
  Mb5UserRating mb5_work_get_userrating(Mb5Work Work);

/**
 * @see MusicBrainz5::CWork::Language
 *
 * @param Work #Mb5Work object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_work_get_language(Mb5Work Work, char *str, int len);

/**
 * Delete a #Mb5AliasList
 *
 * @param List List to delete
 */
  void mb5_alias_list_delete(Mb5AliasList List);

/**
 * Return the number of entries in a #Mb5AliasList
 *
 * @param	List List to use
 */
  int mb5_alias_list_size(Mb5AliasList List);

/**
 * Returns an entry from a #Mb5AliasList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Alias object.
 */
  Mb5Alias mb5_alias_list_item(Mb5AliasList List, int Item);

/**
 *	Return the count of entries in an #Mb5AliasList
 *
 * @param	List List to use
 */
	int mb5_alias_list_get_count(Mb5AliasList List);

/**
 *	Return the offset of entries in an #Mb5AliasList
 *
 * @param	List List to use
 */
	int mb5_alias_list_get_offset(Mb5AliasList List);

/**
* Clone an #Mb5AliasList object
*
* @param AliasList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5AliasList mb5_alias_list_clone(Mb5AliasList AliasList);

/**
 * Delete a #Mb5AnnotationList
 *
 * @param List List to delete
 */
  void mb5_annotation_list_delete(Mb5AnnotationList List);

/**
 * Return the number of entries in a #Mb5AnnotationList
 *
 * @param	List List to use
 */
  int mb5_annotation_list_size(Mb5AnnotationList List);

/**
 * Returns an entry from a #Mb5AnnotationList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Annotation object.
 */
  Mb5Annotation mb5_annotation_list_item(Mb5AnnotationList List, int Item);

/**
 *	Return the count of entries in an #Mb5AnnotationList
 *
 * @param	List List to use
 */
	int mb5_annotation_list_get_count(Mb5AnnotationList List);

/**
 *	Return the offset of entries in an #Mb5AnnotationList
 *
 * @param	List List to use
 */
	int mb5_annotation_list_get_offset(Mb5AnnotationList List);

/**
* Clone an #Mb5AnnotationList object
*
* @param AnnotationList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5AnnotationList mb5_annotation_list_clone(Mb5AnnotationList AnnotationList);

/**
 * Delete a #Mb5ArtistList
 *
 * @param List List to delete
 */
  void mb5_artist_list_delete(Mb5ArtistList List);

/**
 * Return the number of entries in a #Mb5ArtistList
 *
 * @param	List List to use
 */
  int mb5_artist_list_size(Mb5ArtistList List);

/**
 * Returns an entry from a #Mb5ArtistList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Artist object.
 */
  Mb5Artist mb5_artist_list_item(Mb5ArtistList List, int Item);

/**
 *	Return the count of entries in an #Mb5ArtistList
 *
 * @param	List List to use
 */
	int mb5_artist_list_get_count(Mb5ArtistList List);

/**
 *	Return the offset of entries in an #Mb5ArtistList
 *
 * @param	List List to use
 */
	int mb5_artist_list_get_offset(Mb5ArtistList List);

/**
* Clone an #Mb5ArtistList object
*
* @param ArtistList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5ArtistList mb5_artist_list_clone(Mb5ArtistList ArtistList);

/**
 * Delete a #Mb5AttributeList
 *
 * @param List List to delete
 */
  void mb5_attribute_list_delete(Mb5AttributeList List);

/**
 * Return the number of entries in a #Mb5AttributeList
 *
 * @param	List List to use
 */
  int mb5_attribute_list_size(Mb5AttributeList List);

/**
 * Returns an entry from a #Mb5AttributeList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Attribute object.
 */
  Mb5Attribute mb5_attribute_list_item(Mb5AttributeList List, int Item);

/**
 *	Return the count of entries in an #Mb5AttributeList
 *
 * @param	List List to use
 */
	int mb5_attribute_list_get_count(Mb5AttributeList List);

/**
 *	Return the offset of entries in an #Mb5AttributeList
 *
 * @param	List List to use
 */
	int mb5_attribute_list_get_offset(Mb5AttributeList List);

/**
* Clone an #Mb5AttributeList object
*
* @param AttributeList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5AttributeList mb5_attribute_list_clone(Mb5AttributeList AttributeList);

/**
 * Delete a #Mb5CDStubList
 *
 * @param List List to delete
 */
  void mb5_cdstub_list_delete(Mb5CDStubList List);

/**
 * Return the number of entries in a #Mb5CDStubList
 *
 * @param	List List to use
 */
  int mb5_cdstub_list_size(Mb5CDStubList List);

/**
 * Returns an entry from a #Mb5CDStubList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5CDStub object.
 */
  Mb5CDStub mb5_cdstub_list_item(Mb5CDStubList List, int Item);

/**
 *	Return the count of entries in an #Mb5CDStubList
 *
 * @param	List List to use
 */
	int mb5_cdstub_list_get_count(Mb5CDStubList List);

/**
 *	Return the offset of entries in an #Mb5CDStubList
 *
 * @param	List List to use
 */
	int mb5_cdstub_list_get_offset(Mb5CDStubList List);

/**
* Clone an #Mb5CDStubList object
*
* @param CDStubList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5CDStubList mb5_cdstub_list_clone(Mb5CDStubList CDStubList);

/**
 * Delete a #Mb5CollectionList
 *
 * @param List List to delete
 */
  void mb5_collection_list_delete(Mb5CollectionList List);

/**
 * Return the number of entries in a #Mb5CollectionList
 *
 * @param	List List to use
 */
  int mb5_collection_list_size(Mb5CollectionList List);

/**
 * Returns an entry from a #Mb5CollectionList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Collection object.
 */
  Mb5Collection mb5_collection_list_item(Mb5CollectionList List, int Item);

/**
 *	Return the count of entries in an #Mb5CollectionList
 *
 * @param	List List to use
 */
	int mb5_collection_list_get_count(Mb5CollectionList List);

/**
 *	Return the offset of entries in an #Mb5CollectionList
 *
 * @param	List List to use
 */
	int mb5_collection_list_get_offset(Mb5CollectionList List);

/**
* Clone an #Mb5CollectionList object
*
* @param CollectionList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5CollectionList mb5_collection_list_clone(Mb5CollectionList CollectionList);

/**
 * Delete a #Mb5DiscList
 *
 * @param List List to delete
 */
  void mb5_disc_list_delete(Mb5DiscList List);

/**
 * Return the number of entries in a #Mb5DiscList
 *
 * @param	List List to use
 */
  int mb5_disc_list_size(Mb5DiscList List);

/**
 * Returns an entry from a #Mb5DiscList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Disc object.
 */
  Mb5Disc mb5_disc_list_item(Mb5DiscList List, int Item);

/**
 *	Return the count of entries in an #Mb5DiscList
 *
 * @param	List List to use
 */
	int mb5_disc_list_get_count(Mb5DiscList List);

/**
 *	Return the offset of entries in an #Mb5DiscList
 *
 * @param	List List to use
 */
	int mb5_disc_list_get_offset(Mb5DiscList List);

/**
* Clone an #Mb5DiscList object
*
* @param DiscList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5DiscList mb5_disc_list_clone(Mb5DiscList DiscList);

/**
 * Delete a #Mb5FreeDBDiscList
 *
 * @param List List to delete
 */
  void mb5_freedbdisc_list_delete(Mb5FreeDBDiscList List);

/**
 * Return the number of entries in a #Mb5FreeDBDiscList
 *
 * @param	List List to use
 */
  int mb5_freedbdisc_list_size(Mb5FreeDBDiscList List);

/**
 * Returns an entry from a #Mb5FreeDBDiscList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5FreeDBDisc object.
 */
  Mb5FreeDBDisc mb5_freedbdisc_list_item(Mb5FreeDBDiscList List, int Item);

/**
 *	Return the count of entries in an #Mb5FreeDBDiscList
 *
 * @param	List List to use
 */
	int mb5_freedbdisc_list_get_count(Mb5FreeDBDiscList List);

/**
 *	Return the offset of entries in an #Mb5FreeDBDiscList
 *
 * @param	List List to use
 */
	int mb5_freedbdisc_list_get_offset(Mb5FreeDBDiscList List);

/**
* Clone an #Mb5FreeDBDiscList object
*
* @param FreeDBDiscList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5FreeDBDiscList mb5_freedbdisc_list_clone(Mb5FreeDBDiscList FreeDBDiscList);

/**
 * Delete a #Mb5IPIList
 *
 * @param List List to delete
 */
  void mb5_ipi_list_delete(Mb5IPIList List);

/**
 * Return the number of entries in a #Mb5IPIList
 *
 * @param	List List to use
 */
  int mb5_ipi_list_size(Mb5IPIList List);

/**
 * Returns an entry from a #Mb5IPIList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5IPI object.
 */
  Mb5IPI mb5_ipi_list_item(Mb5IPIList List, int Item);

/**
 *	Return the count of entries in an #Mb5IPIList
 *
 * @param	List List to use
 */
	int mb5_ipi_list_get_count(Mb5IPIList List);

/**
 *	Return the offset of entries in an #Mb5IPIList
 *
 * @param	List List to use
 */
	int mb5_ipi_list_get_offset(Mb5IPIList List);

/**
* Clone an #Mb5IPIList object
*
* @param IPIList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5IPIList mb5_ipi_list_clone(Mb5IPIList IPIList);

/**
 * Delete a #Mb5ISRCList
 *
 * @param List List to delete
 */
  void mb5_isrc_list_delete(Mb5ISRCList List);

/**
 * Return the number of entries in a #Mb5ISRCList
 *
 * @param	List List to use
 */
  int mb5_isrc_list_size(Mb5ISRCList List);

/**
 * Returns an entry from a #Mb5ISRCList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5ISRC object.
 */
  Mb5ISRC mb5_isrc_list_item(Mb5ISRCList List, int Item);

/**
 *	Return the count of entries in an #Mb5ISRCList
 *
 * @param	List List to use
 */
	int mb5_isrc_list_get_count(Mb5ISRCList List);

/**
 *	Return the offset of entries in an #Mb5ISRCList
 *
 * @param	List List to use
 */
	int mb5_isrc_list_get_offset(Mb5ISRCList List);

/**
* Clone an #Mb5ISRCList object
*
* @param ISRCList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5ISRCList mb5_isrc_list_clone(Mb5ISRCList ISRCList);

/**
 * Delete a #Mb5ISWCList
 *
 * @param List List to delete
 */
  void mb5_iswc_list_delete(Mb5ISWCList List);

/**
 * Return the number of entries in a #Mb5ISWCList
 *
 * @param	List List to use
 */
  int mb5_iswc_list_size(Mb5ISWCList List);

/**
 * Returns an entry from a #Mb5ISWCList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5ISWC object.
 */
  Mb5ISWC mb5_iswc_list_item(Mb5ISWCList List, int Item);

/**
 *	Return the count of entries in an #Mb5ISWCList
 *
 * @param	List List to use
 */
	int mb5_iswc_list_get_count(Mb5ISWCList List);

/**
 *	Return the offset of entries in an #Mb5ISWCList
 *
 * @param	List List to use
 */
	int mb5_iswc_list_get_offset(Mb5ISWCList List);

/**
* Clone an #Mb5ISWCList object
*
* @param ISWCList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5ISWCList mb5_iswc_list_clone(Mb5ISWCList ISWCList);

/**
 * Delete a #Mb5LabelList
 *
 * @param List List to delete
 */
  void mb5_label_list_delete(Mb5LabelList List);

/**
 * Return the number of entries in a #Mb5LabelList
 *
 * @param	List List to use
 */
  int mb5_label_list_size(Mb5LabelList List);

/**
 * Returns an entry from a #Mb5LabelList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Label object.
 */
  Mb5Label mb5_label_list_item(Mb5LabelList List, int Item);

/**
 *	Return the count of entries in an #Mb5LabelList
 *
 * @param	List List to use
 */
	int mb5_label_list_get_count(Mb5LabelList List);

/**
 *	Return the offset of entries in an #Mb5LabelList
 *
 * @param	List List to use
 */
	int mb5_label_list_get_offset(Mb5LabelList List);

/**
* Clone an #Mb5LabelList object
*
* @param LabelList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5LabelList mb5_label_list_clone(Mb5LabelList LabelList);

/**
 * Delete a #Mb5LabelInfoList
 *
 * @param List List to delete
 */
  void mb5_labelinfo_list_delete(Mb5LabelInfoList List);

/**
 * Return the number of entries in a #Mb5LabelInfoList
 *
 * @param	List List to use
 */
  int mb5_labelinfo_list_size(Mb5LabelInfoList List);

/**
 * Returns an entry from a #Mb5LabelInfoList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5LabelInfo object.
 */
  Mb5LabelInfo mb5_labelinfo_list_item(Mb5LabelInfoList List, int Item);

/**
 *	Return the count of entries in an #Mb5LabelInfoList
 *
 * @param	List List to use
 */
	int mb5_labelinfo_list_get_count(Mb5LabelInfoList List);

/**
 *	Return the offset of entries in an #Mb5LabelInfoList
 *
 * @param	List List to use
 */
	int mb5_labelinfo_list_get_offset(Mb5LabelInfoList List);

/**
* Clone an #Mb5LabelInfoList object
*
* @param LabelInfoList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5LabelInfoList mb5_labelinfo_list_clone(Mb5LabelInfoList LabelInfoList);

/**
 * Delete a #Mb5MediumList
 *
 * @param List List to delete
 */
  void mb5_medium_list_delete(Mb5MediumList List);

/**
 * Return the number of entries in a #Mb5MediumList
 *
 * @param	List List to use
 */
  int mb5_medium_list_size(Mb5MediumList List);

/**
 * Returns an entry from a #Mb5MediumList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Medium object.
 */
  Mb5Medium mb5_medium_list_item(Mb5MediumList List, int Item);

/**
 *	Return the count of entries in an #Mb5MediumList
 *
 * @param	List List to use
 */
	int mb5_medium_list_get_count(Mb5MediumList List);

/**
 *	Return the offset of entries in an #Mb5MediumList
 *
 * @param	List List to use
 */
	int mb5_medium_list_get_offset(Mb5MediumList List);

/**
* Clone an #Mb5MediumList object
*
* @param MediumList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5MediumList mb5_medium_list_clone(Mb5MediumList MediumList);

/**
 * @see MusicBrainz5::CMedium::TrackCount
 *
 * @param List List to use
 *
 * @return Returned value
 */
  int mb5_medium_list_get_trackcount(Mb5MediumList List);

/**
 * Delete a #Mb5NameCreditList
 *
 * @param List List to delete
 */
  void mb5_namecredit_list_delete(Mb5NameCreditList List);

/**
 * Return the number of entries in a #Mb5NameCreditList
 *
 * @param	List List to use
 */
  int mb5_namecredit_list_size(Mb5NameCreditList List);

/**
 * Returns an entry from a #Mb5NameCreditList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5NameCredit object.
 */
  Mb5NameCredit mb5_namecredit_list_item(Mb5NameCreditList List, int Item);

/**
 *	Return the count of entries in an #Mb5NameCreditList
 *
 * @param	List List to use
 */
	int mb5_namecredit_list_get_count(Mb5NameCreditList List);

/**
 *	Return the offset of entries in an #Mb5NameCreditList
 *
 * @param	List List to use
 */
	int mb5_namecredit_list_get_offset(Mb5NameCreditList List);

/**
* Clone an #Mb5NameCreditList object
*
* @param NameCreditList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5NameCreditList mb5_namecredit_list_clone(Mb5NameCreditList NameCreditList);

/**
 * Delete a #Mb5NonMBTrackList
 *
 * @param List List to delete
 */
  void mb5_nonmbtrack_list_delete(Mb5NonMBTrackList List);

/**
 * Return the number of entries in a #Mb5NonMBTrackList
 *
 * @param	List List to use
 */
  int mb5_nonmbtrack_list_size(Mb5NonMBTrackList List);

/**
 * Returns an entry from a #Mb5NonMBTrackList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5NonMBTrack object.
 */
  Mb5NonMBTrack mb5_nonmbtrack_list_item(Mb5NonMBTrackList List, int Item);

/**
 *	Return the count of entries in an #Mb5NonMBTrackList
 *
 * @param	List List to use
 */
	int mb5_nonmbtrack_list_get_count(Mb5NonMBTrackList List);

/**
 *	Return the offset of entries in an #Mb5NonMBTrackList
 *
 * @param	List List to use
 */
	int mb5_nonmbtrack_list_get_offset(Mb5NonMBTrackList List);

/**
* Clone an #Mb5NonMBTrackList object
*
* @param NonMBTrackList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5NonMBTrackList mb5_nonmbtrack_list_clone(Mb5NonMBTrackList NonMBTrackList);

/**
 * Delete a #Mb5PUIDList
 *
 * @param List List to delete
 */
  void mb5_puid_list_delete(Mb5PUIDList List);

/**
 * Return the number of entries in a #Mb5PUIDList
 *
 * @param	List List to use
 */
  int mb5_puid_list_size(Mb5PUIDList List);

/**
 * Returns an entry from a #Mb5PUIDList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5PUID object.
 */
  Mb5PUID mb5_puid_list_item(Mb5PUIDList List, int Item);

/**
 *	Return the count of entries in an #Mb5PUIDList
 *
 * @param	List List to use
 */
	int mb5_puid_list_get_count(Mb5PUIDList List);

/**
 *	Return the offset of entries in an #Mb5PUIDList
 *
 * @param	List List to use
 */
	int mb5_puid_list_get_offset(Mb5PUIDList List);

/**
* Clone an #Mb5PUIDList object
*
* @param PUIDList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5PUIDList mb5_puid_list_clone(Mb5PUIDList PUIDList);

/**
 * Delete a #Mb5RecordingList
 *
 * @param List List to delete
 */
  void mb5_recording_list_delete(Mb5RecordingList List);

/**
 * Return the number of entries in a #Mb5RecordingList
 *
 * @param	List List to use
 */
  int mb5_recording_list_size(Mb5RecordingList List);

/**
 * Returns an entry from a #Mb5RecordingList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Recording object.
 */
  Mb5Recording mb5_recording_list_item(Mb5RecordingList List, int Item);

/**
 *	Return the count of entries in an #Mb5RecordingList
 *
 * @param	List List to use
 */
	int mb5_recording_list_get_count(Mb5RecordingList List);

/**
 *	Return the offset of entries in an #Mb5RecordingList
 *
 * @param	List List to use
 */
	int mb5_recording_list_get_offset(Mb5RecordingList List);

/**
* Clone an #Mb5RecordingList object
*
* @param RecordingList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5RecordingList mb5_recording_list_clone(Mb5RecordingList RecordingList);

/**
 * Delete a #Mb5RelationList
 *
 * @param List List to delete
 */
  void mb5_relation_list_delete(Mb5RelationList List);

/**
 * Return the number of entries in a #Mb5RelationList
 *
 * @param	List List to use
 */
  int mb5_relation_list_size(Mb5RelationList List);

/**
 * Returns an entry from a #Mb5RelationList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Relation object.
 */
  Mb5Relation mb5_relation_list_item(Mb5RelationList List, int Item);

/**
 *	Return the count of entries in an #Mb5RelationList
 *
 * @param	List List to use
 */
	int mb5_relation_list_get_count(Mb5RelationList List);

/**
 *	Return the offset of entries in an #Mb5RelationList
 *
 * @param	List List to use
 */
	int mb5_relation_list_get_offset(Mb5RelationList List);

/**
* Clone an #Mb5RelationList object
*
* @param RelationList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5RelationList mb5_relation_list_clone(Mb5RelationList RelationList);

/**
 * @see MusicBrainz5::CRelation::TargetType
 *
 * @param List List to use
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb5_relation_list_get_targettype(Mb5RelationList List, char *str, int len);

/**
 * Delete a #Mb5RelationListList
 *
 * @param List List to delete
 */
  void mb5_relationlist_list_delete(Mb5RelationListList List);

/**
 * Return the number of entries in a #Mb5RelationListList
 *
 * @param	List List to use
 */
  int mb5_relationlist_list_size(Mb5RelationListList List);

/**
 * Returns an entry from a #Mb5RelationListList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5RelationList object.
 */
  Mb5RelationList mb5_relationlist_list_item(Mb5RelationListList List, int Item);

/**
 *	Return the count of entries in an #Mb5RelationListList
 *
 * @param	List List to use
 */
	int mb5_relationlist_list_get_count(Mb5RelationListList List);

/**
 *	Return the offset of entries in an #Mb5RelationListList
 *
 * @param	List List to use
 */
	int mb5_relationlist_list_get_offset(Mb5RelationListList List);

/**
* Clone an #Mb5RelationListList object
*
* @param RelationListList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5RelationListList mb5_relationlist_list_clone(Mb5RelationListList RelationListList);

/**
 * Delete a #Mb5ReleaseList
 *
 * @param List List to delete
 */
  void mb5_release_list_delete(Mb5ReleaseList List);

/**
 * Return the number of entries in a #Mb5ReleaseList
 *
 * @param	List List to use
 */
  int mb5_release_list_size(Mb5ReleaseList List);

/**
 * Returns an entry from a #Mb5ReleaseList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Release object.
 */
  Mb5Release mb5_release_list_item(Mb5ReleaseList List, int Item);

/**
 *	Return the count of entries in an #Mb5ReleaseList
 *
 * @param	List List to use
 */
	int mb5_release_list_get_count(Mb5ReleaseList List);

/**
 *	Return the offset of entries in an #Mb5ReleaseList
 *
 * @param	List List to use
 */
	int mb5_release_list_get_offset(Mb5ReleaseList List);

/**
* Clone an #Mb5ReleaseList object
*
* @param ReleaseList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5ReleaseList mb5_release_list_clone(Mb5ReleaseList ReleaseList);

/**
 * Delete a #Mb5ReleaseGroupList
 *
 * @param List List to delete
 */
  void mb5_releasegroup_list_delete(Mb5ReleaseGroupList List);

/**
 * Return the number of entries in a #Mb5ReleaseGroupList
 *
 * @param	List List to use
 */
  int mb5_releasegroup_list_size(Mb5ReleaseGroupList List);

/**
 * Returns an entry from a #Mb5ReleaseGroupList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5ReleaseGroup object.
 */
  Mb5ReleaseGroup mb5_releasegroup_list_item(Mb5ReleaseGroupList List, int Item);

/**
 *	Return the count of entries in an #Mb5ReleaseGroupList
 *
 * @param	List List to use
 */
	int mb5_releasegroup_list_get_count(Mb5ReleaseGroupList List);

/**
 *	Return the offset of entries in an #Mb5ReleaseGroupList
 *
 * @param	List List to use
 */
	int mb5_releasegroup_list_get_offset(Mb5ReleaseGroupList List);

/**
* Clone an #Mb5ReleaseGroupList object
*
* @param ReleaseGroupList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5ReleaseGroupList mb5_releasegroup_list_clone(Mb5ReleaseGroupList ReleaseGroupList);

/**
 * Delete a #Mb5SecondaryTypeList
 *
 * @param List List to delete
 */
  void mb5_secondarytype_list_delete(Mb5SecondaryTypeList List);

/**
 * Return the number of entries in a #Mb5SecondaryTypeList
 *
 * @param	List List to use
 */
  int mb5_secondarytype_list_size(Mb5SecondaryTypeList List);

/**
 * Returns an entry from a #Mb5SecondaryTypeList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5SecondaryType object.
 */
  Mb5SecondaryType mb5_secondarytype_list_item(Mb5SecondaryTypeList List, int Item);

/**
 *	Return the count of entries in an #Mb5SecondaryTypeList
 *
 * @param	List List to use
 */
	int mb5_secondarytype_list_get_count(Mb5SecondaryTypeList List);

/**
 *	Return the offset of entries in an #Mb5SecondaryTypeList
 *
 * @param	List List to use
 */
	int mb5_secondarytype_list_get_offset(Mb5SecondaryTypeList List);

/**
* Clone an #Mb5SecondaryTypeList object
*
* @param SecondaryTypeList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5SecondaryTypeList mb5_secondarytype_list_clone(Mb5SecondaryTypeList SecondaryTypeList);

/**
 * Delete a #Mb5TagList
 *
 * @param List List to delete
 */
  void mb5_tag_list_delete(Mb5TagList List);

/**
 * Return the number of entries in a #Mb5TagList
 *
 * @param	List List to use
 */
  int mb5_tag_list_size(Mb5TagList List);

/**
 * Returns an entry from a #Mb5TagList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Tag object.
 */
  Mb5Tag mb5_tag_list_item(Mb5TagList List, int Item);

/**
 *	Return the count of entries in an #Mb5TagList
 *
 * @param	List List to use
 */
	int mb5_tag_list_get_count(Mb5TagList List);

/**
 *	Return the offset of entries in an #Mb5TagList
 *
 * @param	List List to use
 */
	int mb5_tag_list_get_offset(Mb5TagList List);

/**
* Clone an #Mb5TagList object
*
* @param TagList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5TagList mb5_tag_list_clone(Mb5TagList TagList);

/**
 * Delete a #Mb5TrackList
 *
 * @param List List to delete
 */
  void mb5_track_list_delete(Mb5TrackList List);

/**
 * Return the number of entries in a #Mb5TrackList
 *
 * @param	List List to use
 */
  int mb5_track_list_size(Mb5TrackList List);

/**
 * Returns an entry from a #Mb5TrackList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Track object.
 */
  Mb5Track mb5_track_list_item(Mb5TrackList List, int Item);

/**
 *	Return the count of entries in an #Mb5TrackList
 *
 * @param	List List to use
 */
	int mb5_track_list_get_count(Mb5TrackList List);

/**
 *	Return the offset of entries in an #Mb5TrackList
 *
 * @param	List List to use
 */
	int mb5_track_list_get_offset(Mb5TrackList List);

/**
* Clone an #Mb5TrackList object
*
* @param TrackList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5TrackList mb5_track_list_clone(Mb5TrackList TrackList);

/**
 * Delete a #Mb5UserTagList
 *
 * @param List List to delete
 */
  void mb5_usertag_list_delete(Mb5UserTagList List);

/**
 * Return the number of entries in a #Mb5UserTagList
 *
 * @param	List List to use
 */
  int mb5_usertag_list_size(Mb5UserTagList List);

/**
 * Returns an entry from a #Mb5UserTagList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5UserTag object.
 */
  Mb5UserTag mb5_usertag_list_item(Mb5UserTagList List, int Item);

/**
 *	Return the count of entries in an #Mb5UserTagList
 *
 * @param	List List to use
 */
	int mb5_usertag_list_get_count(Mb5UserTagList List);

/**
 *	Return the offset of entries in an #Mb5UserTagList
 *
 * @param	List List to use
 */
	int mb5_usertag_list_get_offset(Mb5UserTagList List);

/**
* Clone an #Mb5UserTagList object
*
* @param UserTagList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5UserTagList mb5_usertag_list_clone(Mb5UserTagList UserTagList);

/**
 * Delete a #Mb5WorkList
 *
 * @param List List to delete
 */
  void mb5_work_list_delete(Mb5WorkList List);

/**
 * Return the number of entries in a #Mb5WorkList
 *
 * @param	List List to use
 */
  int mb5_work_list_size(Mb5WorkList List);

/**
 * Returns an entry from a #Mb5WorkList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb5Work object.
 */
  Mb5Work mb5_work_list_item(Mb5WorkList List, int Item);

/**
 *	Return the count of entries in an #Mb5WorkList
 *
 * @param	List List to use
 */
	int mb5_work_list_get_count(Mb5WorkList List);

/**
 *	Return the offset of entries in an #Mb5WorkList
 *
 * @param	List List to use
 */
	int mb5_work_list_get_offset(Mb5WorkList List);

/**
* Clone an #Mb5WorkList object
*
* @param WorkList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb5WorkList mb5_work_list_clone(Mb5WorkList WorkList);

#ifdef __cplusplus
}
#endif

#endif

