# Edit Audio Settings of a Guest
use strict;
use warnings;
our (%gui, %signal, %vmc);

# Initialise the audio page
sub setup_edit_dialog_audio {
    my $vhost = &vhost();
    &addrow_log("Fetching audio settings for $vmc{Name}...");
    &busy_pointer($gui{dialogEdit}, 1);
    $gui{comboboxEditAudioDriver}->signal_handler_block($signal{audiodrv});
    $gui{comboboxEditAudioCtr}->signal_handler_block($signal{audioctr});
    $gui{checkbuttonEditAudioEnable}->set_active(&bl(IAudioAdapter_getEnabled($vmc{IAudioAdapter})));
    $gui{tableEditAudio}->set_sensitive($gui{checkbuttonEditAudioEnable}->get_active()); # Ghost/Unghost other widgets based on audio enabled

    # Set WinMM and MMPM to Null as they no longer seem supported and cause problems if set.
    my $AudioDriver = IAudioAdapter_getAudioDriver($vmc{IAudioAdapter});
    IAudioAdapter_setAudioDriver($vmc{IAudioAdapter}, 'Null') if ($AudioDriver eq 'WinMM' or $AudioDriver eq 'MMPM');

    if ($$vhost{os} =~ m/Linux/i) { $gui{comboboxEditAudioDriver}->set_model($gui{liststoreEditAudioDriverLin}); }
    elsif ($$vhost{os} =~ m/Windows/i) { $gui{comboboxEditAudioDriver}->set_model($gui{liststoreEditAudioDriverWin}); }
    elsif ($$vhost{os} =~ m/SunOS/i) { $gui{comboboxEditAudioDriver}->set_model($gui{liststoreEditAudioDriverSol}); }
    elsif ($$vhost{os} =~ m/Darwin/i) { $gui{comboboxEditAudioDriver}->set_model($gui{liststoreEditAudioDriverMac}); }
    else { $gui{comboboxEditAudioDriver}->set_model($gui{liststoreEditAudioDriverOther}); }

    &combobox_set_active_text($gui{comboboxEditAudioDriver}, IAudioAdapter_getAudioDriver($vmc{IAudioAdapter}));
    &combobox_set_active_text($gui{comboboxEditAudioCtr}, IAudioAdapter_getAudioController($vmc{IAudioAdapter}));
    $gui{comboboxEditAudioDriver}->signal_handler_unblock($signal{audiodrv});
    $gui{comboboxEditAudioCtr}->signal_handler_unblock($signal{audioctr});
    &busy_pointer($gui{dialogEdit}, 0);
    &addrow_log('Audio settings completed.');
}

# Toggle whether audio is enable or not for this guest
sub audio_toggle {
    if ($vmc{SessionType} eq 'WriteLock') {
        my $state = $gui{checkbuttonEditAudioEnable}->get_active();
        IAudioAdapter_setEnabled($vmc{IAudioAdapter}, $state);
        $gui{tableEditAudio}->set_sensitive($state);
    }
}

# Set the audio controller type
sub audio_ctr {
    if ($vmc{SessionType} eq 'WriteLock') {
        my $controller = &getsel_combo($gui{comboboxEditAudioCtr}, 0);
        IAudioAdapter_setAudioController($vmc{IAudioAdapter}, $controller);
    }
}

# Set the audio driver type
sub audio_driver {
    if ($vmc{SessionType} eq 'WriteLock') {
        my $driver = &getsel_combo($gui{comboboxEditAudioDriver}, 0);
        IAudioAdapter_setAudioDriver($vmc{IAudioAdapter}, $driver);
    }
}

1;
