/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.SyslogAppenderBase;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyslogAppender
extends SyslogAppenderBase<ILoggingEvent> {
    public static final String DEFAULT_SUFFIX_PATTERN = "[%thread] %logger %msg";
    PatternLayout prefixLayout = new PatternLayout();

    @Override
    public Layout<ILoggingEvent> buildLayout(String facilityStr) {
        String prefixPattern = "%syslogStart{" + facilityStr + "}%nopex";
        this.prefixLayout.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        this.prefixLayout.setPattern(prefixPattern);
        this.prefixLayout.setContext(this.getContext());
        this.prefixLayout.start();
        PatternLayout fullLayout = new PatternLayout();
        fullLayout.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        if (this.suffixPattern == null) {
            this.suffixPattern = DEFAULT_SUFFIX_PATTERN;
        }
        fullLayout.setPattern(prefixPattern + this.suffixPattern);
        fullLayout.setContext(this.getContext());
        fullLayout.start();
        return fullLayout;
    }

    @Override
    public int getSeverityForEvent(Object eventObject) {
        ILoggingEvent event = (ILoggingEvent)eventObject;
        return LevelToSyslogSeverity.convert(event);
    }

    @Override
    protected void postProcess(Object eventObject, OutputStream sw) {
        ILoggingEvent event = (ILoggingEvent)eventObject;
        String prefix = this.prefixLayout.doLayout(event);
        for (IThrowableProxy tp = event.getThrowableProxy(); tp != null; tp = tp.getCause()) {
            StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
            try {
                for (StackTraceElementProxy step : stepArray) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(prefix).append('\t').append(step);
                    sw.write(sb.toString().getBytes());
                    sw.flush();
                }
                continue;
            }
            catch (IOException e) {
                break;
            }
        }
    }
}

