/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import openlink.util.Vector;
import virtuoso.jdbc4.VirtuosoColumn;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;

public class VirtuosoResultSetMetaData
implements ResultSetMetaData {
    protected Hashtable<VirtuosoColumn, Integer> hcolumns;
    private Vector columnsMetaData = new Vector(10, 20);

    protected VirtuosoResultSetMetaData(VirtuosoConnection virtuosoConnection, String[] stringArray, int[] nArray) {
        this.hcolumns = new Hashtable();
        for (int i = 0; i < stringArray.length; ++i) {
            VirtuosoColumn virtuosoColumn = new VirtuosoColumn(stringArray[i], nArray[i], virtuosoConnection);
            this.hcolumns.put(virtuosoColumn, new Integer(i));
            this.columnsMetaData.insertElementAt(virtuosoColumn, i);
        }
    }

    VirtuosoResultSetMetaData(Vector vector, VirtuosoConnection virtuosoConnection) throws VirtuosoException {
        if (vector == null) {
            return;
        }
        Object object = vector.firstElement();
        Vector vector2 = null;
        if (!(object instanceof Vector)) {
            return;
        }
        vector2 = (Vector)object;
        this.hcolumns = new Hashtable();
        for (int i = 0; i < vector2.size(); ++i) {
            VirtuosoColumn virtuosoColumn = new VirtuosoColumn((Vector)vector2.elementAt(i), virtuosoConnection);
            this.hcolumns.put(virtuosoColumn, new Integer(i));
            this.columnsMetaData.insertElementAt(virtuosoColumn, i);
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    @Override
    public int getColumnCount() throws VirtuosoException {
        return this.columnsMetaData.size();
    }

    @Override
    public boolean isAutoIncrement(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).isCaseSensitive();
    }

    @Override
    public boolean isSearchable(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).isSearchable();
    }

    @Override
    public boolean isCurrency(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).isCurrency();
    }

    @Override
    public int isNullable(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).isNullable();
    }

    @Override
    public boolean isSigned(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).getColumnDisplaySize();
    }

    @Override
    public String getColumnLabel(int n) throws VirtuosoException {
        return this.getColumnName(n);
    }

    @Override
    public String getColumnName(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).getColumnName();
    }

    public void setColumnName(int n, String string) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).setColumnName(string);
    }

    @Override
    public int getPrecision(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).getPrecision();
    }

    @Override
    public int getScale(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).getScale();
    }

    @Override
    public int getColumnType(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).getColumnType();
    }

    @Override
    public String getColumnTypeName(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        VirtuosoColumn virtuosoColumn = (VirtuosoColumn)this.columnsMetaData.elementAt(n - 1);
        if (virtuosoColumn.isXml()) {
            return "XMLType";
        }
        return VirtuosoResultSetMetaData._getColumnTypeName(this.getColumnType(n));
    }

    protected static String _getColumnTypeName(int n) throws VirtuosoException {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE PRECISION";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONG VARBINARY";
            }
            case -1: {
                return "LONG VARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case -10: {
                return "LONG NVARCHAR";
            }
        }
        return "";
    }

    @Override
    public boolean isReadOnly(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return !((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).isUpdateable();
    }

    @Override
    public boolean isWritable(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).isUpdateable();
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws VirtuosoException {
        return this.isWritable(n);
    }

    @Override
    public String getColumnClassName(int n) throws VirtuosoException {
        if (n < 1 || n > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).getColumnClassName();
    }

    @Override
    public String getSchemaName(int n) throws VirtuosoException {
        return "";
    }

    @Override
    public String getTableName(int n) throws VirtuosoException {
        return "";
    }

    @Override
    public String getCatalogName(int n) throws VirtuosoException {
        return "";
    }

    public void close() throws VirtuosoException {
        if (this.hcolumns != null) {
            this.hcolumns.clear();
            this.hcolumns = null;
        }
        if (this.columnsMetaData != null) {
            this.columnsMetaData.removeAllElements();
            this.columnsMetaData = null;
        }
    }

    protected int getColumnDtp(int n) {
        if (n < 1 || n > this.columnsMetaData.size()) {
            return 0;
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).getDtp();
    }

    protected boolean isXml(int n) {
        if (n < 1 || n > this.columnsMetaData.size()) {
            return false;
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(n - 1)).isXml();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new VirtuosoException("Unable to unwrap to " + clazz.toString(), "22023", -4);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }
}

