/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.io.Reader;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MarshallAware;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.transport.stomp.XStreamSupport;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;

public class XStreamWireFormat
extends TextWireFormat {
    private XStream xStream;
    private int version;

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    public WireFormat copy() {
        return new XStreamWireFormat();
    }

    @Override
    public Object unmarshalText(String text) {
        return this.getXStream().fromXML(text);
    }

    @Override
    public Object unmarshalText(Reader reader) {
        Object val = this.getXStream().fromXML(reader);
        if (val instanceof ConsumerInfo) {
            ((ConsumerInfo)val).initTransients();
        }
        return val;
    }

    @Override
    public String marshalText(Object command) throws IOException {
        MessageDispatch dispatch;
        if (command instanceof MarshallAware) {
            ((MarshallAware)command).beforeMarshall(this);
        } else if (command instanceof MessageDispatch && (dispatch = (MessageDispatch)command) != null && dispatch.getMessage() != null) {
            dispatch.getMessage().beforeMarshall(this);
        }
        return this.getXStream().toXML(command);
    }

    public boolean canProcessWireFormatVersion(int version) {
        return true;
    }

    public int getCurrentWireFormatVersion() {
        return 1;
    }

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
            this.xStream.setClassLoader(this.getClass().getClassLoader());
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    protected XStream createXStream() {
        final XStream xstream = XStreamSupport.createXStream();
        xstream.ignoreUnknownElements();
        xstream.registerConverter(new Converter(){
            final Converter delegate;
            {
                this.delegate = xstream.getConverterLookup().lookupConverterForType(ByteSequence.class);
            }

            public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
                ByteSequence byteSequence = (ByteSequence)o;
                byteSequence.compact();
                this.delegate.marshal((Object)byteSequence, hierarchicalStreamWriter, marshallingContext);
            }

            public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
                return this.delegate.unmarshal(hierarchicalStreamReader, unmarshallingContext);
            }

            public boolean canConvert(Class aClass) {
                return aClass == ByteSequence.class;
            }
        });
        return xstream;
    }
}

