/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.CamelLogger;

public class LogProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable,
IdAware {
    private String id;
    private final Expression expression;
    private final CamelLogger logger;

    public LogProcessor(Expression expression, CamelLogger logger) {
        this.expression = expression;
        this.logger = logger;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            if (this.logger.shouldLog()) {
                String msg = this.expression.evaluate(exchange, String.class);
                this.logger.doLog(msg);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    public String toString() {
        return "Log(" + this.logger.getLog().getName() + ")[" + this.expression + "]";
    }

    @Override
    public String getTraceLabel() {
        return "log[" + this.expression + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public CamelLogger getLogger() {
        return this.logger;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

