/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.propertyoutput;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.propertyoutput.Messages;
import org.pentaho.di.trans.steps.propertyoutput.PropertyOutput;
import org.pentaho.di.trans.steps.propertyoutput.PropertyOutputData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String keyfield;
    private String valuefield;
    private boolean AddToResult;
    private String fileName;
    private String extension;
    private boolean stepNrInFilename;
    private boolean partNrInFilename;
    private boolean dateInFilename;
    private boolean timeInFilename;
    private boolean createparentfolder;
    private String comment;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        PropertyOutputMeta retval = (PropertyOutputMeta)super.clone();
        return retval;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isStepNrInFilename() {
        return this.stepNrInFilename;
    }

    public void setStepNrInFilename(boolean stepNrInFilename) {
        this.stepNrInFilename = stepNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean AddToResult() {
        return this.AddToResult;
    }

    public void setAddToResult(boolean AddToResult) {
        this.AddToResult = AddToResult;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String commentin) {
        this.comment = commentin;
    }

    public String[] getFiles(VariableSpace space) {
        int nr;
        int copies = 1;
        int parts = 1;
        if (this.stepNrInFilename) {
            copies = 3;
        }
        if (this.partNrInFilename) {
            parts = 3;
        }
        if ((nr = copies * parts) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int part = 0; part < parts; ++part) {
                retval[i] = this.buildFilename(space, copy);
                ++i;
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(VariableSpace space, int stepnr) {
        SimpleDateFormat daf = new SimpleDateFormat();
        String retval = space.environmentSubstitute(this.fileName);
        Date now = new Date();
        if (this.dateInFilename) {
            daf.applyPattern("yyyMMdd");
            String d = daf.format(now);
            retval = retval + "_" + d;
        }
        if (this.timeInFilename) {
            daf.applyPattern("HHmmss");
            String t = daf.format(now);
            retval = retval + "_" + t;
        }
        if (this.stepNrInFilename) {
            retval = retval + "_" + stepnr;
        }
        if (this.extension != null && this.extension.length() != 0) {
            retval = retval + "." + this.extension;
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.keyfield = XMLHandler.getTagValue((Node)stepnode, (String)"keyfield");
            this.valuefield = XMLHandler.getTagValue((Node)stepnode, (String)"valuefield");
            this.comment = XMLHandler.getTagValue((Node)stepnode, (String)"comment");
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
            this.createparentfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"create_parent_folder"));
            this.extension = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"extention");
            this.stepNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"split"));
            this.partNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"haspartno"));
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_time"));
            this.AddToResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"AddToResult"));
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.createparentfolder = false;
        this.keyfield = null;
        this.valuefield = null;
        this.comment = null;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"keyfield", (String)this.keyfield));
        retval.append("    " + XMLHandler.addTagValue((String)"valuefield", (String)this.valuefield));
        retval.append("    " + XMLHandler.addTagValue((String)"comment", (String)this.comment));
        retval.append("    <file>" + Const.CR);
        retval.append("      " + XMLHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append("      " + XMLHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append("      " + XMLHandler.addTagValue((String)"split", (boolean)this.stepNrInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"haspartno", (boolean)this.partNrInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append("    " + XMLHandler.addTagValue((String)"addtoresult", (boolean)this.AddToResult));
        retval.append("      </file>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.keyfield = rep.getStepAttributeString(id_step, "keyfield");
            this.valuefield = rep.getStepAttributeString(id_step, "valuefield");
            this.comment = rep.getStepAttributeString(id_step, "comment");
            this.fileName = rep.getStepAttributeString(id_step, "file_name");
            this.extension = rep.getStepAttributeString(id_step, "file_extention");
            this.stepNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_stepnr");
            this.partNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_partnr");
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, "file_add_date");
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, "file_add_time");
            this.createparentfolder = rep.getStepAttributeBoolean(id_step, "create_parent_folder");
            this.AddToResult = rep.getStepAttributeBoolean(id_step, "addtoresult");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "keyfield", this.keyfield);
            rep.saveStepAttribute(id_transformation, id_step, "valuefield", this.valuefield);
            rep.saveStepAttribute(id_transformation, id_step, "comment", this.comment);
            rep.saveStepAttribute(id_transformation, id_step, "file_name", this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, "file_extention", this.extension);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_stepnr", this.stepNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_partnr", this.partNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_date", this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_time", this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "create_parent_folder", this.createparentfolder);
            rep.saveStepAttribute(id_transformation, id_step, "addtoresult", this.AddToResult);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, Messages.getString("PropertyOutputMeta.CheckResult.FieldsReceived", "" + prev.size()), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("PropertyOutputMeta.CheckResult.NoFields"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("PropertyOutputMeta.CheckResult.ExpectedInputOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("PropertyOutputMeta.CheckResult.ExpectedInputError"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (!Const.isEmpty((String)this.fileName)) {
            cr = new CheckResult(1, Messages.getString("PropertyOutputMeta.CheckResult.FilenameOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("PropertyOutputMeta.CheckResult.FilenameError"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        ValueMetaInterface v = prev.searchValueMeta(this.keyfield);
        if (v == null) {
            cr = new CheckResult(4, Messages.getString("PropertyOutputMeta.CheckResult.KeyFieldMissing"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("PropertyOutputMeta.CheckResult.KeyFieldOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        v = prev.searchValueMeta(this.valuefield);
        if (v == null) {
            cr = new CheckResult(4, Messages.getString("PropertyOutputMeta.CheckResult.ValueFieldMissing"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("PropertyOutputMeta.CheckResult.ValueFieldOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepDataInterface getStepData() {
        return new PropertyOutputData();
    }

    public String getKeyField() {
        return this.keyfield;
    }

    public String getValueField() {
        return this.valuefield;
    }

    public void setKeyField(String KeyField) {
        this.keyfield = KeyField;
    }

    public void setValueField(String valuefield) {
        this.valuefield = valuefield;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new PropertyOutput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName));
            if (fileObject.exists()) {
                this.fileName = resourceNamingInterface.nameResource(fileObject.getName().getBaseName(), fileObject.getParent().getName().getPath(), space.toString(), ResourceNamingInterface.FileNamingType.DATA_FILE);
                return this.fileName;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

