/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.FetchBuffer;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;

final class ClientFetchBuffer
extends FetchBuffer {
    private static final int UNKNOWN_ROW_COUNT = -1;
    private SQLServerStatement stmt;
    private int rowCount = -1;
    private int currentRow;

    ClientFetchBuffer(SQLServerStatement sQLServerStatement) {
        this.stmt = sQLServerStatement;
        this.currentRow = 0;
    }

    final void close() throws SQLServerException {
    }

    final void getterRefreshCurrentRow() throws SQLServerException {
    }

    final void beforeFirst() throws SQLServerException {
        this.currentRow = 0;
        this.stmt.fetchBufferBeforeFirst();
    }

    final void afterLast() throws SQLServerException {
        this.currentRow = this.getRowCount() + 1;
    }

    final boolean relative(int n) throws SQLServerException {
        if (0 == n) {
            return 0 != this.currentRow && this.getRowCount() + 1 != this.currentRow;
        }
        if (this.currentRow + n <= 0) {
            this.beforeFirst();
            return false;
        }
        if (this.currentRow + n > this.getRowCount()) {
            this.afterLast();
            return false;
        }
        if (n < 0) {
            n += this.currentRow;
            this.beforeFirst();
        }
        for (int i = 0; i < n; ++i) {
            this.stmt.fetchBufferNext();
            ++this.currentRow;
        }
        return true;
    }

    final boolean absolute(int n) throws SQLServerException {
        if (n < 0) {
            this.afterLast();
            return this.relative(n);
        }
        return this.relative(n - this.currentRow);
    }

    final int getRowCount() throws SQLServerException {
        if (-1 == this.rowCount) {
            this.rowCount = this.stmt.countRowsInFetchBuffer();
        }
        return this.rowCount;
    }
}

