/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.dao.session.SPFontLoader;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class FontSelector
implements DataEntryPanel {
    private static final Logger logger = Logger.getLogger(FontSelector.class);
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Font selectedFont;
    private final JList fontNameList;
    private final JList fontSizeList;
    private final JSpinner fontSizeSpinner;
    private final JList styleChoice;
    private static final Integer[] FONT_SIZES = new Integer[]{4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 18, 20, 24, 30, 36, 40, 48, 60, 72, 96, 144};
    private final JTextArea previewArea = new JTextArea("The Quick Wabit Architected the Loaded Matchmaker");
    private final JPanel panel;
    private final Font originalFont;
    private final SPFontLoader fontLoader;

    public FontSelector(Font font) {
        this(font == null ? Font.decode(null) : font, GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(), null);
    }

    public FontSelector(Font font, String[] fontList, SPFontLoader fontLoader) {
        this.fontLoader = fontLoader;
        if (font == null) {
            if (fontList == null || fontList.length == 0) {
                throw new IllegalArgumentException("The fontList parameter requires at least one valid font.");
            }
            font = Font.decode(fontList[0]);
            if (font == null) {
                throw new IllegalArgumentException("The fontList[0] element cannot be loaded.");
            }
        }
        logger.debug((Object)("Creating new font selector with given font: " + font));
        this.originalFont = font;
        SelectionHandler selectionHandler = new SelectionHandler();
        this.fontNameList = new JList<String>(fontList);
        this.fontNameList.addListSelectionListener(selectionHandler);
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel(font.getSize(), 1, 200, 1));
        this.fontSizeSpinner.addChangeListener(selectionHandler);
        this.fontSizeList = new JList<Integer>(FONT_SIZES);
        this.fontSizeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (FontSelector.this.fontSizeList.getSelectedValue() != null) {
                    FontSelector.this.fontSizeSpinner.setValue((Integer)FontSelector.this.fontSizeList.getSelectedValue());
                }
            }
        });
        this.styleChoice = new JList<FontStyle>(FontStyle.values());
        this.styleChoice.setSelectedValue((Object)FontStyle.forCode(font.getStyle()), true);
        this.styleChoice.addListSelectionListener(selectionHandler);
        FormLayout layout = new FormLayout("pref:grow, 4dlu, pref, 4dlu, pref", "pref, 4dlu, pref, 4dlu, fill:pref:grow");
        layout.setHonorsVisibility(true);
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)new JScrollPane(this.fontNameList), cc.xywh(1, 1, 1, 3));
        builder.add((Component)this.fontSizeSpinner, cc.xywh(3, 1, 1, 1));
        builder.add((Component)new JScrollPane(this.fontSizeList), cc.xywh(3, 3, 1, 1));
        builder.add((Component)new JScrollPane(this.styleChoice), cc.xywh(5, 1, 1, 3));
        this.previewArea.setBackground(Color.WHITE);
        this.previewArea.setPreferredSize(new Dimension(300, 100));
        builder.add((Component)this.previewArea, cc.xywh(1, 5, 5, 1));
        this.fontSizeList.setSelectedValue(font.getSize(), true);
        this.fontNameList.setSelectedValue(font.getFamily(), true);
        logger.debug((Object)("Set family list to \"" + font.getFamily() + "\" and size to " + Integer.valueOf(font.getSize())));
        this.panel = builder.getPanel();
        this.previewFont();
    }

    private void previewFont() {
        String name = (String)this.fontNameList.getSelectedValue();
        FontStyle style = (FontStyle)((Object)this.styleChoice.getSelectedValue());
        int size = (Integer)this.fontSizeSpinner.getValue();
        if (this.fontLoader == null) {
            this.setSelectedFont(new Font(name, style.getStyleCode(), size));
        } else {
            Font font = this.fontLoader.loadFontFromName(name);
            font = font.deriveFont(style.getStyleCode());
            font = font.deriveFont(Float.valueOf(String.valueOf(size)).floatValue());
            this.setSelectedFont(font);
        }
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Font selectedFont) {
        Font oldFont = this.selectedFont;
        this.selectedFont = selectedFont;
        this.pcs.firePropertyChange("selectedFont", oldFont, selectedFont);
        this.previewArea.setFont(selectedFont);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public boolean applyChanges() {
        return true;
    }

    @Override
    public void discardChanges() {
        this.setSelectedFont(this.originalFont);
    }

    @Override
    public boolean hasUnsavedChanges() {
        return false;
    }

    public void setPreviewText(String text) {
        this.previewArea.setText(text);
    }

    public String getPreviewText() {
        return this.previewArea.getText();
    }

    public void setShowingPreview(boolean show) {
        this.previewArea.setVisible(show);
    }

    public boolean isShowingPreview() {
        return this.previewArea.isVisible();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final FontSelector fs = new FontSelector(Font.decode("Courier bold 20"));
                fs.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        System.out.println("New font selection: " + fs.getSelectedFont());
                    }
                });
                JFrame dummyFrame = new JFrame();
                JDialog d = DataEntryPanelBuilder.createDataEntryPanelDialog(fs, dummyFrame, "Font Selector Demo!", "Yeehaw");
                d.setModal(true);
                d.setVisible(true);
                System.out.println("Selected font: " + fs.getSelectedFont());
                d.dispose();
                dummyFrame.dispose();
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private class SelectionHandler
    implements ChangeListener,
    ListSelectionListener {
        boolean updatingListSelection = false;

        private SelectionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.updatingListSelection) {
                return;
            }
            try {
                this.updatingListSelection = true;
                Integer newSize = (Integer)FontSelector.this.fontSizeSpinner.getValue();
                int newSizeIndexInList = Arrays.binarySearch((Object[])FONT_SIZES, newSize);
                if (newSizeIndexInList >= 0) {
                    FontSelector.this.fontSizeList.setSelectedIndex(newSizeIndexInList);
                    FontSelector.this.fontSizeList.ensureIndexIsVisible(newSizeIndexInList);
                } else {
                    FontSelector.this.fontSizeList.clearSelection();
                }
            }
            finally {
                this.updatingListSelection = false;
            }
            FontSelector.this.previewFont();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FontSelector.this.previewFont();
        }
    }

    private static enum FontStyle {
        PLAIN("Plain", 0),
        BOLD("Bold", 1),
        ITALIC("Italic", 2),
        BOLD_ITALIC("Bold Italic", 3);

        private final String humanName;
        private final int styleCode;

        private FontStyle(String name, int styleCode) {
            this.humanName = name;
            this.styleCode = styleCode;
        }

        public Font apply(Font f) {
            return f.deriveFont(this.styleCode);
        }

        public String toString() {
            return this.humanName;
        }

        public static FontStyle forCode(int styleCode) {
            for (FontStyle sty : FontStyle.values()) {
                if (styleCode != sty.styleCode) continue;
                return sty;
            }
            throw new IllegalArgumentException("Unknown font style code: " + styleCode);
        }

        public int getStyleCode() {
            return this.styleCode;
        }
    }
}

