/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.checkin;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracklink.CheckinOptions;
import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.ModelCache;
import com.almworks.tracklink.TrackLinkPlugin;
import com.almworks.tracklink.checkin.BeforeCheckinDialog;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.toolwindow.IssueMonitor;
import com.almworks.tracklink.util.BooleanWrapper;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.almworks.tracklink.vcslinks.cache.VCSCache;
import com.almworks.util.Log;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracklinkCheckinHandler
extends CheckinHandler {
    private final Project myProject;
    private final ArtifactInfoCache myCache;
    private final BooleanWrapper myCheckinWrapper;
    private final BooleanWrapper myFilteringWrapper;
    private final CheckinProjectPanel myCheckinProjectPanel;
    private final IssueMonitor myIssueMonitor;
    private final Dimension myDefaultDialogDimension;
    private final JCheckBox myCheckBox = TracklinkCheckinHandler.createCheckbox();
    private VirtualFile[] myVirtualFiles;

    private static JCheckBox createCheckbox() {
        JCheckBox checkBox = new JCheckBox(StringBundle.get("checkin.checkbox.text", new Object[0]));
        checkBox.setAlignmentX(0.0f);
        checkBox.setHorizontalAlignment(2);
        return checkBox;
    }

    public TracklinkCheckinHandler(Project project, ArtifactInfoCache cache, BooleanWrapper checkinWrapper, BooleanWrapper filteringWrapper, CheckinProjectPanel panel, IssueMonitor issueMonitor, Dimension defaultDialogDimension) {
        this.myProject = project;
        this.myCache = cache;
        this.myCheckinWrapper = checkinWrapper;
        this.myFilteringWrapper = filteringWrapper;
        this.myCheckinProjectPanel = panel;
        this.myIssueMonitor = issueMonitor;
        this.myDefaultDialogDimension = defaultDialogDimension;
    }

    public boolean isCheckerSelected() {
        return this.myCheckBox.isSelected();
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        return new RefreshableOnComponent(){
            private final JPanel myPanel = new JPanel(new BorderLayout());
            {
                this.myPanel.add((Component)TracklinkCheckinHandler.this.myCheckBox, "West");
                JPanel spacer = new JPanel();
                this.myPanel.add((Component)spacer, "Center");
            }

            public JComponent getComponent() {
                return this.myPanel;
            }

            public void refresh() {
            }

            public void saveState() {
            }

            public void restoreState() {
            }
        };
    }

    @Nullable
    public RefreshableOnComponent getAfterCheckinConfigurationPanel() {
        return null;
    }

    public CheckinHandler.ReturnResult beforeCheckin() {
        CheckinOptions checkinOptions;
        this.myVirtualFiles = null;
        if (!this.myCheckBox.isSelected()) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        HashSet workedOnURLs = new HashSet();
        HashSet allInfos = new HashSet(this.myIssueMonitor.getAllMonitoringArtifactInfos());
        HashSet filteredInfos = new HashSet();
        for (String url : workedOnURLs) {
            ArtifactInfo snapshot = this.myCache.getArtifactInfoSnapshot(url);
            if (snapshot.getStatus() == null || !snapshot.getStatus().isOk()) continue;
            if (this.notAddedYet(snapshot, (Set<ArtifactInfo>)allInfos)) {
                allInfos.add(snapshot);
            }
            filteredInfos.add(snapshot);
        }
        if (allInfos.isEmpty()) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        IssueLinkModel linkModel = ModelCache.getInstance().getModel(this.myProject);
        Collection collection = this.myCheckinProjectPanel.getVirtualFiles();
        VirtualFile[] virtualFiles = collection.toArray(new VirtualFile[collection.size()]);
        TrackLinkPlugin component = (TrackLinkPlugin)this.myProject.getComponent(TrackLinkPlugin.class);
        if (component == null) {
            assert (false) : this;
            checkinOptions = new CheckinOptions();
        } else {
            checkinOptions = component.getCheckinOptions();
        }
        BeforeCheckinDialog dialog = new BeforeCheckinDialog(this.myCheckBox, false, new ArrayList<ArtifactInfo>((Collection<ArtifactInfo>)allInfos), new ArrayList<ArtifactInfo>((Collection<ArtifactInfo>)filteredInfos), this.myFilteringWrapper, this.myCheckinProjectPanel.getCommitMessage(), linkModel, virtualFiles, checkinOptions);
        dialog.getWindow().setPreferredSize(this.myDefaultDialogDimension);
        dialog.show();
        this.myDefaultDialogDimension.setSize(dialog.getSize());
        if (0 == dialog.getExitCode()) {
            this.myVirtualFiles = virtualFiles;
            this.myCheckinProjectPanel.setCommitMessage(dialog.getComment());
            return CheckinHandler.ReturnResult.COMMIT;
        }
        return CheckinHandler.ReturnResult.CANCEL;
    }

    private boolean notAddedYet(ArtifactInfo snapshot, Set<ArtifactInfo> allInfos) {
        for (ArtifactInfo info : allInfos) {
            if (!Comparing.strEqual((String)snapshot.getUrl(), (String)info.getUrl())) continue;
            return false;
        }
        return true;
    }

    public void checkinSuccessful() {
        if (this.myVirtualFiles == null) {
            return;
        }
        VCSCache vcsCache = Utils.getVCSCache(this.myProject);
        if (vcsCache != null) {
            vcsCache.updateNextTime();
        }
    }

    public void checkinFailed(List<VcsException> exception) {
        Log.debug("checkinFailed");
    }
}

