/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.epic.debug.ui.PerlDebugImages;

public class PerlImageDescriptor
extends CompositeImageDescriptor {
    public static final int INSTALLED = 4;
    public static final int ENTRY = 8;
    public static final int EXIT = 16;
    public static final int ENABLED = 32;
    public static final int CONDITIONAL = 64;
    public static final int CAUGHT = 128;
    public static final int UNCAUGHT = 256;
    public static final int SCOPED = 512;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public PerlImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.setBaseImage(baseImage);
        this.setFlags(flags);
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PerlImageDescriptor)) {
            return false;
        }
        PerlImageDescriptor other = (PerlImageDescriptor)((Object)object);
        return this.getBaseImage().equals(other.getBaseImage()) && this.getFlags() == other.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawBreakpointOverlays();
    }

    protected void drawBreakpointOverlays() {
        int flags = this.getFlags();
        int x = 0;
        int y = 0;
        ImageData data = null;
        if ((flags & 4) != 0) {
            x = 0;
            y = this.getSize().y;
            data = (flags & 0x20) != 0 ? PerlDebugImages.DESC_OBJS_BREAKPOINT_INSTALLED.getImageData() : PerlDebugImages.DESC_OBJS_BREAKPOINT_INSTALLED_DISABLED.getImageData();
            this.drawImage(data, x, y -= data.height);
        }
        if ((flags & 0x80) != 0) {
            data = (flags & 0x20) != 0 ? PerlDebugImages.DESC_OBJS_CAUGHT_BREAKPOINT.getImageData() : PerlDebugImages.DESC_OBJS_CAUGHT_BREAKPOINT_DISABLED.getImageData();
            x = 0;
            y = 0;
            this.drawImage(data, x, y);
        }
        if ((flags & 0x100) != 0) {
            data = (flags & 0x20) != 0 ? PerlDebugImages.DESC_OBJS_UNCAUGHT_BREAKPOINT.getImageData() : PerlDebugImages.DESC_OBJS_UNCAUGHT_BREAKPOINT_DISABLED.getImageData();
            x = data.width;
            y = data.height;
            this.drawImage(data, x, y);
        }
        if ((flags & 0x200) != 0) {
            data = (flags & 0x20) != 0 ? PerlDebugImages.DESC_OBJS_SCOPED_BREAKPOINT.getImageData() : PerlDebugImages.DESC_OBJS_SCOPED_BREAKPOINT_DISABLED.getImageData();
            x = 0;
            y = this.getSize().y;
            this.drawImage(data, x, y -= data.height);
        }
        if ((flags & 0x40) != 0) {
            x = this.getSize().x;
            y = 0;
            data = (flags & 0x20) != 0 ? PerlDebugImages.DESC_OBJS_CONDITIONAL_BREAKPOINT.getImageData() : PerlDebugImages.DESC_OBJS_CONDITIONAL_BREAKPOINT_DISABLED.getImageData();
            this.drawImage(data, x -= data.width, y);
        } else {
            if ((flags & 8) != 0) {
                x = this.getSize().x;
                y = 0;
                data = (flags & 0x20) != 0 ? PerlDebugImages.DESC_OBJS_METHOD_BREAKPOINT_ENTRY.getImageData() : PerlDebugImages.DESC_OBJS_METHOD_BREAKPOINT_ENTRY_DISABLED.getImageData();
                this.drawImage(data, x -= data.width, y);
            }
            if ((flags & 0x10) != 0) {
                x = this.getSize().x;
                y = this.getSize().y;
                data = (flags & 0x20) != 0 ? PerlDebugImages.DESC_OBJS_METHOD_BREAKPOINT_EXIT.getImageData() : PerlDebugImages.DESC_OBJS_METHOD_BREAKPOINT_EXIT_DISABLED.getImageData();
                this.drawImage(data, x -= data.width, y -= data.height);
            }
        }
    }

    protected ImageDescriptor getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(ImageDescriptor baseImage) {
        this.fBaseImage = baseImage;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

