/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class BadSyntaxForRegularExpression
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    OpcodeStack stack = new OpcodeStack();

    public BadSyntaxForRegularExpression(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
    }

    public void visit(Method obj) {
    }

    public void visit(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visit(obj);
    }

    private void singleDotPatternWouldBeSilly(int stackDepth, boolean ignorePasswordMasking) {
        String replacementString;
        OpcodeStack.Item top;
        Object topValue;
        if (ignorePasswordMasking && stackDepth != 1) {
            throw new IllegalArgumentException("Password masking requires stack depth 1, but is " + stackDepth);
        }
        if (this.stack.getStackDepth() < stackDepth) {
            return;
        }
        OpcodeStack.Item it = this.stack.getStackItem(stackDepth);
        Object value = it.getConstant();
        if (value == null || !(value instanceof String)) {
            return;
        }
        String regex = (String)value;
        if (!regex.equals(".")) {
            return;
        }
        if (ignorePasswordMasking && (topValue = (top = this.stack.getStackItem(0)).getConstant()) instanceof String && ((replacementString = (String)topValue).length() == 1 && replacementString.toLowerCase().equals("x") || replacementString.equals("*") || replacementString.equals("\\*"))) {
            return;
        }
        this.bugReporter.reportBug(new BugInstance((Detector)this, "RE_POSSIBLE_UNINTENDED_PATTERN", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
    }

    private void sawRegExPattern(int stackDepth) {
        this.sawRegExPattern(stackDepth, 0);
    }

    private void sawRegExPattern(int stackDepth, int flags) {
        if (this.stack.getStackDepth() < stackDepth) {
            return;
        }
        OpcodeStack.Item it = this.stack.getStackItem(stackDepth);
        if (it.getSpecialKind() == 10 && (flags & 0x10) == 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "RE_CANT_USE_FILE_SEPARATOR_AS_REGULAR_EXPRESSION", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            return;
        }
        Object value = it.getConstant();
        if (value == null || !(value instanceof String)) {
            return;
        }
        String regex = (String)value;
        try {
            Pattern.compile(regex, flags);
        }
        catch (PatternSyntaxException e) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "RE_BAD_SYNTAX_FOR_REGULAR_EXPRESSION", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private int getIntValue(int stackDepth, int defaultValue) {
        if (this.stack.getStackDepth() < stackDepth) {
            return defaultValue;
        }
        OpcodeStack.Item it = this.stack.getStackItem(stackDepth);
        Object value = it.getConstant();
        if (value == null || !(value instanceof Integer)) {
            return defaultValue;
        }
        return ((Number)value).intValue();
    }

    public void sawOpcode(int seen) {
        this.stack.mergeJumps((DismantleBytecode)this);
        if (seen == 184 && this.getClassConstantOperand().equals("java/util/regex/Pattern") && this.getNameConstantOperand().equals("compile") && this.getSigConstantOperand().startsWith("(Ljava/lang/String;I)")) {
            this.sawRegExPattern(1, this.getIntValue(0, 0));
        } else if (seen == 184 && this.getClassConstantOperand().equals("java/util/regex/Pattern") && this.getNameConstantOperand().equals("compile") && this.getSigConstantOperand().startsWith("(Ljava/lang/String;)")) {
            this.sawRegExPattern(0);
        } else if (seen == 184 && this.getClassConstantOperand().equals("java/util/regex/Pattern") && this.getNameConstantOperand().equals("matches")) {
            this.sawRegExPattern(1);
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("replaceAll")) {
            this.sawRegExPattern(1);
            this.singleDotPatternWouldBeSilly(1, true);
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("replaceFirst")) {
            this.sawRegExPattern(1);
            this.singleDotPatternWouldBeSilly(1, false);
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("matches")) {
            this.sawRegExPattern(0);
            this.singleDotPatternWouldBeSilly(0, false);
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("split")) {
            this.sawRegExPattern(0);
            this.singleDotPatternWouldBeSilly(0, false);
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }
}

