/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.evaluation.EvaluationExpression;
import org.rubypeople.rdt.internal.debug.ui.evaluation.EvaluationExpressionReaderWriter;
import org.rubypeople.rdt.internal.debug.ui.preferences.EditEvaluationExpressionDialog;

public class EvaluationExpressionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fImportButton;
    private Button fExportButton;
    private Button fRemoveButton;
    private EditableExpressionModel fModel = new EditableExpressionModel();

    public EvaluationExpressionsPreferencePage() {
        this.setDescription(RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.description"));
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData);
        Table table = new Table(composite3, 67618);
        GridData gridData2 = new GridData(1808);
        gridData2.widthHint = this.convertWidthInCharsToPixels(3);
        gridData2.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)gridData2);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.column.name"));
        TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText(RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.column.description"));
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new EvaluationExpressionLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new EvaluationExpressionContentProvider());
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                EvaluationExpressionsPreferencePage.this.edit();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                EvaluationExpressionsPreferencePage.this.selectionChanged1();
            }
        });
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayoutData((Object)new GridData(2));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout);
        this.fAddButton = new Button(composite4, 8);
        this.fAddButton.setText(RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.new"));
        this.fAddButton.setLayoutData((Object)EvaluationExpressionsPreferencePage.getButtonGridData(this.fAddButton));
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EvaluationExpressionsPreferencePage.this.add();
            }
        });
        this.fEditButton = new Button(composite4, 8);
        this.fEditButton.setText(RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.edit"));
        this.fEditButton.setLayoutData((Object)EvaluationExpressionsPreferencePage.getButtonGridData(this.fEditButton));
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EvaluationExpressionsPreferencePage.this.edit();
            }
        });
        this.fRemoveButton = new Button(composite4, 8);
        this.fRemoveButton.setText(RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.remove"));
        this.fRemoveButton.setLayoutData((Object)EvaluationExpressionsPreferencePage.getButtonGridData(this.fRemoveButton));
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EvaluationExpressionsPreferencePage.this.remove();
            }
        });
        this.createSeparator(composite4);
        this.fImportButton = new Button(composite4, 8);
        this.fImportButton.setText(RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.import"));
        this.fImportButton.setLayoutData((Object)EvaluationExpressionsPreferencePage.getButtonGridData(this.fImportButton));
        this.fImportButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EvaluationExpressionsPreferencePage.this.importFile();
            }
        });
        this.fExportButton = new Button(composite4, 8);
        this.fExportButton.setText(RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.export"));
        this.fExportButton.setLayoutData((Object)EvaluationExpressionsPreferencePage.getButtonGridData(this.fExportButton));
        this.fExportButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EvaluationExpressionsPreferencePage.this.exportFile();
            }
        });
        this.fTableViewer.setInput((Object)this.fModel);
        this.updateButtons();
        EvaluationExpressionsPreferencePage.configureTableResizing(composite3, composite4, table, tableColumn, tableColumn2);
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private Label createSeparator(Composite composite) {
        Label label = new Label(composite, 0);
        label.setVisible(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.heightHint = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private static void configureTableResizing(final Composite composite, final Composite composite2, final Table table, final TableColumn tableColumn, final TableColumn tableColumn2) {
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Point point;
                Rectangle rectangle = composite.getClientArea();
                Point point2 = table.computeSize(-1, -1);
                int n = rectangle.width - 2 * table.getBorderWidth();
                if (point2.y > rectangle.height) {
                    point = table.getVerticalBar().getSize();
                    n -= point.x;
                }
                point = table.getSize();
                if (point.x > (n -= composite2.getSize().x)) {
                    tableColumn.setWidth(n / 3);
                    tableColumn2.setWidth(n - tableColumn.getWidth());
                    table.setSize(n, rectangle.height);
                } else {
                    table.setSize(n, rectangle.height);
                    tableColumn.setWidth(n / 3);
                    tableColumn2.setWidth(n - tableColumn.getWidth());
                }
            }
        });
    }

    private static GridData getButtonGridData(Button button) {
        GridData gridData = new GridData(768);
        return gridData;
    }

    private void selectionChanged1() {
        this.updateButtons();
    }

    protected void updateButtons() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        int n = iStructuredSelection.size();
        int n2 = this.fTableViewer.getTable().getItemCount();
        this.fEditButton.setEnabled(n == 1);
        this.fExportButton.setEnabled(n > 0);
        this.fRemoveButton.setEnabled(n > 0 && n <= n2);
    }

    private void add() {
        EvaluationExpression evaluationExpression = new EvaluationExpression("", "", "");
        String string = RdtDebugUiMessages.getString("EditEvaluationExpressionDialog.add");
        EditEvaluationExpressionDialog editEvaluationExpressionDialog = new EditEvaluationExpressionDialog(this.getShell(), string, evaluationExpression);
        if (editEvaluationExpressionDialog.open() == 0) {
            this.fModel.addExpression(evaluationExpression);
            this.fTableViewer.refresh();
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)evaluationExpression));
        }
    }

    private void edit() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        if (objectArray == null || objectArray.length != 1) {
            return;
        }
        EvaluationExpression evaluationExpression = (EvaluationExpression)iStructuredSelection.getFirstElement();
        this.edit(evaluationExpression);
    }

    private void edit(EvaluationExpression evaluationExpression) {
        String string = RdtDebugUiMessages.getString("EditEvaluationExpressionDialog.edit");
        EditEvaluationExpressionDialog editEvaluationExpressionDialog = new EditEvaluationExpressionDialog(this.getShell(), string, evaluationExpression);
        if (editEvaluationExpressionDialog.open() == 0) {
            this.fTableViewer.refresh();
        }
    }

    private void importFile() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText(RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.import.title"));
        fileDialog.setFilterExtensions(new String[]{RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.importexport.extension")});
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        new TemplateReaderWriter();
        File file = new File(string);
        if (file.exists()) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                this.fModel.importExpressions(bufferedInputStream);
            }
            catch (Exception exception) {
                RdtDebugUiPlugin.log(exception);
            }
        }
        this.fTableViewer.refresh();
    }

    private void exportFile() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        EvaluationExpression[] evaluationExpressionArray = new EvaluationExpression[objectArray.length];
        int n = 0;
        while (n != objectArray.length) {
            evaluationExpressionArray[n] = (EvaluationExpression)objectArray[n];
            ++n;
        }
        this.export(evaluationExpressionArray);
    }

    private void export(EvaluationExpression[] evaluationExpressionArray) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setText(RdtDebugUiMessages.getFormattedString("EvaluationExpressionsPreferencePage.export.title", new Integer(evaluationExpressionArray.length)));
        fileDialog.setFilterExtensions(new String[]{RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.importexport.extension")});
        fileDialog.setFileName(RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.export.filename"));
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (file.isHidden()) {
            String string2 = RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.export.error.title");
            String string3 = RdtDebugUiMessages.getFormattedString("EvaluationExpressionsPreferencePage.export.error.hidden", file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)string2, (String)string3);
            return;
        }
        if (file.exists() && !file.canWrite()) {
            String string4 = RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.export.error.title");
            String string5 = RdtDebugUiMessages.getFormattedString("EvaluationExpressionsPreferencePage.export.error.canNotWrite", file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)string4, (String)string5);
            return;
        }
        if (!file.exists() || this.confirmOverwrite(file)) {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                this.fModel.exportExpressions(evaluationExpressionArray, bufferedOutputStream);
            }
            catch (Exception exception) {}
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.export.exists.title"), (String)RdtDebugUiMessages.getFormattedString("EvaluationExpressionsPreferencePage.export.exists.message", file.getAbsolutePath()));
    }

    private void remove() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            this.fModel.removeExpression((EvaluationExpression)iterator.next());
        }
        this.fTableViewer.refresh();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.setTitle(RdtDebugUiMessages.getString("EvaluationExpressionsPreferencePage.title"));
        }
    }

    protected void performDefaults() {
        RdtDebugUiPlugin.getDefault().getPluginPreferences().setToDefault("org.rubypeople.rdt.debug.ui.evaluationExpressions");
        this.fModel.load();
        this.fTableViewer.refresh();
    }

    public boolean performOk() {
        this.fModel.save();
        return super.performOk();
    }

    public boolean performCancel() {
        this.fModel.load();
        return super.performCancel();
    }

    protected TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    private class EvaluationExpressionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        EvaluationExpressionLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            EvaluationExpression evaluationExpression = (EvaluationExpression)object;
            switch (n) {
                case 0: {
                    return evaluationExpression.getName();
                }
                case 1: {
                    return evaluationExpression.getDescription();
                }
            }
            return "";
        }
    }

    private class EvaluationExpressionContentProvider
    implements IStructuredContentProvider {
        private EditableExpressionModel model;

        EvaluationExpressionContentProvider() {
        }

        public Object[] getElements(Object object) {
            return this.model.getExpressionsAsArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.model = (EditableExpressionModel)object2;
        }

        public void dispose() {
            this.model = null;
        }
    }

    private class EditableExpressionModel {
        private ArrayList expressions;

        public EditableExpressionModel() {
            this.load();
        }

        public Collection getExpressions() {
            return this.expressions;
        }

        public Object[] getExpressionsAsArray() {
            return this.expressions.toArray(new EvaluationExpression[this.expressions.size()]);
        }

        public void addExpression(EvaluationExpression evaluationExpression) {
            this.expressions.add(evaluationExpression);
        }

        public void replaceExpression(EvaluationExpression evaluationExpression, EvaluationExpression evaluationExpression2) {
            int n = this.expressions.indexOf(evaluationExpression);
            if (n >= 0) {
                this.expressions.set(n, evaluationExpression2);
            }
        }

        public void removeExpression(EvaluationExpression evaluationExpression) {
            this.expressions.remove(evaluationExpression);
        }

        public void save() {
            StringWriter stringWriter = new StringWriter();
            try {
                new EvaluationExpressionReaderWriter().save((EvaluationExpression[])this.getExpressionsAsArray(), stringWriter);
                RdtDebugUiPlugin.getDefault().getPluginPreferences().setValue("org.rubypeople.rdt.debug.ui.evaluationExpressions", stringWriter.toString());
            }
            catch (IOException iOException) {
                RdtDebugUiPlugin.log(iOException);
            }
        }

        public void load() {
            EvaluationExpression[] evaluationExpressionArray = RdtDebugUiPlugin.getDefault().getEvaluationExpressionModel().getEvaluationExpressions();
            this.expressions = new ArrayList(evaluationExpressionArray.length);
            int n = 0;
            while (n < evaluationExpressionArray.length) {
                EvaluationExpression evaluationExpression = evaluationExpressionArray[n];
                this.expressions.add(evaluationExpression);
                ++n;
            }
        }

        public void importExpressions(InputStream inputStream) throws IOException, FileNotFoundException {
            EvaluationExpression[] evaluationExpressionArray = new EvaluationExpressionReaderWriter().read(inputStream, null);
            int n = 0;
            while (n < evaluationExpressionArray.length) {
                this.expressions.add(evaluationExpressionArray[n]);
                ++n;
            }
        }

        public void exportExpressions(EvaluationExpression[] evaluationExpressionArray, OutputStream outputStream) throws IOException {
            new EvaluationExpressionReaderWriter().save(evaluationExpressionArray, outputStream);
        }
    }
}

