/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PreferencesAdapter
implements IPreferenceStore {
    private ListenerList fListeners = new ListenerList();
    private PropertyChangeListener fListener = new PropertyChangeListener();
    private Preferences fPreferences;
    private boolean fSilent;

    public PreferencesAdapter() {
        this(new Preferences());
    }

    public PreferencesAdapter(Preferences preferences) {
        this.fPreferences = preferences;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.fListeners.size() == 0) {
            this.fPreferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fListener);
        }
        this.fListeners.add((Object)iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.fListeners.remove((Object)iPropertyChangeListener);
        if (this.fListeners.size() == 0) {
            this.fPreferences.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fListener);
        }
    }

    public boolean contains(String string) {
        return this.fPreferences.contains(string);
    }

    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        if (!this.fSilent) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
                ++n;
            }
        }
    }

    public boolean getBoolean(String string) {
        return this.fPreferences.getBoolean(string);
    }

    public boolean getDefaultBoolean(String string) {
        return this.fPreferences.getDefaultBoolean(string);
    }

    public double getDefaultDouble(String string) {
        return this.fPreferences.getDefaultDouble(string);
    }

    public float getDefaultFloat(String string) {
        return this.fPreferences.getDefaultFloat(string);
    }

    public int getDefaultInt(String string) {
        return this.fPreferences.getDefaultInt(string);
    }

    public long getDefaultLong(String string) {
        return this.fPreferences.getDefaultLong(string);
    }

    public String getDefaultString(String string) {
        return this.fPreferences.getDefaultString(string);
    }

    public double getDouble(String string) {
        return this.fPreferences.getDouble(string);
    }

    public float getFloat(String string) {
        return this.fPreferences.getFloat(string);
    }

    public int getInt(String string) {
        return this.fPreferences.getInt(string);
    }

    public long getLong(String string) {
        return this.fPreferences.getLong(string);
    }

    public String getString(String string) {
        return this.fPreferences.getString(string);
    }

    public boolean isDefault(String string) {
        return this.fPreferences.isDefault(string);
    }

    public boolean needsSaving() {
        return this.fPreferences.needsSaving();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putValue(String string, String string2) {
        try {
            this.fSilent = true;
            this.fPreferences.setValue(string, string2);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fSilent = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.fSilent = false;
            return;
        }
    }

    public void setDefault(String string, double d) {
        this.fPreferences.setDefault(string, d);
    }

    public void setDefault(String string, float f) {
        this.fPreferences.setDefault(string, f);
    }

    public void setDefault(String string, int n) {
        this.fPreferences.setDefault(string, n);
    }

    public void setDefault(String string, long l) {
        this.fPreferences.setDefault(string, l);
    }

    public void setDefault(String string, String string2) {
        this.fPreferences.setDefault(string, string2);
    }

    public void setDefault(String string, boolean bl) {
        this.fPreferences.setDefault(string, bl);
    }

    public void setToDefault(String string) {
        this.fPreferences.setToDefault(string);
    }

    public void setValue(String string, double d) {
        this.fPreferences.setValue(string, d);
    }

    public void setValue(String string, float f) {
        this.fPreferences.setValue(string, f);
    }

    public void setValue(String string, int n) {
        this.fPreferences.setValue(string, n);
    }

    public void setValue(String string, long l) {
        this.fPreferences.setValue(string, l);
    }

    public void setValue(String string, String string2) {
        this.fPreferences.setValue(string, string2);
    }

    public void setValue(String string, boolean bl) {
        this.fPreferences.setValue(string, bl);
    }

    private class PropertyChangeListener
    implements Preferences.IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
            PreferencesAdapter.this.firePropertyChangeEvent(propertyChangeEvent.getProperty(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }
}

