/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyModelStatusConstants;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.util.Util;

public class RubyModelStatus
extends Status
implements IRubyModelStatus,
IRubyModelStatusConstants,
IResourceStatus {
    protected IRubyElement[] elements = new IRubyElement[0];
    protected IPath path;
    protected String string;
    protected static final IStatus[] NO_CHILDREN = new IStatus[0];
    protected IStatus[] children = NO_CHILDREN;
    public static final IRubyModelStatus VERIFIED_OK = new RubyModelStatus(0, 0, Util.bind("status.OK"));

    public RubyModelStatus() {
        super(4, "org.rubypeople.rdt.core", 0, "RubyModelStatus", null);
    }

    public RubyModelStatus(int n) {
        super(4, "org.rubypeople.rdt.core", n, "RubyModelStatus", null);
        this.elements = RubyElement.NO_ELEMENTS;
    }

    public RubyModelStatus(int n, IRubyElement[] iRubyElementArray) {
        super(4, "org.rubypeople.rdt.core", n, "RubyModelStatus", null);
        this.elements = iRubyElementArray;
        this.path = null;
    }

    public RubyModelStatus(int n, String string) {
        this(4, n, string);
    }

    public RubyModelStatus(int n, int n2, String string) {
        super(n, "org.rubypeople.rdt.core", n2, "RubyModelStatus", null);
        this.elements = RubyElement.NO_ELEMENTS;
        this.path = null;
        this.string = string;
    }

    public RubyModelStatus(int n, Throwable throwable) {
        super(4, "org.rubypeople.rdt.core", n, "RubyModelStatus", throwable);
        this.elements = RubyElement.NO_ELEMENTS;
    }

    public RubyModelStatus(int n, IPath iPath) {
        super(4, "org.rubypeople.rdt.core", n, "RubyModelStatus", null);
        this.elements = RubyElement.NO_ELEMENTS;
        this.path = iPath;
    }

    public RubyModelStatus(int n, IRubyElement iRubyElement) {
        this(n, new IRubyElement[]{iRubyElement});
    }

    public RubyModelStatus(int n, IRubyElement iRubyElement, String string) {
        this(n, new IRubyElement[]{iRubyElement});
        this.string = string;
    }

    public RubyModelStatus(int n, IRubyElement iRubyElement, IPath iPath) {
        this(n, new IRubyElement[]{iRubyElement});
        this.path = iPath;
    }

    public RubyModelStatus(int n, IRubyElement iRubyElement, IPath iPath, String string) {
        this(n, new IRubyElement[]{iRubyElement});
        this.path = iPath;
        this.string = string;
    }

    public RubyModelStatus(CoreException coreException) {
        super(4, "org.rubypeople.rdt.core", 966, "RubyModelStatus", (Throwable)coreException);
        this.elements = RubyElement.NO_ELEMENTS;
    }

    protected int getBits() {
        int n = 1 << this.getCode() % 100 / 33;
        int n2 = 1 << this.getCode() / 100 + 3;
        return n | n2;
    }

    public IStatus[] getChildren() {
        return this.children;
    }

    public IRubyElement[] getElements() {
        return this.elements;
    }

    public String getMessage() {
        Throwable throwable = this.getException();
        if (throwable == null) {
            switch (this.getCode()) {
                case 966: {
                    return Util.bind("status.coreException");
                }
                case 990: {
                    return Util.bind("build.initializationError");
                }
                case 991: {
                    return Util.bind("build.serializationError");
                }
                case 973: {
                    return Util.bind("status.cannotUseDeviceOnPath", this.getPath().toString());
                }
                case 986: {
                    return Util.bind("status.JDOMError");
                }
                case 969: {
                    return Util.bind("element.doesNotExist", ((RubyElement)this.elements[0]).toStringWithAncestors());
                }
                case 1006: {
                    return Util.bind("element.notOnClasspath", ((RubyElement)this.elements[0]).toStringWithAncestors());
                }
                case 992: {
                    return Util.bind("status.evaluationError", this.string);
                }
                case 980: {
                    return Util.bind("status.indexOutOfBounds");
                }
                case 984: {
                    return Util.bind("status.invalidContents");
                }
                case 978: {
                    return Util.bind("status.invalidDestination", ((RubyElement)this.elements[0]).toStringWithAncestors());
                }
                case 967: {
                    StringBuffer stringBuffer = new StringBuffer(Util.bind("operation.notSupported"));
                    int n = 0;
                    while (n < this.elements.length) {
                        if (n > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(((RubyElement)this.elements[n]).toStringWithAncestors());
                        ++n;
                    }
                    return stringBuffer.toString();
                }
                case 983: {
                    return Util.bind("status.invalidName", this.string);
                }
                case 998: {
                    return Util.bind("status.invalidPackage", this.string);
                }
                case 979: {
                    if (this.string != null) {
                        return this.string;
                    }
                    return Util.bind("status.invalidPath", this.getPath() == null ? "null" : this.getPath().toString());
                }
                case 997: {
                    return Util.bind("status.invalidProject", this.string);
                }
                case 995: {
                    return Util.bind("status.invalidResource", this.string);
                }
                case 996: {
                    return Util.bind("status.invalidResourceType", this.string);
                }
                case 993: {
                    if (this.string != null) {
                        return Util.bind("status.invalidSibling", this.string);
                    }
                    return Util.bind("status.invalidSibling", ((RubyElement)this.elements[0]).toStringWithAncestors());
                }
                case 985: {
                    return Util.bind("status.IOException");
                }
                case 977: {
                    if (this.string != null) {
                        return this.string;
                    }
                    return Util.bind("status.nameCollision", "");
                }
                case 968: {
                    return Util.bind("operation.needElements");
                }
                case 982: {
                    return Util.bind("operation.needName");
                }
                case 970: {
                    return Util.bind("operation.needPath");
                }
                case 974: {
                    return Util.bind("operation.needString");
                }
                case 971: {
                    return Util.bind("operation.pathOutsideProject", this.string, ((RubyElement)this.elements[0]).toStringWithAncestors());
                }
                case 976: {
                    IRubyElement iRubyElement = this.elements[0];
                    String string = iRubyElement.getElementName();
                    return Util.bind("status.readOnly", string);
                }
                case 972: {
                    return Util.bind("operation.needAbsolutePath", this.getPath().toString());
                }
                case 987: {
                    return Util.bind("status.targetException");
                }
                case 981: {
                    return Util.bind("status.updateConflict");
                }
                case 999: {
                    return Util.bind("status.noLocalContents", this.getPath().toString());
                }
                case 965: {
                    IRubyProject iRubyProject = (IRubyProject)this.elements[0];
                    return Util.bind("classpath.unboundVariablePath", this.path.makeRelative().toString(), iRubyProject.getElementName());
                }
                case 1001: {
                    IRubyProject iRubyProject = (IRubyProject)this.elements[0];
                    return Util.bind("classpath.cycle", iRubyProject.getElementName());
                }
                case 1002: {
                    IRubyProject iRubyProject = (IRubyProject)this.elements[0];
                    String string = iRubyProject.getElementName();
                    IPath iPath = this.path;
                    if (this.path.segment(0).toString().equals(string)) {
                        iPath = this.path.removeFirstSegments(1);
                    }
                    return Util.bind("classpath.disabledInclusionExclusionPatterns", iPath.makeRelative().toString(), string);
                }
                case 1003: {
                    IRubyProject iRubyProject = (IRubyProject)this.elements[0];
                    String string = iRubyProject.getElementName();
                    IPath iPath = this.path;
                    if (this.path.segment(0).toString().equals(string)) {
                        iPath = this.path.removeFirstSegments(1);
                    }
                    return Util.bind("classpath.disabledMultipleOutputLocations", iPath.makeRelative().toString(), string);
                }
            }
            if (this.string != null) {
                return this.string;
            }
            return "";
        }
        String string = throwable.getMessage();
        if (string != null) {
            return string;
        }
        return throwable.toString();
    }

    public IPath getPath() {
        return this.path;
    }

    public int getSeverity() {
        if (this.children == NO_CHILDREN) {
            return super.getSeverity();
        }
        int n = -1;
        int n2 = 0;
        int n3 = this.children.length;
        while (n2 < n3) {
            int n4 = this.children[n2].getSeverity();
            if (n4 > n) {
                n = n4;
            }
            ++n2;
        }
        return n;
    }

    public String getString() {
        return this.string;
    }

    public boolean isDoesNotExist() {
        int n = this.getCode();
        return n == 969 || n == 1006;
    }

    public boolean isMultiStatus() {
        return this.children != NO_CHILDREN;
    }

    public boolean isOK() {
        return this.getCode() == 0;
    }

    public boolean matches(int n) {
        if (!this.isMultiStatus()) {
            return this.matches(this, n);
        }
        int n2 = 0;
        int n3 = this.children.length;
        while (n2 < n3) {
            if (this.matches((RubyModelStatus)this.children[n2], n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean matches(RubyModelStatus rubyModelStatus, int n) {
        int n2 = n & 7;
        int n3 = n & 0xFFFFFFF8;
        int n4 = rubyModelStatus.getBits();
        return !(n2 != 0 && (n4 & n2) == 0 || n3 != 0 && (n4 & n3) == 0);
    }

    public static IRubyModelStatus newMultiStatus(IRubyModelStatus[] iRubyModelStatusArray) {
        RubyModelStatus rubyModelStatus = new RubyModelStatus();
        rubyModelStatus.children = iRubyModelStatusArray;
        return rubyModelStatus;
    }

    public String toString() {
        if (this == VERIFIED_OK) {
            return "RubyModelStatus[OK]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Ruby Model Status [");
        stringBuffer.append(this.getMessage());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

