/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.tigris.subversion.subclipse.core.IResourceStateChangeListener;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class SVNMarkerListener
implements IResourceStateChangeListener {
    public void resourceSyncInfoChanged(IResource[] changedResources) {
        int i = 0;
        while (i < changedResources.length) {
            try {
                if (changedResources[i].exists()) {
                    changedResources[i].deleteMarkers("org.tigris.subversion.subclipse.ui.conflictMarker", true, 0);
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)changedResources[i]);
                    LocalResourceStatus status = svnResource.getStatus();
                    if (status.isTextConflicted()) {
                        try {
                            IMarker marker = changedResources[i].createMarker("org.tigris.subversion.subclipse.ui.conflictMarker");
                            marker.setAttribute("message", (Object)Policy.bind("SVNConflicts"));
                            marker.setAttribute("severity", 1);
                        }
                        catch (Exception e) {
                            SVNUIPlugin.log(e.getMessage());
                        }
                    }
                }
            }
            catch (Exception e) {
                SVNUIPlugin.log(e.getMessage());
            }
            ++i;
        }
    }

    public void resourceModified(IResource[] changedResources) {
    }

    public void projectConfigured(IProject project) {
    }

    public void projectDeconfigured(IProject project) {
    }
}

