/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.authentication;

import java.util.Properties;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class SSLClientCertificate
extends TrayDialog {
    private String realm;
    private String certificate;
    private String passphrase;
    private boolean save;
    private boolean maySave;
    private Combo keyFileCombo;
    private Text passphraseText;
    private Button browseButton;
    private Button saveButton;
    private Button okButton;
    private String[] keyFiles = new String[0];
    private static int WIDTH = 300;

    public SSLClientCertificate(Shell parentShell, String realm, boolean maySave) {
        super(parentShell);
        this.realm = realm;
        this.maySave = maySave;
        this.keyFiles = SVNUIPlugin.getPlugin().getRepositoryManager().getKeyFilesManager().getPreviousKeyFiles();
    }

    protected Control createDialogArea(Composite parent) {
        Composite rtnGroup = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Policy.bind("SSLPromptDialog.title"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        rtnGroup.setLayout((Layout)layout);
        rtnGroup.setLayoutData((Object)new GridData(32));
        Label realmLabel = new Label(rtnGroup, 0);
        realmLabel.setText(Policy.bind("PasswordPromptDialog.repository"));
        Text realmText = new Text(rtnGroup, 2048);
        GridData gd = new GridData();
        gd.widthHint = WIDTH;
        realmText.setLayoutData((Object)gd);
        realmText.setEditable(false);
        realmText.setText(this.realm);
        Label keyFileLabel = new Label(rtnGroup, 0);
        keyFileLabel.setText(Policy.bind("SSLPromptDialog.certificate"));
        Composite keyFileGroup = new Composite(rtnGroup, 0);
        GridLayout keyFileLayout = new GridLayout();
        keyFileLayout.numColumns = 2;
        keyFileLayout.marginWidth = 0;
        keyFileLayout.marginHeight = 0;
        keyFileGroup.setLayout((Layout)keyFileLayout);
        gd = new GridData(768);
        keyFileGroup.setLayoutData((Object)gd);
        this.keyFileCombo = new Combo(keyFileGroup, 2048);
        gd = new GridData();
        gd.widthHint = WIDTH;
        this.keyFileCombo.setLayoutData((Object)gd);
        this.keyFileCombo.setEnabled(true);
        if (this.keyFiles != null && this.keyFiles.length > 0) {
            int i = 0;
            while (i < this.keyFiles.length) {
                this.keyFileCombo.add(this.keyFiles[i]);
                ++i;
            }
            this.keyFileCombo.setText(this.keyFiles[0]);
        }
        this.browseButton = new Button(keyFileGroup, 8);
        this.browseButton.setText(Policy.bind("SSHPromptDialog.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String returnFile;
                Properties properties = System.getProperties();
                String home = (String)properties.get("user.home");
                FileDialog fileDialog = new FileDialog(SSLClientCertificate.this.getShell(), 4096);
                if (home != null) {
                    fileDialog.setFilterPath(home);
                }
                if ((returnFile = fileDialog.open()) != null) {
                    SSLClientCertificate.this.keyFileCombo.setText(returnFile);
                }
            }
        });
        this.browseButton.setEnabled(true);
        Label passphraseLabel = new Label(rtnGroup, 0);
        passphraseLabel.setText(Policy.bind("SSHPromptDialog.passphrase"));
        this.passphraseText = new Text(rtnGroup, 2048);
        gd = new GridData();
        gd.widthHint = WIDTH;
        this.passphraseText.setEchoChar('*');
        this.passphraseText.setLayoutData((Object)gd);
        this.passphraseText.setEnabled(true);
        if (this.maySave) {
            this.saveButton = new Button(rtnGroup, 32);
            this.saveButton.setText(Policy.bind("SSHPromptDialog.save"));
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.saveButton.setLayoutData((Object)gd);
        }
        return rtnGroup;
    }

    public Button createButton(Composite parent, int id, String label, boolean isDefault) {
        Button button = super.createButton(parent, id, label, isDefault);
        if (id == 0) {
            this.okButton = button;
            this.okButton.setEnabled(true);
        }
        return button;
    }

    protected void okPressed() {
        this.certificate = this.keyFileCombo.getText().trim();
        this.passphrase = this.passphraseText.getText().trim();
        if (this.maySave) {
            this.save = this.saveButton.getSelection();
        }
        if (this.certificate.length() > 0) {
            SVNUIPlugin.getPlugin().getRepositoryManager().getKeyFilesManager().addKeyFile(this.certificate);
        }
        super.okPressed();
    }

    public boolean isSave() {
        return this.save;
    }

    public String getKeyFile() {
        return this.certificate;
    }

    public String getPassphrase() {
        return this.passphrase;
    }
}

