/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.history;

import java.util.ArrayList;
import java.util.List;
import org.tigris.subversion.subclipse.core.history.LogEntryChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class HistoryFolder {
    private final String path;
    private final char action;
    private final String copySrcPath;
    private final SVNRevision.Number copySrcRevision;
    private final List children = new ArrayList();

    public HistoryFolder(String path) {
        this.path = path;
        this.action = (char)63;
        this.copySrcPath = null;
        this.copySrcRevision = null;
    }

    public HistoryFolder(LogEntryChangePath changePath) {
        this.path = changePath.getPath();
        this.action = changePath.getAction();
        this.copySrcPath = changePath.getCopySrcPath();
        this.copySrcRevision = changePath.getCopySrcRevision();
    }

    public String getPath() {
        return this.path;
    }

    public char getAction() {
        return this.action;
    }

    public String getCopySrcPath() {
        return this.copySrcPath;
    }

    public SVNRevision.Number getCopySrcRevision() {
        return this.copySrcRevision;
    }

    public void add(LogEntryChangePath changePath) {
        this.children.add(changePath);
    }

    public Object[] getChildren() {
        return this.children.toArray();
    }

    public int getChildCount() {
        return this.children.size();
    }
}

