/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeParticipant;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class CommitOperation
extends SVNOperation {
    private IResource[] resourcesToAdd;
    private IResource[] resourcesToDelete;
    private IResource[] resourcesToCommit;
    private String commitComment;
    private boolean keepLocks;
    private ISVNClientAdapter svnClient;
    private ISynchronizePageConfiguration configuration;

    public CommitOperation(IWorkbenchPart part, IResource[] selectedResources, IResource[] resourcesToAdd, IResource[] resourcesToDelete, IResource[] resourcesToCommit, String commitComment, boolean keepLocks) {
        super(part);
        this.resourcesToAdd = resourcesToAdd;
        this.resourcesToDelete = resourcesToDelete;
        this.resourcesToCommit = resourcesToCommit;
        this.commitComment = commitComment;
        this.keepLocks = keepLocks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        try {
            try {
                IResource[] providerResources;
                List list;
                SVNTeamProvider provider;
                Iterator iterator;
                Set keySet;
                Map table;
                this.svnClient = SVNProviderPlugin.getPlugin().getSVNClientManager().createSVNClient();
                if (this.resourcesToAdd.length > 0) {
                    table = this.getProviderMapping(this.resourcesToAdd);
                    if (table.get(null) != null) {
                        throw new SVNException(Policy.bind("RepositoryManager.addErrorNotAssociated"));
                    }
                    keySet = table.keySet();
                    iterator = keySet.iterator();
                    while (iterator.hasNext()) {
                        provider = (SVNTeamProvider)iterator.next();
                        list = (List)table.get(provider);
                        providerResources = list.toArray(new IResource[list.size()]);
                        provider.add(providerResources, 0, null);
                    }
                }
                if (this.resourcesToDelete.length > 0) {
                    ISVNClientAdapter svnDeleteClient = null;
                    Map table2 = this.getProviderMapping(this.resourcesToDelete);
                    if (table2.get(null) != null) {
                        throw new SVNException(Policy.bind("RepositoryManager.addErrorNotAssociated"));
                    }
                    Set keySet2 = table2.keySet();
                    Iterator iterator2 = keySet2.iterator();
                    while (iterator2.hasNext()) {
                        SVNTeamProvider provider2 = (SVNTeamProvider)iterator2.next();
                        List list2 = (List)table2.get(provider2);
                        IResource[] providerResources2 = list2.toArray(new IResource[list2.size()]);
                        File[] files = new File[providerResources2.length];
                        int i = 0;
                        while (i < providerResources2.length) {
                            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)providerResources2[i]);
                            if (svnDeleteClient == null) {
                                svnDeleteClient = svnResource.getRepository().getSVNClient();
                            }
                            files[i] = svnResource.getFile();
                            ++i;
                        }
                        try {
                            svnDeleteClient.remove(files, true);
                        }
                        catch (SVNClientException e) {
                            throw new TeamException(e.getMessage());
                        }
                    }
                }
                table = this.getProviderMapping(this.resourcesToCommit);
                keySet = table.keySet();
                iterator = keySet.iterator();
                monitor.beginTask(null, 100 * keySet.size());
                while (iterator.hasNext()) {
                    provider = (SVNTeamProvider)iterator.next();
                    list = (List)table.get(provider);
                    providerResources = list.toArray(new IResource[list.size()]);
                    provider.checkin(providerResources, this.commitComment, this.keepLocks, this.getDepth(providerResources), Policy.subMonitorFor(monitor, 100));
                }
            }
            catch (TeamException e) {
                throw SVNException.wrapException((TeamException)e);
            }
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            monitor.done();
            if (this.configuration == null) throw throwable;
            SVNSynchronizeParticipant sync = (SVNSynchronizeParticipant)this.configuration.getParticipant();
            IResource[] roots = sync.getResources();
            if (roots.length > 1) {
                roots = this.reduceRoots(roots);
            }
            sync.refresh(roots, monitor);
            throw throwable;
        }
        monitor.done();
        if (this.configuration == null) return;
        SVNSynchronizeParticipant sync = (SVNSynchronizeParticipant)this.configuration.getParticipant();
        IResource[] roots = sync.getResources();
        if (roots.length > 1) {
            roots = this.reduceRoots(roots);
        }
        sync.refresh(roots, monitor);
    }

    private int getDepth(IResource[] resources) {
        int depth = 2;
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getType() != 1) {
                ISVNLocalResource svnResource;
                block6: {
                    svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i]);
                    try {
                        if (!svnResource.getStatus().isDeleted()) break block6;
                        return 2;
                    }
                    catch (SVNException sVNException) {}
                }
                if (svnResource.getStatus().isPropModified()) {
                    depth = 0;
                }
            }
            ++i;
        }
        return depth;
    }

    protected String getTaskName() {
        return Policy.bind("CommitOperation.taskName");
    }

    private Map getProviderMapping(IResource[] resources) {
        RepositoryProvider provider = null;
        HashMap<RepositoryProvider, ArrayList<IResource>> result = new HashMap<RepositoryProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            ArrayList<IResource> list;
            if (provider == null || !this.svnClient.canCommitAcrossWC()) {
                provider = RepositoryProvider.getProvider((IProject)resources[i].getProject(), (String)SVNProviderPlugin.getTypeId());
            }
            if ((list = (ArrayList<IResource>)result.get(provider)) == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    public void setConfiguration(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
    }

    private IResource[] reduceRoots(IResource[] roots) {
        ArrayList<IResource> rootArray = new ArrayList<IResource>();
        int i = 0;
        while (i < roots.length) {
            int j = 0;
            while (j < this.resourcesToCommit.length) {
                if (this.resourcesToCommit[j].getFullPath().toString().startsWith(roots[i].getFullPath().toString())) {
                    rootArray.add(roots[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        roots = new IResource[rootArray.size()];
        rootArray.toArray(roots);
        return roots;
    }
}

