/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.svnproperties;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.properties.SVNPropertyDefinition;
import org.tigris.subversion.subclipse.core.properties.SVNPropertyManager;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class SetSvnPropertyDialog
extends TrayDialog {
    private ISVNProperty property;
    private ISVNLocalResource svnResource;
    private Combo propertyNameText;
    private Text propertyValueText;
    private Text fileText;
    private Button textRadio;
    private Button fileRadio;
    private Button browseButton;
    private Label statusMessageLabel;
    private Button recurseCheckbox;
    private String propertyName;
    private String propertyValue;
    private File propertyFile;
    private boolean recurse;
    private ArrayList allPropertyTypes = new ArrayList();
    private SVNPropertyDefinition[] propertyTypes;
    private ArrayList propertyNames;
    private int prop;

    public SetSvnPropertyDialog(Shell parentShell, ISVNLocalResource svnResource) {
        this(parentShell, svnResource, null);
    }

    public SetSvnPropertyDialog(Shell parentShell, ISVNLocalResource svnResource, ISVNProperty property) {
        super(parentShell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        this.property = property;
        this.svnResource = svnResource;
    }

    private boolean isNewProperty() {
        return this.property == null;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateEnablements();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Listener updateEnablementsListener = new Listener(){

            public void handleEvent(Event event) {
                SetSvnPropertyDialog.this.updateEnablements();
            }
        };
        Listener validateListener = new Listener(){

            public void handleEvent(Event event) {
                SetSvnPropertyDialog.this.validate();
            }
        };
        Listener updatePropertiesListener = new Listener(){

            public void handleEvent(Event event) {
                SetSvnPropertyDialog.this.validate();
            }
        };
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        area.setLayout((Layout)layout);
        Composite composite = new Composite(area, 0);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 16384);
        label.setText(Policy.bind("SetSvnPropertyDialog.propertyName"));
        this.propertyNameText = new Combo(composite, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 400;
        gridData.grabExcessHorizontalSpace = true;
        this.propertyNameText.setLayoutData((Object)gridData);
        if (this.property != null) {
            this.propertyNameText.setText(this.property.getName());
            this.propertyNameText.setEnabled(false);
        }
        this.getPropertyTypes();
        this.propertyNameText.addListener(24, validateListener);
        this.propertyNameText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                SetSvnPropertyDialog.this.getProperty();
            }
        });
        this.propertyNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                SetSvnPropertyDialog.this.getProperty();
            }
        });
        Group group = new Group(area, 0);
        group.setText(Policy.bind("SetSvnPropertyDialog.propertyContent"));
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gridData);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        this.textRadio = new Button((Composite)group, 16);
        this.textRadio.setText(Policy.bind("SetSvnPropertyDialog.enterTextProperty"));
        this.textRadio.addListener(13, updateEnablementsListener);
        this.textRadio.setSelection(true);
        this.propertyValueText = new Text((Composite)group, 2818);
        gridData = new GridData(1808);
        gridData.heightHint = 100;
        gridData.widthHint = 400;
        gridData.horizontalIndent = 30;
        gridData.grabExcessHorizontalSpace = true;
        this.propertyValueText.setLayoutData((Object)gridData);
        this.fileRadio = new Button((Composite)group, 16);
        this.fileRadio.setText(Policy.bind("SetSvnPropertyDialog.useFile"));
        this.fileRadio.addListener(13, updateEnablementsListener);
        composite = new Composite((Composite)group, 0);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fileText = new Text(composite, 2052);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 30;
        this.fileText.setLayoutData((Object)gridData);
        this.fileText.setEditable(false);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(Policy.bind("SetSvnPropertyDialog.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(SetSvnPropertyDialog.this.getShell(), 4096);
                String res = fileDialog.open();
                if (res != null) {
                    SetSvnPropertyDialog.this.fileText.setText(res);
                    SetSvnPropertyDialog.this.validate();
                }
            }
        });
        this.recurseCheckbox = new Button(area, 32);
        gridData = new GridData(768);
        this.recurseCheckbox.setLayoutData((Object)gridData);
        this.recurseCheckbox.setText(Policy.bind("SetSvnPropertyDialog.setPropertyRecursively"));
        this.recurseCheckbox.setSelection(false);
        if (!this.svnResource.isFolder()) {
            this.recurseCheckbox.setEnabled(false);
        }
        this.recurseCheckbox.addListener(13, updatePropertiesListener);
        this.statusMessageLabel = new Label(area, 16384);
        this.statusMessageLabel.setText("");
        GridData data = new GridData(784);
        this.statusMessageLabel.setLayoutData((Object)data);
        this.statusMessageLabel.setFont(parent.getFont());
        if (this.property != null) {
            this.propertyValueText.setText(this.property.getValue());
            this.getProperty();
        }
        this.propertyValueText.addListener(24, updatePropertiesListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)area, "org.tigris.subversion.subclipse.ui.set_svn_property_dialog_context");
        return area;
    }

    private void getPropertyTypes() {
        if (this.svnResource.isFolder()) {
            SVNPropertyDefinition[] allProperties = SVNPropertyManager.getInstance().getPropertyTypes();
            int i = 0;
            while (i < allProperties.length) {
                this.allPropertyTypes.add(allProperties[i]);
                ++i;
            }
            this.propertyTypes = SVNPropertyManager.getInstance().getFolderPropertyTypes();
        } else {
            this.propertyTypes = SVNPropertyManager.getInstance().getFilePropertyTypes();
        }
        this.propertyNames = new ArrayList();
        int i = 0;
        while (i < this.propertyTypes.length) {
            this.propertyNameText.add(this.propertyTypes[i].getName());
            this.propertyNames.add(this.propertyTypes[i].getName());
            ++i;
        }
    }

    private void updateEnablements() {
        if (this.textRadio.getSelection()) {
            this.browseButton.setEnabled(false);
            this.fileText.setEnabled(false);
            this.propertyValueText.setEnabled(true);
        } else {
            this.browseButton.setEnabled(true);
            this.fileText.setEnabled(true);
            this.propertyValueText.setEnabled(false);
        }
        this.validate();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Policy.bind("SetSvnPropertyDialog.shellText"));
    }

    private void updateProperties() {
        this.propertyName = this.propertyNameText.getText();
        if (this.textRadio.getSelection()) {
            this.propertyFile = null;
            this.propertyValue = this.propertyValueText.getText();
        } else {
            this.propertyFile = new File(this.fileText.getText());
            this.propertyValue = null;
        }
        this.recurse = this.recurseCheckbox.getSelection();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validate() {
        SVNPropertyDefinition checkDefinition;
        int index;
        block20: {
            this.updateProperties();
            if (this.propertyName.equals("")) {
                this.setError("");
                return;
            }
            if (!this.isNewProperty()) break block20;
            try {
                try {
                    SVNUIPlugin.getPlugin().disableConsoleListener();
                    if (this.svnResource.getSvnProperty(this.getPropertyName()) != null) {
                        this.setError(Policy.bind("SetSvnPropertyDialog.anotherPropertyHasSameName"));
                        Object var1_1 = null;
                        SVNUIPlugin.getPlugin().enableConsoleListener();
                        return;
                    }
                }
                catch (SVNException sVNException) {}
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                SVNUIPlugin.getPlugin().enableConsoleListener();
                throw throwable;
            }
            {
                Object var1_3 = null;
                SVNUIPlugin.getPlugin().enableConsoleListener();
            }
        }
        if (this.textRadio.getSelection() && this.prop != -1) {
            if (this.propertyTypes[this.prop].isBoolean() && !this.propertyValue.equals("true") && !this.propertyValue.equals("false")) {
                this.setError(Policy.bind("SetSvnPropertyDialog.boolean"));
                return;
            }
            if (this.propertyTypes[this.prop].isNumber()) {
                try {
                    Integer.parseInt(this.propertyValue);
                }
                catch (Exception exception) {
                    this.setError(Policy.bind("SetSvnPropertyDialog.number"));
                    return;
                }
            }
            if (this.propertyTypes[this.prop].isUrl()) {
                try {
                    new URL(this.propertyValue);
                }
                catch (Exception exception) {
                    this.setError(Policy.bind("SetSvnPropertyDialog.url"));
                    return;
                }
            }
        }
        if (this.svnResource.isFolder() && !this.recurseCheckbox.getSelection() && this.prop == -1 && (index = this.allPropertyTypes.indexOf(checkDefinition = new SVNPropertyDefinition(this.propertyName, null))) != -1) {
            this.setError(Policy.bind("SetSvnPropertyDialog.recurseRequired"));
            return;
        }
        if (this.propertyFile != null) {
            if (this.fileText.getText().equals("")) {
                this.setError("");
            } else if (!this.getPropertyFile().exists()) {
                this.setError(Policy.bind("SetSvnPropertyDialog.fileDoesNotExist"));
                return;
            }
        }
        this.setError(null);
    }

    private void setError(String text) {
        if (text == null) {
            this.statusMessageLabel.setText("");
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(true);
            }
        } else {
            this.statusMessageLabel.setText(text);
            this.statusMessageLabel.setForeground(JFaceColors.getErrorText((Display)this.getShell().getDisplay()));
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
        }
    }

    private void getProperty() {
        this.prop = this.propertyNames.indexOf(this.propertyNameText.getText());
        if (this.prop != -1) {
            this.propertyNameText.setToolTipText(this.propertyTypes[this.prop].getDescription());
            this.recurseCheckbox.setEnabled(this.svnResource.isFolder() && this.propertyTypes[this.prop].isAllowRecurse());
            if (!this.recurseCheckbox.getEnabled()) {
                this.recurseCheckbox.setSelection(false);
            }
        } else {
            this.recurseCheckbox.setEnabled(this.svnResource.isFolder());
        }
        this.validate();
    }
}

