/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.util;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Table;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class TableSetter {
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();

    public void saveColumnWidths(Table table, String qualifier) {
        int i = 0;
        while (i < table.getColumnCount()) {
            this.settings.put(String.valueOf(qualifier) + ".column" + i, table.getColumn(i).getWidth());
            ++i;
        }
    }

    public void saveColumnWeights(Table table, String qualifier) {
        int i = 0;
        while (i < table.getColumnCount()) {
            this.settings.put(String.valueOf(qualifier) + ".columnWeight" + i, this.getColumnWeight(table, i));
            ++i;
        }
    }

    public float getColumnWeight(Table table, int column) {
        int tableWidth = table.getSize().x;
        int columnWidth = table.getColumn(column).getWidth();
        if (tableWidth > columnWidth) {
            return (float)columnWidth / (float)tableWidth;
        }
        return 0.33333334f;
    }

    public void saveSorterColumn(String qualifier, int sortColumn) {
        this.settings.put(String.valueOf(qualifier) + ".sortColumn", sortColumn);
    }

    public void saveSorterReversed(String qualifier, boolean sorterReversed) {
        this.settings.put(String.valueOf(qualifier) + ".sortReversed", sorterReversed);
    }

    public int[] getColumnWidths(String qualifier, int columnCount) {
        int[] widths = new int[columnCount];
        int i = 0;
        while (i < columnCount) {
            try {
                widths[i] = this.settings.getInt(String.valueOf(qualifier) + ".column" + i);
            }
            catch (NumberFormatException numberFormatException) {
                widths[i] = 150;
            }
            ++i;
        }
        return widths;
    }

    public float[] getColumnWeights(String qualifier, int columnCount) {
        float[] weights = new float[columnCount];
        int i = 0;
        while (i < columnCount) {
            try {
                weights[i] = this.settings.getFloat(String.valueOf(qualifier) + ".columnWeight" + i);
            }
            catch (NumberFormatException numberFormatException) {
                weights[i] = 0.33333334f;
            }
            ++i;
        }
        return weights;
    }

    public int getSorterColumn(String qualifier) {
        int sortColumn;
        try {
            sortColumn = this.settings.getInt(String.valueOf(qualifier) + ".sortColumn");
        }
        catch (NumberFormatException numberFormatException) {
            sortColumn = -1;
        }
        return sortColumn;
    }

    public boolean getSorterReversed(String qualifier) {
        return this.settings.getBoolean(String.valueOf(qualifier) + ".sortReversed");
    }
}

