/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalFile;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNStatus;
import org.tigris.subversion.subclipse.core.client.IConsoleListener;
import org.tigris.subversion.subclipse.core.client.PeekStatusCommand;
import org.tigris.subversion.subclipse.core.commands.CheckoutCommand;
import org.tigris.subversion.subclipse.core.commands.ShareProjectCommand;
import org.tigris.subversion.subclipse.core.resources.LocalFile;
import org.tigris.subversion.subclipse.core.resources.LocalFolder;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.ResourceStatus;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SVNWorkspaceRoot {
    private ISVNLocalFolder localRoot;
    private String url;
    private static boolean nullResourceLogged = false;

    public SVNWorkspaceRoot(IContainer resource) {
        this.localRoot = SVNWorkspaceRoot.getSVNFolderFor(resource);
    }

    public static IProject getProject(ISVNRemoteFolder folder, IProgressMonitor monitor) {
        String name = folder.getName();
        try {
            ISVNResource[] children = folder.members(monitor, 1);
            int k = 0;
            while (k < children.length) {
                ISVNResource resource = children[k];
                if (".project".equals(resource.getName())) {
                    RemoteFile dotProject = (RemoteFile)folder.getRepository().getRemoteFile(folder.getUrl().appendPath(".project"));
                    InputStream is = dotProject.getStorage(monitor).getContents();
                    DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = db.parse(is);
                    is.close();
                    NodeList nl = doc.getDocumentElement().getChildNodes();
                    int j = 0;
                    while (j < nl.getLength()) {
                        Node grandChild;
                        Node child = nl.item(j);
                        if (child instanceof Element && "name".equals(child.getNodeName()) && (grandChild = child.getFirstChild()) instanceof Text) {
                            name = ((Text)grandChild).getData();
                        }
                        ++j;
                    }
                }
                ++k;
            }
        }
        catch (Exception exception) {}
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        return project;
    }

    public static void checkout(ISVNRemoteFolder[] resources, IProject[] projects, IProgressMonitor monitor) throws SVNException {
        CheckoutCommand command = new CheckoutCommand(resources, projects);
        command.run(monitor);
    }

    public static void shareProject(ISVNRepositoryLocation location, IProject project, String remoteDirName, String comment, IProgressMonitor monitor) throws TeamException {
        ShareProjectCommand command = new ShareProjectCommand(location, project, remoteDirName);
        command.setComment(comment);
        command.run(monitor);
    }

    public static void setSharing(IProject project, IProgressMonitor monitor) throws TeamException {
        LocalResourceStatus status = SVNWorkspaceRoot.peekResourceStatusFor((IResource)project);
        if (!status.hasRemote()) {
            throw new SVNException((IStatus)new SVNStatus(4, Policy.bind("SVNProvider.infoMismatch", project.getName())));
        }
        String repositoryURL = null;
        ISVNClientAdapter client = SVNProviderPlugin.getPlugin().createSVNClient();
        try {
            ISVNInfo info = client.getInfoFromWorkingCopy(project.getLocation().toFile());
            if (info.getRepository() != null) {
                repositoryURL = info.getRepository().toString();
            }
        }
        catch (SVNClientException sVNClientException) {}
        if (repositoryURL == null) {
            repositoryURL = status.getUrlString();
        }
        SVNProviderPlugin.getPlugin().getRepositories().getRepository(repositoryURL);
        RepositoryProvider.map((IProject)project, (String)SVNProviderPlugin.getTypeId());
    }

    public static IPath pathForLocation(IPath location) {
        if (Platform.getLocation().equals((Object)location)) {
            return Path.ROOT;
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IPath projectLocation = project.getLocation();
            if (projectLocation != null && projectLocation.isPrefixOf(location)) {
                int segmentsToRemove = projectLocation.segmentCount();
                return project.getFullPath().append(location.removeFirstSegments(segmentsToRemove));
            }
            ++i;
        }
        return null;
    }

    public static ISVNLocalFolder getSVNFolderFor(IContainer resource) {
        return new LocalFolder(resource);
    }

    public static ISVNLocalFile getSVNFileFor(IFile resource) {
        return new LocalFile(resource);
    }

    public static ISVNLocalResource getSVNResourceFor(IResource resource) {
        if (resource.getType() == 1) {
            return SVNWorkspaceRoot.getSVNFileFor((IFile)resource);
        }
        return SVNWorkspaceRoot.getSVNFolderFor((IContainer)resource);
    }

    public static ISVNLocalResource[] getSVNResourcesFor(IResource[] resources) {
        ISVNLocalResource[] svnResources = new ISVNLocalResource[resources.length];
        int i = 0;
        while (i < resources.length) {
            svnResources[i] = SVNWorkspaceRoot.getSVNResourceFor(resources[i]);
            ++i;
        }
        return svnResources;
    }

    public static ISVNRemoteResource getBaseResourceFor(IResource resource) throws SVNException {
        ISVNLocalResource managed = SVNWorkspaceRoot.getSVNResourceFor(resource);
        return managed.getBaseResource();
    }

    public static ISVNRemoteResource getLatestResourceFor(IResource resource) throws SVNException {
        ISVNLocalResource managed = SVNWorkspaceRoot.getSVNResourceFor(resource);
        return managed.getLatestRemoteResource();
    }

    public static LocalResourceStatus peekResourceStatusFor(IResource resource) throws SVNException {
        PeekStatusCommand command = new PeekStatusCommand(resource);
        command.execute(SVNProviderPlugin.getPlugin().createSVNClient());
        return command.getLocalResourceStatus();
    }

    public static LocalResourceStatus peekResourceStatusFor(IPath path) throws SVNException {
        PeekStatusCommand command = new PeekStatusCommand(path);
        command.execute(SVNProviderPlugin.getPlugin().createSVNClient());
        return command.getLocalResourceStatus();
    }

    public ISVNRepositoryLocation getRepository() throws SVNException {
        if (this.url == null) {
            LocalResourceStatus status = this.localRoot.getStatus();
            if (!status.isManaged()) {
                throw new SVNException(Policy.bind("SVNWorkspaceRoot.notSVNFolder", this.localRoot.getName()));
            }
            this.url = status.getUrlString();
        }
        return SVNProviderPlugin.getPlugin().getRepository(this.url);
    }

    public ISVNLocalFolder getLocalRoot() {
        return this.localRoot;
    }

    public static boolean isLinkedResource(IResource resource) {
        if (resource.isLinked()) {
            return true;
        }
        if (resource.getType() == 4 || resource.getType() == 8) {
            return false;
        }
        String linkedParentName = resource.getProjectRelativePath().segment(0);
        IFolder linkedParent = resource.getProject().getFolder(linkedParentName);
        return linkedParent.isLinked();
    }

    public static boolean isSvnMetaResource(IResource resource) {
        if (resource.getType() == 2 && SVNProviderPlugin.getPlugin().isAdminDirectory(resource.getName())) {
            return true;
        }
        IContainer parent = resource.getParent();
        if (parent == null) {
            return false;
        }
        return SVNWorkspaceRoot.isSvnMetaResource((IResource)parent);
    }

    public static int getResourceType(String absolutePath) {
        return SVNWorkspaceRoot.getResourceType(SVNWorkspaceRoot.pathForLocation((IPath)new Path(absolutePath)));
    }

    public static int getResourceType(IPath aResourcePath) {
        if (aResourcePath == null) {
            return 0;
        }
        IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(aResourcePath);
        return r == null ? 0 : r.getType();
    }

    public static IResource getResourceFor(ResourceStatus status) throws SVNException {
        if (status.getFile() == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath resourcePath = SVNWorkspaceRoot.pathForLocation(status.getIPath());
        if (resourcePath == null) {
            return null;
        }
        int kind = SVNWorkspaceRoot.getResourceType(resourcePath);
        if (kind == 1) {
            return root.getFile(resourcePath);
        }
        if (kind == 2) {
            return root.getFolder(resourcePath);
        }
        if (kind == 4) {
            return root.getProject(resourcePath.segment(0));
        }
        if (kind == 8) {
            return root;
        }
        if (status.getNodeKind() == SVNNodeKind.FILE) {
            return root.getFile(resourcePath);
        }
        if (resourcePath.isRoot()) {
            return root;
        }
        if (resourcePath.segmentCount() == 1) {
            return root.getProject(resourcePath.segment(0));
        }
        return root.getFolder(resourcePath);
    }

    public static IResource getResourceFor(ISVNStatus status) throws SVNException {
        if (status.getPath() == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath resourcePath = SVNWorkspaceRoot.pathForLocation((IPath)new Path(status.getPath()));
        if (resourcePath == null) {
            if (status.getFile() != null && status.getFile().getName().equals(".metadata")) {
                return null;
            }
            if (!nullResourceLogged) {
                String errorMsg = Policy.bind("SVNWorkspaceRoot.nullResource", status.getPath());
                IConsoleListener console = SVNProviderPlugin.getPlugin().getConsoleListener();
                if (console != null) {
                    console.logError(Policy.bind(errorMsg));
                    console.logError(Policy.bind("SVNWorkspaceRoot.nullResource.2"));
                    console.logError(Policy.bind("SVNWorkspaceRoot.nullResource.3"));
                    console.logError(Policy.bind("SVNWorkspaceRoot.nullResource.4"));
                    console.logError(Policy.bind("SVNWorkspaceRoot.nullResource.5"));
                    console.logError(Policy.bind("SVNWorkspaceRoot.nullResource.6"));
                }
                nullResourceLogged = true;
                throw new SVNException(errorMsg);
            }
            throw new SVNException("");
        }
        int kind = SVNWorkspaceRoot.getResourceType(resourcePath);
        if (kind == 1) {
            return root.getFile(resourcePath);
        }
        if (kind == 2) {
            return root.getFolder(resourcePath);
        }
        if (kind == 4) {
            return root.getProject(resourcePath.segment(0));
        }
        if (kind == 8) {
            return root;
        }
        if (status.getNodeKind() == SVNNodeKind.FILE) {
            return root.getFile(resourcePath);
        }
        if (resourcePath.isRoot()) {
            return root;
        }
        if (resourcePath.segmentCount() == 1) {
            return root.getProject(resourcePath.segment(0));
        }
        return root.getFolder(resourcePath);
    }
}

