/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.util;

import java.util.HashSet;
import java.util.Set;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.util.Assert;

public class ReentrantLock {
    private static final boolean DEBUG = Policy.DEBUG_THREADING;
    private Thread thread = null;
    private int nestingCount = 0;
    private Set readOnlyThreads = new HashSet();

    public synchronized void acquire() {
        Thread thisThread = Thread.currentThread();
        if (this.thread != thisThread) {
            while (this.nestingCount != 0) {
                try {
                    if (DEBUG) {
                        System.out.println("[" + thisThread.getName() + "] waiting for SVN synchronizer lock");
                    }
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (!DEBUG) continue;
                    System.out.println("[" + thisThread.getName() + "] interrupted in SVN synchronizer lock");
                }
            }
            this.thread = thisThread;
            if (DEBUG) {
                System.out.println("[" + thisThread.getName() + "] acquired SVN synchronizer lock");
            }
        }
        ++this.nestingCount;
    }

    public synchronized void release() {
        Thread thisThread = Thread.currentThread();
        Assert.isLegal(this.thread == thisThread, "Thread attempted to release a lock it did not own");
        if (--this.nestingCount == 0) {
            if (DEBUG) {
                System.out.println("[" + this.thread.getName() + "] released SVN synchronizer lock");
            }
            this.thread = null;
            this.notifyAll();
        }
    }

    public int getNestingCount() {
        Thread thisThread = Thread.currentThread();
        Assert.isLegal(this.thread == thisThread, "Thread attempted to read nesting count of a lock it did not own");
        return this.nestingCount;
    }

    public boolean isReadOnly() {
        return this.readOnlyThreads.contains(this.thread);
    }

    public void addReadOnlyThread(Thread aThread) {
        this.readOnlyThreads.add(aThread);
    }
}

