/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.ui.IDecorationsProvider;
import org.eclipse.wst.common.project.facet.ui.IRuntimeComponentLabelProvider;
import org.eclipse.wst.common.project.facet.ui.internal.AbstractDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.ChangeTargetedRuntimesDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;

public final class RuntimesPanel
extends Composite {
    private static final Object NO_RUNTIME_SELECTED_PLACEHOLDER = new Object();
    private final ChangeTargetedRuntimesDataModel model;
    private boolean showAllRuntimesSetting;
    private final Label runtimesLabel;
    private final CheckboxTableViewer runtimes;
    private final Button showAllRuntimesCheckbox;
    private final Button makePrimaryButton;
    private final Label runtimeComponentsLabel;
    private final TableViewer runtimeComponents;
    private IRuntime currentPrimaryRuntime;
    private final List listeners = new ArrayList();
    private Color colorGray;
    private Color colorManila;

    public RuntimesPanel(Composite parent, int style, ChangeTargetedRuntimesDataModel model) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RuntimesPanel.this.handleWidgetDisposed();
            }
        });
        this.model = model;
        this.addDataModelListener("availableRuntimesChanged", new AbstractDataModel.IDataModelListener(){

            public void handleEvent() {
                RuntimesPanel.this.handleAvailableRuntimesChanged();
            }
        });
        this.addDataModelListener("targetableRuntimesChanged", new AbstractDataModel.IDataModelListener(){

            public void handleEvent() {
                RuntimesPanel.this.handleTargetableRuntimesChanged();
            }
        });
        this.addDataModelListener("targetedRuntimesChanged", new AbstractDataModel.IDataModelListener(){

            public void handleEvent() {
                RuntimesPanel.this.handleTargetedRuntimesChanged();
            }
        });
        this.addDataModelListener("primaryRuntimeChanged", new AbstractDataModel.IDataModelListener(){

            public void handleEvent() {
                RuntimesPanel.this.handlePrimaryRuntimeChanged();
            }
        });
        this.showAllRuntimesSetting = false;
        this.colorGray = new Color(null, 160, 160, 164);
        this.colorManila = new Color(null, 255, 255, 206);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.runtimesLabel = new Label((Composite)this, 0);
        this.runtimesLabel.setText(Resources.runtimesLabel);
        this.runtimesLabel.setLayoutData((Object)RuntimesPanel.gdhfill());
        this.runtimes = CheckboxTableViewer.newCheckList((Composite)this, (int)2048);
        this.runtimes.getTable().setLayoutData((Object)RuntimesPanel.gdfill());
        this.runtimes.setContentProvider((IContentProvider)new ContentProvider());
        this.runtimes.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.runtimes.setSorter((ViewerSorter)new Sorter());
        this.runtimes.setInput(new Object());
        this.runtimes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                RuntimesPanel.this.handleRuntimeSelectionChanged();
            }
        });
        this.runtimes.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                RuntimesPanel.this.handleCheckStateChanged(e);
            }
        });
        this.showAllRuntimesCheckbox = new Button((Composite)this, 32);
        this.showAllRuntimesCheckbox.setText(Resources.showAllRuntimes);
        this.showAllRuntimesCheckbox.setSelection(this.showAllRuntimesSetting);
        this.showAllRuntimesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimesPanel.this.handleShowAllRuntimesSelected();
            }
        });
        this.makePrimaryButton = new Button((Composite)this, 8);
        this.makePrimaryButton.setText(Resources.makePrimaryLabel);
        GridData gd = RuntimesPanel.halign(new GridData(), 3);
        gd = RuntimesPanel.whint(gd, RuntimesPanel.getPreferredWidth((Control)this.makePrimaryButton) + 15);
        this.makePrimaryButton.setLayoutData((Object)gd);
        this.makePrimaryButton.setEnabled(false);
        this.makePrimaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimesPanel.this.handleMakePrimarySelected();
            }
        });
        this.runtimeComponentsLabel = new Label((Composite)this, 0);
        this.runtimeComponentsLabel.setText(Resources.runtimeCompositionLabel);
        this.runtimeComponentsLabel.setLayoutData((Object)RuntimesPanel.gdhfill());
        this.runtimeComponents = new TableViewer((Composite)this, 2048);
        this.runtimeComponents.getTable().setLayoutData((Object)RuntimesPanel.hhint(RuntimesPanel.gdhfill(), 50));
        this.runtimeComponents.getTable().setBackground(this.colorManila);
        this.runtimeComponents.setContentProvider((IContentProvider)new RuntimeComponentsContentProvider());
        this.runtimeComponents.setLabelProvider((IBaseLabelProvider)new RuntimeComponentsLabelProvider());
        this.runtimeComponents.setInput(NO_RUNTIME_SELECTED_PLACEHOLDER);
        this.runtimeComponents.getTable().setEnabled(false);
        this.runtimeComponentsLabel.setEnabled(false);
        this.refresh();
        this.currentPrimaryRuntime = this.model.getPrimaryRuntime();
    }

    public ChangeTargetedRuntimesDataModel getDataModel() {
        return this.model;
    }

    private void handleAvailableRuntimesChanged() {
        if (!Thread.currentThread().equals(this.getDisplay().getThread())) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    RuntimesPanel.this.handleAvailableRuntimesChanged();
                }
            });
            return;
        }
        if (this.showAllRuntimesSetting) {
            this.refresh();
        }
    }

    private void handleTargetableRuntimesChanged() {
        if (!Thread.currentThread().equals(this.getDisplay().getThread())) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    RuntimesPanel.this.handleTargetableRuntimesChanged();
                }
            });
            return;
        }
        this.refresh();
    }

    private void handleTargetedRuntimesChanged() {
        if (!Thread.currentThread().equals(this.getDisplay().getThread())) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    RuntimesPanel.this.handleTargetedRuntimesChanged();
                }
            });
            return;
        }
        Set targeted = this.model.getTargetedRuntimes();
        Iterator itr = this.model.getTargetableRuntimes().iterator();
        while (itr.hasNext()) {
            IRuntime r = (IRuntime)itr.next();
            if (targeted.contains(r)) {
                if (this.runtimes.getChecked((Object)r)) continue;
                this.runtimes.setChecked((Object)r, true);
                continue;
            }
            if (!this.runtimes.getChecked((Object)r)) continue;
            this.runtimes.setChecked((Object)r, false);
        }
    }

    private void handlePrimaryRuntimeChanged() {
        if (!Thread.currentThread().equals(this.getDisplay().getThread())) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    RuntimesPanel.this.handlePrimaryRuntimeChanged();
                }
            });
            return;
        }
        if (this.currentPrimaryRuntime != null) {
            this.runtimes.update((Object)this.currentPrimaryRuntime, null);
        }
        this.currentPrimaryRuntime = this.model.getPrimaryRuntime();
        if (this.currentPrimaryRuntime != null) {
            this.runtimes.update((Object)this.currentPrimaryRuntime, null);
        }
    }

    private void handleCheckStateChanged(CheckStateChangedEvent e) {
        IRuntime runtime = (IRuntime)e.getElement();
        if (!this.model.getTargetableRuntimes().contains(runtime) && e.getChecked()) {
            this.runtimes.setChecked((Object)runtime, false);
            return;
        }
        if (e.getChecked()) {
            this.model.addTargetedRuntime(runtime);
        } else {
            this.model.removeTargetedRuntime(runtime);
        }
    }

    private void handleRuntimeSelectionChanged() {
        IRuntime r = this.getSelection();
        if (r == null) {
            if (this.runtimeComponents.getInput() != null) {
                this.runtimeComponentsLabel.setEnabled(false);
                this.runtimeComponents.getTable().setEnabled(false);
                this.runtimeComponents.setInput(NO_RUNTIME_SELECTED_PLACEHOLDER);
            }
        } else {
            if (this.runtimeComponents.getInput() == null || !this.runtimeComponents.getInput().equals(r)) {
                this.runtimeComponentsLabel.setEnabled(true);
                this.runtimeComponents.getTable().setEnabled(true);
                this.runtimeComponents.setInput((Object)r);
            }
            if (this.runtimes.getChecked((Object)r) && this.model.getPrimaryRuntime() != null && !this.model.getPrimaryRuntime().equals(r) && this.model.getTargetableRuntimes().contains(r)) {
                this.makePrimaryButton.setEnabled(true);
            } else {
                this.makePrimaryButton.setEnabled(false);
            }
        }
    }

    private void handleShowAllRuntimesSelected() {
        this.showAllRuntimesSetting = this.showAllRuntimesCheckbox.getSelection();
        this.refresh();
    }

    private void handleMakePrimarySelected() {
        this.model.setPrimaryRuntime(this.getSelection());
    }

    private void handleWidgetDisposed() {
        this.removeDataModelListeners();
        this.colorGray.dispose();
        this.colorManila.dispose();
    }

    private void refresh() {
        this.runtimes.refresh();
        HashSet untargetable = new HashSet(this.model.getAllRuntimes());
        untargetable.removeAll(this.model.getTargetableRuntimes());
        this.runtimes.setCheckedElements(this.model.getTargetedRuntimes().toArray());
    }

    private IRuntime getSelection() {
        IStructuredSelection ssel = (IStructuredSelection)this.runtimes.getSelection();
        if (ssel.isEmpty()) {
            return null;
        }
        return (IRuntime)ssel.getFirstElement();
    }

    private void addDataModelListener(String event, AbstractDataModel.IDataModelListener listener) {
        this.model.addListener(event, listener);
        this.listeners.add(listener);
    }

    private void removeDataModelListeners() {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            this.model.removeListener((AbstractDataModel.IDataModelListener)itr.next());
        }
    }

    private static final GridData gdfill() {
        return new GridData(4, 4, true, true);
    }

    private static final GridData gdhfill() {
        return new GridData(768);
    }

    private static final GridData whint(GridData gd, int width) {
        gd.widthHint = width;
        return gd;
    }

    private static final GridData hhint(GridData gd, int height) {
        gd.heightHint = height;
        return gd;
    }

    private static final GridData halign(GridData gd, int alignment) {
        gd.horizontalAlignment = alignment;
        return gd;
    }

    private static final int getPreferredWidth(Control control) {
        return control.computeSize((int)-1, (int)-1).x;
    }

    private final class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (RuntimesPanel.this.showAllRuntimesSetting) {
                return RuntimesPanel.this.getDataModel().getAllRuntimes().toArray();
            }
            return RuntimesPanel.this.getDataModel().getTargetableRuntimes().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class LabelProvider
    implements ILabelProvider,
    IColorProvider {
        private final ImageRegistry imageRegistry = new ImageRegistry();
        static /* synthetic */ Class class$0;

        public String getText(Object element) {
            return ((IRuntime)element).getName();
        }

        public Image getImage(Object element) {
            IRuntime r = (IRuntime)element;
            IRuntimeComponent rc = (IRuntimeComponent)r.getRuntimeComponents().get(0);
            IRuntimeComponentType rct = rc.getRuntimeComponentType();
            IRuntime primary = RuntimesPanel.this.getDataModel().getPrimaryRuntime();
            boolean isPrimary = primary != null && primary.equals(r);
            String imgid = String.valueOf(isPrimary ? "p:" : "s") + rct.getId();
            Image image = this.imageRegistry.get(imgid);
            if (image == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.IDecorationsProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IDecorationsProvider decprov = (IDecorationsProvider)rct.getAdapter((Class)clazz);
                Object imgdesc = decprov.getIcon();
                if (isPrimary) {
                    imgdesc = new PrimaryRuntimeImageDescriptor((ImageDescriptor)imgdesc);
                }
                this.imageRegistry.put(imgid, imgdesc);
                image = this.imageRegistry.get(imgid);
            }
            if (RuntimesPanel.this.getDataModel().getTargetableRuntimes().contains(r)) {
                if (RuntimesPanel.this.model.getTargetedRuntimes().contains(r)) {
                    RuntimesPanel.this.runtimes.setChecked((Object)r, true);
                } else {
                    RuntimesPanel.this.runtimes.setChecked((Object)r, false);
                }
                return image;
            }
            RuntimesPanel.this.runtimes.setChecked((Object)r, false);
            String greyedId = String.valueOf(rct.getId()) + "##greyed##";
            Image greyed = this.imageRegistry.get(greyedId);
            if (greyed == null) {
                greyed = new Image(null, image, 2);
                this.imageRegistry.put(greyedId, greyed);
            }
            return greyed;
        }

        public Color getForeground(Object element) {
            if (!RuntimesPanel.this.getDataModel().getTargetableRuntimes().contains(element)) {
                return RuntimesPanel.this.colorGray;
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public void dispose() {
            this.imageRegistry.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class PrimaryRuntimeImageDescriptor
    extends CompositeImageDescriptor {
        private static final String OVERLAY_IMG_LOCATION = "images/primary-runtime-overlay.gif";
        private static final ImageData OVERLAY = FacetUiPlugin.getImageDescriptor("images/primary-runtime-overlay.gif").getImageData();
        private final ImageData base;
        private final Point size;

        public PrimaryRuntimeImageDescriptor(ImageDescriptor base) {
            this.base = base.getImageData();
            this.size = new Point(this.base.width, this.base.height);
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.base, 0, 0);
            this.drawImage(OVERLAY, 0, height - PrimaryRuntimeImageDescriptor.OVERLAY.height);
        }

        protected Point getSize() {
            return this.size;
        }
    }

    private static final class Resources
    extends NLS {
        public static String runtimesLabel;
        public static String runtimeCompositionLabel;
        public static String makePrimaryLabel;
        public static String showAllRuntimes;
        public static String noRuntimeSelectedLabel;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.RuntimesPanel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.RuntimesPanel$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }

    private final class RuntimeComponentsContentProvider
    implements IStructuredContentProvider {
        private RuntimeComponentsContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element == NO_RUNTIME_SELECTED_PLACEHOLDER) {
                return new Object[]{NO_RUNTIME_SELECTED_PLACEHOLDER};
            }
            IRuntime r = (IRuntime)element;
            return r.getRuntimeComponents().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class RuntimeComponentsLabelProvider
    implements ILabelProvider {
        private final ImageRegistry imageRegistry = new ImageRegistry();
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        private RuntimeComponentsLabelProvider() {
        }

        public String getText(Object element) {
            IRuntimeComponentLabelProvider provider;
            if (element == NO_RUNTIME_SELECTED_PLACEHOLDER) {
                return Resources.noRuntimeSelectedLabel;
            }
            IRuntimeComponent comp = (IRuntimeComponent)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.IRuntimeComponentLabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((provider = (IRuntimeComponentLabelProvider)comp.getAdapter((Class)clazz)) == null) {
                StringBuffer label = new StringBuffer();
                label.append(comp.getRuntimeComponentType().getId());
                label.append(' ');
                label.append(comp.getRuntimeComponentVersion().getVersionString());
                return label.toString();
            }
            return provider.getLabel();
        }

        public Image getImage(Object element) {
            if (element == NO_RUNTIME_SELECTED_PLACEHOLDER) {
                return null;
            }
            IRuntimeComponent rc = (IRuntimeComponent)element;
            IRuntimeComponentType rct = rc.getRuntimeComponentType();
            Image image = this.imageRegistry.get(rct.getId());
            if (image == null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.wst.common.project.facet.ui.IDecorationsProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IDecorationsProvider decprov = (IDecorationsProvider)rct.getAdapter((Class)clazz);
                this.imageRegistry.put(rct.getId(), decprov.getIcon());
                image = this.imageRegistry.get(rct.getId());
            }
            return image;
        }

        public void dispose() {
            this.imageRegistry.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class Sorter
    extends ViewerSorter {
        private Sorter() {
        }

        public int compare(Viewer viewer, Object a, Object b) {
            IRuntime r1 = (IRuntime)a;
            IRuntime r2 = (IRuntime)b;
            return r1.getName().compareToIgnoreCase(r2.getName());
        }
    }
}

