/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.internal.java.adapters.JavaArrayTypeReflectionAdapter;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.ReflectionAdaptor;
import org.eclipse.jem.java.JavaRefPackage;

public abstract class JavaReflectionAdapterFactory
extends AdapterFactoryImpl {
    protected HashMap reflected = new HashMap();
    public static final String TYPE_KEY = "JavaReflection";
    protected boolean isBusyIteratingReflected = false;
    protected Map registerQueue;
    protected List unregisterQueue;

    public Adapter createAdapter(Notifier target) {
        ReflectionAdaptor adapter = null;
        EObject object = (EObject)target;
        JavaRefPackage pack = this.getJavaRefPackage();
        if (object.eClass() == pack.getJavaClass()) {
            adapter = this.createJavaClassAdaptor(target);
        } else if (object.eClass() == pack.getArrayType()) {
            adapter = this.createArrayTypeAdaptor(target);
        } else if (object.eClass() == pack.getMethod()) {
            adapter = this.createJavaMethodAdaptor(target);
        } else if (object.eClass() == pack.getField()) {
            adapter = this.createJavaFieldAdaptor(target);
        }
        return adapter;
    }

    protected ReflectionAdaptor createArrayTypeAdaptor(Notifier target) {
        return new JavaArrayTypeReflectionAdapter(target);
    }

    protected abstract ReflectionAdaptor createJavaClassAdaptor(Notifier var1);

    protected abstract ReflectionAdaptor createJavaFieldAdaptor(Notifier var1);

    protected abstract ReflectionAdaptor createJavaMethodAdaptor(Notifier var1);

    public Notification disAssociateSource(String source) {
        return this.disAssociateSource(source, true);
    }

    public Notification disAssociateSource(String source, boolean doNotify) {
        JavaReflectionAdaptor a = (JavaReflectionAdaptor)this.reflected.get(source);
        Notification notification = null;
        if (a != null) {
            if (doNotify) {
                a.releaseSourceType();
            } else {
                notification = a.releaseSourceTypeNoNotification();
            }
        }
        return notification;
    }

    public void flushAll() {
    }

    public void flushReflection(String source) {
    }

    protected JavaRefPackage getJavaRefPackage() {
        return (JavaRefPackage)EPackage.Registry.INSTANCE.getEPackage("java.xmi");
    }

    public void registerReflection(String source, ReflectionAdaptor adapter) {
        if (this.isBusyIteratingReflected) {
            if (this.registerQueue == null) {
                this.registerQueue = new HashMap();
            }
            this.registerQueue.put(source, adapter);
        } else {
            this.reflected.put(source, adapter);
        }
    }

    public void unregisterReflection(String source) {
        if (this.isBusyIteratingReflected) {
            if (this.unregisterQueue == null) {
                this.unregisterQueue = new ArrayList();
            }
            this.unregisterQueue.add(source);
        } else {
            this.reflected.remove(source);
        }
    }

    public void disAssociateSourcePlusInner(String source) {
        this.disAssociateSourcePlusInner(source, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Notification disAssociateSourcePlusInner(String source, boolean doNotify) {
        this.isBusyIteratingReflected = true;
        Notification notification = null;
        try {
            String innerName = String.valueOf(source) + '$';
            Iterator it = this.reflected.entrySet().iterator();
            while (it.hasNext()) {
                JavaReflectionAdaptor adaptor;
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                if (!key.equals(source) && !key.startsWith(innerName) || (adaptor = (JavaReflectionAdaptor)this.reflected.get(key)) == null) continue;
                if (doNotify) {
                    adaptor.releaseSourceType();
                    continue;
                }
                notification = adaptor.releaseSourceTypeNoNotification();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.finishedIteratingReflected();
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.finishedIteratingReflected();
            return notification;
        }
    }

    protected void finishedIteratingReflected() {
        this.isBusyIteratingReflected = false;
        if (this.unregisterQueue != null && !this.unregisterQueue.isEmpty()) {
            int i = 0;
            while (i < this.unregisterQueue.size()) {
                this.reflected.remove(this.unregisterQueue.get(i));
                ++i;
            }
            this.unregisterQueue.clear();
        }
        if (this.registerQueue != null && !this.registerQueue.isEmpty()) {
            Iterator it = this.registerQueue.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.reflected.put(entry.getKey(), entry.getValue());
            }
            this.registerQueue.clear();
        }
    }

    public boolean isFactoryForType(Object type) {
        return TYPE_KEY.equals(type);
    }
}

