/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.eclipse;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidationConfiguration;
import org.eclipse.wst.wsdl.validation.internal.eclipse.InlineSchemaModelGrammarPoolImpl;
import org.eclipse.wst.wsdl.validation.internal.eclipse.WSDLValidationMessages;
import org.eclipse.wst.wsdl.validation.internal.eclipse.WSDLValidator;
import org.eclipse.wst.xml.core.internal.validation.core.AbstractNestedValidator;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;

public class Validator
extends AbstractNestedValidator {
    protected HashMap xsdGrammarPools = new HashMap();
    protected HashMap xmlGrammarPools = new HashMap();
    static /* synthetic */ Class class$0;

    protected String getValidatorName() {
        return WSDLValidationMessages.Message_WSDL_validation_message_ui;
    }

    protected void setupValidation(NestedValidatorContext context) {
        super.setupValidation(context);
        InlineSchemaModelGrammarPoolImpl xsdGrammarPool = new InlineSchemaModelGrammarPoolImpl();
        XMLGrammarPoolImpl xmlGrammarPool = new XMLGrammarPoolImpl();
        this.xsdGrammarPools.put(context, xsdGrammarPool);
        this.xmlGrammarPools.put(context, xmlGrammarPool);
    }

    protected void teardownValidation(NestedValidatorContext context) {
        XMLGrammarPool xmlGrammarPool;
        XMLGrammarPool xsdGrammarPool = (XMLGrammarPool)this.xsdGrammarPools.remove(context);
        if (xsdGrammarPool != null) {
            xsdGrammarPool.clear();
        }
        if ((xmlGrammarPool = (XMLGrammarPool)this.xmlGrammarPools.remove(context)) != null) {
            xmlGrammarPool.clear();
        }
        super.teardownValidation(context);
    }

    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context) {
        XMLGrammarPool xsdGrammarPool = (XMLGrammarPool)this.xsdGrammarPools.get(context);
        XMLGrammarPool xmlGrammarPool = (XMLGrammarPool)this.xmlGrammarPools.get(context);
        WSDLValidator validator = WSDLValidator.getInstance();
        WSDLValidationConfiguration configuration = new WSDLValidationConfiguration();
        configuration.setProperty("http://www.eclipse.org/webtools/wsdl/schemacache", xsdGrammarPool);
        configuration.setProperty("http://www.eclipse.org/webtools/wsdl/xmlcache", xmlGrammarPool);
        IValidationReport valreport = null;
        valreport = inputstream != null ? validator.validate(uri, inputstream, configuration) : validator.validate(uri, null, configuration);
        return this.convertReportToXMLReport(valreport);
    }

    protected ValidationReport convertReportToXMLReport(IValidationReport report) {
        ValidationInfo convertedReport = new ValidationInfo(report.getFileURI());
        IValidationMessage[] messages = report.getValidationMessages();
        int numMessages = messages.length;
        int i = 0;
        while (i < numMessages) {
            this.convertMessage(messages[i], convertedReport);
            ++i;
        }
        return convertedReport;
    }

    protected void convertMessage(IValidationMessage message, ValidationInfo convertedReport) {
        List nestedMessages = message.getNestedMessages();
        if (nestedMessages != null && nestedMessages.size() > 0) {
            Iterator messageIter = nestedMessages.iterator();
            while (messageIter.hasNext()) {
                this.convertMessage((IValidationMessage)messageIter.next(), convertedReport);
            }
        } else if (message.getSeverity() == 1) {
            convertedReport.addWarning(message.getMessage(), message.getLine(), message.getColumn(), message.getURI());
        } else {
            convertedReport.addError(message.getMessage(), message.getLine(), message.getColumn(), message.getURI());
        }
    }

    protected String getValidatorID() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.validation.internal.eclipse.WSDLDelegatingValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }
}

