/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSCDDArtifactEdit;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServiceEvent;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServiceManagerListener;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;
import org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesResource;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class WebServicesManager
implements EditModelListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    private HashMap wsArtifactEdits = new HashMap();
    private HashMap wsClientArtifactEdits = new HashMap();
    private List wsArtifactEditsList;
    private List wsClientArtifactEditsList;
    private static WebServicesManager INSTANCE = null;
    private List listeners;
    private List removedListeners = new ArrayList();
    private boolean isNotifying = false;
    private boolean wsClientElementsChanged = true;
    private boolean wsElementsChanged = true;
    public static final String WSDL_EXT = "wsdl";
    public static final String WSIL_EXT = "wsil";

    public static synchronized WebServicesManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WebServicesManager();
        }
        return INSTANCE;
    }

    public WebServicesManager() {
        this.init();
    }

    private void init() {
        this.collectArtifactEdits();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addArtifactEdit(IProject handle) {
        EnterpriseArtifactEdit edit;
        HashMap hashMap = this.wsArtifactEdits;
        synchronized (hashMap) {
            if (!this.wsArtifactEdits.containsKey(handle) && (edit = WSDDArtifactEdit.getWSDDArtifactEditForRead(handle)) != null) {
                WebServices webServices = edit.getWebServices();
                if (webServices != null && !webServices.getWebServiceDescriptions().isEmpty() || !edit.getWSILResources().isEmpty()) {
                    edit.addListener((EditModelListener)this);
                    this.wsArtifactEdits.put(handle, edit);
                    this.wsElementsChanged = true;
                } else {
                    edit.dispose();
                }
            }
        }
        hashMap = this.wsClientArtifactEdits;
        synchronized (hashMap) {
            if (!this.wsClientArtifactEdits.containsKey(handle) && (edit = WSCDDArtifactEdit.getWSCDDArtifactEditForRead(handle)) != null) {
                WebServicesResource res = edit.getWscddXmiResource();
                boolean isInterested = false;
                if (res != null && res.isLoaded() && res.getWebServicesClient() != null) {
                    isInterested = true;
                }
                ArrayList<EnterpriseArtifactEdit> wsClientEdits = new ArrayList<EnterpriseArtifactEdit>();
                wsClientEdits.add(edit);
                if (!this.getWorkspace14ServiceRefs(wsClientEdits).isEmpty()) {
                    isInterested = true;
                }
                if (isInterested) {
                    edit.addListener((EditModelListener)this);
                    this.wsClientArtifactEdits.put(handle, edit);
                    this.wsClientElementsChanged = true;
                } else {
                    edit.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeArtifactEdit(IProject handle) {
        ArtifactEdit edit;
        HashMap hashMap = this.wsArtifactEdits;
        synchronized (hashMap) {
            if (this.wsArtifactEdits.containsKey(handle) && (edit = (ArtifactEdit)this.wsArtifactEdits.get(handle)) != null) {
                this.wsArtifactEdits.remove(handle);
                edit.removeListener((EditModelListener)this);
                edit.dispose();
                this.wsElementsChanged = true;
            }
        }
        hashMap = this.wsClientArtifactEdits;
        synchronized (hashMap) {
            if (this.wsClientArtifactEdits.containsKey(handle) && (edit = (ArtifactEdit)this.wsClientArtifactEdits.get(handle)) != null) {
                this.wsClientArtifactEdits.remove(handle);
                edit.removeListener((EditModelListener)this);
                edit.dispose();
                this.wsClientElementsChanged = true;
            }
        }
    }

    private void collectArtifactEdits() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            block4: {
                IProject project = projects[i];
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                try {
                    if (!ModuleCoreNature.isFlexibleProject((IProject)project) || J2EEProjectUtilities.isEARProject((IProject)project)) break block4;
                    if (J2EEProjectUtilities.isStaticWebProject((IProject)project)) {
                    }
                }
                catch (Exception exception) {}
                break block4;
                this.addArtifactEdit(component.getProject());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getWSArtifactEdits() {
        HashMap hashMap = this.wsArtifactEdits;
        synchronized (hashMap) {
            if (this.wsElementsChanged) {
                this.wsArtifactEditsList = new ArrayList();
                this.wsArtifactEditsList.addAll(this.wsArtifactEdits.values());
                this.wsElementsChanged = false;
            }
        }
        return this.wsArtifactEditsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getWSClientArtifactEdits() {
        HashMap hashMap = this.wsClientArtifactEdits;
        synchronized (hashMap) {
            if (this.wsClientElementsChanged) {
                this.wsClientArtifactEditsList = new ArrayList();
                this.wsClientArtifactEditsList.addAll(this.wsClientArtifactEdits.values());
                this.wsClientElementsChanged = false;
            }
        }
        return this.wsClientArtifactEditsList;
    }

    private List getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        return this.listeners;
    }

    public void addListener(WebServiceManagerListener aListener) {
        if (aListener != null && !this.getListeners().contains(aListener)) {
            this.getListeners().add(aListener);
        }
    }

    public void editModelChanged(EditModelEvent anEvent) {
        if (anEvent == null) {
            return;
        }
        if (anEvent.getEventCode() == 7) {
            List resources = anEvent.getChangedResources();
            int i = 0;
            while (i < resources.size()) {
                Resource res = (Resource)resources.get(i);
                if (this.isInterestedInResource(res)) {
                    this.notifyListeners(anEvent.getEventCode());
                }
                ++i;
            }
        } else if (anEvent.getEventCode() == 5) {
            ArtifactEditModel editModel = (ArtifactEditModel)anEvent.getEditModel();
            if (editModel == null || editModel.getProject() == null) {
                return;
            }
            this.removeArtifactEdit(editModel.getProject());
            this.notifyListeners(anEvent.getEventCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifyListeners(int anEventType) {
        if (this.listeners == null) {
            return;
        }
        var2_2 = this;
        synchronized (var2_2) {
            this.isNotifying = true;
        }
        try {
            webServiceEvent = null;
            switch (anEventType) {
                case 3: 
                case 5: 
                case 7: {
                    webServiceEvent = new WebServiceEvent(0);
                    break;
                }
                default: {
                    if (this.getAllWorkspaceServiceRefs().isEmpty() && this.getAllWSDLServices().isEmpty()) break;
                    webServiceEvent = new WebServiceEvent(1);
                }
            }
            list = this.getListeners();
            if (webServiceEvent != null) {
                i = 0;
                while (i < list.size()) {
                    ((WebServiceManagerListener)list.get(i)).webServiceManagerChanged(webServiceEvent);
                    ++i;
                }
            }
        }
        catch (Throwable var6_5) {
            var5_6 = null;
            var7_8 = this;
            synchronized (var7_8) {
                this.isNotifying = false;
                if (this.removedListeners == null) throw var6_5;
                if (this.removedListeners.isEmpty() != false) throw var6_5;
                i = 0;
                while (true) {
                    if (i >= this.removedListeners.size()) {
                        this.removedListeners.clear();
                        throw var6_5;
                    }
                    this.listeners.remove(this.removedListeners.get(i));
                    ++i;
                }
            }
        }
        {
            var5_7 = null;
            var7_9 = this;
        }
        synchronized (var7_9) {
            ** try [egrp 2[TRYBLOCK] [4 : 173->256)] { 
lbl51:
            // 1 sources

            this.isNotifying = false;
            if (this.removedListeners == null) return;
            if (this.removedListeners.isEmpty() != false) return;
            i = 0;
            while (true) {
                if (i >= this.removedListeners.size()) {
                    this.removedListeners.clear();
                    return;
                }
                this.listeners.remove(this.removedListeners.get(i));
                ++i;
            }
lbl63:
            // 1 sources

            catch (Throwable v2) {
                throw v2;
            }
        }
    }

    public synchronized boolean removeListener(WebServiceManagerListener aListener) {
        if (aListener != null) {
            if (this.isNotifying) {
                return this.removedListeners.add(aListener);
            }
            return this.getListeners().remove(aListener);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseArtifactEdits() {
        EnterpriseArtifactEdit artifactEdit;
        Iterator iter;
        HashMap hashMap = this.wsArtifactEdits;
        synchronized (hashMap) {
            iter = this.wsArtifactEdits.values().iterator();
            while (iter.hasNext()) {
                artifactEdit = (WSDDArtifactEdit)((Object)iter.next());
                artifactEdit.removeListener((EditModelListener)this);
                artifactEdit.dispose();
            }
            this.wsArtifactEdits.clear();
        }
        hashMap = this.wsClientArtifactEdits;
        synchronized (hashMap) {
            iter = this.wsClientArtifactEdits.values().iterator();
            while (iter.hasNext()) {
                artifactEdit = (WSCDDArtifactEdit)((Object)iter.next());
                artifactEdit.removeListener((EditModelListener)this);
                artifactEdit.dispose();
            }
            this.wsClientArtifactEdits.clear();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.acceptDelta(event);
    }

    protected void acceptDelta(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    public List getInternalWebServicesDescriptions() {
        ArrayList result = new ArrayList();
        List webServices = this.getInternalWebServices();
        int i = 0;
        while (i < webServices.size()) {
            WebServices webService = (WebServices)webServices.get(i);
            if (webService != null) {
                result.addAll(webService.getWebServiceDescriptions());
            }
            ++i;
        }
        return result;
    }

    public List getInternalWebServices() {
        ArrayList<WebServices> result = new ArrayList<WebServices>();
        Iterator iter = this.getWSArtifactEdits().iterator();
        while (iter.hasNext()) {
            WSDDArtifactEdit artifactEdit = (WSDDArtifactEdit)((Object)iter.next());
            WebServices webServices = artifactEdit.getWebServices();
            if (webServices == null) continue;
            result.add(webServices);
        }
        return result;
    }

    public List getInternalWSDLServices() {
        return this.getWSDLServicesFromWSDLResources(this.getInternalWSDLResources());
    }

    public List getInternalWSDLResources() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        List wsddWebServices = this.getInternalWebServicesDescriptions();
        int i = 0;
        while (i < wsddWebServices.size()) {
            WebServiceDescription webServices = (WebServiceDescription)wsddWebServices.get(i);
            Resource wsdl = this.getWSDLResource(webServices);
            if (wsdl != null && !result.contains(wsdl)) {
                result.add(wsdl);
            }
            ++i;
        }
        return result;
    }

    public List getExternalWSDLResources() {
        List result = this.getWorkspaceWSDLResources();
        result.removeAll(this.getInternalWSDLResources());
        List serviceRefs = this.getAllWorkspaceServiceRefs();
        int i = 0;
        while (i < serviceRefs.size()) {
            ServiceRef ref = (ServiceRef)serviceRefs.get(i);
            try {
                Resource res = WorkbenchResourceHelperBase.getResource((URI)URI.createURI((String)ref.getWsdlFile()), (boolean)true);
                if (res != null && result.contains(res)) {
                    result.remove(res);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return result;
    }

    public boolean isServiceInternal(EObject service) {
        return this.getInternalWSDLResources().contains(this.getWSDLResource(service));
    }

    private List getWSDLServicesFromWSDLResources(List wsdlResources) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < wsdlResources.size()) {
            Resource wsdl = (Resource)wsdlResources.get(i);
            List services = this.getWSDLServices(wsdl);
            if (wsdl != null && services != null && !services.isEmpty()) {
                result.addAll(services);
            }
            ++i;
        }
        return result;
    }

    public List getExternalWSDLServices() {
        List result = this.getWsdlServicesFromWorkspaceWSILs();
        result.removeAll(this.getInternalWSDLServices());
        return result;
    }

    public List getWsdlServicesFromWorkspaceWSILs() {
        ArrayList result = new ArrayList();
        List wsilFiles = this.getWorkspaceWSILFiles();
        int i = 0;
        while (i < wsilFiles.size()) {
            IFile wsil = (IFile)wsilFiles.get(i);
            List services = this.getWsdlServicesFromWsilFile(wsil);
            if (!services.isEmpty()) {
                result.addAll(services);
            }
            ++i;
        }
        return result;
    }

    public List getWsdlServicesFromWsilFile(IFile wsil) {
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        return serviceHelper.getWsdlServicesFromWsilFile(wsil);
    }

    public List getAllWSDLServices() {
        ArrayList result = new ArrayList();
        result.addAll(this.getInternalWSDLServices());
        result.addAll(this.getExternalWSDLServices());
        return result;
    }

    protected void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.releaseArtifactEdits();
        INSTANCE = null;
    }

    public Resource getWSDLResource(WebServiceDescription webService) {
        if (webService == null) {
            return null;
        }
        String wsdlFileName = webService.getWsdlFile();
        Resource res = null;
        IVirtualResource[] resources = ComponentCore.createResources((IResource)WorkbenchResourceHelper.getFile((EObject)webService));
        if (resources == null || resources.length == 0) {
            return res;
        }
        WSDDArtifactEdit artifactEdit = this.getExistingWSDDArtifactEdit(resources[0].getComponent().getProject());
        if (artifactEdit != null) {
            res = artifactEdit.getWsdlResource(wsdlFileName);
        }
        return res;
    }

    private WSDDArtifactEdit getExistingWSDDArtifactEdit(IProject project) {
        List wsEdits = this.getWSArtifactEdits();
        int i = 0;
        while (i < wsEdits.size()) {
            WSDDArtifactEdit edit = (WSDDArtifactEdit)((Object)wsEdits.get(i));
            if (edit != null && edit.getProject() != null && edit.getProject().equals((Object)project)) {
                return edit;
            }
            ++i;
        }
        return null;
    }

    private WSCDDArtifactEdit getExistingWSCDDArtifactEdit(IProject project) {
        List wsClientEdits = this.getWSClientArtifactEdits();
        int i = 0;
        while (i < wsClientEdits.size()) {
            WSCDDArtifactEdit edit = (WSCDDArtifactEdit)((Object)wsClientEdits.get(i));
            if (edit != null && edit.getProject() != null && edit.getProject().equals((Object)project)) {
                return edit;
            }
            ++i;
        }
        return null;
    }

    public List getWSDLServices(Resource wsdl) {
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        ArrayList<Object> result = new ArrayList();
        Object def = serviceHelper.getWSDLDefinition(wsdl);
        if (def == null) {
            return result;
        }
        result = new ArrayList(serviceHelper.getDefinitionServices(def).values());
        return result;
    }

    public EObject getWSDLServiceForWebService(WebServiceDescription webService) {
        EObject service = null;
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        Resource wsdl = this.getWSDLResource(webService);
        if (wsdl == null) {
            return service;
        }
        Object definition = serviceHelper.getWSDLDefinition(wsdl);
        if (definition == null) {
            return service;
        }
        Map services = serviceHelper.getDefinitionServices(definition);
        if (services.isEmpty()) {
            return service;
        }
        PortComponent portComp = null;
        if (webService.getPortComponents() != null && webService.getPortComponents().size() > 0) {
            portComp = (PortComponent)webService.getPortComponents().get(0);
            return this.getService(portComp);
        }
        return service;
    }

    public Resource getWSDLResource(EObject wsdlService) {
        return wsdlService.eResource();
    }

    public EObject getService(PortComponent port) {
        List services = this.getInternalWSDLServices();
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        int i = 0;
        while (i < services.size()) {
            EObject service = (EObject)services.get(i);
            if (serviceHelper.getServicePorts((Object)service).size() == 1) {
                Object wsdlPort = serviceHelper.getServicePorts((Object)service).values().toArray()[0];
                String qName = serviceHelper.getPortBindingNamespaceURI(wsdlPort);
                if (port.getWsdlPort().getNamespaceURI().equals(qName)) {
                    return service;
                }
            }
            ++i;
        }
        return null;
    }

    public PortComponent getPortComponent(String qName) {
        List wsDescs = this.getInternalWebServicesDescriptions();
        int i = 0;
        while (i < wsDescs.size()) {
            WebServiceDescription wsDesc = (WebServiceDescription)wsDescs.get(i);
            EList ports = wsDesc.getPortComponents();
            int j = 0;
            while (j < ports.size()) {
                PortComponent portComp = (PortComponent)ports.get(j);
                if (portComp.getWsdlPort().getNamespaceURI().equals(qName)) {
                    return portComp;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public PortComponent getPortComponent(String qName, IProject project) {
        List wsDescs = this.getInternalWebServicesDescriptions();
        int i = 0;
        while (i < wsDescs.size()) {
            WebServiceDescription wsDesc = (WebServiceDescription)wsDescs.get(i);
            EList ports = wsDesc.getPortComponents();
            int j = 0;
            while (j < ports.size()) {
                PortComponent portComp = (PortComponent)ports.get(j);
                if (project == ProjectUtilities.getProject((EObject)portComp)) {
                    return portComp;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public PortComponent getPortComponent(EObject wsdlService) {
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        if (wsdlService == null || serviceHelper.getServicePorts((Object)wsdlService).isEmpty()) {
            return null;
        }
        if (serviceHelper.getServicePorts((Object)wsdlService).size() == 1) {
            Object port = serviceHelper.getServicePorts((Object)wsdlService).values().toArray()[0];
            String qName = serviceHelper.getPortBindingNamespaceURI(port);
            return this.getPortComponent(qName, ProjectUtilities.getProject((EObject)wsdlService));
        }
        return null;
    }

    public ServiceImplBean getServiceImplBean(EObject wsdlService) {
        PortComponent port = this.getPortComponent(wsdlService);
        if (port == null) {
            return null;
        }
        return port.getServiceImplBean();
    }

    public WsddResource getWsddResource(EObject wsdlService) {
        PortComponent port = this.getPortComponent(wsdlService);
        if (port == null) {
            return null;
        }
        return (WsddResource)port.eResource();
    }

    public String getServiceEndpointInterface(EObject wsdlService) {
        PortComponent port = this.getPortComponent(wsdlService);
        if (port == null) {
            return null;
        }
        return port.getServiceEndpointInterface();
    }

    public List getAllWorkspaceServiceRefs() {
        ArrayList result = new ArrayList();
        result.addAll(this.getWorkspace13ServiceRefs());
        result.addAll(this.getWorkspace14ServiceRefs());
        return result;
    }

    public List getWorkspace13ServiceRefs() {
        ArrayList result = new ArrayList();
        Iterator iter = this.getWSClientArtifactEdits().iterator();
        while (iter.hasNext()) {
            WSCDDArtifactEdit artifactEdit = (WSCDDArtifactEdit)((Object)iter.next());
            WebServicesResource res = artifactEdit.getWscddXmiResource();
            if (res == null || !res.isLoaded() || res.getWebServicesClient() == null) continue;
            if (J2EEProjectUtilities.isEJBProject((IProject)artifactEdit.getProject())) {
                EList scopedBeans = res.getWebServicesClient().getComponentScopedRefs();
                Iterator iterator = scopedBeans.iterator();
                while (iterator.hasNext()) {
                    ComponentScopedRefs refBean = (ComponentScopedRefs)iterator.next();
                    result.addAll(refBean.getServiceRefs());
                }
                continue;
            }
            result.addAll(res.getWebServicesClient().getServiceRefs());
        }
        return result;
    }

    public List get13ServiceRefs(IProject handle) {
        WebServicesResource res;
        ArrayList result = new ArrayList();
        WSCDDArtifactEdit wsClientArtifactEdit = this.getExistingWSCDDArtifactEdit(handle);
        if (wsClientArtifactEdit != null && (res = wsClientArtifactEdit.getWscddXmiResource()) != null && res.isLoaded() && res.getWebServicesClient() != null) {
            result.addAll(res.getWebServicesClient().getServiceRefs());
        }
        return result;
    }

    public List getWorkspace14ServiceRefs() {
        return this.getWorkspace14ServiceRefs(this.getWSClientArtifactEdits());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getWorkspace14ServiceRefs(List wsClientArtifactEdits) {
        iter = wsClientArtifactEdits.iterator();
        result = new ArrayList<E>();
        while (true) {
            if (!iter.hasNext()) {
                return result;
            }
            wscArtifactEdit = (WSCDDArtifactEdit)iter.next();
            project = wscArtifactEdit.getProject();
            projectType = J2EEProjectUtilities.getJ2EEProjectType((IProject)project);
            projectVersion = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project);
            j2eeLevel = 0;
            if ("jst.ejb".equals(projectType)) {
                j2eeLevel = J2EEVersionUtil.convertEJBVersionStringToJ2EEVersionID((String)projectVersion);
            } else if ("jst.web".equals(projectType)) {
                j2eeLevel = J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)projectVersion);
            } else if ("jst.appclient".equals(projectType)) {
                j2eeLevel = J2EEVersionUtil.convertAppClientVersionStringToJ2EEVersionID((String)projectVersion);
            }
            if (j2eeLevel != 14) continue;
            artifactEdit = ArtifactEdit.getArtifactEditForRead((IProject)project);
            try {
                block17: {
                    block16: {
                        rootObject = null;
                        if (artifactEdit != null) {
                            rootObject = artifactEdit.getContentModelRoot();
                        }
                        if (!(rootObject instanceof EJBJar)) break block16;
                        cmps = ((EJBJar)rootObject).getEnterpriseBeans();
                        j = 0;
                        while (j < cmps.size()) {
                            bean = (EnterpriseBean)cmps.get(j);
                            if (bean.getServiceRefs() != null && !bean.getServiceRefs().isEmpty()) {
                                result.addAll(bean.getServiceRefs());
                            }
                            ++j;
                        }
                        ** GOTO lbl-1000
                    }
                    if (!(rootObject instanceof WebApp)) break block17;
                    if (((WebApp)rootObject).getServiceRefs() != null && !((WebApp)rootObject).getServiceRefs().isEmpty()) {
                        result.addAll(((WebApp)rootObject).getServiceRefs());
                    }
                    ** GOTO lbl-1000
                }
                if (rootObject instanceof ApplicationClient && ((ApplicationClient)rootObject).getServiceRefs() != null && !((ApplicationClient)rootObject).getServiceRefs().isEmpty()) {
                    result.addAll(((ApplicationClient)rootObject).getServiceRefs());
                }
            }
            catch (Throwable var15_15) {
                var14_14 = null;
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
                throw var15_15;
            }
lbl-1000:
            // 3 sources

            {
                var14_14 = null;
                if (artifactEdit == null) continue;
            }
            artifactEdit.dispose();
        }
    }

    public boolean isJ2EE14(ServiceRef ref) {
        return !(ref.eContainer() instanceof WebServicesClient);
    }

    public List getWorkspaceWSILFiles() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        Iterator iter = this.getWSArtifactEdits().iterator();
        while (iter.hasNext()) {
            WSDDArtifactEdit artifactEdit = (WSDDArtifactEdit)((Object)iter.next());
            List files = artifactEdit.getWSILResources();
            int j = 0;
            while (j < files.size()) {
                IFile file = (IFile)files.get(j);
                if (file != null && WSIL_EXT.equals(file.getFileExtension())) {
                    result.add(file);
                }
                ++j;
            }
        }
        return result;
    }

    public List getWorkspaceWSDLResources() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        Iterator iter = this.getWSArtifactEdits().iterator();
        while (iter.hasNext()) {
            List wsdlResources;
            WSDDArtifactEdit artifactEdit = (WSDDArtifactEdit)((Object)iter.next());
            IProject project = artifactEdit.getProject();
            if (project == null || (wsdlResources = artifactEdit.getWSDLResources()) == null || wsdlResources.isEmpty()) continue;
            int j = 0;
            while (j < wsdlResources.size()) {
                Resource wsdl = (Resource)wsdlResources.get(j);
                if (!result.contains(wsdl)) {
                    result.add(wsdl);
                }
                ++j;
            }
        }
        return result;
    }

    public List getWSDLServices() {
        ArrayList result = new ArrayList();
        List internalWsdls = this.getInternalWSDLServices();
        if (internalWsdls != null && !internalWsdls.isEmpty()) {
            result.addAll(internalWsdls);
        }
        return result;
    }

    public List get13ServiceRefs(EnterpriseBean bean) {
        WebServicesResource res;
        WSCDDArtifactEdit artifactEdit = null;
        IFile file = WorkbenchResourceHelper.getFile((EObject)bean);
        if (file != null) {
            artifactEdit = this.getExistingWSCDDArtifactEdit(file.getProject());
        }
        if (artifactEdit != null && (res = artifactEdit.getWscddXmiResource()) != null && res.getWebServicesClient() != null) {
            String ejbName = bean.getName();
            EList scopes = res.getWebServicesClient().getComponentScopedRefs();
            Iterator iter = scopes.iterator();
            while (iter.hasNext()) {
                ComponentScopedRefs scope = (ComponentScopedRefs)iter.next();
                if (!scope.getComponentName().equals(ejbName)) continue;
                return scope.getServiceRefs();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List get13ServiceRefs(ApplicationClient client) {
        WebServicesClient webClient;
        WebServicesResource res;
        IProject handle = this.getComponentProject(WorkbenchResourceHelper.getFile((EObject)client));
        if (handle == null) {
            return Collections.EMPTY_LIST;
        }
        WSCDDArtifactEdit artifactEdit = this.getExistingWSCDDArtifactEdit(handle);
        if (artifactEdit != null && (res = artifactEdit.getWscddXmiResource()) != null && (webClient = res.getWebServicesClient()) != null) {
            return webClient.getServiceRefs();
        }
        return Collections.EMPTY_LIST;
    }

    public List get13ServiceRefs(WebApp webapp) {
        WebServicesClient webClient;
        WebServicesResource res;
        IProject handle = this.getComponentProject(WorkbenchResourceHelper.getFile((EObject)webapp));
        if (handle == null) {
            return Collections.EMPTY_LIST;
        }
        WSCDDArtifactEdit artifactEdit = this.getExistingWSCDDArtifactEdit(handle);
        if (artifactEdit != null && (res = artifactEdit.getWscddXmiResource()) != null && (webClient = res.getWebServicesClient()) != null) {
            return webClient.getServiceRefs();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource.getType() == 4) {
            IProject p = (IProject)resource;
            if (delta.getKind() == 1 || (delta.getFlags() & 0x4000) != 0 && p.isAccessible()) {
                IVirtualComponent component = ComponentCore.createComponent((IProject)p);
                if (component != null && !J2EEProjectUtilities.isEARProject((IProject)p) && !J2EEProjectUtilities.isStaticWebProject((IProject)p)) {
                    ProcessProjectsWithWSDL job = new ProcessProjectsWithWSDL(p, 4);
                    job.setRule((ISchedulingRule)p);
                    job.schedule();
                    return false;
                }
            } else if (delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0 || delta.getKind() == 2) {
                this.removeArtifactEdit(p);
                return false;
            }
        } else if (resource.getType() == 1 && this.isInterrestedInFile((IFile)resource)) {
            if (delta.getKind() == 1 || (delta.getFlags() & 0x2000) != 0) {
                if (resource.getFileExtension().equals(WSDL_EXT)) {
                    this.addedWsdl((IFile)resource);
                } else if (resource.getFileExtension().equals(WSIL_EXT)) {
                    this.addedWsil((IFile)resource);
                } else if (resource.getName().equals("webservicesclient.xml") || resource.getName().equals("webservices.xml")) {
                    ProcessProjectsWithWSDL job = new ProcessProjectsWithWSDL(resource.getProject(), 6);
                    job.setRule((ISchedulingRule)resource.getProject());
                    job.schedule();
                }
            } else if ((delta.getKind() == 2 || (delta.getFlags() & 0x1000) != 0) && (resource.getFileExtension().equals(WSDL_EXT) || resource.getFileExtension().equals(WSIL_EXT))) {
                this.notifyListeners(7);
            }
            return false;
        }
        return true;
    }

    protected void addedWsdl(IFile wsdl) {
        if (!wsdl.exists()) {
            return;
        }
        IProject handle = this.getComponentProject(wsdl);
        if (handle != null) {
            this.addArtifactEdit(handle);
            this.notifyListeners(6);
        }
    }

    protected void addedWsil(IFile wsil) {
        if (!wsil.exists()) {
            return;
        }
        IProject handle = this.getComponentProject(wsil);
        if (handle != null) {
            this.addArtifactEdit(handle);
            this.notifyListeners(6);
        }
    }

    private IProject getComponentProject(IFile res) {
        if (res == null) {
            return null;
        }
        return res.getProject();
    }

    protected boolean isInterrestedInFile(IFile aFile) {
        if (aFile != null && aFile.getFileExtension() != null) {
            String extension = aFile.getFileExtension();
            return extension.equals(WSDL_EXT) || extension.equals(WSIL_EXT) || aFile.getName().equals("webservicesclient.xml") || aFile.getName().equals("webservices.xml");
        }
        return false;
    }

    private boolean isInterestedInResource(Resource res) {
        if (res instanceof WsddResource || res instanceof WebServicesResource) {
            return true;
        }
        if (res instanceof EJBResource || res instanceof WebAppResource || res instanceof ApplicationClientResource) {
            return ((XMLResource)res).getJ2EEVersionID() > 13;
        }
        return false;
    }

    public Collection getServiceRefs(EJBJar jar) {
        ArrayList list = new ArrayList();
        EList beans = jar.getEnterpriseBeans();
        try {
            int i = 0;
            while (i < beans.size()) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                list.addAll(this.getServiceRefs(bean));
                ++i;
            }
        }
        catch (Exception exception) {}
        return list;
    }

    public Collection getServiceRefs(EnterpriseBean bean) {
        ArrayList list = new ArrayList();
        if (bean.getEjbJar().getJ2EEVersionID() >= 14) {
            list.addAll(bean.getServiceRefs());
        } else {
            list.addAll(this.get13ServiceRefs(bean));
        }
        return list;
    }

    public Collection getServiceRefs(WebApp webapp) {
        ArrayList list = new ArrayList();
        try {
            if (webapp.getVersionID() >= 24) {
                list.addAll(webapp.getServiceRefs());
            } else {
                list.addAll(this.get13ServiceRefs(webapp));
            }
        }
        catch (Exception exception) {}
        return list;
    }

    public Collection getServiceRefs(ApplicationClient client) {
        ArrayList list = new ArrayList();
        try {
            if (client.getJ2EEVersionID() >= 14) {
                list.addAll(client.getServiceRefs());
            } else {
                list.addAll(this.get13ServiceRefs(client));
            }
        }
        catch (Exception exception) {}
        return list;
    }

    private class ProcessProjectsWithWSDL
    extends Job {
        private IProject currentProject;
        private int eventType;

        public ProcessProjectsWithWSDL(IProject p, int newEventType) {
            super("Loading artifact edit for project");
            this.currentProject = p;
            this.eventType = newEventType;
        }

        protected IStatus run(IProgressMonitor monitor) {
            WebServicesManager.this.addArtifactEdit(this.currentProject);
            WebServicesManager.this.notifyListeners(this.eventType);
            return Status.OK_STATUS;
        }
    }
}

