/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.contentassist.CompoundContentAssistProcessor;

public class StructuredContentAssistant
extends ContentAssistant {
    private static final String CONTENT_ASSIST_PROCESSOR_EXTENDED_ID = "contentassistprocessor";
    private Map fProcessors;
    private List fInstalledExtendedContentTypes;

    public void setContentAssistProcessor(IContentAssistProcessor processor, String partitionType) {
        if (this.fProcessors == null) {
            this.fProcessors = new HashMap();
        }
        CompoundContentAssistProcessor compoundProcessor = this.getExistingContentAssistProcessor(partitionType);
        if (processor == null && compoundProcessor != null) {
            compoundProcessor.dispose();
            this.fProcessors.remove(partitionType);
            compoundProcessor = null;
        }
        if (processor != null) {
            if (compoundProcessor == null) {
                compoundProcessor = new CompoundContentAssistProcessor();
            }
            compoundProcessor.add(processor);
            this.fProcessors.put(partitionType, compoundProcessor);
        }
        super.setContentAssistProcessor((IContentAssistProcessor)compoundProcessor, partitionType);
    }

    private CompoundContentAssistProcessor getExistingContentAssistProcessor(String partitionType) {
        CompoundContentAssistProcessor compoundContentAssistProcessor = null;
        IContentAssistProcessor processor = super.getContentAssistProcessor(partitionType);
        if (processor != null) {
            if (processor instanceof CompoundContentAssistProcessor) {
                compoundContentAssistProcessor = (CompoundContentAssistProcessor)processor;
            } else {
                throw new IllegalStateException("StructuredContentAssistant use CompoundContentAssistProcessor");
            }
        }
        return compoundContentAssistProcessor;
    }

    public IContentAssistProcessor getContentAssistProcessor(String partitionType) {
        if (this.fInstalledExtendedContentTypes == null || !this.fInstalledExtendedContentTypes.contains(partitionType)) {
            List processors = ExtendedConfigurationBuilder.getInstance().getConfigurations(CONTENT_ASSIST_PROCESSOR_EXTENDED_ID, partitionType);
            if (processors != null && !processors.isEmpty()) {
                Iterator iter = processors.iterator();
                while (iter.hasNext()) {
                    IContentAssistProcessor processor = (IContentAssistProcessor)iter.next();
                    this.setContentAssistProcessor(processor, partitionType);
                }
            }
            if (this.fInstalledExtendedContentTypes == null) {
                this.fInstalledExtendedContentTypes = new ArrayList();
            }
            this.fInstalledExtendedContentTypes.add(partitionType);
        }
        IContentAssistProcessor processor = super.getContentAssistProcessor(partitionType);
        return processor;
    }

    public void uninstall() {
        if (this.fProcessors != null && !this.fProcessors.isEmpty()) {
            Collection collection = this.fProcessors.values();
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                ((CompoundContentAssistProcessor)iter.next()).dispose();
            }
            this.fProcessors.clear();
        }
        if (this.fInstalledExtendedContentTypes != null) {
            this.fInstalledExtendedContentTypes.clear();
        }
        super.uninstall();
    }
}

