/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.jst.server.core.internal.RuntimeClasspathContainer;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.jst.server.core.internal.RuntimeComponentProviderWrapper;
import org.eclipse.jst.server.core.internal.RuntimeFacetMapping;
import org.eclipse.jst.server.core.internal.ServerProfiler;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JavaServerPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.jst.server.core";
    private static JavaServerPlugin singleton;
    private static List runtimeClasspathProviders;
    private static List runtimeComponentProviders;
    private static List runtimeFacetMappings;
    private static List serverProfilers;
    private static IRuntimeLifecycleListener runtimeListener;
    private BundleContext context;

    public JavaServerPlugin() {
        singleton = this;
    }

    public static JavaServerPlugin getInstance() {
        return singleton;
    }

    public void start(BundleContext context2) throws Exception {
        super.start(context2);
        this.context = context2;
        runtimeListener = new IRuntimeLifecycleListener(){

            public void runtimeAdded(IRuntime runtime) {
                JavaServerPlugin.this.handleRuntimeChange(runtime, 0);
            }

            public void runtimeChanged(IRuntime runtime) {
                JavaServerPlugin.this.handleRuntimeChange(runtime, 1);
            }

            public void runtimeRemoved(IRuntime runtime) {
                JavaServerPlugin.this.handleRuntimeChange(runtime, 2);
            }
        };
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)runtimeListener);
    }

    public void stop(BundleContext context2) throws Exception {
        ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)runtimeListener);
        super.stop(context2);
    }

    protected void handleRuntimeChange(IRuntime runtime) {
        this.handleRuntimeChange(runtime, 1);
    }

    protected void handleRuntimeChange(IRuntime runtime, int act) {
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        Trace.trace(Trace.FINEST, "Possible runtime change: " + runtime);
        RuntimeClasspathProviderWrapper rcpw = JavaServerPlugin.findRuntimeClasspathProvider(runtime.getRuntimeType());
        if (rcpw != null && (rcpw.hasRuntimeClasspathChanged(runtime) || act != 1)) {
            IPath serverContainerPath = new Path("org.eclipse.jst.server.core.container").append(rcpw.getId()).append(runtime.getId());
            class RebuildRuntimeReferencesJob
            extends Job {
                final /* synthetic */ JavaServerPlugin this$0;
                private final /* synthetic */ IPath val$serverContainerPath;
                private final /* synthetic */ IRuntime val$runtime;
                private final /* synthetic */ int val$act;
                private final /* synthetic */ RuntimeClasspathProviderWrapper val$rcpw;

                public RebuildRuntimeReferencesJob(JavaServerPlugin javaServerPlugin, IRuntime iRuntime, IPath iPath, int n, RuntimeClasspathProviderWrapper runtimeClasspathProviderWrapper) {
                    super(NLS.bind((String)Messages.updateClasspathContainers, (Object)iRuntime.getName()));
                    this.this$0 = javaServerPlugin;
                    this.val$runtime = iRuntime;
                    this.val$serverContainerPath = iPath;
                    this.val$act = n;
                    this.val$rcpw = runtimeClasspathProviderWrapper;
                }

                public boolean belongsTo(Object family) {
                    return "org.eclipse.wst.server.core".equals(family);
                }

                public IStatus run(IProgressMonitor monitor) {
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    if (projects != null) {
                        int size = projects.length;
                        int i = 0;
                        while (i < size) {
                            if (projects[i].isAccessible()) {
                                try {
                                    if (projects[i].isNatureEnabled("org.eclipse.jdt.core.javanature")) {
                                        IJavaProject javaProject = JavaCore.create((IProject)projects[i]);
                                        boolean found = false;
                                        IClasspathEntry[] ce = javaProject.getRawClasspath();
                                        int j = 0;
                                        while (j < ce.length) {
                                            if (ce[j].getEntryKind() == 5 && this.val$serverContainerPath.isPrefixOf(ce[j].getPath())) {
                                                found = true;
                                            }
                                            ++j;
                                        }
                                        Trace.trace(Trace.FINEST, "Classpath change on: " + projects[i] + " " + found);
                                        if (found) {
                                            IRuntime runtime2 = this.val$runtime;
                                            if (this.val$act == 2) {
                                                runtime2 = null;
                                            }
                                            RuntimeClasspathContainer container = new RuntimeClasspathContainer(projects[i], this.val$serverContainerPath, this.val$rcpw, runtime2, this.val$runtime.getId());
                                            JavaCore.setClasspathContainer((IPath)this.val$serverContainerPath, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Trace.trace(Trace.SEVERE, "Could not update classpath container", e);
                                }
                            }
                            ++i;
                        }
                    }
                    return Status.OK_STATUS;
                }
            }
            RebuildRuntimeReferencesJob job = new RebuildRuntimeReferencesJob(this, runtime, serverContainerPath, act, rcpw);
            job.schedule();
        }
    }

    private static void log(IStatus status) {
        JavaServerPlugin.getInstance().getLog().log(status);
    }

    public static void logWarning(String msg) {
        JavaServerPlugin.log((IStatus)new Status(2, PLUGIN_ID, 0, msg, null));
    }

    public static RuntimeClasspathProviderWrapper[] getRuntimeClasspathProviders() {
        if (runtimeClasspathProviders == null) {
            JavaServerPlugin.loadRuntimeClasspathProviders();
        }
        RuntimeClasspathProviderWrapper[] rth = new RuntimeClasspathProviderWrapper[runtimeClasspathProviders.size()];
        runtimeClasspathProviders.toArray(rth);
        return rth;
    }

    public static RuntimeClasspathProviderWrapper findRuntimeClasspathProvider(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeClasspathProviders == null) {
            JavaServerPlugin.loadRuntimeClasspathProviders();
        }
        Iterator iterator = runtimeClasspathProviders.iterator();
        while (iterator.hasNext()) {
            RuntimeClasspathProviderWrapper runtimeClasspathProvider = (RuntimeClasspathProviderWrapper)iterator.next();
            if (!runtimeClasspathProvider.supportsRuntimeType(runtimeType)) continue;
            return runtimeClasspathProvider;
        }
        return null;
    }

    public static RuntimeClasspathProviderWrapper findRuntimeClasspathProvider(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeClasspathProviders == null) {
            JavaServerPlugin.loadRuntimeClasspathProviders();
        }
        Iterator iterator = runtimeClasspathProviders.iterator();
        while (iterator.hasNext()) {
            RuntimeClasspathProviderWrapper runtimeClasspathProvider = (RuntimeClasspathProviderWrapper)iterator.next();
            if (!id.equals(runtimeClasspathProvider.getId())) continue;
            return runtimeClasspathProvider;
        }
        return null;
    }

    private static synchronized void loadRuntimeClasspathProviders() {
        if (runtimeClasspathProviders != null) {
            return;
        }
        Trace.trace(Trace.CONFIG, "->- Loading .runtimeClasspathProviders extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "runtimeClasspathProviders");
        int size = cf.length;
        ArrayList<RuntimeClasspathProviderWrapper> list = new ArrayList<RuntimeClasspathProviderWrapper>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new RuntimeClasspathProviderWrapper(cf[i]));
                Trace.trace(Trace.CONFIG, "  Loaded runtimeClasspathProviders: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load runtimeClasspathProviders: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        runtimeClasspathProviders = list;
        Trace.trace(Trace.CONFIG, "-<- Done loading .runtimeClasspathProviders extension point -<-");
    }

    public static RuntimeFacetMapping[] getRuntimeFacetMapping() {
        if (runtimeFacetMappings == null) {
            JavaServerPlugin.loadRuntimeFacetMapping();
        }
        RuntimeFacetMapping[] rfm = new RuntimeFacetMapping[runtimeFacetMappings.size()];
        runtimeFacetMappings.toArray(rfm);
        return rfm;
    }

    public static RuntimeComponentProviderWrapper findRuntimeComponentProvider(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeComponentProviders == null) {
            JavaServerPlugin.loadRuntimeComponentProviders();
        }
        Iterator iterator = runtimeComponentProviders.iterator();
        while (iterator.hasNext()) {
            RuntimeComponentProviderWrapper runtimeComponentProvider = (RuntimeComponentProviderWrapper)iterator.next();
            if (!runtimeComponentProvider.supportsRuntimeType(runtimeType)) continue;
            return runtimeComponentProvider;
        }
        return null;
    }

    private static synchronized void loadRuntimeComponentProviders() {
        if (runtimeComponentProviders != null) {
            return;
        }
        Trace.trace(Trace.CONFIG, "->- Loading .runtimeComponentProviders extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "internalRuntimeComponentProviders");
        int size = cf.length;
        ArrayList<RuntimeComponentProviderWrapper> list = new ArrayList<RuntimeComponentProviderWrapper>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new RuntimeComponentProviderWrapper(cf[i]));
                Trace.trace(Trace.CONFIG, "  Loaded runtimeComponentProviders: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load runtimeComponentProvider: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        runtimeComponentProviders = list;
        Trace.trace(Trace.CONFIG, "-<- Done loading .runtimeComponentProviders extension point -<-");
    }

    private static synchronized void loadRuntimeFacetMapping() {
        if (runtimeFacetMappings != null) {
            return;
        }
        Trace.trace(Trace.CONFIG, "->- Loading .runtimeFacetMapping extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "runtimeFacetMappings");
        int size = cf.length;
        ArrayList<RuntimeFacetMapping> list = new ArrayList<RuntimeFacetMapping>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new RuntimeFacetMapping(cf[i]));
                Trace.trace(Trace.CONFIG, "  Loaded runtimeFacetMapping: " + cf[i].getAttribute("runtimeTypeId"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load runtimeFacetMapping: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        runtimeFacetMappings = list;
        Trace.trace(Trace.CONFIG, "-<- Done loading .runtimeFacetMapping extension point -<-");
    }

    public static ServerProfiler[] getServerProfilers() {
        if (serverProfilers == null) {
            JavaServerPlugin.loadServerProfilers();
        }
        ServerProfiler[] sp = new ServerProfiler[serverProfilers.size()];
        serverProfilers.toArray(sp);
        return sp;
    }

    private static synchronized void loadServerProfilers() {
        if (serverProfilers != null) {
            return;
        }
        Trace.trace(Trace.CONFIG, "->- Loading .serverProfilers extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "serverProfilers");
        int size = cf.length;
        ArrayList<ServerProfiler> list = new ArrayList<ServerProfiler>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new ServerProfiler(cf[i]));
                Trace.trace(Trace.CONFIG, "  Loaded serverProfiler: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load serverProfiler: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        serverProfilers = list;
        Trace.trace(Trace.CONFIG, "-<- Done loading .serverProfilers extension point -<-");
    }

    protected void startContributor(IContributor contributor) {
        if (contributor == null) {
            return;
        }
        String name = contributor.getName();
        if (name == null) {
            return;
        }
        try {
            Bundle[] bundles = this.context.getBundles();
            int size = bundles.length;
            int i = 0;
            while (i < size) {
                if (name.equals(bundles[i].getSymbolicName())) {
                    bundles[i].loadClass("does.not.exist.Test");
                    return;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {}
    }
}

