/*
 *+------------------------------------------------------------------------+
 *| Licensed Materials - Property of IBM                                   |
 *| (C) Copyright IBM Corp. 2003.  All Rights Reserved.                    |
 *|                                                                        |
 *| US Government Users Restricted Rights - Use, duplication or disclosure |
 *| restricted by GSA ADP Schedule Contract with IBM Corp.                 |
 *+------------------------------------------------------------------------+
 */
package org.eclipse.wst.rdb.server.internal.ui.services;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.RefreshAction;

/**
 * @author ljulien
 */
public class ServerExplorerRefreshService implements IServerExplorerRefreshService
{
    public void refresh(Object objectToRefresh)
    {
        RefreshAction action = new RefreshAction();
        action.selectionChanged(null, new StructuredSelection(objectToRefresh));
        action.run();
    }
}