/*******************************************************************************
* Copyright (c) 2000, 2004 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
package org.eclipse.wst.rdb.internal.outputview;

/**
 * Represents a table row.
 */
public class ResultTableRow
{
   /** The values in our row. */
   protected Object[] values;
   
   /**
    * Constructs a row for a given number of columns. 
    * @param columnCount The number of columns.
    */
   public ResultTableRow(int columnCount)
   {
      values = new Object[columnCount];
   }
   
   /**
    * Constructs a row with given values.
    * @param values The data in this row.
    */
   public ResultTableRow(Object[] values)
   {
      this.values = values;
   }
   
   /**
    * Sets the value for this row at a given column.
    * @param value The data in the row for this column.
    * @param columnIndex The index of the column.
    */
   public void setColumn(Object value, int columnIndex)
   {
      values[columnIndex] = value;
   }
   
   /**
    * Gets the data for the row.
    * @return The data for the row.
    */
   public Object[] getColValues()
   {
      return values;
   }
   
   /** 
    * Gets the name of a given column.
    * @param columnIndex The index of the column.
    * @return The column name.
    */
   public String getColumnText(int columnIndex)
   {
      if (values[columnIndex] == null)
         return "";
      else
      {
    	  Object obj = values[columnIndex];
    	  if (obj instanceof IXMLResult)
    	  {    		  
    		  return ((IXMLResult)obj).getInitialValue(
    				  ResultTableViewer.MAXDISPLAYLENGTH + 1);    		  
    	  }
    	  else
    		  return (String) values[columnIndex];
      }         
   }
   
   /**
    * Gets the content of the entire XML document for a particular column
    * @param columnIndex the index of the column
    * @return the content of the document as a String
    */
   public String getXMLColumnContent(int columnIndex)
   {
	   Object obj = values[columnIndex];
	   if (obj instanceof IXMLResult)
	   {
		   return ((IXMLResult)obj).getEntireDocument();
	   }
	   return "";
   }
}

