/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.IDialogSettings;

public class UnusedCodeCleanUp
extends AbstractCleanUp {
    public static final int REMOVE_UNUSED_IMPORTS = 1;
    public static final int REMOVE_UNUSED_PRIVATE_CONSTRUCTORS = 2;
    public static final int REMOVE_UNUSED_PRIVATE_METHODS = 4;
    public static final int REMOVE_UNUSED_PRIVATE_FIELDS = 8;
    public static final int REMOVE_UNUSED_PRIVATE_TYPES = 16;
    public static final int REMOVE_UNUSED_LOCAL_VARIABLES = 32;
    private static final int DEFAULT_FLAG = 1;
    private static final String SECTION_NAME = "CleanUp_UnusedCode";

    public UnusedCodeCleanUp(int flag) {
        super(flag);
    }

    public UnusedCodeCleanUp(IDialogSettings settings) {
        super(UnusedCodeCleanUp.getSection(settings, SECTION_NAME), 1);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, this.isFlag(4), this.isFlag(2), this.isFlag(8), this.isFlag(16), this.isFlag(32), this.isFlag(1), false);
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, problems, this.isFlag(4), this.isFlag(2), this.isFlag(8), this.isFlag(16), this.isFlag(32), this.isFlag(1), false);
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (this.isFlag(1)) {
            options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
        }
        if (this.isFlag(30)) {
            options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
        }
        if (this.isFlag(32)) {
            options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        }
        return options;
    }

    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(UnusedCodeCleanUp.getSection(settings, SECTION_NAME));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isFlag(1)) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedImport_description);
        }
        if (this.isFlag(4)) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedMethod_description);
        }
        if (this.isFlag(2)) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedConstructor_description);
        }
        if (this.isFlag(16)) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedType_description);
        }
        if (this.isFlag(8)) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedField_description);
        }
        if (this.isFlag(32)) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedVariable_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (!this.isFlag(1)) {
            buf.append("import pack.Bar;\n");
        }
        buf.append("class Example {\n");
        if (!this.isFlag(16)) {
            buf.append("    private class Sub {}\n");
        }
        if (!this.isFlag(2)) {
            buf.append("    private Example() {}\n");
        }
        if (!this.isFlag(8)) {
            buf.append("    private int fField;\n");
        }
        if (!this.isFlag(4)) {
            buf.append("    private void foo() {}\n");
        }
        buf.append("    public void bar() {\n");
        if (!this.isFlag(32)) {
            buf.append("        int i= 10;\n");
        }
        buf.append("    }\n");
        buf.append("}\n");
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        UnusedCodeFix fix;
        if (this.isFlag(1) && (fix = UnusedCodeFix.createRemoveUnusedImportFix(compilationUnit, problem)) != null) {
            return true;
        }
        return (this.isFlag(4) || this.isFlag(2) || this.isFlag(16) || this.isFlag(8) || this.isFlag(32)) && (fix = UnusedCodeFix.createUnusedMemberFix(compilationUnit, problem)) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isFlag(1)) {
            int i = 0;
            while (i < problems.length) {
                int id = problems[i].getID();
                if (id == 268435844 || id == 268435842 || id == 0x10000181 || id == 268435843 || id == 268435846) {
                    ++result;
                }
                ++i;
            }
        }
        if (this.isFlag(4)) {
            result += this.getNumberOfProblems(problems, 603979894);
        }
        if (this.isFlag(2)) {
            result += this.getNumberOfProblems(problems, 603979910);
        }
        if (this.isFlag(16)) {
            result += this.getNumberOfProblems(problems, 553648135);
        }
        if (this.isFlag(8)) {
            result += this.getNumberOfProblems(problems, 570425421);
        }
        if (this.isFlag(32)) {
            result += this.getNumberOfProblems(problems, 536870973);
        }
        return result;
    }

    public int getDefaultFlag() {
        return 1;
    }
}

