/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.tags.TagSelectionArea;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;

public class TagAsVersionDialog
extends DetailsDialog {
    private static final int TAG_AREA_HEIGHT_HINT = 200;
    private ITagOperation operation;
    private Text tagText;
    private Button moveTagButton;
    private String tagName = "";
    private boolean moveTag = false;
    private TagSource tagSource;
    private TagSelectionArea tagArea;

    public TagAsVersionDialog(Shell parentShell, String title, ITagOperation operation) {
        super(parentShell, title);
        this.tagSource = operation.getTagSource();
        this.operation = operation;
    }

    protected void createMainDialogArea(Composite parent) {
        int width = this.convertHorizontalDLUsToPixels(350);
        Label label = SWTUtils.createLabel((Composite)parent, (String)CVSUIMessages.TagAction_enterTag);
        label.setLayoutData((Object)SWTUtils.createGridData((int)width, (int)-1, (boolean)true, (boolean)false));
        this.tagText = new Text(parent, 2052);
        this.tagText.setLayoutData((Object)SWTUtils.createHFillGridData());
        this.tagText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TagAsVersionDialog.this.tagName = TagAsVersionDialog.this.tagText.getText();
                TagAsVersionDialog.this.updateEnablements();
            }
        });
        this.moveTagButton = SWTUtils.createCheckBox((Composite)parent, (String)CVSUIMessages.TagAction_moveTag);
        this.moveTagButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagAsVersionDialog.this.moveTag = TagAsVersionDialog.this.moveTagButton.getSelection();
            }
        });
    }

    protected String getHelpContextId() {
        return "org.eclipse.team.cvs.ui.tag_as_version_dialog_context";
    }

    public boolean shouldMoveTag() {
        return this.moveTag;
    }

    protected Composite createDropDownDialogArea(Composite parent) {
        PixelConverter converter = SWTUtils.createDialogPixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)1));
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        composite.setLayoutData((Object)gridData);
        this.tagArea = new TagSelectionArea(this.getShell(), this.tagSource, 8, null);
        this.tagArea.setTagAreaLabel(CVSUIMessages.TagAction_existingVersions);
        this.tagArea.setIncludeFilterInputArea(false);
        this.tagArea.createArea(composite);
        this.tagArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                CVSTag tag;
                if (event.getProperty().equals("selectedTag")) {
                    CVSTag tag2 = TagAsVersionDialog.this.tagArea.getSelection();
                    if (tag2 != null) {
                        TagAsVersionDialog.this.tagText.setText(tag2.getName());
                    }
                } else if (event.getProperty().equals("openSelectedTag") && (tag = TagAsVersionDialog.this.tagArea.getSelection()) != null) {
                    TagAsVersionDialog.this.tagText.setText(tag.getName());
                    TagAsVersionDialog.this.okPressed();
                }
            }
        });
        return composite;
    }

    protected void updateEnablements() {
        String message = null;
        if (this.tagName.length() == 0) {
            message = "";
        } else {
            IStatus status = CVSTag.validateTagName((String)this.tagName);
            if (!status.isOK()) {
                message = status.getMessage();
            }
        }
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
        if (this.tagArea != null) {
            this.tagArea.setFilter(this.tagName);
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public ITagOperation getOperation() {
        this.operation.setTag(new CVSTag(this.tagName, 2));
        if (this.moveTag) {
            this.operation.moveTag();
        }
        return this.operation;
    }

    protected boolean isMainGrabVertical() {
        return false;
    }
}

