/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.buildpath.BuildPathSupport;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public final class JUnitAddLibraryProposal
implements IJavaCompletionProposal {
    private final IInvocationContext fContext;
    private final boolean fIsJunit4;
    private final int fRelevance;

    public JUnitAddLibraryProposal(boolean isJunit4, IInvocationContext context, int relevance) {
        this.fIsJunit4 = isJunit4;
        this.fContext = context;
        this.fRelevance = relevance;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void apply(IDocument document) {
        IJavaProject project = this.fContext.getCompilationUnit().getJavaProject();
        Shell shell = JUnitPlugin.getActiveWorkbenchShell();
        try {
            IClasspathEntry entry = null;
            entry = this.fIsJunit4 ? BuildPathSupport.getJUnit4ClasspathEntry() : BuildPathSupport.getJUnit3ClasspathEntry();
            if (entry != null) {
                JUnitAddLibraryProposal.addToClasspath(shell, project, entry, (IRunnableContext)new BusyIndicatorRunnableContext());
            }
            int offset = this.fContext.getSelectionOffset();
            int length = this.fContext.getSelectionLength();
            String s = document.get(offset, length);
            document.replace(offset, length, s);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)shell, (String)JUnitMessages.JUnitAddLibraryProposal_title, (String)JUnitMessages.JUnitAddLibraryProposal_cannotAdd, (IStatus)e.getStatus());
        }
        catch (BadLocationException badLocationException) {}
    }

    private static boolean addToClasspath(Shell shell, final IJavaProject project, IClasspathEntry entry, IRunnableContext context) throws JavaModelException {
        IClasspathEntry[] oldEntries = project.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].equals(entry)) {
                return true;
            }
            ++i;
        }
        int nEntries = oldEntries.length;
        final IClasspathEntry[] newEntries = new IClasspathEntry[nEntries + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, nEntries);
        newEntries[nEntries] = entry;
        try {
            context.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        project.setRawClasspath(newEntries, monitor);
                    }
                    catch (JavaModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                ErrorDialog.openError((Shell)shell, (String)JUnitMessages.JUnitAddLibraryProposal_title, (String)JUnitMessages.JUnitAddLibraryProposal_cannotAdd, (IStatus)((CoreException)t).getStatus());
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fContext.getSelectionOffset(), this.fContext.getSelectionLength());
    }

    public String getAdditionalProposalInfo() {
        if (this.fIsJunit4) {
            return JUnitMessages.JUnitAddLibraryProposal_junit4_info;
        }
        return JUnitMessages.JUnitAddLibraryProposal_info;
    }

    public String getDisplayString() {
        if (this.fIsJunit4) {
            return JUnitMessages.JUnitAddLibraryProposa_junit4_label;
        }
        return JUnitMessages.JUnitAddLibraryProposal_label;
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

