/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.launchConfigurations.AddVariableStringAction;
import org.eclipse.ant.internal.ui.launchConfigurations.AntHomeClasspathEntry;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntTargetsTab;
import org.eclipse.ant.internal.ui.launchConfigurations.EditAntHomeEntryAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveDownAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveUpAction;
import org.eclipse.jdt.internal.debug.ui.actions.RemoveAction;
import org.eclipse.jdt.internal.debug.ui.actions.RestoreDefaultEntriesAction;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathModel;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class AntClasspathTab
extends JavaClasspathTab {
    public boolean isShowBootpath() {
        return false;
    }

    protected void createPathButtons(Composite pathButtonComp) {
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new MoveUpAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new MoveDownAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new RemoveAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new AddJarAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new AddExternalJarAction((IClasspathViewer)this.fClasspathViewer, "JavaClasspathTab"));
        Button button = this.createButton(pathButtonComp, (RuntimeClasspathAction)new AddFolderAction((IClasspathViewer)this.fClasspathViewer));
        button.setText(AntLaunchConfigurationMessages.AntClasspathTab_0);
        this.createButton(pathButtonComp, new AddVariableStringAction((IClasspathViewer)this.fClasspathViewer));
        Object action = new RestoreDefaultEntriesAction((IClasspathViewer)this.fClasspathViewer, (JavaClasspathTab)this);
        this.createButton(pathButtonComp, (RuntimeClasspathAction)action);
        action.setEnabled(true);
        action = new EditAntHomeEntryAction((IClasspathViewer)this.fClasspathViewer, this);
        this.createButton(pathButtonComp, (RuntimeClasspathAction)action);
        action.setEnabled(true);
    }

    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            AntUtil.migrateToNewClasspathFormat(configuration);
        }
        catch (CoreException coreException) {}
        super.initializeFrom(configuration);
    }

    public void entriesChanged(IClasspathViewer viewer) {
        super.entriesChanged(viewer);
        ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
        int i = 0;
        while (i < tabs.length) {
            ILaunchConfigurationTab tab = tabs[i];
            if (tab instanceof AntTargetsTab) {
                ((AntTargetsTab)tab).setDirty(true);
            }
            ++i;
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid = super.isValid(launchConfig);
        if (!valid) {
            return false;
        }
        return this.validateAntHome();
    }

    private boolean validateAntHome() {
        ClasspathModel model = this.getModel();
        IClasspathEntry userEntry = model.getUserEntry();
        IClasspathEntry[] entries = userEntry.getEntries();
        int i = 0;
        while (i < entries.length) {
            ClasspathEntry entry = (ClasspathEntry)entries[i];
            IRuntimeClasspathEntry runtimeEntry = entry.getDelegate();
            if (runtimeEntry instanceof AntHomeClasspathEntry) {
                try {
                    ((AntHomeClasspathEntry)runtimeEntry).resolveAntHome();
                    break;
                }
                catch (CoreException ce) {
                    this.setErrorMessage(ce.getStatus().getMessage());
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

