/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.tools.ant.Target;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;

public class AntTargetNode
extends AntElementNode {
    private Target fTarget = null;
    private String fLabel = null;

    public AntTargetNode(Target target) {
        super("target");
        this.fTarget = target;
    }

    public String getLabel() {
        if (this.fLabel == null) {
            StringBuffer displayName = new StringBuffer(this.getTargetName());
            if (this.isDefaultTarget()) {
                displayName.append(AntModelMessages.AntTargetNode_2);
            }
            if (this.isExternal()) {
                this.appendEntityName(displayName);
            }
            this.fLabel = displayName.toString();
        }
        return this.fLabel;
    }

    public Target getTarget() {
        return this.fTarget;
    }

    public boolean isDefaultTarget() {
        String targetName = this.fTarget.getName();
        if (targetName == null) {
            return false;
        }
        return targetName.equals(this.fTarget.getProject().getDefaultTarget());
    }

    public boolean isInternal() {
        Target target = this.getTarget();
        return target.getDescription() == null && !this.isDefaultTarget();
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        ImageDescriptor base = null;
        base = this.isDefaultTarget() ? AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antDefaultTarget") : (this.getTarget().getDescription() == null ? AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antPrivateTarget") : AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antTarget"));
        return base;
    }

    public void reset() {
        super.reset();
        Hashtable currentTargets = this.fTarget.getProject().getTargets();
        if (currentTargets.get(this.fTarget.getName()) != null) {
            currentTargets.remove(this.fTarget.getName());
        }
    }

    public String checkDependencies() {
        Enumeration dependencies = this.fTarget.getDependencies();
        while (dependencies.hasMoreElements()) {
            String dependency = (String)dependencies.nextElement();
            if (this.fTarget.getProject().getTargets().get(dependency) != null) continue;
            return dependency;
        }
        return null;
    }

    public boolean collapseProjection() {
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("editor_folding_targets");
    }

    public String getTargetName() {
        String targetName = this.fTarget.getName();
        if (targetName == null) {
            targetName = "target";
            this.setProblemSeverity(1);
        }
        return targetName;
    }

    public boolean containsOccurrence(String identifier) {
        if (this.getTargetName().equals(identifier)) {
            return true;
        }
        Enumeration dependencies = this.fTarget.getDependencies();
        while (dependencies.hasMoreElements()) {
            String dependency = (String)dependencies.nextElement();
            if (!dependency.equals(identifier)) continue;
            return true;
        }
        if (identifier.startsWith("${") && identifier.endsWith("}")) {
            String ifString = this.fTarget.getIf();
            if (ifString != null && ifString.endsWith(identifier.substring(2, identifier.length() - 1))) {
                return true;
            }
            String unlessString = this.fTarget.getUnless();
            if (unlessString != null && unlessString.endsWith(identifier.substring(2, identifier.length() - 1))) {
                return true;
            }
        }
        return false;
    }

    public String getOccurrencesIdentifier() {
        return this.getTargetName();
    }

    public List computeIdentifierOffsets(String identifier) {
        String textToSearch = this.getAntModel().getText(this.getOffset(), this.getLength());
        if (textToSearch == null || textToSearch.length() == 0 || identifier.length() == 0) {
            return null;
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (this.getTargetName().equals(identifier)) {
            int nameOffset = textToSearch.indexOf("name");
            nameOffset = textToSearch.indexOf(identifier, nameOffset);
            results.add(new Integer(this.getOffset() + nameOffset));
        } else {
            String ifString = this.fTarget.getIf();
            if (ifString != null && ifString.endsWith(identifier)) {
                int ifOffset = textToSearch.indexOf("if");
                ifOffset = textToSearch.indexOf(identifier, ifOffset);
                results.add(new Integer(this.getOffset() + ifOffset));
            } else {
                String unlessString = this.fTarget.getUnless();
                if (unlessString != null && unlessString.endsWith(identifier)) {
                    int unlessOffset = textToSearch.indexOf("unless");
                    unlessOffset = textToSearch.indexOf(identifier, unlessOffset);
                    results.add(new Integer(this.getOffset() + unlessOffset));
                } else {
                    int dependsOffset = textToSearch.indexOf("depends");
                    while (dependsOffset > 0 && !Character.isWhitespace(textToSearch.charAt(dependsOffset - 1))) {
                        dependsOffset = textToSearch.indexOf("depends", dependsOffset + 1);
                    }
                    if (dependsOffset != -1) {
                        int dependsOffsetEnd = textToSearch.indexOf(34, dependsOffset += 7);
                        dependsOffsetEnd = textToSearch.indexOf(34, dependsOffsetEnd + 1);
                        while (dependsOffset < dependsOffsetEnd) {
                            if ((dependsOffset = textToSearch.indexOf(identifier, dependsOffset)) == -1 || dependsOffset > dependsOffsetEnd) break;
                            char delimiter = textToSearch.charAt(dependsOffset - 1);
                            if (delimiter == ',' || delimiter == '\"' || delimiter == ' ') {
                                results.add(new Integer(this.getOffset() + dependsOffset));
                            }
                            dependsOffset += identifier.length();
                        }
                    }
                }
            }
        }
        return results;
    }

    public boolean isRegionPotentialReference(IRegion region) {
        boolean superOK = super.isRegionPotentialReference(region);
        if (!superOK) {
            return false;
        }
        String textToSearch = this.getAntModel().getText(this.getOffset(), this.getLength());
        if (textToSearch == null) {
            return false;
        }
        if (this.checkReferenceRegion(region, textToSearch, "depends")) {
            return true;
        }
        if (this.checkReferenceRegion(region, textToSearch, "name")) {
            return true;
        }
        if (this.checkReferenceRegion(region, textToSearch, "if")) {
            return true;
        }
        return this.checkReferenceRegion(region, textToSearch, "unless");
    }

    public boolean isFromDeclaration(IRegion region) {
        String textToSearch = this.getAntModel().getText(this.getOffset(), this.getLength());
        if (textToSearch == null || textToSearch.length() == 0) {
            return false;
        }
        return this.checkReferenceRegion(region, textToSearch, "name");
    }
}

