/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;

public class WebappResources {
    private static HashMap resourceBundleTable = new HashMap();

    public static String getString(String name, Locale locale) {
        ResourceBundle bundle = WebappResources.getBundle(locale);
        if (bundle == null) {
            return name;
        }
        try {
            return bundle.getString(name);
        }
        catch (MissingResourceException missingResourceException) {
            return name;
        }
    }

    public static String getString(String name, Locale locale, String replace0) {
        ResourceBundle bundle = WebappResources.getBundle(locale);
        if (bundle == null) {
            return name;
        }
        try {
            String stringFromPropertiesFile = bundle.getString(name);
            stringFromPropertiesFile = MessageFormat.format(stringFromPropertiesFile, replace0);
            return stringFromPropertiesFile;
        }
        catch (Exception exception) {
            return name;
        }
    }

    private static ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle;
        if (locale == null) {
            locale = WebappResources.getDefaultLocale();
        }
        if ((bundle = (ResourceBundle)resourceBundleTable.get(locale)) == null && (bundle = ResourceBundle.getBundle(WebappResources.class.getName(), locale)) != null) {
            resourceBundleTable.put(locale, bundle);
        }
        return bundle;
    }

    private static Locale getDefaultLocale() {
        String nl = Platform.getNL();
        if (nl == null) {
            return Locale.getDefault();
        }
        StringTokenizer locales = new StringTokenizer(nl, "_");
        if (locales.countTokens() == 1) {
            return new Locale(locales.nextToken(), "");
        }
        if (locales.countTokens() == 2) {
            return new Locale(locales.nextToken(), locales.nextToken());
        }
        if (locales.countTokens() == 3) {
            return new Locale(locales.nextToken(), locales.nextToken(), locales.nextToken());
        }
        return Locale.getDefault();
    }
}

