/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.JavaObjectValueEditor;
import org.eclipse.jdt.internal.debug.ui.actions.JavaPrimitiveValueEditor;
import org.eclipse.swt.widgets.Shell;

public class JavaVariableValueEditor
implements IVariableValueEditor {
    public boolean editVariable(IVariable variable, Shell shell) {
        String signature = null;
        try {
            signature = JavaVariableValueEditor.getSignature(variable);
        }
        catch (DebugException e) {
            DebugUIPlugin.errorDialog((Shell)shell, (String)ActionMessages.JavaVariableValueEditor_0, (String)ActionMessages.JavaVariableValueEditor_1, (Throwable)e);
        }
        if (signature == null) {
            return false;
        }
        Object editor = JDIModelPresentation.isObjectValue(signature) ? new JavaObjectValueEditor() : new JavaPrimitiveValueEditor(signature);
        return editor.editVariable(variable, shell);
    }

    public boolean saveVariable(IVariable variable, String expression, Shell shell) {
        try {
            if (JDIModelPresentation.isObjectValue(JavaVariableValueEditor.getSignature(variable))) {
                JavaObjectValueEditor editor = new JavaObjectValueEditor();
                return editor.saveVariable(variable, expression, shell);
            }
        }
        catch (DebugException e) {
            DebugUIPlugin.errorDialog((Shell)shell, (String)ActionMessages.JavaVariableValueEditor_0, (String)ActionMessages.JavaVariableValueEditor_1, (Throwable)e);
        }
        return false;
    }

    public static String getSignature(IVariable variable) throws DebugException {
        String signature = null;
        IJavaVariable javaVariable = (IJavaVariable)variable.getAdapter(IJavaVariable.class);
        if (javaVariable != null) {
            signature = javaVariable.getSignature();
        }
        return signature;
    }
}

