/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiffEntry;
import org.eclipse.jface.internal.databinding.provisional.observable.set.SetDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.value.ValueDiff;

public class Diffs {
    public static ListDiff computeListDiff(List oldList, List newList) {
        ArrayList<ListDiffEntry> diffEntries = new ArrayList<ListDiffEntry>();
        for (Object oldElement : oldList) {
            diffEntries.add(Diffs.createListDiffEntry(0, false, oldElement));
        }
        int i = 0;
        for (Object newElement : newList) {
            diffEntries.add(Diffs.createListDiffEntry(i++, true, newElement));
        }
        ListDiff listDiff = Diffs.createListDiff(diffEntries.toArray(new ListDiffEntry[diffEntries.size()]));
        return listDiff;
    }

    public static final boolean equals(Object left, Object right) {
        return left == null ? right == null : right != null && left.equals(right);
    }

    public static SetDiff computeSetDiff(Set oldSet, Set newSet) {
        HashSet additions = new HashSet(newSet);
        additions.removeAll(oldSet);
        HashSet removals = new HashSet(oldSet);
        removals.removeAll(newSet);
        return Diffs.createSetDiff(additions, removals);
    }

    public static ValueDiff createValueDiff(final Object oldValue, final Object newValue) {
        return new ValueDiff(){

            public Object getOldValue() {
                return oldValue;
            }

            public Object getNewValue() {
                return newValue;
            }
        };
    }

    public static SetDiff createSetDiff(Set additions, Set removals) {
        final Set unmodifiableAdditions = Collections.unmodifiableSet(additions);
        final Set unmodifiableRemovals = Collections.unmodifiableSet(removals);
        return new SetDiff(){

            public Set getAdditions() {
                return unmodifiableAdditions;
            }

            public Set getRemovals() {
                return unmodifiableRemovals;
            }
        };
    }

    public static ListDiff createListDiff(ListDiffEntry difference) {
        return Diffs.createListDiff(new ListDiffEntry[]{difference});
    }

    public static ListDiff createListDiff(ListDiffEntry difference1, ListDiffEntry difference2) {
        return Diffs.createListDiff(new ListDiffEntry[]{difference1, difference2});
    }

    public static ListDiff createListDiff(final ListDiffEntry[] differences) {
        return new ListDiff(){

            public ListDiffEntry[] getDifferences() {
                return differences;
            }
        };
    }

    public static ListDiffEntry createListDiffEntry(final int position, final boolean isAddition, final Object element) {
        return new ListDiffEntry(){

            public int getPosition() {
                return position;
            }

            public boolean isAddition() {
                return isAddition;
            }

            public Object getElement() {
                return element;
            }
        };
    }
}

