/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.scripting;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ApplyRefactoringScriptWizard;
import org.eclipse.ltk.internal.ui.refactoring.scripting.RefactoringScriptLocationControl;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ScriptingMessages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public final class ApplyRefactoringScriptWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "ApplyRefactoringScriptWizardPage";
    private RefactoringScriptLocationControl fLocationControl = null;
    private final ApplyRefactoringScriptWizard fWizard;

    public ApplyRefactoringScriptWizardPage(ApplyRefactoringScriptWizard wizard) {
        super(PAGE_NAME);
        Assert.isNotNull((Object)((Object)wizard));
        this.fWizard = wizard;
        this.setTitle(ScriptingMessages.ApplyRefactoringScriptWizard_title);
        this.setDescription(ScriptingMessages.ApplyRefactoringScriptWizard_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        Group group = new Group(composite, 0);
        group.setText(ScriptingMessages.ApplyRefactoringScriptWizardPage_location_caption);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.fLocationControl = new RefactoringScriptLocationControl((IWizard)this.fWizard, (Composite)group){

            protected final void handleClipboardScriptChanged() {
                super.handleClipboardScriptChanged();
                ApplyRefactoringScriptWizardPage.this.fWizard.setRefactoringHistory(null);
                ApplyRefactoringScriptWizardPage.this.setErrorMessage(null);
                ApplyRefactoringScriptWizardPage.this.setPageComplete(true);
                ApplyRefactoringScriptWizardPage.this.handleClipboardChanged();
            }

            protected final void handleExternalLocationChanged() {
                super.handleExternalLocationChanged();
                ApplyRefactoringScriptWizardPage.this.fWizard.setRefactoringHistory(null);
                ApplyRefactoringScriptWizardPage.this.setErrorMessage(null);
                ApplyRefactoringScriptWizardPage.this.setPageComplete(true);
                ApplyRefactoringScriptWizardPage.this.handleLocationChanged();
            }
        };
        this.setPageComplete(false);
        this.fLocationControl.loadHistory();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.refactoring_apply_script_page");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleClipboardChanged() {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.fLocationControl.getDisplay());
            Object contents = clipboard.getContents((Transfer)TextTransfer.getInstance());
            if (contents == null) {
                this.setErrorMessage(ScriptingMessages.ApplyRefactoringScriptWizardPage_empty_clipboard);
                this.setPageComplete(false);
                return;
            }
            if (contents instanceof String) {
                String script = (String)contents;
                try {
                    ByteArrayInputStream stream = new ByteArrayInputStream(script.getBytes("utf-8"));
                    this.fWizard.setRefactoringHistory(RefactoringCore.getHistoryService().readRefactoringHistory((InputStream)stream, 0));
                    return;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return;
                }
                catch (CoreException coreException) {
                    this.setErrorMessage(ScriptingMessages.ApplyRefactoringScriptWizardPage_no_script_clipboard);
                    this.setPageComplete(false);
                    return;
                }
            }
            this.setErrorMessage(ScriptingMessages.ApplyRefactoringScriptWizardPage_no_text_clipboard);
            this.setPageComplete(false);
            return;
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleLocationChanged() {
        block17: {
            uri = this.fLocationControl.getRefactoringScript();
            if (uri == null) {
                this.setErrorMessage(ScriptingMessages.ApplyRefactoringScriptWizardPage_invalid_location);
                this.setPageComplete(false);
                return;
            }
            file = new File(uri);
            if (!file.exists()) {
                this.setErrorMessage(ScriptingMessages.ApplyRefactoringScriptWizardPage_invalid_script_file);
                this.setPageComplete(false);
                return;
            }
            stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                this.fWizard.setRefactoringHistory(RefactoringCore.getHistoryService().readRefactoringHistory(stream, 0));
            }
            catch (IOException v0) {
                this.setErrorMessage(ScriptingMessages.ApplyRefactoringScriptWizardPage_error_cannot_read);
                this.setPageComplete(false);
lbl20:
                // 2 sources

                while (true) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException v1) {}
                    }
                    return;
                }
            }
            catch (CoreException v2) {
                try {
                    this.setErrorMessage(ScriptingMessages.ApplyRefactoringScriptWizardPage_invalid_format);
                    this.setPageComplete(false);
                    ** continue;
                }
                catch (Throwable var4_4) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException v3) {}
                    }
                    throw var4_4;
                }
            }
            if (stream == null) break block17;
            try {
                stream.close();
            }
            catch (IOException v4) {}
        }
    }

    public void performFinish() {
        this.fLocationControl.saveHistory();
    }

    public void setVisible(boolean visible) {
        URI uri;
        if (visible && (uri = this.fWizard.getRefactoringScript()) != null) {
            this.fWizard.setRefactoringScript(null);
            try {
                this.fLocationControl.setRefactoringScript(uri);
                this.handleLocationChanged();
            }
            catch (IllegalArgumentException exception) {
                RefactoringUIPlugin.log(exception);
            }
        }
        super.setVisible(visible);
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }
}

