/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.EditorAreaHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class WorkbookEditorsAction
extends Action
implements ActionFactory.IWorkbenchAction,
IPageListener,
IPartListener {
    private IWorkbenchWindow workbenchWindow;

    public WorkbookEditorsAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.WorkbookEditorsAction_label);
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setActionDefinitionId("org.eclipse.ui.window.openEditorDropDown");
        this.workbenchWindow.addPageListener(this);
        this.workbenchWindow.getPartService().addPartListener(this);
        this.updateState();
    }

    public void run() {
        WorkbenchPage wbp;
        EditorAreaHelper eah;
        if (this.workbenchWindow == null) {
            return;
        }
        IWorkbenchPage page = this.workbenchWindow.getActivePage();
        if (page != null && (eah = (wbp = (WorkbenchPage)page).getEditorPresentation()) != null) {
            eah.displayEditorList();
        }
    }

    public void dispose() {
        this.workbenchWindow.removePageListener(this);
        this.workbenchWindow.getPartService().removePartListener(this);
        this.workbenchWindow = null;
    }

    public void updateState() {
        IWorkbenchPage page = null;
        if (this.workbenchWindow != null) {
            page = this.workbenchWindow.getActivePage();
        }
        if (page == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(page.getEditorReferences().length >= 1);
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        this.updateState();
    }

    public void pageOpened(IWorkbenchPage page) {
        this.updateState();
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.updateState();
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        this.updateState();
    }
}

