/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NamedHandleObject;
import org.eclipse.core.commands.common.NamedHandleObjectComparator;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeySequenceText;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.NamedHandleObjectLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.ICommandImageService;
import org.eclipse.ui.internal.keys.ImageFactory;
import org.eclipse.ui.internal.keys.NewKeysPreferenceMessages;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.IBindingService;

public final class NewKeysPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int GROUPING_CATEGORY = 0;
    private static final int GROUPING_CONTEXT = 1;
    private static final int GROUPING_NONE = 2;
    private static final String ICON_GROUP_OF_BINDINGS = "$nl$/icons/full/obj16/keygroups_obj.gif";
    private static final int ITEMS_TO_SHOW = 7;
    private static final NamedHandleObjectComparator NAMED_HANDLE_OBJECT_COMPARATOR = new NamedHandleObjectComparator();
    private IBindingService bindingService;
    private Text bindingText;
    private ICommandImageService commandImageService;
    private Label commandNameValueLabel;
    private ICommandService commandService;
    private IContextService contextService;
    private Label descriptionValueLabel;
    private GroupedFilteredTree filteredTree;
    private int grouping = 2;
    private KeySequenceText keySequenceText;
    private BindingManager localChangeManager;
    private String markedContextId = null;
    private ParameterizedCommand markedParameterizedCommand = null;
    private ComboViewer schemeCombo = null;
    private Button showAllCheckBox = null;
    private ComboViewer whenCombo = null;

    private static final NamedHandleObject[] sortByName(NamedHandleObject[] objects) {
        Arrays.sort(objects, NAMED_HANDLE_OBJECT_COMPARATOR);
        return objects;
    }

    private final void bindingAdd(Binding binding) {
        this.markedParameterizedCommand = binding.getParameterizedCommand();
        this.markedContextId = binding.getContextId();
        this.update();
        this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)new BindingTreeNode(this.markedParameterizedCommand)), true);
        this.bindingText.setFocus();
        this.bindingText.selectAll();
    }

    private final void bindingRemove(KeyBinding binding) {
        String contextId = binding.getContextId();
        String schemeId = binding.getSchemeId();
        KeySequence triggerSequence = binding.getKeySequence();
        this.localChangeManager.removeBindings((TriggerSequence)triggerSequence, schemeId, contextId, null, null, null, 1);
        this.localChangeManager.addBinding((Binding)new KeyBinding(triggerSequence, null, schemeId, contextId, null, null, null, 1));
        this.update();
    }

    private final Control createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        buttonBar.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        buttonBar.setLayoutData((Object)gridData);
        Button advancedButton = new Button(buttonBar, 8);
        gridData = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        advancedButton.setText(NewKeysPreferenceMessages.AdvancedButton_Text);
        gridData.widthHint = Math.max(widthHint, advancedButton.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        advancedButton.setLayoutData((Object)gridData);
        return buttonBar;
    }

    protected final Control createContents(Composite parent) {
        GridLayout layout = null;
        Composite page = new Composite(parent, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        page.setLayout((Layout)layout);
        this.createSchemeControls(page);
        this.createTree(page);
        this.createTreeControls(page);
        this.createDataControls(page);
        this.createButtonBar(page);
        this.fill();
        this.update();
        return page;
    }

    private final Control createDataControls(Composite parent) {
        final Composite dataArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        dataArea.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        dataArea.setLayoutData((Object)gridData);
        Composite leftDataArea = new Composite(dataArea, 0);
        layout = new GridLayout(3, false);
        leftDataArea.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 128;
        gridData.horizontalAlignment = 4;
        leftDataArea.setLayoutData((Object)gridData);
        Label commandNameLabel = new Label(leftDataArea, 0);
        commandNameLabel.setText(NewKeysPreferenceMessages.CommandNameLabel_Text);
        this.commandNameValueLabel = new Label(leftDataArea, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.commandNameValueLabel.setLayoutData((Object)gridData);
        Label bindingLabel = new Label(leftDataArea, 0);
        bindingLabel.setText(NewKeysPreferenceMessages.BindingLabel_Text);
        this.bindingText = new Text(leftDataArea, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 200;
        this.bindingText.setLayoutData((Object)gridData);
        this.keySequenceText = new KeySequenceText(this.bindingText);
        this.keySequenceText.setKeyStrokeLimit(4);
        this.keySequenceText.addPropertyChangeListener(new IPropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent event) {
                if (!event.getOldValue().equals(event.getNewValue())) {
                    NewKeysPreferencePage.this.keySequenceChanged();
                }
            }
        });
        final Button addKeyButton = new Button(leftDataArea, 16388);
        addKeyButton.setToolTipText(NewKeysPreferenceMessages.AddKeyButton_ToolTipText);
        gridData = new GridData();
        gridData.heightHint = this.schemeCombo.getCombo().getTextHeight();
        addKeyButton.setLayoutData((Object)gridData);
        Control[] tabStops = dataArea.getTabList();
        ArrayList<Object> newTabStops = new ArrayList<Object>();
        int i = 0;
        while (i < tabStops.length) {
            Control tabStop = tabStops[i];
            newTabStops.add(tabStop);
            if (this.bindingText.equals(tabStop)) {
                newTabStops.add(addKeyButton);
            }
            ++i;
        }
        Control[] newTabStopArray = newTabStops.toArray(new Control[newTabStops.size()]);
        dataArea.setTabList(newTabStopArray);
        final Menu addKeyMenu = new Menu((Control)addKeyButton);
        for (final KeyStroke trappedKey : KeySequenceText.TRAPPED_KEYS) {
            MenuItem menuItem = new MenuItem(addKeyMenu, 8);
            menuItem.setText(trappedKey.format());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewKeysPreferencePage.this.keySequenceText.insert(trappedKey);
                    NewKeysPreferencePage.this.bindingText.setFocus();
                    NewKeysPreferencePage.this.bindingText.setSelection(NewKeysPreferencePage.this.bindingText.getTextLimit());
                }
            });
        }
        addKeyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Point buttonLocation = addKeyButton.getLocation();
                buttonLocation = dataArea.toDisplay(buttonLocation.x, buttonLocation.y);
                Point buttonSize = addKeyButton.getSize();
                addKeyMenu.setLocation(buttonLocation.x, buttonLocation.y + buttonSize.y);
                addKeyMenu.setVisible(true);
            }
        });
        Label whenLabel = new Label(leftDataArea, 0);
        whenLabel.setText(NewKeysPreferenceMessages.WhenLabel_Text);
        this.whenCombo = new ComboViewer(leftDataArea);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.whenCombo.getCombo().setLayoutData((Object)gridData);
        this.whenCombo.setLabelProvider((IBaseLabelProvider)new NamedHandleObjectLabelProvider());
        this.whenCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite rightDataArea = new Composite(dataArea, 0);
        layout = new GridLayout(1, false);
        rightDataArea.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 128;
        gridData.horizontalAlignment = 4;
        rightDataArea.setLayoutData((Object)gridData);
        Label descriptionLabel = new Label(rightDataArea, 0);
        descriptionLabel.setText(NewKeysPreferenceMessages.DescriptionLabel_Text);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        descriptionLabel.setLayoutData((Object)gridData);
        this.descriptionValueLabel = new Label(rightDataArea, 64);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalIndent = 30;
        gridData.verticalIndent = 5;
        gridData.widthHint = 200;
        this.descriptionValueLabel.setLayoutData((Object)gridData);
        return dataArea;
    }

    private final Control createSchemeControls(Composite parent) {
        Composite schemeControls = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        schemeControls.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        schemeControls.setLayoutData((Object)gridData);
        Label schemeLabel = new Label(schemeControls, 0);
        schemeLabel.setText(NewKeysPreferenceMessages.SchemeLabel_Text);
        this.schemeCombo = new ComboViewer(schemeControls);
        this.schemeCombo.setLabelProvider((IBaseLabelProvider)new NamedHandleObjectLabelProvider());
        this.schemeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.schemeCombo.getCombo().setLayoutData((Object)gridData);
        this.schemeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public final void selectionChanged(SelectionChangedEvent event) {
                NewKeysPreferencePage.this.selectSchemeCombo(event);
            }
        });
        Button deleteSchemeButton = new Button(schemeControls, 8);
        gridData = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        deleteSchemeButton.setText(NewKeysPreferenceMessages.DeleteSchemeButton_Text);
        gridData.widthHint = Math.max(widthHint, deleteSchemeButton.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        deleteSchemeButton.setLayoutData((Object)gridData);
        return schemeControls;
    }

    private final Control createTree(Composite parent) {
        this.filteredTree = new GroupedFilteredTree(parent, 2052, new PatternFilter());
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        this.filteredTree.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.filteredTree.setLayoutData(gridData);
        Tree tree = this.filteredTree.getViewer().getTree();
        tree.setHeaderVisible(true);
        Object layoutData = tree.getLayoutData();
        if (layoutData instanceof GridData) {
            gridData = (GridData)layoutData;
            int itemHeight = tree.getItemHeight();
            if (itemHeight > 1) {
                gridData.heightHint = 7 * itemHeight;
            }
        }
        TreeColumn commandNameColumn = new TreeColumn(tree, 16384, 0);
        commandNameColumn.setText(NewKeysPreferenceMessages.CommandNameColumn_Text);
        TreeColumn triggerSequenceColumn = new TreeColumn(tree, 16384, 1);
        triggerSequenceColumn.setText(NewKeysPreferenceMessages.TriggerSequenceColumn_Text);
        new TreeColumn(tree, 16384, 2);
        new TreeColumn(tree, 16384, 3);
        TreeViewer viewer = this.filteredTree.getViewer();
        viewer.setLabelProvider((IBaseLabelProvider)new BindingLabelProvider());
        viewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        viewer.setSorter((ViewerSorter)new BindingSorter());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public final void selectionChanged(SelectionChangedEvent event) {
                NewKeysPreferencePage.this.selectTreeRow(event);
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public final void mouseDown(MouseEvent event) {
                NewKeysPreferencePage.this.selectTreeColumn(event);
            }
        });
        this.filteredTree.getPatternFilter().setIncludeLeadingWildcard(true);
        Combo groupingCombo = this.filteredTree.getGroupingCombo();
        String[] groupings = new String[]{NewKeysPreferenceMessages.GroupingCombo_Category_Text, NewKeysPreferenceMessages.GroupingCombo_When_Text, NewKeysPreferenceMessages.GroupingCombo_None_Text};
        Collator collator = Collator.getInstance();
        Arrays.sort(groupings, collator);
        groupingCombo.setItems(groupings);
        groupingCombo.setText(NewKeysPreferenceMessages.GroupingCombo_None_Text);
        groupingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewKeysPreferencePage.this.update();
            }
        });
        return this.filteredTree;
    }

    private final Control createTreeControls(Composite parent) {
        Composite treeControls = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        treeControls.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        treeControls.setLayoutData((Object)gridData);
        this.showAllCheckBox = new Button(treeControls, 32);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        this.showAllCheckBox.setLayoutData((Object)gridData);
        this.showAllCheckBox.setText(NewKeysPreferenceMessages.ShowAllCheckBox_Text);
        this.showAllCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewKeysPreferencePage.this.updateTree();
            }
        });
        Button addBindingButton = new Button(treeControls, 8);
        gridData = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        addBindingButton.setText(NewKeysPreferenceMessages.AddBindingButton_Text);
        gridData.widthHint = Math.max(widthHint, addBindingButton.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        addBindingButton.setLayoutData((Object)gridData);
        addBindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                NewKeysPreferencePage.this.selectAddBindingButton(event);
            }
        });
        Button removeBindingButton = new Button(treeControls, 8);
        gridData = new GridData();
        widthHint = this.convertHorizontalDLUsToPixels(61);
        removeBindingButton.setText(NewKeysPreferenceMessages.RemoveBindingButton_Text);
        gridData.widthHint = Math.max(widthHint, removeBindingButton.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        removeBindingButton.setLayoutData((Object)gridData);
        removeBindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                NewKeysPreferencePage.this.selectRemoveBindingButton(event);
            }
        });
        return treeControls;
    }

    private final void fill() {
        this.localChangeManager = new BindingManager(new ContextManager(), new CommandManager());
        Scheme[] definedSchemes = this.bindingService.getDefinedSchemes();
        try {
            int i = 0;
            while (i < definedSchemes.length) {
                Scheme scheme = definedSchemes[i];
                Scheme copy = this.localChangeManager.getScheme(scheme.getId());
                copy.define(scheme.getName(), scheme.getDescription(), scheme.getParentId());
                ++i;
            }
            this.localChangeManager.setActiveScheme(this.bindingService.getActiveScheme());
        }
        catch (NotDefinedException notDefinedException) {
            throw new Error("There is a programmer error in the keys preference page");
        }
        this.localChangeManager.setLocale(this.bindingService.getLocale());
        this.localChangeManager.setPlatform(this.bindingService.getPlatform());
        this.localChangeManager.setBindings(this.bindingService.getBindings());
        this.schemeCombo.setInput((Object)NewKeysPreferencePage.sortByName((NamedHandleObject[])this.localChangeManager.getDefinedSchemes()));
        this.setScheme(this.localChangeManager.getActiveScheme());
        this.whenCombo.setInput((Object)NewKeysPreferencePage.sortByName((NamedHandleObject[])this.contextService.getDefinedContexts()));
    }

    public final void init(IWorkbench workbench) {
        this.bindingService = (IBindingService)workbench.getAdapter(IBindingService.class);
        this.commandImageService = (ICommandImageService)workbench.getAdapter(ICommandImageService.class);
        this.commandService = (ICommandService)workbench.getAdapter(ICommandService.class);
        this.contextService = (IContextService)workbench.getAdapter(IContextService.class);
    }

    private final void keySequenceChanged() {
        IStructuredSelection structuredSelection;
        TreeNode node;
        KeySequence keySequence = this.keySequenceText.getKeySequence();
        if (keySequence == null || !keySequence.isComplete() || keySequence.isEmpty()) {
            return;
        }
        ISelection selection = this.filteredTree.getViewer().getSelection();
        if (selection instanceof IStructuredSelection && (node = (TreeNode)(structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
            Object firstElement;
            Object object = node.getValue();
            selection = this.whenCombo.getSelection();
            String contextId = selection instanceof IStructuredSelection ? ((firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) == null ? "org.eclipse.ui.contexts.window" : ((Context)firstElement).getId()) : "org.eclipse.ui.contexts.window";
            if (!(object instanceof KeyBinding) && object instanceof ParameterizedCommand) {
                KeyBinding binding = new KeyBinding(keySequence, (ParameterizedCommand)object, "org.eclipse.ui.defaultAcceleratorConfiguration", contextId, null, null, null, 1);
                this.localChangeManager.addBinding((Binding)binding);
                this.update();
                this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)new BindingTreeNode(binding)), true);
            }
        }
    }

    private final void logPreferenceStoreException(Throwable exception) {
        String message = NewKeysPreferenceMessages.PreferenceStoreError_Message;
        String title = NewKeysPreferenceMessages.PreferenceStoreError_Title;
        String exceptionMessage = exception.getMessage();
        if (exceptionMessage == null) {
            exceptionMessage = message;
        }
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, exceptionMessage, exception);
        WorkbenchPlugin.log(message, (IStatus)status);
        ErrorDialog.openError((Shell)this.schemeCombo.getCombo().getShell(), (String)title, (String)message, (IStatus)status);
    }

    protected final void performDefaults() {
        String title = NewKeysPreferenceMessages.RestoreDefaultsMessageBoxText;
        String message = NewKeysPreferenceMessages.RestoreDefaultsMessageBoxMessage;
        boolean confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)message);
        if (confirmed) {
            String defaultSchemeId = this.bindingService.getDefaultSchemeId();
            Scheme defaultScheme = this.localChangeManager.getScheme(defaultSchemeId);
            try {
                this.localChangeManager.setActiveScheme(defaultScheme);
            }
            catch (NotDefinedException notDefinedException) {}
            Binding[] currentBindings = this.localChangeManager.getBindings();
            int currentBindingsLength = currentBindings.length;
            HashSet<Binding> trimmedBindings = new HashSet<Binding>();
            int i = 0;
            while (i < currentBindingsLength) {
                Binding binding = currentBindings[i];
                if (binding.getType() != 1) {
                    trimmedBindings.add(binding);
                }
                ++i;
            }
            Binding[] trimmedBindingArray = trimmedBindings.toArray(new Binding[trimmedBindings.size()]);
            this.localChangeManager.setBindings(trimmedBindingArray);
            try {
                this.bindingService.savePreferences(defaultScheme, trimmedBindingArray);
            }
            catch (IOException e) {
                this.logPreferenceStoreException(e);
            }
        }
        this.setScheme(this.localChangeManager.getActiveScheme());
        super.performDefaults();
    }

    public final boolean performOk() {
        try {
            this.bindingService.savePreferences(this.localChangeManager.getActiveScheme(), this.localChangeManager.getBindings());
        }
        catch (IOException e) {
            this.logPreferenceStoreException(e);
        }
        return super.performOk();
    }

    private final void selectAddBindingButton(SelectionEvent event) {
        TreeViewer viewer = this.filteredTree.getViewer();
        ISelection selection = viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        if (firstElement instanceof TreeNode) {
            Object value = ((TreeNode)firstElement).getValue();
            if (value instanceof KeyBinding) {
                this.bindingAdd((Binding)((KeyBinding)value));
            } else if (value instanceof ParameterizedCommand) {
                this.bindingText.setFocus();
            }
        }
    }

    private final void selectRemoveBindingButton(SelectionEvent event) {
        TreeViewer viewer = this.filteredTree.getViewer();
        ISelection selection = viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        if (firstElement instanceof TreeNode) {
            Object value = ((TreeNode)firstElement).getValue();
            if (value instanceof KeyBinding) {
                this.bindingRemove((KeyBinding)value);
            } else if (value == this.markedParameterizedCommand) {
                this.markedParameterizedCommand = null;
                this.markedContextId = null;
                this.update();
            }
        }
    }

    private final void selectSchemeCombo(SelectionChangedEvent event) {
        Scheme newScheme;
        Object firstElement;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Scheme && (newScheme = (Scheme)firstElement) != this.localChangeManager.getActiveScheme()) {
            try {
                this.localChangeManager.setActiveScheme(newScheme);
                this.update();
            }
            catch (NotDefinedException notDefinedException) {}
        }
    }

    private final void selectTreeColumn(MouseEvent event) {
        Point point;
        TreeViewer viewer = this.filteredTree.getViewer();
        Tree tree = viewer.getTree();
        TreeItem item = tree.getItem(point = new Point(event.x, event.y));
        if (item == null) {
            return;
        }
        int i = 0;
        while (i < 4) {
            Rectangle rectangle = item.getBounds(i);
            if (rectangle.contains(point)) {
                if (i != 2 && i != 3) {
                    return;
                }
                ISelection selection = viewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                TreeNode treeNode = (TreeNode)structuredSelection.getFirstElement();
                Object value = treeNode.getValue();
                if (value instanceof KeyBinding) {
                    KeyBinding binding = (KeyBinding)value;
                    if (i == 2) {
                        this.bindingAdd((Binding)binding);
                    } else if (i == 3) {
                        this.bindingRemove(binding);
                    }
                }
            }
            ++i;
        }
    }

    private final void selectTreeRow(SelectionChangedEvent event) {
        this.updateDataControls();
    }

    private final void setScheme(Scheme scheme) {
        this.schemeCombo.setSelection((ISelection)new StructuredSelection((Object)scheme));
    }

    private final void update() {
        this.updateTree();
        this.updateDataControls();
    }

    private final void updateDataControls() {
        IStructuredSelection structuredSelection;
        TreeNode node;
        ISelection selection = this.filteredTree.getViewer().getSelection();
        if (selection instanceof IStructuredSelection && (node = (TreeNode)(structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
            Object object = node.getValue();
            if (object instanceof KeyBinding) {
                KeyBinding binding = (KeyBinding)object;
                try {
                    this.commandNameValueLabel.setText(binding.getParameterizedCommand().getName());
                    String description = binding.getParameterizedCommand().getCommand().getDescription();
                    if (description == null) {
                        description = "";
                    }
                    this.descriptionValueLabel.setText(description);
                    this.descriptionValueLabel.pack(true);
                }
                catch (NotDefinedException notDefinedException) {}
                this.keySequenceText.setKeySequence(binding.getKeySequence());
                this.whenCombo.setSelection((ISelection)new StructuredSelection((Object)this.contextService.getContext(binding.getContextId())));
            } else if (object instanceof ParameterizedCommand) {
                ParameterizedCommand command = (ParameterizedCommand)object;
                try {
                    this.commandNameValueLabel.setText(command.getName());
                    String description = command.getCommand().getDescription();
                    if (description == null) {
                        description = "";
                    }
                    this.descriptionValueLabel.setText(description);
                    this.descriptionValueLabel.pack(true);
                }
                catch (NotDefinedException notDefinedException) {}
                this.keySequenceText.clear();
                if (command == this.markedParameterizedCommand) {
                    this.whenCombo.setSelection((ISelection)new StructuredSelection((Object)this.contextService.getContext(this.markedContextId)));
                } else {
                    this.whenCombo.setSelection((ISelection)new StructuredSelection((Object)this.contextService.getContext("org.eclipse.ui.contexts.window")));
                }
            }
        }
    }

    private final void updateTree() {
        TreeNode[] elements;
        Iterator entryItr;
        String grouping;
        ParameterizedCommand command;
        TreeViewer viewer = this.filteredTree.getViewer();
        Collection bindings = this.localChangeManager.getActiveBindingsDisregardingContextFlat();
        if (this.showAllCheckBox.getSelection()) {
            Collection commandIds = this.commandService.getDefinedCommandIds();
            ArrayList commands = new ArrayList();
            for (String currentCommandId : commandIds) {
                Command currentCommand = this.commandService.getCommand(currentCommandId);
                try {
                    commands.addAll(ParameterizedCommand.generateCombinations((Command)currentCommand));
                }
                catch (NotDefinedException notDefinedException) {}
            }
            Iterator commandItr = commands.iterator();
            while (commandItr.hasNext()) {
                command = (ParameterizedCommand)commandItr.next();
                if (this.localChangeManager.getActiveBindingsDisregardingContextFor(command).length <= 0) continue;
                commandItr.remove();
            }
            bindings.addAll(commands);
        }
        if (this.markedParameterizedCommand != null) {
            bindings.add(this.markedParameterizedCommand);
        }
        if (NewKeysPreferenceMessages.GroupingCombo_Category_Text.equals(grouping = this.filteredTree.getGroupingCombo().getText())) {
            HashMap bindingsByCategory = new HashMap();
            for (Object object : bindings) {
                command = object instanceof Binding ? ((Binding)object).getParameterizedCommand() : (ParameterizedCommand)object;
                try {
                    Category category = command.getCommand().getCategory();
                    Object existing = bindingsByCategory.get(category);
                    if (existing instanceof Collection) {
                        Collection existingBindings = (Collection)existing;
                        existingBindings.add(object);
                        continue;
                    }
                    ArrayList newCollection = new ArrayList();
                    newCollection.add(object);
                    bindingsByCategory.put(category, newCollection);
                }
                catch (NotDefinedException notDefinedException) {}
            }
            entryItr = bindingsByCategory.entrySet().iterator();
            elements = new TreeNode[bindingsByCategory.size()];
            int i = 0;
            while (entryItr.hasNext()) {
                Map.Entry entry = entryItr.next();
                BindingTreeNode parentNode = new BindingTreeNode(entry.getKey());
                Collection childValues = (Collection)entry.getValue();
                Iterator childValueItr = childValues.iterator();
                TreeNode[] children = new TreeNode[childValues.size()];
                int j = 0;
                while (childValueItr.hasNext()) {
                    BindingTreeNode childNode = new BindingTreeNode(childValueItr.next());
                    childNode.setParent(parentNode);
                    children[j++] = childNode;
                }
                parentNode.setChildren(children);
                elements[i++] = parentNode;
            }
            viewer.setInput((Object)elements);
        } else if (NewKeysPreferenceMessages.GroupingCombo_When_Text.equals(grouping)) {
            HashMap bindingsByContextId = new HashMap();
            for (Object binding : bindings) {
                String contextId = binding instanceof ParameterizedCommand ? "org.eclipse.ui.contexts.window" : ((Binding)binding).getContextId();
                Object existing = bindingsByContextId.get(contextId);
                if (existing instanceof Collection) {
                    Collection existingBindings = (Collection)existing;
                    existingBindings.add(binding);
                    continue;
                }
                ArrayList newCollection = new ArrayList();
                newCollection.add(binding);
                bindingsByContextId.put(contextId, newCollection);
            }
            entryItr = bindingsByContextId.entrySet().iterator();
            elements = new TreeNode[bindingsByContextId.size()];
            int i = 0;
            while (entryItr.hasNext()) {
                Map.Entry entry = entryItr.next();
                BindingTreeNode parentNode = new BindingTreeNode(entry.getKey());
                Collection childValues = (Collection)entry.getValue();
                Iterator childValueItr = childValues.iterator();
                TreeNode[] children = new TreeNode[childValues.size()];
                int j = 0;
                while (childValueItr.hasNext()) {
                    BindingTreeNode childNode = new BindingTreeNode(childValueItr.next());
                    childNode.setParent(parentNode);
                    children[j++] = childNode;
                }
                parentNode.setChildren(children);
                elements[i++] = parentNode;
            }
            viewer.setInput((Object)elements);
        } else {
            Iterator bindingItr = bindings.iterator();
            BindingTreeNode[] elements2 = new BindingTreeNode[bindings.size()];
            int i = 0;
            while (bindingItr.hasNext()) {
                elements2[i++] = new BindingTreeNode(bindingItr.next());
            }
            viewer.setInput((Object)elements2);
        }
        Tree tree = viewer.getTree();
        TreeColumn[] columns = tree.getColumns();
        if (NewKeysPreferenceMessages.GroupingCombo_Category_Text.equals(grouping) || NewKeysPreferenceMessages.GroupingCombo_When_Text.equals(grouping)) {
            columns[0].setWidth(292);
        } else {
            columns[0].setWidth(292);
        }
        columns[1].setWidth(234);
        columns[2].setWidth(22);
        columns[3].setWidth(22);
    }

    protected class GroupedFilteredTree
    extends FilteredTree {
        protected Combo groupingCombo;

        protected GroupedFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter);
        }

        protected void createControl(Composite parent, int treeStyle) {
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
            this.setLayoutData(new GridData(4, 4, true, true));
            this.setFont(parent.getFont());
            this.filterComposite = new Composite((Composite)this, 0);
            GridLayout filterLayout = new GridLayout(3, false);
            filterLayout.marginHeight = 0;
            filterLayout.marginWidth = 0;
            this.filterComposite.setLayout((Layout)filterLayout);
            this.filterComposite.setFont(parent.getFont());
            this.createFilterControls(this.filterComposite);
            this.filterComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            Control groupingControl = this.createGroupingControl(this.filterComposite);
            groupingControl.setLayoutData((Object)new GridData());
            groupingControl.setFont(parent.getFont());
            Control treeControl = this.createTreeControl(this, treeStyle);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.horizontalSpan = 3;
            treeControl.setLayoutData((Object)gridData);
        }

        protected Control createGroupingControl(Composite parent) {
            Composite groupingControl = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            groupingControl.setLayout((Layout)layout);
            groupingControl.setFont(parent.getFont());
            Label groupingLabel = new Label(groupingControl, 0);
            groupingLabel.setText(NewKeysPreferenceMessages.GroupingCombo_Label);
            groupingLabel.setLayoutData((Object)new GridData());
            this.groupingCombo = new Combo(groupingControl, 8);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            this.groupingCombo.setLayoutData((Object)gridData);
            return groupingControl;
        }

        public final Combo getGroupingCombo() {
            return this.groupingCombo;
        }
    }

    private final class BindingLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int COLUMN_ADD = 2;
        private static final int COLUMN_COMMAND = 0;
        private static final int COLUMN_REMOVE = 3;
        private static final int COLUMN_TRIGGER_SEQUENCE = 1;
        private static final int NUMBER_OF_COLUMNS = 4;
        private final LocalResourceManager localResourceManager = new LocalResourceManager(JFaceResources.getResources());

        private BindingLabelProvider() {
        }

        public final void dispose() {
            super.dispose();
            this.localResourceManager.dispose();
        }

        public final Image getColumnImage(Object element, int columnIndex) {
            Object value = ((TreeNode)element).getValue();
            if (value instanceof Binding) {
                switch (columnIndex) {
                    case 0: {
                        ParameterizedCommand parameterizedCommand = ((Binding)value).getParameterizedCommand();
                        if (parameterizedCommand != null) {
                            String commandId = parameterizedCommand.getId();
                            ImageDescriptor imageDescriptor = NewKeysPreferencePage.this.commandImageService.getImageDescriptor(commandId);
                            if (imageDescriptor == null) {
                                return null;
                            }
                            try {
                                return this.localResourceManager.createImage(imageDescriptor);
                            }
                            catch (DeviceResourceException e) {
                                String message = "Problem retrieving image for a command '" + commandId + '\'';
                                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e);
                                WorkbenchPlugin.log(message, (IStatus)status);
                            }
                        }
                        return null;
                    }
                    case 2: {
                        return ImageFactory.getImage("plus");
                    }
                    case 3: {
                        return ImageFactory.getImage("minus");
                    }
                }
            } else if (value instanceof ParameterizedCommand) {
                switch (columnIndex) {
                    case 0: {
                        ParameterizedCommand parameterizedCommand = (ParameterizedCommand)value;
                        String commandId = parameterizedCommand.getId();
                        ImageDescriptor imageDescriptor = NewKeysPreferencePage.this.commandImageService.getImageDescriptor(commandId);
                        if (imageDescriptor == null) {
                            return null;
                        }
                        try {
                            return this.localResourceManager.createImage(imageDescriptor);
                        }
                        catch (DeviceResourceException e) {
                            String message = "Problem retrieving image for a command '" + commandId + '\'';
                            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e);
                            WorkbenchPlugin.log(message, (IStatus)status);
                            return null;
                        }
                    }
                }
            } else if (value instanceof Category || value instanceof String) {
                switch (columnIndex) {
                    case 0: {
                        URL url = BundleUtility.find("org.eclipse.ui", NewKeysPreferencePage.ICON_GROUP_OF_BINDINGS);
                        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
                        try {
                            return this.localResourceManager.createImage(imageDescriptor);
                        }
                        catch (DeviceResourceException e) {
                            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "Problem retrieving image for groups of bindings: '$nl$/icons/full/obj16/keygroups_obj.gif'", (Throwable)e);
                            WorkbenchPlugin.log("Problem retrieving image for groups of bindings: '$nl$/icons/full/obj16/keygroups_obj.gif'", (IStatus)status);
                        }
                    }
                }
            }
            return null;
        }

        public final String getColumnText(Object element, int columnIndex) {
            Object value = ((TreeNode)element).getValue();
            if (value instanceof Binding) {
                Binding binding = (Binding)value;
                switch (columnIndex) {
                    case 0: {
                        try {
                            return binding.getParameterizedCommand().getName();
                        }
                        catch (NotDefinedException notDefinedException) {
                            return null;
                        }
                    }
                    case 1: {
                        return binding.getTriggerSequence().format();
                    }
                }
                return null;
            }
            if (value instanceof Category) {
                if (columnIndex == 0) {
                    try {
                        return ((Category)value).getName();
                    }
                    catch (NotDefinedException notDefinedException) {
                        return null;
                    }
                }
                return null;
            }
            if (value instanceof String) {
                if (columnIndex == 0) {
                    try {
                        return NewKeysPreferencePage.this.contextService.getContext((String)value).getName();
                    }
                    catch (NotDefinedException notDefinedException) {
                        return null;
                    }
                }
                return null;
            }
            if (value instanceof ParameterizedCommand) {
                if (columnIndex == 0) {
                    try {
                        return ((ParameterizedCommand)value).getName();
                    }
                    catch (NotDefinedException notDefinedException) {
                        return null;
                    }
                }
                return null;
            }
            return null;
        }
    }

    private final class BindingSorter
    extends ViewerSorter {
        private BindingSorter() {
        }

        public final int category(Object element) {
            switch (NewKeysPreferencePage.this.grouping) {
                case 0: {
                    try {
                        ParameterizedCommand command = element instanceof ParameterizedCommand ? (ParameterizedCommand)element : ((Binding)element).getParameterizedCommand();
                        return command.getCommand().getCategory().hashCode();
                    }
                    catch (NotDefinedException notDefinedException) {
                        return 0;
                    }
                }
                case 1: {
                    if (!(element instanceof Binding)) break;
                    return ((Binding)element).getContextId().hashCode();
                }
            }
            return 0;
        }

        public final int compare(Viewer viewer, Object a, Object b) {
            block23: {
                String selectedText = NewKeysPreferencePage.this.filteredTree.getGroupingCombo().getText();
                try {
                    if (NewKeysPreferenceMessages.GroupingCombo_Category_Text.equals(selectedText)) {
                        Object x = ((TreeNode)a).getValue();
                        Object y = ((TreeNode)b).getValue();
                        ParameterizedCommand commandA = null;
                        if (x instanceof ParameterizedCommand) {
                            commandA = (ParameterizedCommand)x;
                        } else if (x instanceof Binding) {
                            commandA = ((Binding)x).getParameterizedCommand();
                        }
                        ParameterizedCommand commandB = null;
                        if (y instanceof ParameterizedCommand) {
                            commandB = (ParameterizedCommand)y;
                        } else if (y instanceof Binding) {
                            commandB = ((Binding)y).getParameterizedCommand();
                        }
                        if (x instanceof Category && y instanceof Category) {
                            return Util.compare((Comparable)((Object)((Category)x).getName()), (Comparable)((Object)((Category)y).getName()));
                        }
                        if (commandA != null && commandB != null) {
                            return Util.compare((Comparable)commandA, (Comparable)commandB);
                        }
                        if (x instanceof Category && commandB != null) {
                            int compare = Util.compare((Comparable)((Object)((Category)x).getName()), (Comparable)((Object)commandB.getCommand().getCategory().getName()));
                            return compare == 0 ? -1 : compare;
                        }
                        if (y instanceof Category && commandA != null) {
                            int compare = Util.compare((Comparable)((Object)((Category)y).getName()), (Comparable)((Object)commandA.getCommand().getCategory().getName()));
                            return compare == 0 ? 1 : compare;
                        }
                        break block23;
                    }
                    if (NewKeysPreferenceMessages.GroupingCombo_When_Text.equals(selectedText)) {
                        Object x = ((TreeNode)a).getValue();
                        Object y = ((TreeNode)b).getValue();
                        if (x instanceof String && y instanceof String) {
                            return Util.compare((Comparable)((Object)NewKeysPreferencePage.this.contextService.getContext((String)x).getName()), (Comparable)((Object)NewKeysPreferencePage.this.contextService.getContext((String)y).getName()));
                        }
                        if (x instanceof Binding && y instanceof Binding) {
                            return Util.compare((Comparable)((Binding)x).getParameterizedCommand(), (Comparable)((Binding)y).getParameterizedCommand());
                        }
                        if (x instanceof ParameterizedCommand && y instanceof ParameterizedCommand) {
                            return Util.compare((Comparable)((ParameterizedCommand)x), (Comparable)((ParameterizedCommand)y));
                        }
                        if (x instanceof String && y instanceof Binding) {
                            int compare = Util.compare((Comparable)((Object)NewKeysPreferencePage.this.contextService.getContext((String)x).getName()), (Comparable)((Object)NewKeysPreferencePage.this.contextService.getContext(((Binding)y).getContextId()).getName()));
                            return compare == 0 ? -1 : compare;
                        }
                        if (y instanceof String && x instanceof Binding) {
                            int compare = Util.compare((Comparable)((Object)NewKeysPreferencePage.this.contextService.getContext(((Binding)x).getContextId()).getName()), (Comparable)((Object)NewKeysPreferencePage.this.contextService.getContext((String)y).getName()));
                            return compare == 0 ? 1 : compare;
                        }
                        if (x instanceof String && y instanceof ParameterizedCommand) {
                            int compare = Util.compare((Comparable)((Object)NewKeysPreferencePage.this.contextService.getContext((String)x).getName()), (Comparable)((Object)NewKeysPreferencePage.this.contextService.getContext("org.eclipse.ui.contexts.window").getName()));
                            return compare == 0 ? -1 : compare;
                        }
                        if (y instanceof String && x instanceof ParameterizedCommand) {
                            int compare = Util.compare((Comparable)((Object)NewKeysPreferencePage.this.contextService.getContext("org.eclipse.ui.contexts.window").getName()), (Comparable)((Object)NewKeysPreferencePage.this.contextService.getContext((String)y).getName()));
                            return compare == 0 ? 1 : compare;
                        }
                        if (x instanceof Binding && y instanceof ParameterizedCommand) {
                            ParameterizedCommand commandY;
                            ParameterizedCommand commandX = ((Binding)x).getParameterizedCommand();
                            int compare = Util.compare((Comparable)commandX, (Comparable)(commandY = (ParameterizedCommand)y));
                            return compare == 0 ? -1 : compare;
                        }
                        if (y instanceof Binding && x instanceof ParameterizedCommand) {
                            ParameterizedCommand commandX = (ParameterizedCommand)x;
                            ParameterizedCommand commandY = ((Binding)y).getParameterizedCommand();
                            int compare = Util.compare((Comparable)commandX, (Comparable)commandY);
                            return compare == 0 ? 1 : compare;
                        }
                        break block23;
                    }
                    Object x = ((TreeNode)a).getValue();
                    Object y = ((TreeNode)b).getValue();
                    ParameterizedCommand commandX = x instanceof Binding ? ((Binding)x).getParameterizedCommand() : (ParameterizedCommand)x;
                    ParameterizedCommand commandY = y instanceof Binding ? ((Binding)y).getParameterizedCommand() : (ParameterizedCommand)y;
                    return Util.compare((Comparable)commandX, (Comparable)commandY);
                }
                catch (NotDefinedException notDefinedException) {}
            }
            return 0;
        }
    }

    private static final class BindingTreeNode
    extends TreeNode {
        private BindingTreeNode(Object object) {
            super(object);
        }

        public final String toString() {
            ParameterizedCommand command;
            Object value = this.getValue();
            if (value instanceof Binding) {
                command = ((Binding)value).getParameterizedCommand();
            } else if (value instanceof ParameterizedCommand) {
                command = (ParameterizedCommand)value;
            } else {
                return null;
            }
            try {
                return String.valueOf(command.getName()) + command.getCommand().getDescription();
            }
            catch (NotDefinedException notDefinedException) {
                return null;
            }
        }
    }
}

