/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.Util;

public class ActionMarkCompleted
extends MarkerSelectionProviderAction {
    public ActionMarkCompleted(ISelectionProvider provider) {
        super(provider, MarkerMessages.markCompletedAction_title);
        this.setEnabled(false);
    }

    public void run() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    IMarker[] markers = ActionMarkCompleted.this.getSelectedMarkers();
                    int i = 0;
                    while (i < markers.length) {
                        try {
                            markers[i].setAttribute("done", true);
                        }
                        catch (CoreException e) {
                            Util.log(e);
                        }
                        ++i;
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            Util.log(e);
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(false);
        if (selection == null || selection.isEmpty()) {
            return;
        }
        for (Object obj : selection) {
            if (!(obj instanceof ConcreteMarker)) {
                return;
            }
            IMarker marker = ((ConcreteMarker)obj).getMarker();
            if (!marker.getAttribute("userEditable", true)) {
                return;
            }
            if (!marker.getAttribute("done", false)) continue;
            return;
        }
        this.setEnabled(true);
    }
}

