/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.provisional;

import org.eclipse.debug.internal.ui.viewers.provisional.IModelDelta;

public class ModelDelta
implements IModelDelta {
    private IModelDelta fParent;
    private Object fElement;
    private int fFlags;
    private ModelDelta[] fNodes = EMPTY_NODES;
    private Object fReplacement;
    private int fIndex;
    private static final ModelDelta[] EMPTY_NODES = new ModelDelta[0];

    public ModelDelta(Object element, int flags) {
        this.fElement = element;
        this.fFlags = flags;
    }

    public ModelDelta(Object element, Object replacement, int flags) {
        this.fElement = element;
        this.fReplacement = replacement;
        this.fFlags = flags;
    }

    public ModelDelta(Object element, int index, int flags) {
        this.fElement = element;
        this.fIndex = index;
        this.fFlags = flags;
    }

    public Object getElement() {
        return this.fElement;
    }

    public int getFlags() {
        return this.fFlags;
    }

    public ModelDelta addNode(Object element, int flags) {
        ModelDelta node = new ModelDelta(element, flags);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    public ModelDelta addNode(Object element, Object replacement, int flags) {
        ModelDelta node = new ModelDelta(element, replacement, flags);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    public ModelDelta addNode(Object element, int index, int flags) {
        ModelDelta node = new ModelDelta(element, index, flags);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    void setParent(ModelDelta node) {
        this.fParent = node;
    }

    public IModelDelta getParent() {
        return this.fParent;
    }

    public Object getReplacementElement() {
        return this.fReplacement;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public ModelDelta[] getNodes() {
        return this.fNodes;
    }

    private void addDelta(ModelDelta delta) {
        if (this.fNodes.length == 0) {
            this.fNodes = new ModelDelta[]{delta};
        } else {
            ModelDelta[] nodes = new ModelDelta[this.fNodes.length + 1];
            System.arraycopy(this.fNodes, 0, nodes, 0, this.fNodes.length);
            nodes[this.fNodes.length] = delta;
            this.fNodes = nodes;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Model Delta Start\n");
        this.appendDetail(buf, this);
        buf.append("Model Delta End\n");
        return buf.toString();
    }

    private void appendDetail(StringBuffer buf, ModelDelta delta) {
        buf.append("\tElement: ");
        buf.append(delta.fElement);
        buf.append('\n');
        buf.append("\t\tFlags: ");
        int flags = delta.getFlags();
        if (flags == 0) {
            buf.append("NO_CHANGE");
        } else {
            if ((flags & 1) > 0) {
                buf.append("ADDED | ");
            }
            if ((flags & 0x400) > 0) {
                buf.append("CONTENT | ");
            }
            if ((flags & 0x100000) > 0) {
                buf.append("EXPAND | ");
            }
            if ((flags & 0x10) > 0) {
                buf.append("INSERTED | ");
            }
            if ((flags & 2) > 0) {
                buf.append("REMOVED | ");
            }
            if ((flags & 8) > 0) {
                buf.append("REPLACED | ");
            }
            if ((flags & 0x200000) > 0) {
                buf.append("SELECT | ");
            }
            if ((flags & 0x800) > 0) {
                buf.append("STATE | ");
            }
        }
        buf.append('\n');
        ModelDelta[] nodes = delta.getNodes();
        int i = 0;
        while (i < nodes.length) {
            this.appendDetail(buf, nodes[i]);
            ++i;
        }
    }
}

