/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class BulkShardRequest
extends ReplicationRequest<BulkShardRequest> {
    private BulkItemRequest[] items;
    private boolean refresh;

    BulkShardRequest() {
    }

    BulkShardRequest(BulkRequest bulkRequest, String index, int shardId, boolean refresh, BulkItemRequest[] items) {
        super(bulkRequest);
        this.index = index;
        this.setShardId(new ShardId(index, shardId));
        this.items = items;
        this.refresh = refresh;
    }

    boolean refresh() {
        return this.refresh;
    }

    BulkItemRequest[] items() {
        return this.items;
    }

    @Override
    public String[] indices() {
        ArrayList<String> indices = new ArrayList<String>();
        for (BulkItemRequest item : this.items) {
            if (item == null) continue;
            indices.add(item.index());
        }
        return indices.toArray(new String[indices.size()]);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.items.length);
        for (BulkItemRequest item : this.items) {
            if (item != null) {
                out.writeBoolean(true);
                item.writeTo(out);
                continue;
            }
            out.writeBoolean(false);
        }
        out.writeBoolean(this.refresh);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.items = new BulkItemRequest[in.readVInt()];
        for (int i = 0; i < this.items.length; ++i) {
            if (!in.readBoolean()) continue;
            this.items[i] = BulkItemRequest.readBulkItem(in);
        }
        this.refresh = in.readBoolean();
    }
}

