/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.suggest;

import java.io.IOException;
import org.elasticsearch.action.suggest.SuggestRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

final class ShardSuggestRequest
extends BroadcastShardRequest {
    private BytesReference suggestSource;

    ShardSuggestRequest() {
    }

    ShardSuggestRequest(ShardId shardId, SuggestRequest request) {
        super(shardId, request);
        this.suggestSource = request.suggest();
    }

    public BytesReference suggest() {
        return this.suggestSource;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.suggestSource = in.readBytesReference();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.suggestSource);
    }
}

